/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cdm.formplugin.billpoolbiz;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.filter.CommonFilterColumn;
import kd.bos.filter.FilterColumn;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.field.ComboItem;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.tmc.cdm.common.helper.BillPoolHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcOrgDataHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.formplugin.list.AbstractTmcBillBaseList;

public class PoolDraftQueryList
extends AbstractTmcBillBaseList {
    public void filterContainerInit(FilterContainerInitArgs args) {
        super.filterContainerInit(args);
        for (FilterColumn filterColumn : args.getFilterContainerInitEvent().getCommonFilterColumns()) {
            CommonFilterColumn commonFilterColumn = (CommonFilterColumn)filterColumn;
            String fieldName = commonFilterColumn.getFieldName();
            if (!fieldName.startsWith("billpool.")) continue;
            String appId = this.getView().getFormShowParameter().getAppId();
            Long userId = Long.valueOf(RequestContext.get().getUserId());
            List authOrgIds = TmcOrgDataHelper.getAuthorizedBankOrgId((Long)userId, (String)appId, (String)"cdm_pooldraftbill_query", (String)"47150e89000000ac");
            DynamicObject[] billPools = BillPoolHelper.getAuthorizedBillPool((List)authOrgIds);
            if (billPools.length <= 0) continue;
            List<DynamicObject> billPoolList = Arrays.stream(billPools).sorted(Comparator.comparing(e -> e.getLong("id"))).collect(Collectors.toList());
            commonFilterColumn.setComboItems(this.initBillPoolList(billPoolList));
        }
    }

    private List<ComboItem> initBillPoolList(List<DynamicObject> billPools) {
        ArrayList<ComboItem> billPoolItems = new ArrayList<ComboItem>(10);
        if (!CollectionUtils.isEmpty(billPools)) {
            for (DynamicObject billPool : billPools) {
                ComboItem item = new ComboItem();
                item.setCaption(new LocaleString(billPool.getString("name")));
                item.setValue(billPool.getString("id"));
                billPoolItems.add(item);
            }
        }
        return billPoolItems;
    }

    public void setFilter(SetFilterEvent e) {
        ArrayList<QFilter> filterList = new ArrayList<QFilter>();
        QFilter filter = new QFilter("billpool", ">", (Object)0);
        String appId = this.getView().getFormShowParameter().getAppId();
        Long userId = Long.valueOf(RequestContext.get().getUserId());
        List authOrgIds = TmcOrgDataHelper.getAuthorizedBankOrgId((Long)userId, (String)appId, (String)"cdm_pooldraftbill_query", (String)"47150e89000000ac");
        filter.and(new QFilter("billpool.company", "in", (Object)authOrgIds));
        filterList.add(filter);
        e.setCustomQFilters(filterList);
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String operateKey = args.getOperateKey();
        OperationResult operationResult = args.getOperationResult();
        switch (operateKey) {
            case "relationtrackdown": {
                this.relationTrackDown(operationResult);
            }
        }
    }

    private void relationTrackDown(OperationResult opResult) {
        if (opResult != null && opResult.isSuccess() && opResult.getSuccessPkIds().size() > 0) {
            Object pkValue = opResult.getSuccessPkIds().get(0);
            QFilter sourceIdFilter = new QFilter("sourceid", "=", pkValue);
            Object[] electronicSignDeal = TmcDataServiceHelper.load((String)"cdm_electronic_sign_deal", (String)"id,sourceid", (QFilter[])new QFilter[]{sourceIdFilter});
            if (!EmptyUtil.isEmpty((Object[])electronicSignDeal) && EmptyUtil.isNoEmpty((Long)electronicSignDeal[0].getLong("sourceid")) && electronicSignDeal[0].getLong("sourceid") > 0L) {
                BillShowParameter parameter = new BillShowParameter();
                parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                parameter.setAppId("cdm");
                parameter.setFormId("cdm_electronic_sign_deal");
                parameter.setPkId((Object)electronicSignDeal[0].getLong("id"));
                parameter.setStatus(OperationStatus.VIEW);
                this.getView().showForm((FormShowParameter)parameter);
            } else {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u8054\u67e5\u6570\u636e\u3002", (String)"CdmBizResource_167", (String)"tmc-cdm-common", (Object[])new Object[0]));
            }
        }
    }
}

