/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cdm.formplugin.billsInventory;

import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.cache.IAppCache;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.IListView;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.common.helper.TmcAppCache;
import kd.tmc.fbp.common.param.ParamMap;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.formplugin.list.AbstractTmcBillBaseList;

public class BankDraftsList
extends AbstractTmcBillBaseList {
    private static final String ACTIONKEY = "cdm_importbankdata_back";
    private static IAppCache cache = TmcAppCache.get((String)"cdm", (String)"inventory", (String)"bankdraftparam");

    public void beforeItemClick(BeforeItemClickEvent evt) {
        super.beforeItemClick(evt);
        String itemKey = evt.getItemKey();
        IListView listview = (IListView)this.getView();
        ListSelectedRowCollection selectedRows = listview.getSelectedRows();
        switch (itemKey) {
            case "tblmodify": 
            case "tblview": {
                DynamicObjectCollection bankDraftsInventoried;
                if (!EmptyUtil.isNoEmpty((Object)selectedRows)) break;
                Set dataSet = selectedRows.parallelStream().map(ListSelectedRow::getPrimaryKeyValue).collect(Collectors.toSet());
                if (dataSet.size() > 1) {
                    evt.setCancel(true);
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u6761\u6570\u636e\u3002", (String)"BankDraftsList_1", (String)"tmc-cdm-formplugin", (Object[])new Object[0]));
                    return;
                }
                if (!itemKey.equals("tblmodify") || !EmptyUtil.isNoEmpty((DynamicObjectCollection)(bankDraftsInventoried = QueryServiceHelper.query((String)"cdm_bankdrafts", (String)"id,bankaccount,datadate,bankdraftentry.e_inventorystatus", (QFilter[])new QFilter[]{new QFilter("id", "in", dataSet), new QFilter("bankdraftentry.e_inventorystatus", "=", (Object)"B")})))) break;
                evt.setCancel(true);
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0d\u80fd\u4fee\u6539\u5df2\u76d8\u70b9\u7684\u6570\u636e\u3002", (String)"BankDraftsList_2", (String)"tmc-cdm-formplugin", (Object[])new Object[0]));
                return;
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        Object returnData = closedCallBackEvent.getReturnData();
        if (StringUtils.equals((CharSequence)ACTIONKEY, (CharSequence)actionId)) {
            ParamMap dataMap = (ParamMap)returnData;
            if (null == dataMap) {
                return;
            }
            Object dataSource = dataMap.get("dataSource");
            if ("import".equals(dataSource)) {
                Map params = dataMap.getParams();
                String userId = RequestContext.get().getUserId();
                String keyStr = String.format("importparam_%s", userId);
                cache.put(keyStr, (Object)params);
                OperationResult operationResult = this.getView().invokeOperation("importdata");
            } else if ("bei".equals(dataSource)) {
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5bfc\u5165\u6210\u529f\u3002", (String)"BankDraftsList_5", (String)"tmc-cdm-formplugin", (Object[])new Object[0]));
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String operateKey;
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        switch (operateKey = formOperate.getOperateKey()) {
            case "importbankdatas": {
                FormShowParameter para = new FormShowParameter();
                para.setFormId("cdm_importbankdata");
                para.setCloseCallBack(new CloseCallBack((IFormPlugin)this, ACTIONKEY));
                para.getOpenStyle().setShowType(ShowType.Modal);
                this.getView().showForm(para);
                break;
            }
        }
    }
}

