/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cdm.formplugin.billsInventory;

import java.math.BigDecimal;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.IListView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.common.param.ParamMap;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.formplugin.list.AbstractTmcBillBaseList;

public class BussinessDraftsInventoryList
extends AbstractTmcBillBaseList {
    private static final String ACTIONKEY = "cdm_billinventory_back";
    private static final Log logger = LogFactory.getLog(BussinessDraftsInventoryList.class);

    public void beforeItemClick(BeforeItemClickEvent evt) {
        super.beforeItemClick(evt);
        String itemKey = evt.getItemKey();
        IListView listview = (IListView)this.getView();
        ListSelectedRowCollection selectedRows = listview.getSelectedRows();
        switch (itemKey) {
            case "tblnew": {
                FormShowParameter para = new FormShowParameter();
                para.setFormId("cdm_billinventoryrange");
                para.setCloseCallBack(new CloseCallBack((IFormPlugin)this, ACTIONKEY));
                para.getOpenStyle().setShowType(ShowType.Modal);
                this.getView().showForm(para);
                break;
            }
            case "tblsubmit": 
            case "tblunsubmit": {
                if (!EmptyUtil.isNoEmpty((Object)selectedRows)) break;
                Set dataSet = selectedRows.parallelStream().map(ListSelectedRow::getPrimaryKeyValue).collect(Collectors.toSet());
                if (dataSet.size() > 1) {
                    evt.setCancel(true);
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u6761\u6570\u636e\u3002", (String)"BussinessDraftsInventoryList_1", (String)"tmc-cdm-formplugin", (Object[])new Object[0]));
                    return;
                }
                Set idsSet = selectedRows.stream().map(e -> e.getPrimaryKeyValue()).collect(Collectors.toSet());
                QFilter qFilter1 = new QFilter("id", "in", idsSet);
                DynamicObjectCollection inventoryBillList = QueryServiceHelper.query((String)"cdm_businessnventory", (String)"id,billno,recdiffereamount,paydiffereamount", (QFilter[])new QFilter[]{qFilter1});
                Set differentBillSet = inventoryBillList.stream().filter(e -> BigDecimal.ZERO.compareTo(e.getBigDecimal("recdiffereamount")) != 0 || BigDecimal.ZERO.compareTo(e.getBigDecimal("paydiffereamount")) != 0).map(e -> e.getString("billno")).collect(Collectors.toSet());
                if (EmptyUtil.isNoEmpty(differentBillSet) && differentBillSet.size() > 0) {
                    this.getView().showConfirm(String.format(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7 %s \u7968\u636e\u76d8\u70b9\u5b58\u5728\u5dee\u5f02\uff0c\u662f\u5426\u7ee7\u7eed?", (String)"BussinessInventoryEdit_2", (String)"tmc-cdm-formplugin", (Object[])new Object[0]), differentBillSet), MessageBoxOptions.YesNo, ConfirmTypes.Default, new ConfirmCallBackListener(itemKey, (IFormPlugin)this));
                    break;
                }
                this.callSubmitOp(itemKey);
                break;
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        ParamMap dataMap;
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        Object returnData = closedCallBackEvent.getReturnData();
        if (StringUtils.equals((CharSequence)ACTIONKEY, (CharSequence)actionId) && EmptyUtil.isNoEmpty((Object)(dataMap = (ParamMap)returnData)) && EmptyUtil.isNoEmpty((Object)dataMap.get("inventoryBillId"))) {
            String inventoryBillId = (String)dataMap.get("inventoryBillId");
            BillShowParameter parameter = new BillShowParameter();
            parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            parameter.setPkId((Object)inventoryBillId);
            parameter.setFormId("cdm_businessnventory");
            this.getView().showForm((FormShowParameter)parameter);
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent e) {
        super.confirmCallBack(e);
        String callBackId = e.getCallBackId();
        if (("tblsubmit".equals(callBackId) || "tblunsubmit".equals(callBackId)) && e.getResult() == MessageBoxResult.Yes) {
            this.callSubmitOp(callBackId);
        }
    }

    private void callSubmitOp(String callBackId) {
        OperationResult operationResult;
        OperateOption op;
        if ("tblsubmit".equalsIgnoreCase(callBackId)) {
            op = OperateOption.create();
            operationResult = this.getView().invokeOperation("submit", op);
        }
        if ("tblunsubmit".equalsIgnoreCase(callBackId)) {
            op = OperateOption.create();
            operationResult = this.getView().invokeOperation("unsubmit", op);
        }
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        super.billListHyperLinkClick(args);
        String fieldName = args.getHyperLinkClickEvent().getFieldName();
        if ("draftinventoryreport".equals(fieldName)) {
            args.setCancel(true);
            BillList list = (BillList)this.getControl("billlistap");
            Object focusRowPkId = list.getFocusRowPkId();
            DynamicObjectCollection chequeDyColl = QueryServiceHelper.query((String)"cdm_businessnventory", (String)"id,draftinventoryreportid", (QFilter[])new QFilter[]{new QFilter("id", "=", focusRowPkId)});
            long draftinventoryReportId = ((DynamicObject)chequeDyColl.get(0)).getLong("draftinventoryreportid");
            if (EmptyUtil.isNoEmpty((Long)draftinventoryReportId)) {
                BillShowParameter showParameter = new BillShowParameter();
                showParameter.setStatus(OperationStatus.VIEW);
                showParameter.setFormId("cdm_inventoryresult");
                showParameter.setPkId((Object)draftinventoryReportId);
                showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                this.getView().showForm((FormShowParameter)showParameter);
            }
        }
    }
}

