/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cdm.formplugin.billsInventory;

import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.FormShowParameter;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.list.events.ListRowClickListener;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.tmc.cdm.common.helper.DraftHelper;
import kd.tmc.fbp.common.helper.TmcOrgDataHelper;
import kd.tmc.fbp.common.param.ParamMap;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;

public class ChequeBlankAddEdit
extends AbstractFormPlugin
implements ListRowClickListener {
    private static Log logger = LogFactory.getLog(ChequeBlankAddEdit.class);
    private boolean skipPropChange;

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.authorizedCompanyListener();
        this.addAccountListener();
        this.addCurrencyListener();
    }

    private void addAccountListener() {
        BasedataEdit bankAccount = (BasedataEdit)this.getControl("accountbank");
        if (Objects.nonNull(bankAccount)) {
            bankAccount.addBeforeF7SelectListener(evt -> {
                ListShowParameter parameter = (ListShowParameter)evt.getFormShowParameter();
                DynamicObject currency = (DynamicObject)this.getModel().getValue("currency");
                DynamicObject orgDy = (DynamicObject)this.getModel().getValue("org");
                if (EmptyUtil.isEmpty((DynamicObject)orgDy)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u8d44\u91d1\u7ec4\u7ec7\u3002", (String)"DraftsInventoryEdit_2", (String)"tmc-cdm-formplugin", (Object[])new Object[0]), Integer.valueOf(2000));
                    evt.setCancel(true);
                    return;
                }
                ListFilterParameter listFilterParameter = parameter.getListFilterParameter();
                if (!Objects.nonNull(currency)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u5e01\u79cd\u3002", (String)"DraftsInventoryEdit_1", (String)"tmc-cdm-formplugin", (Object[])new Object[0]), Integer.valueOf(2000));
                    evt.setCancel(true);
                    return;
                }
                QFilter companyFilter = new QFilter("acctstatus", "!=", (Object)"closed");
                companyFilter.and(new QFilter("currency.fbasedataid", "=", currency.getPkValue()));
                listFilterParameter.getQFilters().add(companyFilter);
            });
        }
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        Object org = this.getModel().getValue("org");
        if (EmptyUtil.isEmpty((Object)org)) {
            RequestContext requestContext = RequestContext.get();
            long orgId = requestContext.getOrgId();
            MainEntityType orgType = EntityMetadataCache.getDataEntityType((String)"bos_org");
            DynamicObject currentOrg = BusinessDataServiceHelper.loadSingle((Object)orgId, (DynamicObjectType)orgType);
            if (currentOrg.getBoolean("fisbankroll")) {
                this.getModel().setValue("org", (Object)orgId);
                long standardCurrency = DraftHelper.getMainCurrByOrg((DynamicObject)currentOrg);
                if (0L != standardCurrency) {
                    this.getModel().setValue("currency", (Object)standardCurrency);
                }
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String key;
        if (this.skipPropChange) {
            this.skipPropChange = false;
            return;
        }
        switch (key = e.getProperty().getName()) {
            case "org": {
                DynamicObject currentOrg;
                long standardCurrency;
                this.getModel().setValue("accountbank", null);
                Object org = this.getModel().getValue("org");
                if (!EmptyUtil.isNoEmpty((Object)org) || 0L == (standardCurrency = DraftHelper.getMainCurrByOrg((DynamicObject)(currentOrg = (DynamicObject)org)))) break;
                this.getModel().setValue("currency", (Object)standardCurrency);
                break;
            }
            case "purchdate": {
                Date date = DateUtils.stringToDate((String)DateUtils.formatString((Date)((Date)this.getModel().getValue("purchdate")), (String)"yyyy-MM-dd"), (String)"yyyy-MM-dd");
                this.getModel().setValue("purchdate", (Object)date);
                break;
            }
            case "currency": {
                this.getModel().setValue("accountbank", null);
                break;
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        int amount;
        int blankcount;
        super.beforeDoOperation(args);
        AbstractOperate op = (AbstractOperate)args.getSource();
        String operateKey = op.getOperateKey();
        if ("confirm".equals(operateKey) && (blankcount = ((Integer)this.getModel().getValue("blankcount")).intValue()) > (amount = ((Integer)this.getModel().getValue("amount")).intValue())) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u7a7a\u767d\u7968\u636e\u5f20\u6570\u4e0d\u80fd\u8d85\u8fc7\u5f20\u6570\u3002", (String)"ChequeBlankAddEdit_1", (String)"tmc-cdm-formplugin", (Object[])new Object[0]), Integer.valueOf(2000));
            args.setCancel(true);
            return;
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        super.afterDoOperation(e);
        String operateKey = e.getOperateKey();
        FormShowParameter fsp = this.getView().getFormShowParameter();
        String isfromChequelist = (String)fsp.getCustomParam("isfromchequelist");
        if (EmptyUtil.isEmpty((String)isfromChequelist)) {
            return;
        }
        if ("confirm".equals(operateKey) && e.getOperationResult().isSuccess()) {
            this.updateDBInfoBy();
        }
    }

    private void updateDBInfoBy() {
        DynamicObject currentCheque = this.getModel().getDataEntity();
        String codeRule = currentCheque.getString("coderule");
        String startNo = currentCheque.getString("startno");
        int amount = currentCheque.getInt("amount");
        ArrayList<DynamicObject> newList = new ArrayList<DynamicObject>(16);
        DynamicObject formCheque = this.getModel().getDataEntity();
        String replaceChar = (String)this.getModel().getValue("replacechar");
        List<String> noList = this.createNosBy(amount, codeRule, startNo, replaceChar);
        StringJoiner stringJoiner = new StringJoiner(",");
        FormShowParameter fsp = this.getView().getFormShowParameter();
        String inventorydateStr = (String)fsp.getCustomParam("inventorydate");
        Date inventoryDate = DateUtils.stringToDate((String)inventorydateStr, (String)"yyyy-MM-dd");
        for (String no : noList) {
            long pkId = DB.genGlobalLongId();
            stringJoiner.add(String.valueOf(pkId));
            DynamicObject saveCheque = BusinessDataServiceHelper.newDynamicObject((String)"cdm_actualchequef7");
            saveCheque.set("chequestatus", (Object)"blank");
            saveCheque.set("id", (Object)pkId);
            saveCheque.set("org", (Object)formCheque.getDynamicObject("org"));
            saveCheque.set("purchuser", (Object)formCheque.getDynamicObject("purchase"));
            saveCheque.set("inventorystatus", (Object)"B");
            saveCheque.set("checkstatus", (Object)"A");
            DynamicObject accountBank = formCheque.getDynamicObject("accountbank");
            saveCheque.set("accountbank", (Object)accountBank);
            saveCheque.set("bank", (Object)accountBank.getDynamicObject("bank"));
            saveCheque.set("currency", (Object)formCheque.getDynamicObject("currency"));
            saveCheque.set("purchdate", (Object)formCheque.getDate("purchdate"));
            saveCheque.set("datadate", (Object)inventoryDate);
            saveCheque.set("billno", (Object)no);
            newList.add(saveCheque);
        }
        if (!newList.isEmpty()) {
            SaveServiceHelper.save((DynamicObject[])newList.toArray(new DynamicObject[0]));
            String isfromChequelist = (String)fsp.getCustomParam("isfromchequelist");
            if (EmptyUtil.isNoEmpty((String)isfromChequelist)) {
                long cheuqeInventoryId = Long.parseLong(isfromChequelist);
                DynamicObject[] chequeActualDy = BusinessDataServiceHelper.load((String)"cdm_chequeinventory", (String)"id,blankactual_ncd_entry,blankactual_ncd_entry.e_ncd_blankactual,blankactualcount,blankchequecount,blankdifferecount,blankactual_cd_entry", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)cheuqeInventoryId)});
                DynamicObject blankCheuqeDy = chequeActualDy[0];
                DynamicObjectCollection blancAcutalNcdEntry = blankCheuqeDy.getDynamicObjectCollection("blankactual_ncd_entry");
                DynamicObjectCollection blancAcutalcdEntry = blankCheuqeDy.getDynamicObjectCollection("blankactual_cd_entry");
                for (DynamicObject actualDy : newList) {
                    DynamicObject entry = blancAcutalNcdEntry.addNew();
                    entry.set("e_ncd_blankactual", (Object)actualDy);
                }
                int size = blancAcutalNcdEntry.size();
                int cdSize = blancAcutalcdEntry.size();
                int blankActualCount = size + cdSize;
                blankCheuqeDy.set("blankactualcount", (Object)blankActualCount);
                int blankChequeCount = blankCheuqeDy.getInt("blankchequecount");
                blankCheuqeDy.set("blankdifferecount", (Object)(blankActualCount - blankChequeCount));
                ArrayList<DynamicObject> listDy = new ArrayList<DynamicObject>();
                listDy.add(blankCheuqeDy);
                SaveServiceHelper.save((DynamicObject[])listDy.toArray(new DynamicObject[0]));
            }
            ParamMap paramMap = new ParamMap();
            this.getView().returnDataToParent((Object)paramMap);
            this.getView().close();
        }
    }

    private List<String> createNosBy(int amount, String codeRule, String startNo, String replaceChar) {
        long maxVal;
        ArrayList<String> noList = new ArrayList<String>(amount);
        int firstIndex = codeRule.indexOf(replaceChar);
        int endIndex = codeRule.lastIndexOf(replaceChar);
        int replaceLenth = endIndex - firstIndex + 1;
        StringBuilder replaceBuilder = new StringBuilder(replaceChar);
        for (int i = 1; i < replaceLenth; ++i) {
            replaceBuilder.append(replaceChar);
        }
        String replace = replaceBuilder.toString();
        long firstNo = Long.parseLong(startNo);
        long lastNo = firstNo + (long)amount - 1L;
        lastNo = lastNo >= (maxVal = this.getMaxValueBy(replaceLenth)) ? maxVal : lastNo;
        String subStr = "000000000000000000";
        for (long n = firstNo; n <= lastNo; ++n) {
            String num = String.valueOf(n);
            int diffLength = replaceLenth - num.length();
            num = subStr.substring(0, diffLength) + num;
            noList.add(codeRule.replace(replace, num));
        }
        return noList;
    }

    private long getMaxValueBy(int replaceLenth) {
        String subStr = "999999999999999999";
        if (replaceLenth > 18) {
            return Long.parseLong(subStr);
        }
        subStr = subStr.substring(0, replaceLenth);
        return Long.parseLong(subStr);
    }

    private void authorizedCompanyListener() {
        BasedataEdit company = (BasedataEdit)this.getControl("org");
        company.addBeforeF7SelectListener(evt -> {
            ListShowParameter showParameter = (ListShowParameter)evt.getFormShowParameter();
            String appId = this.getView().getFormShowParameter().getAppId();
            DynamicObjectCollection orgDOC = TmcOrgDataHelper.getAuthorizedBankOrg((Long)RequestContext.get().getCurrUserId(), (String)appId, (String)"cdm_chequeinventory", (String)"47156aff000000ac");
            List orgList = TmcOrgDataHelper.getIdList((DynamicObjectCollection)orgDOC);
            showParameter.setCustomParam("range", (Object)orgList);
            showParameter.getListFilterParameter().getQFilters().add(new QFilter("id", "in", (Object)orgList));
        });
    }

    private void addCurrencyListener() {
        BasedataEdit bankCurrency = (BasedataEdit)this.getControl("currency");
        if (Objects.nonNull(bankCurrency)) {
            bankCurrency.addBeforeF7SelectListener(evt -> {
                ListShowParameter parameter = (ListShowParameter)evt.getFormShowParameter();
                DynamicObject bankAcc = (DynamicObject)this.getModel().getValue("accountbank");
                DynamicObject orgDy = (DynamicObject)this.getModel().getValue("org");
                if (EmptyUtil.isEmpty((DynamicObject)orgDy)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u8d44\u91d1\u7ec4\u7ec7\u3002", (String)"DraftsInventoryEdit_2", (String)"tmc-cdm-formplugin", (Object[])new Object[0]), Integer.valueOf(2000));
                    evt.setCancel(true);
                    return;
                }
                ListFilterParameter listFilterParameter = parameter.getListFilterParameter();
                if (Objects.nonNull(bankAcc)) {
                    Set bankAccCurrIdSet = bankAcc.getDynamicObjectCollection("currency").stream().filter(e -> EmptyUtil.isNoEmpty((DynamicObject)e.getDynamicObject("fbasedataid"))).map(e -> e.getDynamicObject("fbasedataid").getLong("id")).collect(Collectors.toSet());
                    listFilterParameter.getQFilters().add(new QFilter("id", "in", bankAccCurrIdSet));
                }
            });
        }
    }
}

