/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cdm.formplugin.billsInventory;

import java.math.BigDecimal;
import java.util.Date;
import java.util.EventObject;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.AfterDeleteRowEventArgs;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.formplugin.edit.AbstractTmcBillEdit;

public class ChequeInventoryEdit
extends AbstractTmcBillEdit {
    public static String ACTIONKEY = "cdm_blankactualgen_callback";

    public void registerListener(EventObject e) {
        super.registerListener(e);
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        super.beforeItemClick(evt);
        String itemKey = evt.getItemKey();
        int blankDiffCount = (Integer)this.getModel().getValue("blankdifferecount");
        BigDecimal filleddiffereAmount = (BigDecimal)this.getModel().getValue("filleddiffamount");
        switch (itemKey) {
            case "bar_submit": 
            case "bar_unsubmit": {
                boolean isNotNullFilledDiffAmount;
                boolean isNotNullBlankDifCount = blankDiffCount != 0;
                boolean bl = isNotNullFilledDiffAmount = EmptyUtil.isNoEmpty((BigDecimal)filleddiffereAmount) && BigDecimal.ZERO.compareTo(filleddiffereAmount) != 0;
                if (isNotNullBlankDifCount && isNotNullFilledDiffAmount) {
                    this.getView().showConfirm(ResManager.loadKDString((String)"\u7a7a\u767d\u7968\u636e\u76d8\u70b9\u4ee5\u53ca\u5df2\u586b\u5f00\u7968\u636e\u76d8\u70b9\u5b58\u5728\u5dee\u5f02\uff0c\u662f\u5426\u7ee7\u7eed?", (String)"ChequeInventoryEdit_1", (String)"tmc-cdm-formplugin", (Object[])new Object[0]), MessageBoxOptions.YesNo, ConfirmTypes.Default, new ConfirmCallBackListener(itemKey, (IFormPlugin)this));
                    break;
                }
                if (isNotNullBlankDifCount && !isNotNullFilledDiffAmount) {
                    this.getView().showConfirm(ResManager.loadKDString((String)"\u7a7a\u767d\u7968\u636e\u76d8\u70b9\u5b58\u5728\u5dee\u5f02\uff0c\u662f\u5426\u7ee7\u7eed?", (String)"ChequeInventoryEdit_2", (String)"tmc-cdm-formplugin", (Object[])new Object[0]), MessageBoxOptions.YesNo, ConfirmTypes.Default, new ConfirmCallBackListener(itemKey, (IFormPlugin)this));
                    break;
                }
                if (!isNotNullBlankDifCount && isNotNullFilledDiffAmount) {
                    this.getView().showConfirm(ResManager.loadKDString((String)"\u5df2\u586b\u5f00\u7968\u636e\u76d8\u70b9\u5b58\u5728\u5dee\u5f02\uff0c\u662f\u5426\u7ee7\u7eed?", (String)"ChequeInventoryEdit_3", (String)"tmc-cdm-formplugin", (Object[])new Object[0]), MessageBoxOptions.YesNo, ConfirmTypes.Default, new ConfirmCallBackListener(itemKey, (IFormPlugin)this));
                    break;
                }
                this.callSubmitOp(itemKey);
                break;
            }
            case "bar_ncd_addfillentry": {
                FormShowParameter para = new FormShowParameter();
                para.setCustomParam("isfromchequelist", (Object)this.getModel().getDataEntity().getString("id"));
                para.setFormId("cdm_cheque_purch");
                para.setCloseCallBack(new CloseCallBack((IFormPlugin)this, ACTIONKEY));
                para.getOpenStyle().setShowType(ShowType.Modal);
                this.getView().showForm(para);
                break;
            }
        }
    }

    private void callSubmitOp(String itemKey) {
        OperationResult operationResult;
        OperateOption op;
        if ("bar_submit".equalsIgnoreCase(itemKey)) {
            op = OperateOption.create();
            operationResult = this.getView().invokeOperation("submit", op);
        }
        if ("bar_unsubmit".equalsIgnoreCase(itemKey)) {
            op = OperateOption.create();
            operationResult = this.getView().invokeOperation("unsubmit", op);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        String operateKey;
        super.afterDoOperation(e);
        switch (operateKey = e.getOperateKey()) {
            case "loadaddchequeop": {
                if (!e.getOperationResult().isSuccess()) break;
                FormShowParameter para = new FormShowParameter();
                para.setCustomParam("isfromchequelist", (Object)this.getModel().getDataEntity().getString("id"));
                Date inventoryDate = (Date)this.getModel().getValue("inventorydate");
                para.setCustomParam("inventorydate", (Object)DateUtils.formatString((Date)inventoryDate, (String)"yyyy-MM-dd"));
                para.setFormId("cdm_blankactualgen");
                para.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "cdm_blankactualgen_callback"));
                para.getOpenStyle().setShowType(ShowType.Modal);
                this.getView().showForm(para);
                break;
            }
            case "loadaddfillactualop": {
                if (!e.getOperationResult().isSuccess()) break;
                FormShowParameter para = new FormShowParameter();
                para.setCustomParam("isfromchequelist", (Object)this.getModel().getDataEntity().getString("id"));
                Date inventoryDate = (Date)this.getModel().getValue("inventorydate");
                para.setCustomParam("inventorydate", (Object)DateUtils.formatString((Date)inventoryDate, (String)"yyyy-MM-dd"));
                para.setFormId("cdm_filledactualge");
                para.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "cdm_filledactualgen_callback"));
                para.getOpenStyle().setShowType(ShowType.Modal);
                this.getView().showForm(para);
                break;
            }
            case "autoinventory": 
            case "cancelinventory": {
                if (!e.getOperationResult().isSuccess()) break;
                this.getView().invokeOperation("refresh");
                break;
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent e) {
        super.confirmCallBack(e);
        String callBackId = e.getCallBackId();
        if (("bar_submit".equals(callBackId) || "bar_unsubmit".equals(callBackId)) && e.getResult() == MessageBoxResult.Yes) {
            this.callSubmitOp(callBackId);
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        String actionId;
        super.closedCallBack(closedCallBackEvent);
        switch (actionId = closedCallBackEvent.getActionId()) {
            case "cdm_blankactualgen_callback": 
            case "cdm_filledactualgen_callback": {
                this.getView().invokeOperation("refresh");
                break;
            }
        }
    }

    public void afterDeleteRow(AfterDeleteRowEventArgs e) {
        String key;
        super.afterDeleteRow(e);
        switch (key = e.getEntryProp().getName()) {
            case "blankactual_ncd_entry": {
                DynamicObjectCollection blank_ncd_entrys = this.getModel().getEntryEntity("blankactual_ncd_entry");
                DynamicObjectCollection blank_cd_entrys = this.getModel().getEntryEntity("blankactual_cd_entry");
                int blankChequeCount = (Integer)this.getModel().getValue("blankchequecount");
                int blank_cd_Size = blank_cd_entrys.size();
                if (EmptyUtil.isNoEmpty((DynamicObjectCollection)blank_ncd_entrys)) {
                    int blankEntrySize = blank_ncd_entrys.size();
                    int blankCount = blankEntrySize + blank_cd_Size;
                    this.getModel().setValue("blankactualcount", (Object)blankCount);
                    this.getModel().setValue("blankdifferecount", (Object)(blankCount - blankChequeCount));
                    break;
                }
                this.getModel().setValue("blankactualcount", (Object)blank_cd_Size);
                this.getModel().setValue("blankdifferecount", (Object)(blank_cd_Size - blankChequeCount));
                break;
            }
            case "filledactual_ncd_entry": {
                DynamicObjectCollection filled_ncd_entrys = this.getModel().getEntryEntity("filledactual_ncd_entry");
                DynamicObjectCollection filled_cd_entrys = this.getModel().getEntryEntity("filledactual_cd_entry");
                BigDecimal fillncdAmountSum = filled_ncd_entrys.stream().filter(e1 -> null != e1.getDynamicObject("e_ncd_fiillactual")).map(e1 -> e1.getDynamicObject("e_ncd_fiillactual").getBigDecimal("payamount")).reduce(BigDecimal.ZERO, BigDecimal::add);
                BigDecimal fillcdAmountSum = filled_cd_entrys.stream().filter(e2 -> null != e2.getDynamicObject("e_cd_filledactual")).map(e2 -> e2.getDynamicObject("e_cd_filledactual").getBigDecimal("payamount")).reduce(BigDecimal.ZERO, BigDecimal::add);
                BigDecimal fillChequeAmount = (BigDecimal)this.getModel().getValue("filledchequeamount");
                int filled_cd_entrysSize = filled_cd_entrys.size();
                BigDecimal fillAmountSum = fillncdAmountSum.add(fillcdAmountSum);
                if (EmptyUtil.isNoEmpty((DynamicObjectCollection)filled_ncd_entrys)) {
                    int filled_ncd_EntrySize = filled_ncd_entrys.size();
                    int actualCount = filled_ncd_EntrySize + filled_cd_entrysSize;
                    this.getModel().setValue("filledactualcount", (Object)actualCount);
                    this.getModel().setValue("filledacutaiamount", (Object)fillAmountSum);
                    this.getModel().setValue("filleddiffamount", (Object)fillAmountSum.subtract(fillChequeAmount));
                    break;
                }
                this.getModel().setValue("filledactualcount", (Object)filled_cd_entrysSize);
                this.getModel().setValue("filledacutaiamount", (Object)fillcdAmountSum);
                this.getModel().setValue("filleddiffamount", (Object)fillcdAmountSum.subtract(fillChequeAmount));
                break;
            }
        }
    }
}

