/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cdm.formplugin.billsInventory;

import java.util.Date;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.FormShowParameter;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.list.events.ListRowClickListener;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.tmc.cdm.common.helper.DraftHelper;
import kd.tmc.fbp.common.helper.TmcOrgDataHelper;
import kd.tmc.fbp.common.param.ParamMap;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;

public class ChequeInventoryRangeEdit
extends AbstractFormPlugin
implements ListRowClickListener {
    private static Log logger = LogFactory.getLog(ChequeInventoryRangeEdit.class);
    private boolean skipPropChange;

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.authorizedCompanyListener();
        this.addAccountListener();
        this.addCurrencyListener();
    }

    private void addAccountListener() {
        BasedataEdit bankAccount = (BasedataEdit)this.getControl("bankaccount");
        if (Objects.nonNull(bankAccount)) {
            bankAccount.addBeforeF7SelectListener(evt -> {
                ListShowParameter parameter = (ListShowParameter)evt.getFormShowParameter();
                DynamicObject currency = (DynamicObject)this.getModel().getValue("currency");
                DynamicObject orgDy = (DynamicObject)this.getModel().getValue("org");
                if (EmptyUtil.isEmpty((DynamicObject)orgDy)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u8d44\u91d1\u7ec4\u7ec7\u3002", (String)"DraftsInventoryEdit_2", (String)"tmc-cdm-formplugin", (Object[])new Object[0]), Integer.valueOf(2000));
                    return;
                }
                ListFilterParameter listFilterParameter = parameter.getListFilterParameter();
                if (Objects.nonNull(currency)) {
                    listFilterParameter.getQFilters().add(new QFilter("currency.fbasedataid", "=", currency.getPkValue()));
                } else {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u5e01\u79cd\u3002", (String)"DraftsInventoryEdit_1", (String)"tmc-cdm-formplugin", (Object[])new Object[0]), Integer.valueOf(2000));
                }
            });
        }
    }

    public void afterCreateNewData(EventObject e) {
        Object org;
        super.afterCreateNewData(e);
        Object dataDate = this.getModel().getValue("datdate");
        if (EmptyUtil.isEmpty((Object)dataDate)) {
            this.setBizDateByBizType();
        }
        if (EmptyUtil.isEmpty((Object)(org = this.getModel().getValue("org")))) {
            RequestContext requestContext = RequestContext.get();
            long orgId = requestContext.getOrgId();
            MainEntityType orgType = EntityMetadataCache.getDataEntityType((String)"bos_org");
            DynamicObject currentOrg = BusinessDataServiceHelper.loadSingle((Object)orgId, (DynamicObjectType)orgType);
            if (currentOrg.getBoolean("fisbankroll")) {
                this.getModel().setValue("org", (Object)orgId);
                long standardCurrency = DraftHelper.getMainCurrByOrg((DynamicObject)currentOrg);
                if (0L != standardCurrency) {
                    this.getModel().setValue("currency", (Object)standardCurrency);
                }
            }
        }
        boolean isByBnak = (Boolean)this.getModel().getValue("isbybankaccount");
        ((FieldEdit)this.getView().getControl("bankaccount")).setMustInput(isByBnak);
    }

    private void setBizDateByBizType() {
        Date yesterday = DateUtils.getLastDay((Date)new Date(), (int)1);
        Date date = DateUtils.stringToDate((String)DateUtils.formatString((Date)yesterday, (String)"yyyy-MM-dd"), (String)"yyyy-MM-dd");
        this.skipPropChange = true;
        this.getModel().setValue("datdate", (Object)date);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String key;
        if (this.skipPropChange) {
            this.skipPropChange = false;
            return;
        }
        switch (key = e.getProperty().getName()) {
            case "org": {
                DynamicObject currentOrg;
                long standardCurrency;
                this.getModel().setValue("bankaccount", null);
                Object org = this.getModel().getValue("org");
                if (!EmptyUtil.isNoEmpty((Object)org) || 0L == (standardCurrency = DraftHelper.getMainCurrByOrg((DynamicObject)(currentOrg = (DynamicObject)org)))) break;
                this.getModel().setValue("currency", (Object)standardCurrency);
                break;
            }
            case "datdate": {
                Object dateDy = this.getModel().getValue("datdate");
                if (null == dateDy) break;
                Date date = DateUtils.stringToDate((String)DateUtils.formatString((Date)((Date)dateDy), (String)"yyyy-MM-dd"), (String)"yyyy-MM-dd");
                this.getModel().setValue("datdate", (Object)date);
                break;
            }
            case "inventorydate": {
                Object dateInventoryDy = this.getModel().getValue("inventorydate");
                if (null == dateInventoryDy) break;
                Date inventoryDate = DateUtils.stringToDate((String)DateUtils.formatString((Date)((Date)dateInventoryDy), (String)"yyyy-MM-dd"), (String)"yyyy-MM-dd");
                this.getModel().setValue("inventorydate", (Object)inventoryDate);
                break;
            }
            case "isbybankaccount": {
                boolean isByBnak = (Boolean)this.getModel().getValue("isbybankaccount");
                ((FieldEdit)this.getView().getControl("bankaccount")).setMustInput(isByBnak);
                if (isByBnak) break;
                this.getModel().setValue("bankaccount", null);
                break;
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        AbstractOperate op = (AbstractOperate)args.getSource();
        String operateKey = op.getOperateKey();
        if ("loadinventorydata".equals(operateKey)) {
            // empty if block
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public void afterDoOperation(AfterDoOperationEventArgs e) {
        super.afterDoOperation(e);
        String operateKey = e.getOperateKey();
        FormShowParameter fsp = this.getView().getFormShowParameter();
        String isfromChequelist = (String)fsp.getCustomParam("isfromchequelist");
        if (EmptyUtil.isEmpty((String)isfromChequelist) || !"y".equalsIgnoreCase(isfromChequelist)) {
            return;
        }
        if ("loadchequedata".equals(operateKey) && e.getOperationResult().isSuccess()) {
            long orgId = ((DynamicObject)this.getModel().getValue("org")).getLong("id");
            boolean isbyBankAccount = (Boolean)this.getModel().getValue("isbybankaccount");
            boolean isinventoryFilled = (Boolean)this.getModel().getValue("isinventoryfilled");
            Date datDate = (Date)this.getModel().getValue("datdate");
            Date newDate = DateUtils.stringToDate((String)DateUtils.formatString((Date)datDate, (String)"yyyy-MM-dd"), (String)"yyyy-MM-dd");
            QFilter orgIdQFilter = new QFilter("company", "=", (Object)orgId);
            QFilter dateIdQFilter = new QFilter("bizdate", "=", (Object)newDate);
            if (isbyBankAccount) {
                QFilter byAccountQFilter;
                long bankAccountid = ((DynamicObject)this.getModel().getValue("bankaccount")).getLong("id");
                QFilter accountIdQFilter = new QFilter("bankaccount", "=", (Object)bankAccountid);
                boolean isExistsByAcc = QueryServiceHelper.exists((String)"cdm_chequeinventory", (QFilter[])new QFilter[]{orgIdQFilter, dateIdQFilter, accountIdQFilter, byAccountQFilter = new QFilter("isbybankaccount", "=", (Object)Character.valueOf('1'))});
                if (isExistsByAcc) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u5df2\u5b58\u5728\u8be5\u65e5\u671f\u7684\u76d8\u70b9\u6570\u636e\uff0c\u4e0d\u80fd\u91cd\u590d\u76d8\u70b9\u3002", (String)"ChequeInventoryRangeEdit_1", (String)"tmc-cdm-formplugin", (Object[])new Object[0]), Integer.valueOf(2000));
                    return;
                }
                QFilter noByAccountQFilter = new QFilter("isbybankaccount", "=", (Object)Character.valueOf('0'));
                boolean isExistsNoByAcc = QueryServiceHelper.exists((String)"cdm_chequeinventory", (QFilter[])new QFilter[]{orgIdQFilter, dateIdQFilter, noByAccountQFilter});
                if (isExistsNoByAcc) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u5df2\u5b58\u5728\u8be5\u65e5\u671f\u7684\u76d8\u70b9\u6570\u636e\uff0c\u4e0d\u80fd\u91cd\u590d\u76d8\u70b9\u3002", (String)"ChequeInventoryRangeEdit_1", (String)"tmc-cdm-formplugin", (Object[])new Object[0]), Integer.valueOf(2000));
                    return;
                }
            } else {
                boolean isExists = QueryServiceHelper.exists((String)"cdm_chequeinventory", (QFilter[])new QFilter[]{orgIdQFilter, dateIdQFilter});
                if (isExists) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u5df2\u5b58\u5728\u8be5\u65e5\u671f\u7684\u76d8\u70b9\u6570\u636e\uff0c\u4e0d\u80fd\u91cd\u590d\u76d8\u70b9\u3002", (String)"ChequeInventoryRangeEdit_1", (String)"tmc-cdm-formplugin", (Object[])new Object[0]), Integer.valueOf(2000));
                    return;
                }
            }
            this.callAddInventoryData();
        }
    }

    private void callAddInventoryData() {
        DynamicObject dataDy = this.getModel().getDataEntity(true);
        OperationResult operationResult = OperationServiceHelper.executeOperate((String)"addchequedata", (String)"cdm_chequeinventoryrange", (DynamicObject[])new DynamicObject[]{dataDy}, (OperateOption)OperateOption.create());
        if (EmptyUtil.isNoEmpty((Object)operationResult) && operationResult.isSuccess()) {
            Map billNosMap = operationResult.getBillNos();
            if (EmptyUtil.isNoEmpty((String)((String)billNosMap.get("inventoryBillId")))) {
                String inventoryBillId = (String)billNosMap.get("inventoryBillId");
                ParamMap paramMap = new ParamMap();
                paramMap.put("inventoryBillId", (Object)inventoryBillId);
                this.getView().returnDataToParent((Object)paramMap);
                this.getView().close();
            } else {
                List list = operationResult.getAllErrorInfo();
            }
        }
    }

    private void authorizedCompanyListener() {
        BasedataEdit company = (BasedataEdit)this.getControl("org");
        company.addBeforeF7SelectListener(evt -> {
            ListShowParameter showParameter = (ListShowParameter)evt.getFormShowParameter();
            String appId = this.getView().getFormShowParameter().getAppId();
            DynamicObjectCollection orgDOC = TmcOrgDataHelper.getAuthorizedBankOrg((Long)RequestContext.get().getCurrUserId(), (String)appId, (String)"cdm_chequeinventory", (String)"47156aff000000ac");
            List orgList = TmcOrgDataHelper.getIdList((DynamicObjectCollection)orgDOC);
            showParameter.setCustomParam("range", (Object)orgList);
            showParameter.getListFilterParameter().getQFilters().add(new QFilter("id", "in", (Object)orgList));
        });
    }

    private void addCurrencyListener() {
        BasedataEdit bankCurrency = (BasedataEdit)this.getControl("currency");
        if (Objects.nonNull(bankCurrency)) {
            bankCurrency.addBeforeF7SelectListener(evt -> {
                ListShowParameter parameter = (ListShowParameter)evt.getFormShowParameter();
                DynamicObject bankAcc = (DynamicObject)this.getModel().getValue("bankaccount");
                DynamicObject orgDy = (DynamicObject)this.getModel().getValue("org");
                if (EmptyUtil.isEmpty((DynamicObject)orgDy)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u8d44\u91d1\u7ec4\u7ec7\u3002", (String)"DraftsInventoryEdit_2", (String)"tmc-cdm-formplugin", (Object[])new Object[0]), Integer.valueOf(2000));
                    evt.setCancel(true);
                    return;
                }
                ListFilterParameter listFilterParameter = parameter.getListFilterParameter();
                if (Objects.nonNull(bankAcc)) {
                    Set bankAccCurrIdSet = bankAcc.getDynamicObjectCollection("currency").stream().filter(e -> EmptyUtil.isNoEmpty((DynamicObject)e.getDynamicObject("fbasedataid"))).map(e -> e.getDynamicObject("fbasedataid").getLong("id")).collect(Collectors.toSet());
                    listFilterParameter.getQFilters().add(new QFilter("id", "in", bankAccCurrIdSet));
                }
            });
        }
    }
}

