/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cdm.formplugin.billsInventory;

import java.util.Date;
import java.util.EventObject;
import java.util.List;
import java.util.StringJoiner;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.validate.ValidateResult;
import kd.bos.entity.validate.ValidateResultCollection;
import kd.bos.form.control.Button;
import kd.bos.form.control.events.BeforeClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.events.ListRowClickListener;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.tmc.fbp.common.param.ParamMap;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;

public class ImportBankDraftsEdit
extends AbstractFormPlugin
implements ListRowClickListener {
    private boolean skipPropChange;

    public void registerListener(EventObject e) {
        super.registerListener(e);
    }

    public void afterCreateNewData(EventObject e) {
        Object org;
        super.afterCreateNewData(e);
        Object dataDate = this.getModel().getValue("datadate");
        if (EmptyUtil.isEmpty((Object)dataDate)) {
            this.setBizDateByBizType();
        }
        if (EmptyUtil.isEmpty((Object)(org = this.getModel().getValue("org")))) {
            RequestContext requestContext = RequestContext.get();
            long orgId = requestContext.getOrgId();
            MainEntityType orgType = EntityMetadataCache.getDataEntityType((String)"bos_org");
            DynamicObject currentOrg = BusinessDataServiceHelper.loadSingleFromCache((Object)orgId, (DynamicObjectType)orgType);
            if (currentOrg.getBoolean("fisbankroll")) {
                this.getModel().setValue("org", (Object)orgId);
            }
        }
    }

    private void setBizDateByBizType() {
        String importWay = (String)this.getModel().getValue("importway");
        if ("bei".equals(importWay)) {
            Date date = DateUtils.stringToDate((String)DateUtils.formatString((Date)new Date(), (String)"yyyy-MM-dd"), (String)"yyyy-MM-dd");
            this.skipPropChange = true;
            this.getModel().setValue("datadate", (Object)date);
        } else {
            Date yesterday = DateUtils.getLastDay((Date)new Date(), (int)1);
            Date date = DateUtils.stringToDate((String)DateUtils.formatString((Date)yesterday, (String)"yyyy-MM-dd"), (String)"yyyy-MM-dd");
            this.skipPropChange = true;
            this.getModel().setValue("datadate", (Object)date);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String key;
        if (this.skipPropChange) {
            this.skipPropChange = false;
            return;
        }
        switch (key = e.getProperty().getName()) {
            case "importway": {
                this.setBizDateByBizType();
                break;
            }
            case "org": {
                this.getModel().setValue("bankaccount", null);
                break;
            }
            case "datadate": {
                Object datadate = this.getModel().getValue("datadate");
                if (null == datadate) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u6570\u636e\u65e5\u671f\u3002", (String)"BankDraftsSaveValidator_1_2", (String)"tmc-cdm-business", (Object[])new Object[0]));
                    return;
                }
                Date date = DateUtils.stringToDate((String)DateUtils.formatString((Date)((Date)datadate), (String)"yyyy-MM-dd"), (String)"yyyy-MM-dd");
                this.skipPropChange = true;
                this.getModel().setValue("datadate", (Object)date);
                break;
            }
        }
    }

    public void beforeClick(BeforeClickEvent evt) {
        String key;
        super.beforeClick(evt);
        Object source = evt.getSource();
        if (!(source instanceof Button) || "btnok".equals(key = ((Button)source).getKey())) {
            // empty if block
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        AbstractOperate op = (AbstractOperate)args.getSource();
        String operateKey = op.getOperateKey();
        if ("confirmop".equals(operateKey)) {
            String importWay = (String)this.getModel().getValue("importway");
            DynamicObject bankaccount = (DynamicObject)this.getModel().getValue("bankaccount");
            if (null == bankaccount) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u94f6\u884c\u8d26\u53f7\u3002", (String)"BankDraftsSaveValidator_1_1", (String)"tmc-cdm-business", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            Date datadate = (Date)this.getModel().getValue("datadate");
            if (null == datadate) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u6570\u636e\u65e5\u671f\u3002", (String)"BankDraftsSaveValidator_1_2", (String)"tmc-cdm-business", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            DynamicObjectCollection bankDraftsDb = QueryServiceHelper.query((String)"cdm_bankdrafts", (String)"id,bankaccount,datadate,bankdraftentry.e_inventorystatus", (QFilter[])new QFilter[]{new QFilter("bankaccount", "=", (Object)bankaccount.getLong("id")), new QFilter("datadate", "=", (Object)datadate), new QFilter("bankdraftentry.e_inventorystatus", "=", (Object)"B")});
            if (EmptyUtil.isNoEmpty((DynamicObjectCollection)bankDraftsDb)) {
                String bankAccName = bankaccount.getString("name");
                String dateStr = DateUtils.formatString((Date)datadate, (String)"yyyy-MM-dd");
                this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u6570\u636e\u65e5\u671f\uff1a%1$s, \u94f6\u884c\u8d26\u6237\uff1a%2$s\uff1a\u4e0d\u80fd\u91cd\u590d\u7ef4\u62a4\u5df2\u76d8\u70b9\u7684\u6570\u636e\u3002", (String)"BankDraftsSaveValidator_1", (String)"tmc-cdm-business", (Object[])new Object[0]), dateStr, bankAccName));
                args.setCancel(true);
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        super.afterDoOperation(e);
        String operateKey = e.getOperateKey();
        if ("confirmop".equals(operateKey) && e.getOperationResult().isSuccess()) {
            String importWay = (String)this.getModel().getValue("importway");
            if ("bei".equals(importWay)) {
                DynamicObject dataDy = this.getModel().getDataEntity(true);
                OperationResult operationResult = OperationServiceHelper.executeOperate((String)"querybeidrafts", (String)"cdm_importbankdata", (DynamicObject[])new DynamicObject[]{dataDy}, (OperateOption)OperateOption.create());
                if (EmptyUtil.isNoEmpty((Object)operationResult)) {
                    if (operationResult.isSuccess()) {
                        ParamMap paramMap = new ParamMap();
                        paramMap.put("dataSource", (Object)"bei");
                        this.getView().returnDataToParent((Object)paramMap);
                        this.getView().close();
                    } else {
                        ValidateResultCollection validateResult = operationResult.getValidateResult();
                        List validateErrors = validateResult.getValidateErrors();
                        StringJoiner stringJoiner = new StringJoiner("\r\n");
                        for (ValidateResult validateError : validateErrors) {
                            List allErrorInfos = validateError.getAllErrorInfo();
                            for (OperateErrorInfo allErrorMsg : allErrorInfos) {
                                if (!EmptyUtil.isNoEmpty((Object)allErrorMsg)) continue;
                                stringJoiner.add(allErrorMsg.getMessage());
                            }
                        }
                        if (EmptyUtil.isNoEmpty((String)stringJoiner.toString())) {
                            this.getView().showErrorNotification(stringJoiner.toString());
                        }
                    }
                }
            } else {
                ParamMap paramMap = new ParamMap();
                DynamicObject orgDy = (DynamicObject)this.getModel().getValue("org");
                DynamicObject bankaccount = (DynamicObject)this.getModel().getValue("bankaccount");
                Date datadate = (Date)this.getModel().getValue("datadate");
                String biztype = (String)this.getModel().getValue("biztype");
                paramMap.put("dataSource", (Object)"import");
                paramMap.put("biztype", (Object)biztype);
                paramMap.put("orgid", (Object)orgDy.getString("id"));
                paramMap.put("bankaccid", (Object)bankaccount.getString("id"));
                paramMap.put("bankaccid", (Object)bankaccount.getString("id"));
                paramMap.put("datadate", (Object)DateUtils.formatString((Date)datadate, (String)"yyyy-MM-dd"));
                this.getView().returnDataToParent((Object)paramMap);
                this.getView().close();
            }
        }
    }
}

