/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cdm.formplugin.cheque;

import java.util.ArrayList;
import java.util.EventObject;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.mvc.list.ListView;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.cdm.common.helper.ChequeHelper;

public class ChequeF7ListPlugin
extends AbstractListPlugin {
    private static final String BTN_RETURN_DATA = "returndata";
    private static final String ENTRY_LIST = "chequelist";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{BTN_RETURN_DATA});
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        if (!(e.getSource() instanceof ListView)) {
            return;
        }
        ListView listView = (ListView)e.getSource();
        ListSelectedRowCollection selectedRows = listView.getSelectedRows();
        if (selectedRows == null) {
            return;
        }
        ArrayList<Object> ids = new ArrayList<Object>();
        for (ListSelectedRow row : selectedRows) {
            ids.add(row.getPrimaryKeyValue());
        }
        if (ids.isEmpty()) {
            return;
        }
        QFilter filter = new QFilter("id", "in", ids);
        DynamicObjectCollection cheques = QueryServiceHelper.query((String)"cdm_cheque_purch", (String)"id,billno,chequestatus", (QFilter[])new QFilter[]{filter});
        if (cheques == null || cheques.isEmpty()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6570\u636e\u5df2\u4e0d\u5b58\u5728\uff01", (String)"ChequeF7ListPlugin_0", (String)"tmc-cdm-formplugin", (Object[])new Object[0]));
            return;
        }
        StringBuilder sb = new StringBuilder();
        for (DynamicObject cheque : cheques) {
            if ("0".equals(cheque.getString("chequestatus"))) continue;
            sb.append(cheque.getString("billno")).append(": ").append((String)ChequeHelper.chequeStatusMap.get(cheque.getString("chequestatus"))).append(' ');
        }
        if (sb.length() > 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)String.format("%s", sb.toString()), (String)"ChequeF7ListPlugin_1", (String)"tmc-cdm-formplugin", (Object[])new Object[0]));
            e.setCancel(true);
        }
    }

    public void setFilter(SetFilterEvent e) {
        e.setOrderBy("purchdate asc,createtime asc,billno asc");
    }
}

