/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cdm.formplugin.cheque;

import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import java.util.Optional;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.Save;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.org.utils.Utils;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.tmc.cdm.common.helper.ChequeHelper;
import kd.tmc.cdm.common.property.ChequeProp;
import kd.tmc.fbp.common.helper.TmcAccountHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcOrgDataHelper;
import kd.tmc.fbp.common.helper.VisibleVirtualAcctHelper;

public class ChequePurchEditPlugin
extends AbstractFormPlugin
implements BeforeF7SelectListener {
    private Log log = LogFactory.getLog(ChequeHelper.class);
    private static final String VALUE_MUTEX_CHANGE_KEY = "valueMutexCacheKey";

    public void initialize() {
        super.initialize();
        this.addListener();
    }

    protected void addListener() {
        BasedataEdit purchase = (BasedataEdit)this.getControl("purchase");
        purchase.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit accountBank = (BasedataEdit)this.getControl("accountbank");
        accountBank.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            DynamicObject orgDyn = (DynamicObject)this.getModel().getValue("org");
            long orgID = orgDyn == null ? 0L : Long.parseLong(orgDyn.getPkValue().toString());
            QFilter accountAuthAssignFilter = TmcAccountHelper.getAccountBankFilterByOrg((Long)orgID);
            QFilter companyFilter = new QFilter("acctstatus", "not in", (Object)new String[]{"closed", "changing"});
            showParameter.getListFilterParameter().getQFilters().add(VisibleVirtualAcctHelper.notVirtualAcctQf().and(accountAuthAssignFilter).and(companyFilter));
        });
        BasedataEdit bank = (BasedataEdit)this.getControl("bank");
        bank.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            if (VisibleVirtualAcctHelper.notVirtualBankQf() != null) {
                showParameter.getListFilterParameter().getQFilters().add(VisibleVirtualAcctHelper.notVirtualBankQf());
            }
        });
        BasedataEdit billType = (BasedataEdit)this.getControl("billtype");
        billType.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit org = (BasedataEdit)this.getControl("org");
        org.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.initFormDefualtData();
        this.setFieldEnable();
        this.getModel().setDataChanged(false);
    }

    private void setFieldEnable() {
        String batchNo = this.getModel().getDataEntity().getString("batchno");
        if (StringUtils.isEmpty((CharSequence)batchNo)) {
            return;
        }
        QFilter filter = new QFilter("batchno", "=", (Object)batchNo);
        QFilter status = new QFilter("chequestatus", "!=", (Object)"0");
        if (QueryServiceHelper.exists((String)"cdm_cheque_purch", (QFilter[])new QFilter[]{filter, status})) {
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"purchdate", "org", "purchase", "billtype", "accountbank", "bank", "currencylist", "amount"});
        }
        QFilter fillFilter = new QFilter("chequestatus", "=", (Object)"2");
        if (QueryServiceHelper.exists((String)"cdm_cheque_purch", (QFilter[])new QFilter[]{filter, fillFilter})) {
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"coderule", "replacechar", "startno"});
        }
    }

    private void initFormDefualtData() {
        if (this.getModel().getValue("purchase") == null) {
            this.getModel().setValue("purchase", (Object)RequestContext.get().getUserId());
        }
        if (null == this.getModel().getValue("billtype")) {
            this.fillBillType();
        }
        DynamicObject acctBank = this.getModel().getDataEntity().getDynamicObject("accountbank");
        this.fillCurrencys(acctBank);
    }

    private void fillBillType() {
        QFilter filter = new QFilter("settlementtype", "=", (Object)"1");
        QFilter enableFilter = new QFilter("enable", "=", (Object)"1");
        DynamicObjectCollection billTypes = QueryServiceHelper.query((String)"cdm_billtype", (String)"id", (QFilter[])new QFilter[]{filter, enableFilter});
        if (billTypes == null || billTypes.isEmpty()) {
            return;
        }
        this.getModel().setValue("billtype", ((DynamicObject)billTypes.get(0)).get("id"));
    }

    private void fillCurrencys(DynamicObject accountBank) {
        if (accountBank == null) {
            return;
        }
        ComboEdit currencyEdit = (ComboEdit)this.getControl("currencylist");
        DynamicObject currencyDB = this.getModel().getDataEntity().getDynamicObject("currency");
        String defualt = Optional.ofNullable(currencyDB).map(s -> s.getLong("id") + "").orElse(null);
        DynamicObjectCollection currencys = accountBank.getDynamicObjectCollection("currency");
        if (currencys != null) {
            ArrayList<ComboItem> propertyItems = new ArrayList<ComboItem>(currencys.size());
            for (DynamicObject item : currencys) {
                ComboItem comboItem = new ComboItem();
                DynamicObject currency = (DynamicObject)item.get(1);
                if (currency == null) continue;
                if (StringUtils.isEmpty((CharSequence)defualt)) {
                    defualt = currency.getString("id");
                }
                comboItem.setValue(currency.getString("id"));
                comboItem.setCaption(new LocaleString(currency.getString("name")));
                propertyItems.add(comboItem);
            }
            currencyEdit.setComboItems(propertyItems);
            if (StringUtils.isNotEmpty((CharSequence)defualt)) {
                this.getModel().setValue("currencylist", (Object)defualt);
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        super.afterDoOperation(e);
        String opKey = e.getOperateKey();
        OperationResult result = e.getOperationResult();
        if ("save".equals(opKey)) {
            List list = result.getSuccessPkIds();
            if (Utils.isListEmpty((List)list)) {
                return;
            }
            this.updateDBInfoBy(list.get(0));
        }
    }

    private void updateDBInfoBy(Object pkVal) {
        MainEntityType type = EntityMetadataCache.getDataEntityType((String)"cdm_cheque_purch");
        DynamicObject currentCheque = BusinessDataServiceHelper.loadSingle((Object)pkVal, (DynamicObjectType)type);
        String batchNo = currentCheque.getString("batchno");
        String codeRule = currentCheque.getString("coderule");
        String startNo = currentCheque.getString("startno");
        int amount = currentCheque.getInt("amount");
        DynamicObject bank = currentCheque.getDynamicObject("bank");
        DynamicObject[] cheques = null;
        if (StringUtils.isNotEmpty((CharSequence)batchNo)) {
            QFilter batchNoFilter = new QFilter("batchno", "=", (Object)batchNo);
            DynamicObjectCollection existIds = QueryServiceHelper.query((String)"cdm_cheque_purch", (String)ChequeProp.getSelectField(), (QFilter[])new QFilter[]{batchNoFilter}, (String)"batchno");
            cheques = BusinessDataServiceHelper.load((Object[])existIds.stream().map(DataEntityBase::getPkValue).toArray(), (DynamicObjectType)type);
        } else {
            cheques = new DynamicObject[]{currentCheque};
            batchNo = ChequeHelper.createBatchNo();
        }
        ArrayList<DynamicObject> newList = new ArrayList<DynamicObject>();
        ArrayList<DynamicObject> updateList = new ArrayList<DynamicObject>();
        DynamicObject formCheque = this.getModel().getDataEntity();
        List<String> noList = this.createNosBy(amount, codeRule, startNo);
        ArrayList<Object> selectList = new ArrayList<Object>();
        Date createTime = currentCheque.getDate("createtime");
        for (String no : noList) {
            DynamicObject saveCheque = this.getSaveObject(cheques, selectList);
            if (saveCheque.get("billno") == null || "".equals(saveCheque.get("billno"))) {
                saveCheque.set("creator", (Object)RequestContext.get().getUserId());
                saveCheque.set("chequestatus", (Object)"0");
                newList.add(saveCheque);
            } else {
                updateList.add(saveCheque);
            }
            saveCheque.set("createtime", (Object)(createTime == null ? new Date() : createTime));
            saveCheque.set("modifier", (Object)RequestContext.get().getUserId());
            saveCheque.set("modifytime", (Object)new Date());
            saveCheque.set("purchdate", formCheque.get("purchdate"));
            saveCheque.set("org", formCheque.get("org"));
            saveCheque.set("purchase", formCheque.get("purchase"));
            saveCheque.set("batchno", (Object)batchNo);
            saveCheque.set("accountbank", formCheque.get("accountbank"));
            saveCheque.set("bank", formCheque.get("bank"));
            saveCheque.set("currency", formCheque.get("currency"));
            saveCheque.set("billtype", formCheque.get("billtype"));
            saveCheque.set("amount", formCheque.get("amount"));
            saveCheque.set("coderule", formCheque.get("coderule"));
            saveCheque.set("replacechar", formCheque.get("replacechar"));
            saveCheque.set("startno", formCheque.get("startno"));
            saveCheque.set("purchdate", formCheque.get("purchdate"));
            saveCheque.set("billstatus", (Object)"A");
            saveCheque.set("billno", (Object)no);
        }
        if (!newList.isEmpty()) {
            QFilter qFilter = new QFilter("bank", "=", bank.getPkValue());
            qFilter.and(new QFilter("billno", "in", noList));
            DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)"cdm_cheque_purch", (String)"id,billno", (QFilter[])new QFilter[]{qFilter});
            if (dynamicObjects != null && dynamicObjects.size() > 0) {
                StringBuilder sb = new StringBuilder();
                for (DynamicObject dynamicObject : dynamicObjects) {
                    sb.append(dynamicObject.get("billno"));
                    sb.append(',');
                }
                String billNos = sb.substring(0, sb.lastIndexOf(","));
                this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u5df2\u5b58\u5728\u5f00\u6237\u884c\u201c%1$s\u201d\u7968\u636e\u7f16\u53f7\u201c%2$s\u201d\u7684\u652f\u7968\u4fe1\u606f\u3002", (String)"ChequePurchEditPlugin_20", (String)"tmc-cdm-formplugin", (Object[])new Object[0]), bank.get("name"), billNos));
                return;
            }
            SaveServiceHelper.save((IDataEntityType)type, (Object[])newList.toArray(new DynamicObject[0]));
        }
        if (!updateList.isEmpty()) {
            SaveServiceHelper.update((DynamicObject[])updateList.toArray(new DynamicObject[0]));
        }
        this.deleletChequeBy(cheques, selectList);
        this.getView().invokeOperation("close");
    }

    private boolean beforeUpdateDBInfoBy() {
        String codeRule = (String)this.getModel().getValue("coderule");
        Object startNo = this.getModel().getValue("startno");
        int amount = (Integer)this.getModel().getValue("amount");
        DynamicObject bank = (DynamicObject)this.getModel().getValue("bank");
        List<String> noList = this.createNosBy(amount, codeRule, String.valueOf(startNo));
        QFilter qFilter = new QFilter("bank", "=", bank.getPkValue());
        qFilter.and(new QFilter("billno", "in", noList));
        DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)"cdm_cheque_purch", (String)"id,billno", (QFilter[])new QFilter[]{qFilter});
        if (dynamicObjects != null && dynamicObjects.size() > 0) {
            StringBuilder sb = new StringBuilder();
            for (DynamicObject dynamicObject : dynamicObjects) {
                sb.append(dynamicObject.get("billno"));
                sb.append(',');
            }
            String billNos = sb.substring(0, sb.lastIndexOf(","));
            this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u5df2\u5b58\u5728\u5f00\u6237\u884c\u201c%1$s\u201d\u7968\u636e\u7f16\u53f7\u201c%2$s\u201d\u7684\u652f\u7968\u4fe1\u606f\u3002", (String)"ChequePurchEditPlugin_20", (String)"tmc-cdm-formplugin", (Object[])new Object[0]), bank.get("name"), billNos));
            return false;
        }
        return true;
    }

    private void deleletChequeBy(DynamicObject[] cheques, List<Object> selectList) {
        ArrayList<Object> delList = new ArrayList<Object>();
        for (DynamicObject cheque : cheques) {
            if (selectList.contains(cheque.getPkValue())) continue;
            delList.add(cheque.getPkValue());
        }
        if (delList.isEmpty()) {
            return;
        }
        MainEntityType type = EntityMetadataCache.getDataEntityType((String)"cdm_cheque_purch");
        try {
            DeleteServiceHelper.delete((IDataEntityType)type, (Object[])delList.toArray(new Object[0]));
        }
        catch (Exception e) {
            this.log.error("\u5220\u9664\u591a\u4f59\u652f\u7968\u51fa\u9519\uff01\uff01\uff01", (Throwable)e);
        }
    }

    private DynamicObject getSaveObject(DynamicObject[] cheques, List<Object> selectList) {
        int n = 0;
        DynamicObject[] dynamicObjectArray = cheques;
        int n2 = dynamicObjectArray.length;
        if (n < n2) {
            DynamicObject cheque = dynamicObjectArray[n];
            if (!selectList.contains(cheque.getPkValue())) {
                selectList.add(cheque.getPkValue());
                return cheque;
            }
            DynamicObject newChequeBill = TmcDataServiceHelper.clone((DynamicObject)cheque);
            newChequeBill.set("billno", (Object)"");
            return newChequeBill;
        }
        return BusinessDataServiceHelper.newDynamicObject((String)"cdm_cheque_purch");
    }

    private List<String> createNosBy(int amount, String codeRule, String startNo) {
        long maxVal;
        ArrayList<String> noList = new ArrayList<String>(amount);
        String replaceChar = (String)this.getModel().getValue("replacechar");
        int firstIndex = codeRule.indexOf(replaceChar);
        int endIndex = codeRule.lastIndexOf(replaceChar);
        int replaceLenth = endIndex - firstIndex + 1;
        StringBuilder replaceBuilder = new StringBuilder(replaceChar);
        for (int i = 1; i < replaceLenth; ++i) {
            replaceBuilder.append(replaceChar);
        }
        String replace = replaceBuilder.toString();
        long firstNo = Long.parseLong(startNo);
        long lastNo = firstNo + (long)amount - 1L;
        lastNo = lastNo >= (maxVal = this.getMaxValueBy(replaceLenth)) ? maxVal : lastNo;
        String subStr = "000000000000000000";
        for (long n = firstNo; n <= lastNo; ++n) {
            String num = String.valueOf(n);
            int diffLength = replaceLenth - num.length();
            num = subStr.substring(0, diffLength) + num;
            noList.add(codeRule.replace(replace, num));
        }
        return noList;
    }

    private long getMaxValueBy(int replaceLenth) {
        String subStr = "999999999999999999";
        if (replaceLenth > 18) {
            return Long.parseLong(subStr);
        }
        subStr = subStr.substring(0, replaceLenth);
        return Long.parseLong(subStr);
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        String name = evt.getProperty().getName();
        ListShowParameter param = (ListShowParameter)evt.getFormShowParameter();
        ListFilterParameter filterParameter = param.getListFilterParameter();
        switch (name) {
            case "purchase": {
                DynamicObject purcheOrg = this.getModel().getDataEntity().getDynamicObject("org");
                if (purcheOrg == null) break;
                QFilter filter = new QFilter("entryentity.dpt", "=", purcheOrg.getPkValue());
                param.setCustomParam("isIncludeAllSub", (Object)true);
                filterParameter.setFilter(filter);
                break;
            }
            case "accountbank": {
                DynamicObject purchOrg = this.getModel().getDataEntity().getDynamicObject("org");
                DynamicObject bank = this.getModel().getDataEntity().getDynamicObject("bank");
                if (purchOrg != null) {
                    filterParameter.setFilter(new QFilter("company", "=", purchOrg.getPkValue()));
                }
                if (bank != null) {
                    filterParameter.setFilter(new QFilter("bank", "=", bank.getPkValue()));
                }
                filterParameter.setFilter(new QFilter("acctstatus", "=", (Object)"normal"));
                break;
            }
            case "billtype": {
                filterParameter.setFilter(new QFilter("settlementtype", "=", (Object)"1"));
                break;
            }
            case "org": {
                String appId = this.getView().getFormShowParameter().getAppId();
                List comIdList = TmcOrgDataHelper.getAuthorizedBankOrgId((Long)Long.valueOf(RequestContext.get().getUserId()), (String)appId, (String)this.getModel().getDataEntityType().getName(), (String)"47150e89000000ac");
                param.setCustomParam("range", (Object)comIdList);
                break;
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String name = e.getProperty().getName();
        Object newValue = e.getChangeSet()[0].getNewValue();
        String notChanged = this.getPageCache().get(VALUE_MUTEX_CHANGE_KEY + name);
        if (StringUtils.isNotEmpty((CharSequence)notChanged)) {
            this.getPageCache().remove(VALUE_MUTEX_CHANGE_KEY + name);
            return;
        }
        if (newValue == null) {
            return;
        }
        switch (name) {
            case "org": {
                this.clearFieldValue("purchase", "accountbank", "bank", "currency");
                break;
            }
            case "accountbank": {
                this.clearFieldValue("currency");
                DynamicObject accountBank = (DynamicObject)newValue;
                String lockKey = "valueMutexCacheKeybank";
                this.getPageCache().put(lockKey, "locked");
                this.getModel().setValue("bank", accountBank.getDynamicObject("bank").getPkValue());
                this.fillCurrencys(accountBank);
                this.getPageCache().remove(lockKey);
                break;
            }
            case "bank": {
                this.clearFieldValue("accountbank", "currency");
            }
        }
    }

    private void clearFieldValue(String ... field) {
        String[] fields;
        if (field == null) {
            return;
        }
        for (String item : fields = field) {
            this.getModel().setValue(item, null);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        if (!(args.getSource() instanceof Save)) {
            return;
        }
        if (!this.beforeUpdateDBInfoBy()) {
            args.setCancel(true);
        }
        this.getModel().setValue("currency", this.getModel().getValue("currencylist"));
    }
}

