/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cdm.formplugin.cheque;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.filter.CommonFilterColumn;
import kd.bos.filter.FilterColumn;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.SearchClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.FilterContainerSearchClickArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.field.ComboItem;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.events.BeforeShowBillFormEvent;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;

public class ChequeQueryListPlugin
extends AbstractListPlugin {
    private String CONFIRM_INVALID = "confirm_invalid";
    protected List<Object> selectedOrgIdList = new ArrayList<Object>();
    protected List<Object> selectedAcctIdList = new ArrayList<Object>();
    protected List<Object> selectedBankIdList = new ArrayList<Object>();
    protected DynamicObject[] accountBanks;
    private FilterContainerInitArgs initArgs;

    public void beforeShowBill(BeforeShowBillFormEvent e) {
        BillShowParameter bsp = e.getParameter();
        bsp.getOpenStyle().setShowType(ShowType.Modal);
        bsp.setStatus(OperationStatus.VIEW);
    }

    public void itemClick(ItemClickEvent evt) {
        String itemKey = evt.getItemKey();
        BillList billList = (BillList)this.getControl("billlistap");
        ListSelectedRowCollection rows = billList.getSelectedRows();
        switch (itemKey) {
            default: 
        }
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        String itemKey = evt.getItemKey();
        BillList billList = (BillList)this.getControl("billlistap");
        ListSelectedRowCollection rows = billList.getSelectedRows();
        switch (itemKey) {
            default: 
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        String opKey = afterDoOperationEventArgs.getOperateKey();
        OperationResult operationResult = afterDoOperationEventArgs.getOperationResult();
        if (operationResult != null && operationResult.isSuccess() && StringUtils.equals((CharSequence)opKey, (CharSequence)"invalid")) {
            BillList billList = (BillList)this.getControl("billlistap");
            ListSelectedRowCollection rows = billList.getSelectedRows();
            if (rows.size() != 1) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5355\u5f20\u7968\u636e\u8fdb\u884c\u4f5c\u5e9f\u3002", (String)"ChequeQueryListPlugin_0", (String)"tmc-cdm-formplugin", (Object[])new Object[0]));
                return;
            }
            this.confirmInvalid();
        } else if (operationResult != null && operationResult.isSuccess() && StringUtils.equals((CharSequence)opKey, (CharSequence)"cancelinvalid")) {
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u53cd\u4f5c\u5e9f\u6210\u529f\u3002", (String)"ChequeQueryListPlugin_3", (String)"tmc-cdm-formplugin", (Object[])new Object[0]));
            BillList billList = (BillList)this.getControl("billlistap");
            billList.refresh();
        }
    }

    public void setFilter(SetFilterEvent e) {
        List qFilters = e.getQFilters();
        for (QFilter qFilter : qFilters) {
            DynamicObject acountBankTempDO;
            if (!StringUtils.equals((CharSequence)qFilter.getProperty(), (CharSequence)"bank.bank_cate.id") || !EmptyUtil.isEmpty((DynamicObject)(acountBankTempDO = TmcDataServiceHelper.loadSingle((String)"bd_accountbanks", (String)"id", (QFilter[])new QFilter[]{qFilter})))) continue;
            qFilter.__setProperty("bank.id");
        }
        e.setOrderBy("accountbank,purchdate asc,createtime asc,billno asc");
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        if (this.CONFIRM_INVALID.equals(messageBoxClosedEvent.getCallBackId()) && messageBoxClosedEvent.getResult().equals((Object)MessageBoxResult.Yes)) {
            this.confirmInvalid();
        }
    }

    protected void confirmInvalid() {
        BillList billList = (BillList)this.getControl("billlistap");
        ListSelectedRowCollection rows = billList.getSelectedRows();
        if (rows == null || rows.size() != 1) {
            return;
        }
        ListSelectedRow row = rows.get(0);
        DynamicObject cheque = BusinessDataServiceHelper.loadSingle((Object)row.getPrimaryKeyValue(), (String)"cdm_cheque_purch");
        if (!"0".equals(cheque.getString("chequestatus"))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u53ea\u80fd\u5bf9\u7a7a\u767d\u72b6\u6001\u7968\u636e\u8fdb\u884c\u4f5c\u5e9f\u3002", (String)"ChequeQueryListPlugin_1", (String)"tmc-cdm-formplugin", (Object[])new Object[0]));
            return;
        }
        FormShowParameter fsp = new FormShowParameter();
        fsp.setFormId("cdm_cheque_markinvalid");
        fsp.setCustomParam("invalidmark", cheque.getPkValue());
        fsp.getOpenStyle().setShowType(ShowType.Modal);
        fsp.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "invalidmark"));
        this.getView().showForm(fsp);
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        super.closedCallBack(e);
        if ("invalidmark".equals(e.getActionId())) {
            BillList billList = (BillList)this.getControl("billlistap");
            billList.refresh();
        }
    }

    public void filterContainerInit(FilterContainerInitArgs args) {
        super.filterContainerInit(args);
        this.initArgs = args;
        this.cacheFirstSelectedOrg(args);
        if (this.selectedOrgIdList.size() < 1) {
            this.selectedOrgIdList.addAll(this.getAllOrgIdList(args));
        }
        if (EmptyUtil.isEmpty(this.selectedOrgIdList)) {
            return;
        }
        this.initAccountBanks(this.selectedOrgIdList);
        for (FilterColumn filterColumn : args.getFilterContainerInitEvent().getCommonFilterColumns()) {
            CommonFilterColumn commonFilterColumn = (CommonFilterColumn)filterColumn;
            String fieldName = commonFilterColumn.getFieldName();
            List<ComboItem> acctItems = this.initAcctItemsList();
            if (fieldName.startsWith("org.")) {
                commonFilterColumn.setDefaultValue(this.selectedOrgIdList.get(0).toString());
            }
            if (!StringUtils.equals((CharSequence)"bank.bank_cate.name", (CharSequence)fieldName)) continue;
            List<ComboItem> bankItems = this.initBankItemsList();
            List listcomitem = commonFilterColumn.getComboItems();
            listcomitem.clear();
            commonFilterColumn.setComboItems(bankItems);
            commonFilterColumn.setDefValue(acctItems.get(0).getValue());
        }
    }

    private List<String> parseStringsList(List<Long> longList) {
        ArrayList<String> stringList = new ArrayList<String>(longList.size());
        for (Long x : longList) {
            stringList.add(x.toString());
        }
        return stringList;
    }

    protected void cacheFirstSelectedOrg(FilterContainerInitArgs args) {
        if (this.getPageCache().get("isPageOpen") == null) {
            this.getPageCache().put("isPageOpen", "true");
            String firstOrgId = null;
            if (this.isDefaultOpen()) {
                for (FilterColumn filterColumn : args.getFilterContainerInitEvent().getCommonFilterColumns()) {
                    List orgItems;
                    CommonFilterColumn commonFilterColumn = (CommonFilterColumn)filterColumn;
                    String fieldName = commonFilterColumn.getFieldName();
                    if (!fieldName.startsWith("org.") || (orgItems = commonFilterColumn.getComboItems()) == null || orgItems.size() <= 0) continue;
                    String loginOrg = String.valueOf(RequestContext.get().getOrgId());
                    for (int i = 0; i < orgItems.size(); ++i) {
                        ComboItem item = (ComboItem)orgItems.get(i);
                        if (!item.getValue().equals(loginOrg)) continue;
                        firstOrgId = loginOrg;
                        break;
                    }
                    if (firstOrgId != null) continue;
                    List defaultVals = commonFilterColumn.getDefaultValues();
                    if (defaultVals != null && defaultVals.size() > 0) {
                        firstOrgId = (String)defaultVals.get(0);
                        continue;
                    }
                    firstOrgId = ((ComboItem)orgItems.get(0)).getValue();
                }
            } else {
                firstOrgId = this.getView().getFormShowParameter().getCustomParam("org.id").toString();
            }
            this.selectedOrgIdList.add(firstOrgId);
            this.cacheSelectedOrgIdList(this.selectedOrgIdList);
            this.getPageCache().put("org.id", firstOrgId);
        }
    }

    public void filterContainerSearchClick(FilterContainerSearchClickArgs args) {
        super.filterContainerSearchClick(args);
        Map filterValues = args.getSearchClickEvent().getFilterValues();
        if (filterValues.containsKey("customfilter")) {
            this.cacheCommonFilter(this.getPageCache(), args.getSearchClickEvent());
            this.filterContainerInit(this.initArgs);
        }
    }

    private List<Long> getAllOrgIdList(FilterContainerInitArgs args) {
        ArrayList<Long> orgIdList = new ArrayList<Long>();
        for (FilterColumn filterColumn : args.getFilterContainerInitEvent().getCommonFilterColumns()) {
            CommonFilterColumn commonFilterColumn = (CommonFilterColumn)filterColumn;
            String fieldName = commonFilterColumn.getFieldName();
            if (!fieldName.startsWith("org.")) continue;
            List orgItems = commonFilterColumn.getComboItems();
            for (int i = 0; i < orgItems.size(); ++i) {
                ComboItem item = (ComboItem)orgItems.get(i);
                if (item.getValue() == "") continue;
                orgIdList.add(Long.valueOf(item.getValue()));
            }
        }
        return orgIdList;
    }

    protected List<ComboItem> initAcctItemsList() {
        ArrayList<ComboItem> acctItems = new ArrayList<ComboItem>();
        if (this.accountBanks != null && this.accountBanks.length > 0) {
            for (int i = 0; i < this.accountBanks.length; ++i) {
                DynamicObject cashAcct = this.accountBanks[i];
                ComboItem item = new ComboItem();
                item.setCaption(new LocaleString(cashAcct.getString("bankaccountnumber")));
                item.setValue(cashAcct.getString("id"));
                acctItems.add(item);
            }
        } else {
            acctItems.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u4e0d\u9650", (String)"ChequeQueryListPlugin_2", (String)"tmc-cdm-formplugin", (Object[])new Object[0])), ""));
        }
        return acctItems;
    }

    protected List<ComboItem> initBankItemsList() {
        DynamicObject[] accountBanks;
        ArrayList<ComboItem> acctItems = new ArrayList<ComboItem>();
        String selectProperties = "bank,bank.bank_cate";
        ArrayList<QFilter> qfilters = new ArrayList<QFilter>();
        if (this.selectedOrgIdList != null && this.selectedOrgIdList.size() > 0) {
            List selectedOrgLongIdList = this.selectedOrgIdList.stream().map(o -> Long.valueOf(o.toString())).collect(Collectors.toList());
            qfilters.add(new QFilter("org.id", "in", selectedOrgLongIdList));
        }
        if ((accountBanks = BusinessDataServiceHelper.load((String)"bd_accountbanks", (String)selectProperties, (QFilter[])qfilters.toArray(new QFilter[0]))) != null && accountBanks.length > 0) {
            for (int i = 0; i < accountBanks.length; ++i) {
                ComboItem item;
                DynamicObject cashAcct = accountBanks[i];
                if (!EmptyUtil.isEmpty((Object)cashAcct.get("bank.bank_cate"))) {
                    item = new ComboItem();
                    item.setCaption(new LocaleString(cashAcct.getString("bank.bank_cate.name")));
                    item.setValue(cashAcct.getString("bank.bank_cate.id"));
                    if (acctItems.contains(item)) continue;
                    acctItems.add(item);
                    continue;
                }
                item = new ComboItem();
                item.setCaption(new LocaleString(cashAcct.getString("bank.name")));
                item.setValue(cashAcct.getString("bank.id"));
                if (acctItems.contains(item)) continue;
                acctItems.add(item);
            }
        } else {
            acctItems.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u4e0d\u9650", (String)"ChequeQueryListPlugin_2", (String)"tmc-cdm-formplugin", (Object[])new Object[0])), ""));
        }
        return acctItems;
    }

    private void cacheCommonFilter(IPageCache pageCache, SearchClickEvent searchClickEvent) {
        if (pageCache != null && searchClickEvent.getFilterValues() != null) {
            this.selectedOrgIdList.clear();
            this.selectedAcctIdList.clear();
            pageCache.remove("org.id");
            Map orgFilter = null;
            Map acctFilter = null;
            Map bankFilter = null;
            List customfilter = (List)searchClickEvent.getFilterValues().get("customfilter");
            if (customfilter != null) {
                for (Map filteritem : customfilter) {
                    String fieldName = ((List)filteritem.get("FieldName")).get(0).toString();
                    List item = (List)filteritem.get("Value");
                    if (fieldName.startsWith("org")) {
                        orgFilter = filteritem;
                        if (item.isEmpty() || "".equals(item.get(0))) continue;
                        String fieldValue = item.get(0).toString();
                        pageCache.put(fieldName, fieldValue);
                        this.selectedOrgIdList = item;
                        continue;
                    }
                    if (fieldName.startsWith("accountbank")) {
                        acctFilter = filteritem;
                        if (item.isEmpty() || "".equals(item.get(0))) continue;
                        this.selectedAcctIdList = item;
                        continue;
                    }
                    if (!fieldName.startsWith("bank")) continue;
                    bankFilter = filteritem;
                    if (item.isEmpty() || "".equals(item.get(0))) continue;
                    this.selectedBankIdList = item;
                }
                if (orgFilter == null) {
                    if (this.getCachedOrgList() != null) {
                        this.orgCommonFilterChange(acctFilter);
                    }
                    this.cacheSelectedOrgIdList(null);
                } else {
                    List<Object> tempList = this.getCachedOrgList();
                    if (tempList == null || !tempList.equals(orgFilter.get("Value"))) {
                        this.orgCommonFilterChange(acctFilter);
                    }
                    this.cacheSelectedOrgIdList((List)orgFilter.get("Value"));
                }
            }
        }
    }

    protected void orgCommonFilterChange(Map<String, List<Object>> acctFilter) {
        if (acctFilter != null) {
            ArrayList<String> acctList = new ArrayList<String>();
            acctList.add("");
            acctFilter.put("Value", acctList);
            this.selectedAcctIdList.clear();
        }
    }

    protected void initAccountBanks(List<Object> selectedOrgIdList) {
        String selectProperties = "id,name,number,isbycurrency,defaultcurrency.id,bankaccountnumber,defaultcurrency.name,currency.fbasedataid.*,bank.bank_cate";
        ArrayList<QFilter> qfilters = new ArrayList<QFilter>();
        ArrayList<Long> selectedOrgLongIdList = new ArrayList<Long>(8);
        for (Object selectedOrgLongId : selectedOrgIdList) {
            if (null == selectedOrgLongId || "".equals(selectedOrgLongId.toString()) || " ".equals(selectedOrgLongId.toString())) continue;
            selectedOrgLongIdList.add(Long.valueOf(selectedOrgLongId.toString()));
        }
        qfilters.add(new QFilter("org.id", "in", selectedOrgLongIdList));
        if (this.selectedBankIdList != null && this.selectedBankIdList.size() > 0) {
            List selectedBankLongIdList = this.selectedBankIdList.stream().map(o -> Long.valueOf(o.toString())).collect(Collectors.toList());
            DynamicObject acountBankTempDO = TmcDataServiceHelper.loadSingle((String)"bd_accountbanks", (String)selectProperties, (QFilter[])new QFilter[]{new QFilter("bank.id", "in", selectedBankLongIdList)});
            if (EmptyUtil.isNoEmpty((DynamicObject)acountBankTempDO)) {
                qfilters.add(new QFilter("bank.id", "in", selectedBankLongIdList));
            } else {
                qfilters.add(new QFilter("bank.bank_cate.id", "in", selectedBankLongIdList));
            }
        }
        this.accountBanks = BusinessDataServiceHelper.load((String)"bd_accountbanks", (String)selectProperties, (QFilter[])qfilters.toArray(new QFilter[0]));
    }

    protected QFilter[] getAcctFilter(Collection<Object> acctIds) {
        return new QFilter[]{new QFilter("id", "in", acctIds)};
    }

    private void cacheSelectedOrgIdList(List<Object> selectedOrgIdList) {
        if (selectedOrgIdList != null) {
            this.getPageCache().put("selectedOrgIdList", SerializationUtils.toJsonString(selectedOrgIdList));
        } else {
            this.getPageCache().put("selectedOrgIdList", null);
        }
    }

    protected List<Object> getCachedOrgList() {
        if (this.getPageCache().get("selectedOrgIdList") != null) {
            return (List)SerializationUtils.fromJsonString((String)this.getPageCache().get("selectedOrgIdList"), List.class);
        }
        return null;
    }

    protected boolean isDefaultOpen() {
        FormShowParameter parameters = this.getView().getFormShowParameter();
        return parameters.getCustomParam("setDefaultFilters") == null;
    }
}

