/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cdm.formplugin.cheque;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.filter.FilterParameter;
import kd.bos.form.FormShowParameter;
import kd.bos.form.container.Tab;
import kd.bos.form.control.Button;
import kd.bos.form.control.events.BeforeClickEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.list.BillList;
import kd.bos.list.events.ListRowClickEvent;
import kd.bos.list.events.ListRowClickListener;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.cdm.common.enums.BillStatusEnum;
import kd.tmc.cdm.common.enums.DraftTranStatusEnum;
import kd.tmc.cdm.common.enums.ReceivePayTypeEnum;
import kd.tmc.fbp.common.util.EmptyUtil;

public class PayAndReceiveF7ListFilter
extends AbstractListPlugin {
    private static Log logger = LogFactory.getLog(PayAndReceiveF7ListFilter.class);
    private static final String RADIOGROUP = "radiogroup";
    private static final String RADIO_ALL = "all";
    private static final String RADIO_RECEIVEBILL = ReceivePayTypeEnum.RECEIVEBILL.getValue();
    private static final String RADIO_PAYBILL = ReceivePayTypeEnum.PAYBILL.getValue();
    private static final String TABAP = "tabap";
    private static final String TABAP_ALL = "tabap_all";
    private static final String TABAP_RECEIVEBILL = "tabap_receivebill";
    private static final String TABAP_PAYBILL = "tabap_paybill";
    private static final String BTNOK = "btnok";

    public void initialize() {
        super.initialize();
        FormShowParameter showParameter = this.getView().getFormShowParameter();
        String source = (String)showParameter.getCustomParam("source");
        if ("rec".equals(source)) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{TABAP_ALL});
            this.getView().setVisible(Boolean.valueOf(false), new String[]{TABAP_PAYBILL});
        } else if ("pay".equals(source)) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{TABAP_ALL});
            this.getView().setVisible(Boolean.valueOf(false), new String[]{TABAP_RECEIVEBILL});
        }
    }

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{RADIOGROUP, BTNOK});
        this.tabChange();
        BillList billList = (BillList)this.getControl("billlistap");
        billList.addListRowClickListener((ListRowClickListener)this);
    }

    private void tabChange() {
        Tab tab = (Tab)this.getControl(TABAP);
        tab.addTabSelectListener(tabSelectEvent -> {
            String tabKey = tabSelectEvent.getTabKey();
            if (TABAP_PAYBILL.equals(tabKey)) {
                this.getModel().setValue(RADIOGROUP, (Object)RADIO_PAYBILL);
            } else if (TABAP_RECEIVEBILL.equals(tabKey)) {
                this.getModel().setValue(RADIOGROUP, (Object)RADIO_RECEIVEBILL);
            } else {
                this.getModel().setValue(RADIOGROUP, (Object)RADIO_ALL);
            }
        });
    }

    public void setFilter(SetFilterEvent e) {
        QFilter filter;
        FormShowParameter showParameter;
        String source;
        String selectedRadioVale = (String)this.getModel().getValue(RADIOGROUP);
        if (StringUtils.isBlank((CharSequence)selectedRadioVale)) {
            Tab tab = (Tab)this.getControl(TABAP);
            tab.activeTab(TABAP_RECEIVEBILL);
            this.getModel().setValue(RADIOGROUP, (Object)RADIO_RECEIVEBILL);
            selectedRadioVale = (String)this.getModel().getValue(RADIOGROUP);
        }
        if ("pay".equals(source = (String)(showParameter = this.getView().getFormShowParameter()).getCustomParam("source"))) {
            Tab tab = (Tab)this.getControl(TABAP);
            tab.activeTab(TABAP_PAYBILL);
            this.getModel().setValue(RADIOGROUP, (Object)RADIO_PAYBILL);
            selectedRadioVale = (String)this.getModel().getValue(RADIOGROUP);
        }
        if (selectedRadioVale.equals(RADIO_ALL)) {
            filter = new QFilter("rptype", "=", (Object)ReceivePayTypeEnum.RECEIVEBILL.getValue());
            QFilter payBillFilter = new QFilter("rptype", "=", (Object)ReceivePayTypeEnum.PAYBILL.getValue()).and(new QFilter("draftbilltranstatus", "=", (Object)DraftTranStatusEnum.SUCCESS.getValue()));
            filter.or(payBillFilter);
            e.getQFilters().add(filter);
        } else if (selectedRadioVale.equals(RADIO_RECEIVEBILL)) {
            filter = new QFilter("rptype", "=", (Object)ReceivePayTypeEnum.RECEIVEBILL.getValue());
            e.getQFilters().add(filter);
        } else if (selectedRadioVale.equals(RADIO_PAYBILL)) {
            filter = new QFilter("rptype", "=", (Object)ReceivePayTypeEnum.PAYBILL.getValue()).and(new QFilter("draftbilltranstatus", "=", (Object)DraftTranStatusEnum.SUCCESS.getValue()));
            e.getQFilters().add(filter);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String fieldKey = e.getProperty().getName();
        Object fieldKeyObj = this.getModel().getValue(fieldKey);
        if (fieldKeyObj instanceof String) {
            String selectedRadioVale = (String)fieldKeyObj;
            BillList billList = (BillList)this.getControl("billlistap");
            FilterParameter filterParameter = new FilterParameter();
            if (selectedRadioVale.equals(RADIO_ALL)) {
                QFilter filter = new QFilter("rptype", "=", (Object)ReceivePayTypeEnum.RECEIVEBILL.getValue());
                filter.or(new QFilter("rptype", "=", (Object)ReceivePayTypeEnum.PAYBILL.getValue()));
                filterParameter.setFilter(filter);
                billList.setFilterParameter(filterParameter);
                billList.refresh();
            } else if (selectedRadioVale.equals(RADIO_RECEIVEBILL)) {
                QFilter filter = new QFilter("rptype", "=", (Object)ReceivePayTypeEnum.RECEIVEBILL.getValue());
                filterParameter.setFilter(filter);
                billList.setFilterParameter(filterParameter);
                billList.refresh();
            } else if (selectedRadioVale.equals(RADIO_PAYBILL)) {
                QFilter filter = new QFilter("rptype", "=", (Object)ReceivePayTypeEnum.PAYBILL.getValue());
                filterParameter.setFilter(filter);
                billList.setFilterParameter(filterParameter);
                billList.refresh();
            }
        }
    }

    public void listRowClick(ListRowClickEvent evt) {
        super.listRowClick(evt);
        List tSelectedPkIds = evt.getListSelectedRowCollection().stream().map(ListSelectedRow::getPrimaryKeyValue).collect(Collectors.toList());
        DynamicObjectCollection tSelectedDrafts = QueryServiceHelper.query((String)"cdm_draftbillf7", (String)String.join((CharSequence)",", "id", "rptype", "currency", "amount"), (QFilter[])new QFilter[]{new QFilter("id", "in", tSelectedPkIds)});
        BigDecimal receiveamount = BigDecimal.ZERO;
        BigDecimal payamount = BigDecimal.ZERO;
        for (DynamicObject tSelectedDraft : tSelectedDrafts) {
            if (ReceivePayTypeEnum.RECEIVEBILL.getValue().equals(tSelectedDraft.getString("rptype"))) {
                receiveamount = receiveamount.add(tSelectedDraft.getBigDecimal("amount"));
            } else {
                payamount = payamount.add(tSelectedDraft.getBigDecimal("amount"));
            }
            this.getModel().setValue("currency", (Object)tSelectedDraft.getLong("currency"));
        }
        this.getModel().setValue("receiveamount", (Object)receiveamount);
        this.getModel().setValue("payamount", (Object)payamount);
        this.getModel().setValue("totalamount", (Object)receiveamount.add(payamount));
    }

    public void beforeClick(BeforeClickEvent evt) {
        String key;
        super.beforeClick(evt);
        Object source = evt.getSource();
        if (source instanceof Button && BTNOK.equals(key = ((Button)source).getKey())) {
            HashSet<Long> set = new HashSet<Long>();
            ListSelectedRowCollection selectedRows = this.getSelectedRows();
            List tSelectedPkIds = selectedRows.stream().map(ListSelectedRow::getPrimaryKeyValue).collect(Collectors.toList());
            DynamicObjectCollection tSelectedDrafts = QueryServiceHelper.query((String)"cdm_draftbillf7", (String)String.join((CharSequence)",", "id", "rptype", "currency", "amount"), (QFilter[])new QFilter[]{new QFilter("id", "in", tSelectedPkIds)});
            for (DynamicObject tSelectedDraft : tSelectedDrafts) {
                if (!ReceivePayTypeEnum.PAYBILL.getValue().equals(tSelectedDraft.getString("rptype"))) continue;
                Long id = tSelectedDraft.getLong("id");
                set.add(id);
            }
            Set<String> errorBillNo = this.draftIsQuoteCas(set);
            if (EmptyUtil.isNoEmpty(errorBillNo)) {
                String msg = String.format(ResManager.loadKDString((String)"\u5df2\u5173\u8054\u4ed8\u6b3e\u5355\uff0c\u4e0d\u53ef\u518d\u6b21\u5173\u8054\u5e94\u4ed8\u7968\u636e\u3002\u8bf7\u91cd\u65b0\u9009\u62e9\u3002\u7ed3\u7b97\u53f7\uff1a%s\u3002", (String)"PayAndReceiveF7ListFilter_1", (String)"tmc-cdm-formplugin", (Object[])new Object[0]), errorBillNo);
                evt.setCancel(true);
                this.getView().showTipNotification(msg);
            }
        }
    }

    private Set<String> draftIsQuoteCas(Set<Long> draftIds) {
        Set<String> draftbillnoSet = new HashSet<String>();
        HashSet<Long> payDraftIdSet = new HashSet<Long>();
        HashSet<Long> recDraftIdSet = new HashSet<Long>();
        HashSet<Long> allDraftIdSet = new HashSet<Long>();
        HashMap<Long, String> draftIdAndNumMap = new HashMap<Long, String>();
        try {
            DynamicObject[] payObjs;
            if (null == draftIds || draftIds.size() == 0) {
                return draftbillnoSet;
            }
            FormShowParameter formShowParameter = this.getView().getFormShowParameter();
            QFilter billIdFilter = new QFilter("draftbill.fbasedataid", "in", draftIds);
            Object id = formShowParameter.getCustomParam("paymentbillid");
            if (EmptyUtil.isNoEmpty((Object)id)) {
                billIdFilter.and("id", "!=", id);
            }
            if (null != (payObjs = BusinessDataServiceHelper.load((String)"cas_paybill", (String)"id,draftbill.fbasedataid,actpayamt,billstatus", (QFilter[])new QFilter[]{billIdFilter})) && payObjs.length > 0) {
                BigDecimal sum = Arrays.stream(payObjs).filter(payBill -> StringUtils.equals((CharSequence)payBill.getString("billstatus"), (CharSequence)BillStatusEnum.PAY.getValue())).map(payBill -> EmptyUtil.isNoEmpty((Object)payBill.get("actpayamt")) ? payBill.getBigDecimal("actpayamt") : BigDecimal.ZERO).reduce(BigDecimal.ZERO, BigDecimal::add);
                if (BigDecimal.ZERO.compareTo(sum) == 0) {
                    return draftbillnoSet;
                }
                for (DynamicObject payObj : payObjs) {
                    DynamicObjectCollection draftbillColl = payObj.getDynamicObjectCollection("draftbill");
                    for (DynamicObject draftbill : draftbillColl) {
                        DynamicObject fbasedataid = draftbill.getDynamicObject("fbasedataid");
                        if (fbasedataid == null || !draftIds.contains(fbasedataid.getLong("id"))) continue;
                        String draftbillno = fbasedataid.getString("draftbillno");
                        long draftId = fbasedataid.getLong("id");
                        draftbillnoSet.add(draftbillno);
                        allDraftIdSet.add(draftId);
                        String rptypeStr = fbasedataid.getString("rptype");
                        if ("paybill".equals(rptypeStr)) {
                            payDraftIdSet.add(draftId);
                        } else {
                            recDraftIdSet.add(draftId);
                        }
                        draftIdAndNumMap.put(draftId, draftbillno);
                    }
                }
            }
        }
        catch (Exception e) {
            logger.error("draftIsQuoteCas has error:", (Throwable)e);
        }
        if (EmptyUtil.isNoEmpty(draftbillnoSet) && draftbillnoSet.size() > 0) {
            this.checkRefusedData(payDraftIdSet, allDraftIdSet, "cdm_payablebill");
            this.checkRefusedData(recDraftIdSet, allDraftIdSet, "cdm_receivablebill");
            if (EmptyUtil.isNoEmpty(allDraftIdSet) && allDraftIdSet.size() > 0) {
                draftbillnoSet = allDraftIdSet.stream().map(draftIdAndNumMap::get).collect(Collectors.toSet());
            } else {
                draftbillnoSet.clear();
            }
        }
        return draftbillnoSet;
    }

    private void checkRefusedData(Set<Long> payDraftIdSet, Set<Long> allDraftIdSet, String cdmConstant) {
        if (EmptyUtil.isNoEmpty(payDraftIdSet) && payDraftIdSet.size() > 0) {
            DynamicObject[] hasCasPayBillRecDraftArr;
            for (DynamicObject hasCasPayBillRecDraft : hasCasPayBillRecDraftArr = BusinessDataServiceHelper.load((String)cdmConstant, (String)"id,releatedcasbillentrys,releatedcasbillentrys.rel_billtype,releatedcasbillentrys.rel_isrefuse", (QFilter[])new QFilter[]{new QFilter("id", "in", payDraftIdSet)})) {
                Set not_refuseSet;
                DynamicObjectCollection releatedcasbillentrys = hasCasPayBillRecDraft.getDynamicObjectCollection("releatedcasbillentrys");
                if (!EmptyUtil.isNoEmpty((DynamicObjectCollection)releatedcasbillentrys) || releatedcasbillentrys.size() == 0 || !EmptyUtil.isEmpty(not_refuseSet = releatedcasbillentrys.stream().filter(e -> "cas_paybill".equals(e.getString("rel_billtype")) && !e.getBoolean("rel_isrefuse")).collect(Collectors.toSet())) && not_refuseSet.size() != 0) continue;
                long needRemoveDraftId = hasCasPayBillRecDraft.getLong("id");
                allDraftIdSet.remove(needRemoveDraftId);
            }
        }
    }
}

