/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cdm.formplugin.elcDraft;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.entity.operate.Donothing;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.FilterContainerSearchClickArgs;
import kd.bos.form.operate.FormOperate;
import kd.bos.list.BillList;
import kd.bos.list.events.ListRowClickEvent;
import kd.bos.list.events.ListRowClickListener;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.tmc.cdm.formplugin.elcDraft.provider.GetListDataProvider;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.formplugin.list.AbstractTmcDataBaseList;
import org.apache.commons.lang3.StringUtils;

public class EleDraftGroupList
extends AbstractTmcDataBaseList {
    private static final Log logger = LogFactory.getLog(EleDraftGroupList.class);

    public void filterContainerSearchClick(FilterContainerSearchClickArgs args) {
        ListSelectedRow currentSelectedRowInfo;
        QFilter commonFilter = args.getQFilter("company.id");
        QFilter timeFilter = args.getQFilter("time");
        List fastFilters = args.getFastQFilters();
        if (fastFilters != null) {
            fastFilters.forEach(qFilter -> {
                String text = (String)qFilter.getValue();
                qFilter.__setValue((Object)text.replaceAll("sourcebillno", "billno"));
            });
        }
        this.refreshCard(commonFilter, fastFilters);
        List fastFilterValues = args.getFastFilterValues();
        if (fastFilterValues != null) {
            fastFilterValues.clear();
        }
        BillList cardBillList = (BillList)this.getControl("cardbilllist");
        BillList billlistap = (BillList)this.getControl("billlistap");
        if (timeFilter != null) {
            billlistap.getDataPermQFilters().add(timeFilter);
        }
        if ((currentSelectedRowInfo = cardBillList.getCurrentSelectedRowInfo()) != null) {
            billlistap.getDataPermQFilters().add(new QFilter("sourceid", "=", (Object)String.valueOf(currentSelectedRowInfo.getPrimaryKeyValue())));
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        BillList billListAp = (BillList)this.getControl("billlistap");
        BillList cardBillList = (BillList)this.getControl("cardbilllist");
        if (EmptyUtil.isEmpty((Object)cardBillList)) {
            return;
        }
        ListSelectedRowCollection currentListAllRowCollection = cardBillList.getCurrentListAllRowCollection();
        if (currentListAllRowCollection != null && currentListAllRowCollection.size() > 0) {
            ListSelectedRow currentSelectedRowInfo;
            ListSelectedRowCollection currentListAllRows = cardBillList.getCurrentListAllRowCollection();
            if (currentListAllRows != null && (currentSelectedRowInfo = cardBillList.getCurrentSelectedRowInfo()) == null) {
                cardBillList.selectRows(0);
            }
        } else {
            billListAp.clearData();
        }
    }

    public void registerListener(EventObject e) {
        logger.info("\u70b9\u7968\u4ea4\u6613\u67e5\u8be2-\u521d\u59cb\u5316\u6ce8\u518c\u5217\u8868");
        super.registerListener(e);
        final BillList billListAp = (BillList)this.getControl("billlistap");
        BillList cardBillList = (BillList)this.getControl("cardbilllist");
        if (EmptyUtil.isEmpty((Object)cardBillList) || EmptyUtil.isEmpty((Object)billListAp)) {
            return;
        }
        cardBillList.addListRowClickListener(new ListRowClickListener(){

            public void listRowClick(ListRowClickEvent evt) {
                ListSelectedRow selectCar = evt.getCurrentListSelectedRow();
                if (selectCar != null) {
                    billListAp.clearSelection();
                    billListAp.refreshData();
                }
            }
        });
        billListAp.addSetFilterListener(setFilterEvent -> {
            setFilterEvent.addCustomQFilter(new QFilter("sourcebilltype", "=", (Object)"cdm_electronicbill"));
            if (cardBillList.getSelectedRows() != null && !cardBillList.getSelectedRows().isEmpty()) {
                Object primaryKey = cardBillList.getSelectedRows().get(0).getPrimaryKeyValue();
                setFilterEvent.addCustomQFilter(new QFilter("sourceid", "=", (Object)String.valueOf(primaryKey)));
            }
        });
        cardBillList.addHyperClickListener(hyperLinkClickEvent -> {
            String fieldName = hyperLinkClickEvent.getFieldName();
            BaseShowParameter showParameter = new BaseShowParameter();
            Object focusRowPkId = ((BillList)hyperLinkClickEvent.getSource()).getFocusRowPkId();
            if ("billno".equals(fieldName)) {
                showParameter.setFormId("cdm_electronicbill");
                showParameter.setPkId(focusRowPkId);
                showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                showParameter.setStatus(OperationStatus.VIEW);
                this.getView().showForm((FormShowParameter)showParameter);
            }
        });
        billListAp.addListRowDoubleClickListener(new ListRowClickListener(){

            public void listRowDoubleClick(ListRowClickEvent evt) {
                super.listRowDoubleClick(evt);
                ListSelectedRow selectCar = evt.getCurrentListSelectedRow();
                if (selectCar != null) {
                    Object focusRowPkId = selectCar.getPrimaryKeyValue();
                    EleDraftGroupList.this.openBankLog(focusRowPkId);
                }
            }
        });
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String operateKey = args.getOperateKey();
        if ("message".equals(operateKey)) {
            Donothing source = (Donothing)args.getSource();
            this.openBankLog(source.getListFocusRow().getPrimaryKeyValue());
        }
    }

    public void openBankLog(Object focusRowPkId) {
        BaseShowParameter showParameter = new BaseShowParameter();
        showParameter.setFormId("bei_banklog");
        showParameter.setPkId(focusRowPkId);
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        showParameter.setStatus(OperationStatus.EDIT);
        this.getView().showForm((FormShowParameter)showParameter);
    }

    public void beforeCreateListDataProvider(BeforeCreateListDataProviderArgs args) {
        args.setListDataProvider((IListDataProvider)new GetListDataProvider());
    }

    private void refreshCard(QFilter commonFilter, List<QFilter> fastFilters) {
        BillList cardBillList = (BillList)this.getControl("cardbilllist");
        AtomicReference<QFilter> qFilter = new AtomicReference<QFilter>();
        if (fastFilters != null) {
            fastFilters.forEach(fastFilter -> {
                if (qFilter.get() != null) {
                    ((QFilter)qFilter.get()).or(fastFilter);
                } else {
                    qFilter.set((QFilter)fastFilter);
                }
            });
        }
        if (commonFilter != null) {
            if (qFilter.get() != null) {
                ((QFilter)qFilter.get()).and(commonFilter);
            } else {
                qFilter.set(commonFilter);
            }
        }
        cardBillList.getDataPermQFilters().add(qFilter.get());
        cardBillList.refreshData();
        cardBillList.selectRows(0);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        FormOperate formOperate = (FormOperate)args.getSource();
        if ("refresh".equals(formOperate.getOperateKey())) {
            List sourceBillNos = this.getControlFilters().getFastFilter("sourcebillno");
            Map filters = this.getControlFilters().getFilters();
            List companies = this.getControlFilters().getFilter("company.id");
            ArrayList<QFilter> fastFilters = null;
            if (sourceBillNos != null && sourceBillNos.size() != 0) {
                ArrayList<QFilter> finalFastFilters = fastFilters = new ArrayList<QFilter>(filters.size());
                sourceBillNos.forEach(s -> {
                    QFilter fastFilter = new QFilter("1", "ftlike ", (Object)"billno#".concat((String)s));
                    finalFastFilters.add(fastFilter);
                });
            }
            QFilter commonFilter = null;
            if (companies != null && companies.size() == 1 && StringUtils.isNotBlank((CharSequence)((String)companies.get(0)))) {
                commonFilter = new QFilter("company.id", "=", (Object)Long.valueOf((String)companies.get(0)));
            } else if (companies != null && companies.size() > 1) {
                List longs = companies.stream().map(x -> Long.valueOf((String)x)).collect(Collectors.toList());
                commonFilter = new QFilter("company.id", "in", longs);
            }
            this.refreshCard(commonFilter, fastFilters);
        }
    }
}

