/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cdm.formplugin.elcDraft;

import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.cache.IAppCache;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.MessageTypes;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.mvc.list.ListDataProvider;
import kd.bos.mvc.list.ListView;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.tmc.cdm.business.helper.ElectRecClaimRuleHelper;
import kd.tmc.cdm.common.enums.ClaimAuthorityEnum;
import kd.tmc.cdm.common.enums.ClaimStatusEnum;
import kd.tmc.cdm.common.helper.CasHelper;
import kd.tmc.cdm.common.helper.PermissionHelper;
import kd.tmc.cdm.common.helper.RecClaimHelper;
import kd.tmc.fbp.common.helper.TmcAppCache;
import kd.tmc.fbp.common.helper.TmcOperateServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.formplugin.list.AbstractTmcBillBaseList;
import kd.tmc.fbp.webapi.ebentity.biz.status.EbStatus;

public class EleDraftRecClaimList
extends AbstractTmcBillBaseList {
    private static IAppCache cache = TmcAppCache.get((String)"cas", (String)"intelrec", (String)"claim");

    public void beforeCreateListDataProvider(BeforeCreateListDataProviderArgs args) {
        super.beforeCreateListDataProvider(args);
        args.setListDataProvider((IListDataProvider)new GetListDataProvider());
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        super.billListHyperLinkClick(args);
        String fieldName = args.getHyperLinkClickEvent().getFieldName();
        if ("signnoticebill".equals(fieldName)) {
            args.setCancel(true);
            BillList list = (BillList)this.getControl("billlistap");
            Object focusRowPkId = list.getFocusRowPkId();
            DynamicObject eleBill = BusinessDataServiceHelper.loadSingle((Object)focusRowPkId, (String)"cdm_electronic_sign_deal", (String)"id,signnoticebill");
            String signNoticeBillNo = eleBill.getString("signnoticebill");
            if (!StringUtils.isEmpty((CharSequence)signNoticeBillNo)) {
                QFilter filter = new QFilter("billno", "=", (Object)signNoticeBillNo);
                DynamicObject claimCenterBill = BusinessDataServiceHelper.loadSingle((String)"cas_claimcenterbill", (String)"id,billstatus", (QFilter[])new QFilter[]{filter});
                if (!CasHelper.isEmpty((Object)claimCenterBill)) {
                    BillShowParameter showParameter = new BillShowParameter();
                    showParameter.setStatus(OperationStatus.VIEW);
                    showParameter.setFormId("cas_claimcenterbill");
                    showParameter.setPkId(claimCenterBill.getPkValue());
                    showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                    this.getView().showForm((FormShowParameter)showParameter);
                }
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        DynamicObject[] electRecBills;
        List successPkIds;
        super.afterDoOperation(args);
        String operateKey = args.getOperateKey();
        OperationResult opResult = args.getOperationResult();
        MainEntityType mainEntityType = MetadataServiceHelper.getDataEntityType((String)"cdm_electronic_sign_deal");
        List list = successPkIds = opResult == null ? null : opResult.getSuccessPkIds();
        if ("noticeclaim".equals(operateKey) && successPkIds != null && successPkIds.size() > 0) {
            electRecBills = BusinessDataServiceHelper.load((Object[])successPkIds.toArray(), (DynamicObjectType)mainEntityType);
            boolean signOpinionNull = Arrays.stream(electRecBills).anyMatch(o -> StringUtils.isEmpty((CharSequence)o.getString("signopinion")));
            if (signOpinionNull) {
                this.noticeClaim(electRecBills);
                BillList billList = (BillList)this.getControl("billlistap");
                billList.clearSelection();
                billList.refresh();
            } else {
                this.getPageCache().put("noticeClaimClearIds", Arrays.stream(electRecBills).map(e -> e.get("id").toString()).collect(Collectors.joining(",")));
                this.getView().showConfirm(ResManager.loadKDString((String)"\u901a\u77e5\u7b7e\u6536\u7684\u7968\u636e\u5df2\u88ab\u62d2\u6536\u3002\u91cd\u65b0\u53d1\u8d77\u901a\u77e5\u5c06\u6e05\u7a7a\u4e0a\u4e00\u6b21\u7b7e\u6536\u610f\u89c1\u3002\u662f\u5426\u7ee7\u7eed\uff1f", (String)"EleDraftRecClaimList_0", (String)"tmc-cdm-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("noticeClaimClearConfirm", (IFormPlugin)this));
            }
        }
        if ("cancelnoticeclaim".equals(operateKey) && opResult != null && opResult.isSuccess()) {
            electRecBills = BusinessDataServiceHelper.load((Object[])args.getOperationResult().getSuccessPkIds().toArray(), (DynamicObjectType)mainEntityType);
            this.cancelNotice(electRecBills);
        }
    }

    private void noticeClaim(DynamicObject[] electRecBills) {
        ArrayList<DynamicObject> notifiedList = new ArrayList<DynamicObject>(10);
        ArrayList<DynamicObject> unNotifiedList = new ArrayList<DynamicObject>(10);
        ArrayList<DynamicObject> hasNoticeRuleList = new ArrayList<DynamicObject>(10);
        ArrayList<DynamicObject> noNoticeRuleList = new ArrayList<DynamicObject>(10);
        ArrayList<DynamicObject> validateList1 = new ArrayList<DynamicObject>(10);
        ArrayList<DynamicObject> validateList2 = new ArrayList<DynamicObject>(10);
        HashMap<String, String> hasNoticeRule = new HashMap<String, String>();
        for (DynamicObject electRecBill : electRecBills) {
            String tradeType = electRecBill.getString("tradetype");
            String ebStatus = electRecBill.getString("ebstatus");
            if (StringUtils.isNotEmpty((CharSequence)tradeType)) {
                validateList1.add(electRecBill);
                continue;
            }
            if (!EbStatus.BANK_SUCCESS.getName().equals(ebStatus) && !EbStatus.BANK_FAIL.getName().equals(ebStatus) && StringUtils.isNotEmpty((CharSequence)ebStatus)) {
                validateList2.add(electRecBill);
                continue;
            }
            if (StringUtils.isEmpty((CharSequence)electRecBill.getString("signnoticebill"))) {
                unNotifiedList.add(electRecBill);
                continue;
            }
            notifiedList.add(electRecBill);
        }
        StringBuilder recPayRuleFailMessage = new StringBuilder();
        for (DynamicObject unNotified : unNotifiedList) {
            Object tag;
            DynamicObject ruleResult = ElectRecClaimRuleHelper.getClaimInfoByNoticeRule((Long)unNotified.getLong("id"), (String)"noticeclaim");
            if (ruleResult == null) {
                noNoticeRuleList.add(unNotified);
                continue;
            }
            Object object = tag = ruleResult.get("e_savenotifi_TAG") == null ? "" : ruleResult.getString("e_savenotifi_TAG");
            if ("noticeclaim".equals(ruleResult.get("e_handlescheme")) && !StringUtils.isEmpty((CharSequence)tag)) {
                String idStr = unNotified.getPkValue().toString();
                hasNoticeRuleList.add(unNotified);
                cache.put(idStr, tag);
            } else {
                noNoticeRuleList.add(unNotified);
            }
            if (!"noticeclaim".equals(ruleResult.get("e_handlescheme")) || StringUtils.isEmpty((CharSequence)ruleResult.getString("e_rulesname"))) continue;
            cache.put(unNotified.getPkValue().toString() + "rulesname", ruleResult.get("e_rulesname"));
            hasNoticeRule.put(unNotified.getPkValue().toString(), ruleResult.get("e_savenotifi_TAG").toString());
        }
        OperateOption option = OperateOption.create();
        option.setVariableValue("ishasright", "true");
        Object[] hasNoticeRuleIds = hasNoticeRuleList.stream().map(DataEntityBase::getPkValue).toArray();
        OperationResult operationResult = TmcOperateServiceHelper.execOperateWithoutThrow((String)"pushclaimcenterbill", (String)"cdm_electronic_sign_deal", (Object[])hasNoticeRuleIds, (OperateOption)option);
        if (!operationResult.isSuccess()) {
            for (IOperateInfo iOperateInfo : operationResult.getAllErrorOrValidateInfo()) {
                recPayRuleFailMessage.append(String.format(ResManager.loadKDString((String)"%1$s\uff1a%2$s \r\n", (String)"EleDraftRecClaimList_2", (String)"tmc-cdm-formplugin", (Object[])new Object[0]), iOperateInfo.getPkValue(), iOperateInfo.getMessage()));
            }
        } else {
            this.getPageCache().put("hasNoticeRuleIds", hasNoticeRuleList.stream().map(e -> e.get("id").toString()).collect(Collectors.joining(",")));
        }
        if (!noNoticeRuleList.isEmpty()) {
            ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener("noticeClaimConfirm", (IFormPlugin)this);
            String confirmMessage = "";
            notifiedList.forEach(detail -> recPayRuleFailMessage.append(String.format(ResManager.loadKDString((String)"%s\uff1a\u5df2\u53d1\u8d77\u8fc7\u8ba4\u9886\u901a\u77e5\uff0c\u65e0\u9700\u518d\u901a\u77e5\u8ba4\u9886\u3002\r\n", (String)"ClaimRecWorkbenchList_4", (String)"tmc-cdm-formplugin", (Object[])new Object[0]), detail.get("billno"))));
            hasNoticeRuleList.forEach(detail -> recPayRuleFailMessage.append(String.format(ResManager.loadKDString((String)"%s\uff1a\u901a\u77e5\u8ba4\u9886\u64cd\u4f5c\u6210\u529f\u3002\r\n", (String)"ClaimRecWorkbenchList_5", (String)"tmc-cdm-formplugin", (Object[])new Object[0]), detail.get("billno"))));
            noNoticeRuleList.forEach(detail -> recPayRuleFailMessage.append(String.format(ResManager.loadKDString((String)"%s\uff1a\u65e0\u6cd5\u6309\u65b9\u6848\u901a\u77e5\u8ba4\u9886\uff0c\u53ef\u80fd\u662f\u672a\u8fdb\u884c\u89c4\u5219\u8bbe\u7f6e\uff0c\u6216\u672a\u9002\u914d\u5230\u65b9\u6848\u3002\u53ef\u6307\u5b9a\u53c2\u4e0e\u8ba4\u9886\u7528\u6237\u4fe1\u606f\u540e\u53d1\u8d77\u901a\u77e5\u3002\r\n", (String)"ClaimRecWorkbenchList_1", (String)"tmc-cdm-formplugin", (Object[])new Object[0]), detail.get("billno"))));
            validateList1.forEach(detail -> recPayRuleFailMessage.append(String.format(ResManager.loadKDString((String)"%s\uff1a\u53ea\u6709\u7968\u636e\u72b6\u6001\u4e3a\u63d0\u793a\u6536\u7968\u5f85\u7b7e\u6536/\u80cc\u4e66\u5f85\u7b7e\u6536/\u8d28\u62bc\u89e3\u9664\u5f85\u7b7e\u6536\u4e14\u64cd\u4f5c\u72b6\u6001\u4e3a\u7a7a\u7684\u8bb0\u5f55\u624d\u80fd\u64cd\u4f5c\u901a\u77e5\u8ba4\u9886\u3002\r\n", (String)"ElcDraftNoticeClaimValidator_0", (String)"tmc-cdm-business", (Object[])new Object[0]), detail.get("billno"))));
            validateList2.forEach(detail -> recPayRuleFailMessage.append(String.format(ResManager.loadKDString((String)"%s\uff1a\u7535\u7968\u64cd\u4f5c\u72b6\u6001\u4e0d\u662f\u4ea4\u6613\u6210\u529f\u6216\u4ea4\u6613\u5931\u8d25\u7684\u5355\u636e\u4e0d\u80fd\u901a\u77e5\u8ba4\u9886\u3002\r\n", (String)"ElcDraftNoticeClaimValidator_1", (String)"tmc-cdm-business", (Object[])new Object[0]), detail.get("billno"))));
            confirmMessage = notifiedList.isEmpty() ? String.format(ResManager.loadKDString((String)"\u5171%1$s\u6761\u8bb0\u5f55\uff0c\u5df2\u6309\u89c4\u5219\u901a\u77e5\u8ba4\u9886%2$s\u6761\uff0c\u672a\u901a\u8fc7\u6821\u9a8c%3$s\u6761\uff0c\u9700\u6307\u5b9a\u53c2\u4e0e\u8ba4\u9886\u7528\u6237\u4fe1\u606f%4$s\u6761\uff0c\u786e\u8ba4\u662f\u5426\u7ee7\u7eed\uff1f", (String)"ClaimRecWorkbenchList_0", (String)"tmc-cdm-formplugin", (Object[])new Object[0]), electRecBills.length, hasNoticeRuleList.size(), validateList1.size() + validateList2.size(), noNoticeRuleList.size()) : String.format(ResManager.loadKDString((String)"\u5171%1$s\u6761\u8bb0\u5f55\uff0c\u65e0\u9700\u901a\u77e5%2$s\u6761\uff0c\u5df2\u6309\u89c4\u5219\u901a\u77e5\u8ba4\u9886%3$s\u6761\uff0c\u672a\u901a\u8fc7\u6821\u9a8c%4$s\u6761\uff0c\u9700\u6307\u5b9a\u53c2\u4e0e\u8ba4\u9886\u7528\u6237\u4fe1\u606f%5$s\u6761\uff0c\u786e\u8ba4\u662f\u5426\u7ee7\u7eed\uff1f", (String)"ClaimRecWorkbenchList_6", (String)"tmc-cdm-formplugin", (Object[])new Object[0]), electRecBills.length, notifiedList.size(), hasNoticeRuleList.size(), validateList1.size() + validateList2.size(), noNoticeRuleList.size());
            this.getView().showConfirm(confirmMessage, recPayRuleFailMessage.toString(), MessageBoxOptions.OKCancel, ConfirmTypes.Default, confirmCallBacks);
            this.getPageCache().put("noNoticeRuleIds", noNoticeRuleList.stream().map(e -> e.get("id").toString()).collect(Collectors.joining(",")));
        } else {
            if (notifiedList.isEmpty() && StringUtils.isEmpty((CharSequence)recPayRuleFailMessage.toString())) {
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u64cd\u4f5c\u6210\u529f", (String)"EleDraftRecClaimList_5", (String)"tmc-cdm-formplugin", (Object[])new Object[0]));
            } else {
                notifiedList.forEach(detail -> recPayRuleFailMessage.append(String.format(ResManager.loadKDString((String)"%s\uff1a\u5df2\u53d1\u8d77\u8fc7\u6536\u6b3e\u8ba4\u9886\u901a\u77e5\uff0c\u65e0\u9700\u518d\u901a\u77e5\u8ba4\u9886\u3002\r\n", (String)"EleDraftRecClaimList_3", (String)"tmc-cdm-formplugin", (Object[])new Object[0]), detail.get("billno"))));
                validateList1.forEach(detail -> recPayRuleFailMessage.append(String.format(ResManager.loadKDString((String)"%s\uff1a\u53ea\u6709\u7968\u636e\u72b6\u6001\u4e3a\u63d0\u793a\u6536\u7968\u5f85\u7b7e\u6536/\u80cc\u4e66\u5f85\u7b7e\u6536/\u8d28\u62bc\u89e3\u9664\u5f85\u7b7e\u6536\u4e14\u64cd\u4f5c\u72b6\u6001\u4e3a\u7a7a\u7684\u8bb0\u5f55\u624d\u80fd\u64cd\u4f5c\u901a\u77e5\u8ba4\u9886\u3002\r\n", (String)"ElcDraftNoticeClaimValidator_0", (String)"tmc-cdm-business", (Object[])new Object[0]), detail.get("billno"))));
                validateList2.forEach(detail -> recPayRuleFailMessage.append(String.format(ResManager.loadKDString((String)"%s\uff1a\u7535\u7968\u64cd\u4f5c\u72b6\u6001\u4e0d\u662f\u4ea4\u6613\u6210\u529f\u6216\u4ea4\u6613\u5931\u8d25\u7684\u5355\u636e\u4e0d\u80fd\u901a\u77e5\u8ba4\u9886\u3002\r\n", (String)"ElcDraftNoticeClaimValidator_1", (String)"tmc-cdm-business", (Object[])new Object[0]), detail.get("billno"))));
                this.getView().showMessage(String.format(ResManager.loadKDString((String)"\u5171%1$s\u6761\u8bb0\u5f55\uff0c\u5df2\u901a\u77e5\u8ba4\u9886%2$s\u6761\uff0c\u672a\u901a\u8fc7\u6821\u9a8c%3$s\u6761\uff0c\u65e0\u9700\u901a\u77e5%4$s\u6761", (String)"EleDraftRecClaimList_4", (String)"tmc-cdm-formplugin", (Object[])new Object[0]), electRecBills.length, unNotifiedList.size(), notifiedList.size(), validateList1.size() + validateList2.size()), recPayRuleFailMessage.toString(), MessageTypes.Default);
            }
            this.noticeMessage(hasNoticeRule);
            this.getPageCache().remove("hasNoticeRuleIds");
            this.getView().invokeOperation("refresh");
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent e) {
        super.confirmCallBack(e);
        if ("noticeClaimConfirm".equals(e.getCallBackId()) && e.getResult() == MessageBoxResult.Yes) {
            FormShowParameter formParameter = new FormShowParameter();
            formParameter.setFormId("cas_noticeclaim");
            formParameter.getOpenStyle().setShowType(ShowType.Modal);
            formParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "noticetype"));
            this.getView().showForm(formParameter);
        } else if ("noticeClaimClearConfirm".equals(e.getCallBackId()) && e.getResult() == MessageBoxResult.Yes) {
            String noticeClaimClearString = this.getPageCache().get("noticeClaimClearIds");
            String[] noticeClaimClearArray = noticeClaimClearString.split(",");
            Object[] noticeClaimClearIds = (Long[])Arrays.stream(noticeClaimClearArray).mapToLong(Long::valueOf).boxed().toArray(Long[]::new);
            MainEntityType mainEntityType = MetadataServiceHelper.getDataEntityType((String)"cdm_electronic_sign_deal");
            DynamicObject[] electRecBills = BusinessDataServiceHelper.load((Object[])noticeClaimClearIds, (DynamicObjectType)mainEntityType);
            Arrays.stream(electRecBills).forEach(detail -> {
                detail.set("signnoticebill", null);
                detail.set("signopinion", null);
                detail.set("noticetime", null);
                detail.set("username", null);
                detail.set("remark", null);
            });
            SaveServiceHelper.save((DynamicObject[])electRecBills);
            this.noticeClaim(electRecBills);
            this.getPageCache().remove("noticeClaimClearIds");
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        if ("noticetype".equals(closedCallBackEvent.getActionId())) {
            try {
                Object returnData = closedCallBackEvent.getReturnData();
                if (EmptyUtil.isEmpty((Object)returnData)) {
                    return;
                }
                Map noticeData = (Map)returnData;
                String noNoticeString = SerializationUtils.toJsonString((Object)noticeData);
                String noNoticeRuleString = this.getPageCache().get("noNoticeRuleIds");
                String[] noNoticeRuleArray = noNoticeRuleString.split(",");
                HashMap<String, String> ruleNotice = new HashMap<String, String>(noNoticeRuleArray.length);
                for (String noNoticeRuleId : noNoticeRuleArray) {
                    cache.put(noNoticeRuleId, (Object)noNoticeString);
                    ruleNotice.put(noNoticeRuleId, noNoticeString);
                }
                String successString = this.getPageCache().get("hasNoticeRuleIds");
                if (EmptyUtil.isNotEmpty((CharSequence)successString)) {
                    String[] successIds = successString.split(",");
                    for (int i = 0; i < successIds.length; ++i) {
                        ruleNotice.put(successIds[i], (String)cache.get(successIds[i], String.class));
                    }
                }
                this.noticeMessage(ruleNotice);
                Object[] noNoticeRuleIds = (Long[])Arrays.stream(noNoticeRuleArray).mapToLong(Long::valueOf).boxed().toArray(Long[]::new);
                OperationResult operationResult = TmcOperateServiceHelper.execOperateWithoutThrow((String)"pushclaimcenterbill", (String)"cdm_electronic_sign_deal", (Object[])noNoticeRuleIds, (OperateOption)OperateOption.create());
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u64cd\u4f5c\u6210\u529f", (String)"EleDraftRecClaimList_5", (String)"tmc-cdm-formplugin", (Object[])new Object[0]));
                this.getPageCache().remove("hasNoticeRuleIds");
                this.getPageCache().remove("noNoticeRuleIds");
                this.getView().invokeOperation("refresh");
            }
            catch (Exception e) {
                this.getPageCache().remove("noNoticeRuleIds");
                throw e;
            }
        }
    }

    private void cancelNotice(DynamicObject[] electRecBills) {
        this.checkOpPerm(ResManager.loadKDString((String)"\u53d6\u6d88\u901a\u77e5\u8ba4\u9886", (String)"RecClaimBillList_8", (String)"tmc-cdm-formplugin", (Object[])new Object[0]), electRecBills);
        OperationResult result = new OperationResult();
        result.setBillCount(electRecBills.length);
        ArrayList<String> noticedBillNos = new ArrayList<String>();
        HashMap<String, String> billNoMap = new HashMap<String, String>();
        for (DynamicObject electRecBill : electRecBills) {
            String signNoticeBill = electRecBill.getString("signnoticebill");
            if (StringUtils.isNotEmpty((CharSequence)signNoticeBill)) {
                noticedBillNos.add(signNoticeBill);
                billNoMap.put(signNoticeBill, electRecBill.getString("billno"));
                continue;
            }
            result.addErrorInfo(CasHelper.getOperateErrorInfo((Object)electRecBill.getPkValue(), (String)String.format(ResManager.loadKDString((String)"\u53ea\u6709\u5df2\u53d1\u8d77\u6536\u6b3e\u8ba4\u9886\u901a\u77e5\uff0c\u4e14\u5904\u4e8e\u201c\u5f85\u8ba4\u9886\u201d\u72b6\u6001\u7684\uff0c\u624d\u80fd\u53d6\u6d88\u901a\u77e5\u8ba4\u9886\uff01\u5355\u636e\u7f16\u53f7\uff1a\u7f16\u53f7\uff1a%s\u53d6\u6d88\u901a\u77e5\u8ba4\u9886\u5931\u8d25", (String)"RecClaimBillList_36", (String)"tmc-cdm-formplugin", (Object[])new Object[0]), electRecBill.getString("billno")), (String)ResManager.loadKDString((String)"\u53d6\u6d88\u901a\u77e5\u8ba4\u9886", (String)"RecClaimBillList_8", (String)"tmc-cdm-formplugin", (Object[])new Object[0])));
        }
        HashSet<Object> claimCenterIds = new HashSet<Object>(4);
        HashSet<Object> electSignIds = new HashSet<Object>(4);
        HashMap claimType = new HashMap(claimCenterIds.size());
        StringBuilder message = new StringBuilder();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-M-dd");
        if (noticedBillNos.size() > 0) {
            DynamicObject[] noticeBills;
            for (DynamicObject dynamicObject : noticeBills = BusinessDataServiceHelper.load((String)"cas_claimcenterbill", (String)"id,billno,claimstatus,sourceid,currency,mergestatus,isunclaim,reamount,oppunit,description,tradetime,tradedetailno,claimnoticebillno,receredtype,entryentity1.claimtype,entryentity1.claimtypeid", (QFilter[])new QFilter[]{new QFilter("billno", "in", noticedBillNos)})) {
                String mergeStatus = dynamicObject.getString("mergestatus");
                if (!"0".equals(mergeStatus)) {
                    result.addErrorInfo(CasHelper.getOperateErrorInfo((Object)dynamicObject.getPkValue(), (String)String.format(ResManager.loadKDString((String)"\u53ea\u6709\u672a\u5408\u5e76\u72b6\u6001\u7684\u6536\u6b3e\u8ba4\u9886\u5355\uff0c\u624d\u80fd\u53d6\u6d88\u901a\u77e5\u8ba4\u9886\uff01\u5355\u636e\u7f16\u53f7\uff1a%s\u53d6\u6d88\u901a\u77e5\u8ba4\u9886\u5931\u8d25", (String)"RecClaimBillList_9", (String)"tmc-cdm-formplugin", (Object[])new Object[0]), billNoMap.get(dynamicObject.getString("billno"))), (String)ResManager.loadKDString((String)"\u53d6\u6d88\u901a\u77e5\u8ba4\u9886", (String)"RecClaimBillList_8", (String)"tmc-cdm-formplugin", (Object[])new Object[0])));
                    continue;
                }
                if (dynamicObject.getBoolean("isunclaim")) {
                    result.addErrorInfo(CasHelper.getOperateErrorInfo((Object)dynamicObject.getPkValue(), (String)String.format(ResManager.loadKDString((String)"\u901a\u77e5\u5355\u5df2\u7ecf\u8fdb\u884c\u4e86\u672a\u8ba4\u9886\u5165\u8d26\u64cd\u4f5c\uff0c\u5355\u636e\u7f16\u53f7\uff1a%s\u53d6\u6d88\u901a\u77e5\u8ba4\u9886\u5931\u8d25", (String)"RecClaimBillList_24", (String)"tmc-cdm-formplugin", (Object[])new Object[0]), billNoMap.get(dynamicObject.getString("billno"))), (String)ResManager.loadKDString((String)"\u53d6\u6d88\u901a\u77e5\u8ba4\u9886", (String)"RecClaimBillList_8", (String)"tmc-cdm-formplugin", (Object[])new Object[0])));
                    continue;
                }
                QFilter qFilter = new QFilter("claimno", "=", (Object)dynamicObject.getString("billno"));
                DynamicObject[] claimBillIds = BusinessDataServiceHelper.load((String)"cas_claimbill", (String)"id", (QFilter[])new QFilter[]{qFilter});
                if (claimBillIds.length > 0) {
                    result.addErrorInfo(CasHelper.getOperateErrorInfo((Object)dynamicObject.getPkValue(), (String)String.format(ResManager.loadKDString((String)"\u53ea\u6709\u5df2\u53d1\u8d77\u6536\u6b3e\u8ba4\u9886\u901a\u77e5\uff0c\u4e14\u4e0d\u5b58\u5728\u672a\u5904\u7406\u7684\u8ba4\u9886\u5355\uff0c\u624d\u80fd\u53d6\u6d88\u901a\u77e5\u8ba4\u9886\uff01\u5355\u636e\u7f16\u53f7\uff1a%s\u53d6\u6d88\u901a\u77e5\u8ba4\u9886\u5931\u8d25", (String)"RecClaimBillList_41", (String)"tmc-cdm-formplugin", (Object[])new Object[0]), billNoMap.get(dynamicObject.getString("billno"))), (String)ResManager.loadKDString((String)"\u53d6\u6d88\u901a\u77e5\u8ba4\u9886", (String)"RecClaimBillList_8", (String)"tmc-cdm-formplugin", (Object[])new Object[0])));
                    continue;
                }
                if (!ClaimStatusEnum.WAIT.getValue().equals(dynamicObject.getString("claimstatus"))) {
                    result.addErrorInfo(CasHelper.getOperateErrorInfo((Object)dynamicObject.getPkValue(), (String)String.format(ResManager.loadKDString((String)"\u53ea\u6709\u5df2\u53d1\u8d77\u6536\u6b3e\u8ba4\u9886\u901a\u77e5\u4e14\u72b6\u6001\u4e3a\u5f85\u8ba4\u9886\u7684\u5355\u636e\uff0c\u624d\u80fd\u53d6\u6d88\u901a\u77e5\u8ba4\u9886\u3002\u5355\u636e\u7f16\u53f7\u201c%s\u201d\u53d6\u6d88\u901a\u77e5\u8ba4\u9886\u5931\u8d25\u3002", (String)"RecClaimBillList_25", (String)"tmc-cdm-formplugin", (Object[])new Object[0]), billNoMap.get(dynamicObject.getString("billno"))), (String)ResManager.loadKDString((String)"\u53d6\u6d88\u901a\u77e5\u8ba4\u9886", (String)"RecClaimBillList_8", (String)"tmc-cdm-formplugin", (Object[])new Object[0])));
                    continue;
                }
                claimCenterIds.add(dynamicObject.getPkValue());
                electSignIds.add(dynamicObject.get("sourceid"));
                DynamicObjectCollection claimEntityColl = dynamicObject.getDynamicObjectCollection("entryentity1");
                HashMap<String, List<Object>> typeValue = new HashMap<String, List<Object>>();
                typeValue.put("userids", claimEntityColl.stream().filter(dy -> StringUtils.equals((CharSequence)ClaimAuthorityEnum.USER.getValue(), (CharSequence)dy.getString("claimtype"))).map(dy -> dy.get("claimtypeid")).collect(Collectors.toList()));
                typeValue.put("usergroupids", claimEntityColl.stream().filter(dy -> StringUtils.equals((CharSequence)ClaimAuthorityEnum.USERGROUP.getValue(), (CharSequence)dy.getString("claimtype"))).map(dy -> dy.get("claimtypeid")).collect(Collectors.toList()));
                typeValue.put("orgids", claimEntityColl.stream().filter(dy -> StringUtils.equals((CharSequence)ClaimAuthorityEnum.USERORG.getValue(), (CharSequence)dy.getString("claimtype"))).map(dy -> dy.get("claimtypeid")).collect(Collectors.toList()));
                typeValue.put("roleids", claimEntityColl.stream().filter(dy -> StringUtils.equals((CharSequence)ClaimAuthorityEnum.ROLER.getValue(), (CharSequence)dy.getString("claimtype"))).map(dy -> dy.get("claimtypeid")).collect(Collectors.toList()));
                ArrayList<String> noticeMes = new ArrayList<String>();
                noticeMes.add(String.format(ResManager.loadKDString((String)"1\u7b14\u6536\u6b3e\uff08\u91d1\u989d\uff1a%1$s%2$s\uff09\u5df2\u53d6\u6d88\u901a\u77e5\u8ba4\u9886", (String)"RecClaimBillList_15", (String)"tmc-cdm-formplugin", (Object[])new Object[0]), dynamicObject.getDynamicObject("currency").getString("sign"), CasHelper.formatDecimal((BigDecimal)dynamicObject.getBigDecimal("reamount"), (int)2)));
                typeValue.put("title", noticeMes);
                noticeMes = new ArrayList();
                if (EmptyUtil.isNoEmpty((Object)dynamicObject.getDate("tradetime"))) {
                    noticeMes.add(String.format(ResManager.loadKDString((String)"\u4ee5\u4e0b\u6536\u6b3e\u5df2\u53d6\u6d88\u901a\u77e5\u8ba4\u9886\u3002\r\n\u6536\u6b3e\u91d1\u989d\uff1a%1$s%2$s\r\n\u5bf9\u65b9\u6237\u540d\uff1a%3$s\r\n\u6458\u8981\uff1a%4$s\r\n\u4ea4\u6613\u65f6\u95f4\uff1a%5$s\r\n\u5f85\u7b7e\u6536\u5355\u636e\u7f16\u53f7 \uff1a%6$s", (String)"RecClaimBillList_19", (String)"tmc-cdm-formplugin", (Object[])new Object[0]), dynamicObject.getDynamicObject("currency").getString("sign"), CasHelper.formatDecimal((BigDecimal)dynamicObject.getBigDecimal("reamount"), (int)2), dynamicObject.getString("oppunit"), dynamicObject.getString("description"), sdf.format(dynamicObject.getDate("tradetime")), dynamicObject.getString("tradedetailno")));
                } else {
                    noticeMes.add(String.format(ResManager.loadKDString((String)"\u4ee5\u4e0b\u6536\u6b3e\u5df2\u53d6\u6d88\u901a\u77e5\u8ba4\u9886\u3002\r\n\u6536\u6b3e\u91d1\u989d\uff1a%1$s%2$s\r\n\u5bf9\u65b9\u6237\u540d\uff1a%3$s\r\n\u6458\u8981\uff1a%4$s\r\n\u5f85\u7b7e\u6536\u5355\u636e\u7f16\u53f7 \uff1a%5$s", (String)"RecClaimBillList_20", (String)"tmc-cdm-formplugin", (Object[])new Object[0]), dynamicObject.getDynamicObject("currency").getString("sign"), CasHelper.formatDecimal((BigDecimal)dynamicObject.getBigDecimal("reamount"), (int)2), dynamicObject.getString("oppunit"), dynamicObject.getString("description"), dynamicObject.getString("tradedetailno")));
                }
                typeValue.put("content", noticeMes);
                claimType.put(dynamicObject.getPkValue(), typeValue);
            }
        }
        if (claimCenterIds.size() > 0) {
            OperationResult execOperate;
            block42: {
                try (TXHandle tx = TX.requiresNew();){
                    execOperate = TmcOperateServiceHelper.execOperateWithoutThrow((String)"delete", (String)"cas_claimcenterbill", (Object[])claimCenterIds.toArray(), (OperateOption)OperateOption.create());
                    if (!execOperate.isSuccess() && execOperate.getAllErrorInfo().size() > 0) {
                        result.addErrorInfo((OperateErrorInfo)execOperate.getAllErrorInfo().get(0));
                        break block42;
                    }
                    Throwable throwable = null;
                    try (TXHandle tx2 = TX.requiresNew();){
                        try {
                            ElectRecClaimRuleHelper.cancelWriteClaimNo((Object[])electSignIds.toArray());
                        }
                        catch (Exception e) {
                            tx2.markRollback();
                            tx.markRollback();
                            execOperate.getSuccessPkIds().clear();
                        }
                    }
                    catch (Throwable throwable2) {
                        Throwable throwable3 = throwable2;
                        throw throwable2;
                    }
                }
            }
            HashMap claimTypeTemp = new HashMap(claimCenterIds.size());
            List successPkId = execOperate.getSuccessPkIds();
            for (Map.Entry entry : claimType.entrySet()) {
                if (!successPkId.contains(entry.getKey())) continue;
                claimTypeTemp.put(entry.getKey(), entry.getValue());
            }
            if (claimTypeTemp.size() > 0) {
                RecClaimHelper.sendClaimNoticeMessage(claimTypeTemp, (String)"cancel");
            }
        }
        if (result.getAllErrorInfo().size() > 0) {
            ((ListView)this.getView()).refresh();
            CasHelper.showOperationResultMulti((OperationResult)result, (String)ResManager.loadKDString((String)"\u53d6\u6d88\u901a\u77e5\u8ba4\u9886", (String)"RecClaimBillList_8", (String)"tmc-cdm-formplugin", (Object[])new Object[0]), (IFormView)this.getView());
        } else {
            ((ListView)this.getView()).refresh();
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u64cd\u4f5c\u6210\u529f", (String)"RecClaimBillList_2", (String)"tmc-cdm-formplugin", (Object[])new Object[0]));
        }
    }

    private void checkOpPerm(String opKeyName, DynamicObject[] electRecBills) {
        if (CasHelper.isEmpty((DynamicObject[])electRecBills)) {
            return;
        }
        Map operateMetaMap = EntityMetadataCache.getDataEntityOperate((String)"cdm_electronic_sign_deal", (String)"cancelnoticeclaim");
        Object permission = operateMetaMap.get("permission");
        boolean hasPerm = true;
        HashSet<Long> orgIds = new HashSet<Long>(electRecBills.length);
        for (DynamicObject receivablebill : electRecBills) {
            orgIds.add(receivablebill.getDynamicObject("company").getLong("id"));
        }
        for (Long org : orgIds) {
            hasPerm = PermissionHelper.checkCurrentUserPermission((long)org, (String)"cdm_electronic_sign_deal", (String)(permission + ""));
        }
        if (!hasPerm) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5f53\u524d\u7528\u6237\u6ca1\u6709%s\u7684\u6743\u9650\uff01", (String)"RecWorkbenchPlugin_5", (String)"tmc-cdm-formplugin", (Object[])new Object[0]), opKeyName));
        }
    }

    private void noticeMessage(Map<String, String> ruleNotice) {
        HashMap claimTypeMap = new HashMap(ruleNotice.size());
        for (Map.Entry<String, String> rule : ruleNotice.entrySet()) {
            Map map = (Map)SerializationUtils.fromJsonString((String)rule.getValue(), Map.class);
            HashMap<String, List> typeValue = new HashMap<String, List>();
            typeValue.put("usergroupids", (List)map.get("usergroupids"));
            typeValue.put("orgids", (List)map.get("orgids"));
            typeValue.put("roleids", (List)map.get("roleids"));
            typeValue.put("userids", (List)map.get("userids"));
            claimTypeMap.put(rule.getKey(), typeValue);
        }
        RecClaimHelper.sendClaimNoticeMessage(claimTypeMap, (String)"notice");
    }

    static class GetListDataProvider
    extends ListDataProvider {
        GetListDataProvider() {
        }

        public DynamicObjectCollection getData(int arg0, int arg1) {
            DynamicObjectCollection rows = super.getData(arg0, arg1);
            if (rows.isEmpty()) {
                return rows;
            }
            ArrayList signNoticeBillList = new ArrayList(rows.size());
            if (((DynamicObject)rows.get(0)).getDataEntityType().getProperties().containsKey((Object)"signnoticebill")) {
                rows.forEach(row -> {
                    String signNoticeBill = row.getString("signnoticebill");
                    if (StringUtils.isNotEmpty((CharSequence)signNoticeBill)) {
                        signNoticeBillList.add(signNoticeBill);
                    }
                });
            }
            if (signNoticeBillList.size() == 0) {
                return rows;
            }
            Map<Object, Object> draftAndClaimStatusMap = new HashMap(8);
            DynamicObjectCollection claimBillList = QueryServiceHelper.query((String)"cas_claimcenterbill", (String)"id,claimstatus,billno", (QFilter[])new QFilter[]{new QFilter("billno", "in", signNoticeBillList)});
            if (claimBillList.size() > 0) {
                draftAndClaimStatusMap = claimBillList.stream().collect(Collectors.groupingBy(e -> e.getString("billno")));
            }
            for (DynamicObject row2 : rows) {
                String draftBillKey = row2.getString("signnoticebill");
                if (draftAndClaimStatusMap.size() <= 0 || !EmptyUtil.isNoEmpty((Object)draftAndClaimStatusMap.get(draftBillKey))) continue;
                List claimBillDyList = (List)draftAndClaimStatusMap.get(draftBillKey);
                DynamicObject claimBill = (DynamicObject)claimBillDyList.get(0);
                String claimStatus = claimBill.getString("claimstatus");
                row2.set("claimstatus", (Object)claimStatus);
            }
            return rows;
        }
    }
}

