/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cdm.formplugin.elcDraft;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.bill.BillShowParameter;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.filter.CommonFilterColumn;
import kd.bos.filter.FilterColumn;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.field.ComboItem;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.cdm.common.enums.EleDraftBillStatusEnum;
import kd.tmc.cdm.common.enums.ReceivePayTypeEnum;
import kd.tmc.cdm.common.helper.CdmCommonHelper;
import kd.tmc.fbp.common.helper.TmcBotpHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.formplugin.list.AbstractTmcBillBaseList;

public class EleDraftRecList
extends AbstractTmcBillBaseList {
    public void setFilter(SetFilterEvent e) {
        e.getQFilters().add(new QFilter("rptype", "=", (Object)ReceivePayTypeEnum.RECEIVEBILL.getValue()));
        e.getQFilters().add(new QFilter("ticketstatus", "in", Arrays.asList(EleDraftBillStatusEnum.INIT.getValue(), "", " ", EleDraftBillStatusEnum.INVOICESIGNED.getValue(), EleDraftBillStatusEnum.RECITE.getValue(), EleDraftBillStatusEnum.RECITESIGNED.getValue(), EleDraftBillStatusEnum.NOTEDISCOUNT.getValue(), EleDraftBillStatusEnum.NOTEDISCOUNTSIGNED.getValue(), EleDraftBillStatusEnum.PLEDGE.getValue(), EleDraftBillStatusEnum.RELEASEPLEDGE.getValue(), EleDraftBillStatusEnum.RELEASEOFPLEDGESIGNED.getValue(), EleDraftBillStatusEnum.PAYMENT.getValue(), EleDraftBillStatusEnum.PAYMENTSIGNED.getValue(), EleDraftBillStatusEnum.ENSURE.getValue(), EleDraftBillStatusEnum.PAYMENTREFUSED.getValue(), EleDraftBillStatusEnum.SEARCHFOR.getValue(), EleDraftBillStatusEnum.PROMISESEARCHFOR.getValue(), EleDraftBillStatusEnum.CLOSEDACCOUNT.getValue(), EleDraftBillStatusEnum.PROMISESEARCHFORSIGNED.getValue())));
    }

    public void filterContainerInit(FilterContainerInitArgs args) {
        super.filterContainerInit(args);
        for (FilterColumn filterColumn : args.getFilterContainerInitEvent().getCommonFilterColumns()) {
            CommonFilterColumn commonFilterColumn = (CommonFilterColumn)filterColumn;
            String fieldName = commonFilterColumn.getFieldName();
            if (!"ticketstatus".equals(fieldName)) continue;
            commonFilterColumn.setComboItems(this.buildComboItems());
        }
    }

    List<ComboItem> buildComboItems() {
        List<String> status = Arrays.asList(EleDraftBillStatusEnum.INVOICESIGNED.getValue(), EleDraftBillStatusEnum.RECITE.getValue(), EleDraftBillStatusEnum.RECITESIGNED.getValue(), EleDraftBillStatusEnum.NOTEDISCOUNT.getValue(), EleDraftBillStatusEnum.NOTEDISCOUNTSIGNED.getValue(), EleDraftBillStatusEnum.PLEDGE.getValue(), EleDraftBillStatusEnum.RELEASEPLEDGE.getValue(), EleDraftBillStatusEnum.RELEASEOFPLEDGESIGNED.getValue(), EleDraftBillStatusEnum.PAYMENT.getValue(), EleDraftBillStatusEnum.PAYMENTSIGNED.getValue(), EleDraftBillStatusEnum.ENSURE.getValue(), EleDraftBillStatusEnum.PAYMENTREFUSED.getValue(), EleDraftBillStatusEnum.SEARCHFOR.getValue(), EleDraftBillStatusEnum.PROMISESEARCHFOR.getValue(), EleDraftBillStatusEnum.CLOSEDACCOUNT.getValue(), EleDraftBillStatusEnum.PROMISESEARCHFORSIGNED.getValue());
        return status.stream().map(o -> {
            ComboItem item = new ComboItem();
            item.setCaption(new LocaleString(EleDraftBillStatusEnum.getByValue((String)o).getName()));
            item.setValue(o);
            return item;
        }).collect(Collectors.toList());
    }

    public void afterDoOperation(AfterDoOperationEventArgs event) {
        List pkValues;
        super.afterDoOperation(event);
        FormOperate formOperate = (FormOperate)event.getSource();
        OperationResult opResult = event.getOperationResult();
        String operateKey = formOperate.getOperateKey();
        if ("modifyebstatus".equals(operateKey) && (pkValues = event.getOperationResult().getSuccessPkIds()).size() > 0) {
            HashMap<String, Object> param = new HashMap<String, Object>();
            HashMap<String, Object> customParam = new HashMap<String, Object>();
            customParam.put("sourceIdList", pkValues);
            customParam.put("sourcetype", "cdm_electronic_rec_deal");
            param.put("customParam", customParam);
            param.put("formId", "cdm_ebstatuschange");
            param.put("showType", ShowType.MainNewTabPage);
            CdmCommonHelper.showWebBill(param, (AbstractFormPlugin)this);
        }
        if ("viewmodifyrecord".equals(operateKey)) {
            if (!event.getOperationResult().isSuccess()) {
                return;
            }
            pkValues = event.getOperationResult().getSuccessPkIds();
            Object pkValue = event.getOperationResult().getSuccessPkIds().get(0);
            QFilter qFilter = new QFilter("entryentity.billsourceid", "=", pkValue);
            boolean isExistChangeBill = QueryServiceHelper.exists((String)"cdm_ebstatuschange", (QFilter[])new QFilter[]{qFilter});
            if (pkValues.size() > 0 && isExistChangeBill) {
                ListShowParameter showParameter = new ListShowParameter();
                showParameter.setFormId("bos_list");
                showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                showParameter.setBillFormId("cdm_ebstatuschange");
                List qFiltersCol = showParameter.getListFilterParameter().getQFilters();
                qFiltersCol.add(qFilter);
                this.getView().showForm((FormShowParameter)showParameter);
            } else {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u4fee\u6539\u8bb0\u5f55", (String)"EleDraftRecList_1", (String)"tmc-cdm-formplugin", (Object[])new Object[0]));
            }
        }
        if ("recdealtrackdown".equals(operateKey) && opResult.isSuccess() && opResult.getSuccessPkIds().size() > 0) {
            Object pkValue = event.getOperationResult().getSuccessPkIds().get(0);
            DynamicObject electronicRecDeal = TmcDataServiceHelper.loadSingle(pkValue, (String)"cdm_electronic_rec_deal", (String)"id,sourceid");
            ArrayList<Long> drafttradeBillIds = new ArrayList<Long>();
            ArrayList<Long> receivableBillIds = new ArrayList<Long>();
            if (electronicRecDeal != null && !EmptyUtil.isEmpty((Long)electronicRecDeal.getLong("sourceid")) && electronicRecDeal.getLong("sourceid") > 0L) {
                DynamicObject[] drafttradeBills;
                QFilter draftbillIdFilter = new QFilter("entrys.draftbill.id", "=", (Object)electronicRecDeal.getLong("sourceid"));
                for (DynamicObject dynamicObject : drafttradeBills = TmcDataServiceHelper.load((String)"cdm_drafttradebill", (String)"id", (QFilter[])new QFilter[]{draftbillIdFilter})) {
                    drafttradeBillIds.add(dynamicObject.getLong("id"));
                }
                if (EmptyUtil.isEmpty(drafttradeBillIds)) {
                    receivableBillIds.add(electronicRecDeal.getLong("sourceid"));
                }
            }
            ArrayList<Tuple> tuples = new ArrayList<Tuple>();
            if (!EmptyUtil.isEmpty(drafttradeBillIds)) {
                tuples.add(new Tuple((Object)"cdm_drafttradebill", drafttradeBillIds));
            } else if (!EmptyUtil.isEmpty(receivableBillIds)) {
                tuples.add(new Tuple((Object)"cdm_receivablebill", receivableBillIds));
            }
            TmcBotpHelper.showTrackParameter(tuples, (IFormView)this.getView());
        }
        BillList billList = (BillList)this.getControl("billlistap");
        billList.clearSelection();
        billList.refresh();
    }

    public void confirmCallBack(MessageBoxClosedEvent e) {
        super.confirmCallBack(e);
        if ("existChangeBillConfirm".equals(e.getCallBackId()) && e.getResult() == MessageBoxResult.Yes) {
            String successString = this.getPageCache().get("successIds");
            BillShowParameter sp = new BillShowParameter();
            sp.setBillTypeId("cdm_ebstatuschange");
            sp.setFormId("cdm_ebstatuschange");
            sp.setPkId((Object)successString);
            sp.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            this.getView().showForm((FormShowParameter)sp);
            this.getPageCache().remove("successIds");
            BillList billList = (BillList)this.getControl("billlistap");
            billList.clearSelection();
            billList.refresh();
        }
    }
}

