/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cdm.formplugin.elcDraft;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.filter.ControlFilter;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.filter.CommonFilterColumn;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.field.ComboItem;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.cdm.common.enums.EleDraftBillStatusEnum;
import kd.tmc.cdm.common.enums.ReceivePayTypeEnum;
import kd.tmc.cdm.common.helper.CdmCommonHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.formplugin.list.AbstractTmcBillBaseList;
import org.apache.commons.lang3.StringUtils;

public class EleDraftRecWaitList
extends AbstractTmcBillBaseList {
    public static final int SIZE_DEFAUTLT = 6;

    public void setFilter(SetFilterEvent e) {
        e.getQFilters().add(new QFilter("rptype", "=", (Object)ReceivePayTypeEnum.RECEIVEBILL.getValue()));
        e.getQFilters().add(new QFilter("ticketstatus", "in", Arrays.asList("", " ", EleDraftBillStatusEnum.INVOICE.getValue(), EleDraftBillStatusEnum.INVOICESIGNED.getValue(), EleDraftBillStatusEnum.RECITE.getValue(), EleDraftBillStatusEnum.RECITESIGNED.getValue(), EleDraftBillStatusEnum.RELEASEPLEDGE.getValue(), EleDraftBillStatusEnum.RELEASEOFPLEDGESIGNED.getValue(), EleDraftBillStatusEnum.NOTEDISCOUNT.getValue(), EleDraftBillStatusEnum.NOTEDISCOUNTSIGNED.getValue(), EleDraftBillStatusEnum.PLEDGE.getValue(), EleDraftBillStatusEnum.PLEDGESIGNED.getValue(), EleDraftBillStatusEnum.ACCEPTANCE.getValue(), EleDraftBillStatusEnum.ACCEPTANCESIGNED.getValue(), EleDraftBillStatusEnum.PAYMENT.getValue(), EleDraftBillStatusEnum.PAYMENTSIGNED.getValue(), EleDraftBillStatusEnum.PAYMENTREFUSED.getValue(), EleDraftBillStatusEnum.CLOSEDACCOUNT.getValue())));
    }

    public void filterContainerInit(FilterContainerInitArgs args) {
        super.filterContainerInit(args);
        Iterator iterator = args.getFilterContainerInitEvent().getCommonFilterColumns().iterator();
        List companyObjectIds = new ArrayList(6);
        while (iterator.hasNext()) {
            CommonFilterColumn commonFilterColumn = (CommonFilterColumn)iterator.next();
            String fieldName = commonFilterColumn.getFieldName();
            if ("ticketstatus".equals(fieldName)) {
                commonFilterColumn.setComboItems(this.buildTicketStatusComboItems());
            }
            if (fieldName.contains("company.")) {
                ControlFilter ControlFilter2 = (ControlFilter)commonFilterColumn.getContext().getControlFiltersMap().get(String.join((CharSequence)".", "company", "id"));
                if (ControlFilter2 != null && ControlFilter2.getValue() != null && ControlFilter2.getValue().size() > 0) {
                    companyObjectIds = ControlFilter2.getValue();
                } else {
                    List aa = commonFilterColumn.getDefaultValues();
                    if (aa.size() > 0) {
                        companyObjectIds = aa;
                    }
                }
            }
            if (!fieldName.contains("draftaccount.")) continue;
            List<Long> companyIds = companyObjectIds.stream().filter(o -> !ObjectUtils.isEmpty((Object)o)).map(o -> ObjectUtils.isEmpty((Object)o) ? null : Long.valueOf(Long.parseLong(o.toString()))).collect(Collectors.toList());
            commonFilterColumn.setComboItems(this.buildDraftAccountComboItems(companyIds));
        }
    }

    private List<ComboItem> buildTicketStatusComboItems() {
        List<String> status = Arrays.asList(EleDraftBillStatusEnum.INVOICE.getValue(), EleDraftBillStatusEnum.INVOICESIGNED.getValue(), EleDraftBillStatusEnum.RECITE.getValue(), EleDraftBillStatusEnum.RECITESIGNED.getValue(), EleDraftBillStatusEnum.RELEASEPLEDGE.getValue(), EleDraftBillStatusEnum.RELEASEOFPLEDGESIGNED.getValue(), EleDraftBillStatusEnum.NOTEDISCOUNT.getValue(), EleDraftBillStatusEnum.NOTEDISCOUNTSIGNED.getValue(), EleDraftBillStatusEnum.PLEDGE.getValue(), EleDraftBillStatusEnum.PLEDGESIGNED.getValue(), EleDraftBillStatusEnum.ACCEPTANCE.getValue(), EleDraftBillStatusEnum.ACCEPTANCESIGNED.getValue(), EleDraftBillStatusEnum.PAYMENT.getValue(), EleDraftBillStatusEnum.PAYMENTSIGNED.getValue(), EleDraftBillStatusEnum.PAYMENTREFUSED.getValue(), EleDraftBillStatusEnum.CLOSEDACCOUNT.getValue());
        return status.stream().map(o -> {
            ComboItem item = new ComboItem();
            item.setCaption(new LocaleString(EleDraftBillStatusEnum.getByValue((String)o).getName()));
            item.setValue(o);
            return item;
        }).collect(Collectors.toList());
    }

    private List<ComboItem> buildDraftAccountComboItems(List<Long> companyId) {
        QFilter qFilter = null;
        if (companyId.size() > 0) {
            qFilter = new QFilter("company.id", "in", companyId);
        }
        DynamicObject[] draftAccounts = BusinessDataServiceHelper.load((String)"cdm_electicdirconset", (String)"defaultaccount", (QFilter[])new QFilter[]{qFilter});
        return Arrays.stream(draftAccounts).filter(o -> !StringUtils.isEmpty((CharSequence)o.getString("defaultaccount.id")) && !StringUtils.isEmpty((CharSequence)o.getString("defaultaccount.name"))).map(o -> {
            ComboItem item = new ComboItem();
            item.setCaption(new LocaleString(o.getString("defaultaccount.name")));
            item.setValue(o.getString("defaultaccount.id"));
            return item;
        }).distinct().collect(Collectors.toList());
    }

    public void afterDoOperation(AfterDoOperationEventArgs event) {
        List pkValues;
        super.afterDoOperation(event);
        FormOperate formOperate = (FormOperate)event.getSource();
        OperationResult opResult = event.getOperationResult();
        String operateKey = formOperate.getOperateKey();
        if ("modifyebstatus".equals(operateKey) && (pkValues = event.getOperationResult().getSuccessPkIds()).size() > 0) {
            HashMap<String, Object> param = new HashMap<String, Object>();
            HashMap<String, Object> customParam = new HashMap<String, Object>();
            customParam.put("sourceIdList", pkValues);
            customParam.put("sourcetype", "cdm_electronic_sign_deal");
            param.put("customParam", customParam);
            param.put("formId", "cdm_ebstatuschange");
            param.put("showType", ShowType.MainNewTabPage);
            CdmCommonHelper.showWebBill(param, (AbstractFormPlugin)this);
        }
        if ("viewmodifyrecord".equals(operateKey)) {
            if (!event.getOperationResult().isSuccess()) {
                return;
            }
            pkValues = event.getOperationResult().getSuccessPkIds();
            Object pkValue = event.getOperationResult().getSuccessPkIds().get(0);
            QFilter qFilter = new QFilter("entryentity.billsourceid", "=", pkValue);
            boolean isExistChangeBill = QueryServiceHelper.exists((String)"cdm_ebstatuschange", (QFilter[])new QFilter[]{qFilter});
            if (pkValues.size() > 0 && isExistChangeBill) {
                ListShowParameter showParameter = new ListShowParameter();
                showParameter.setFormId("bos_list");
                showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                showParameter.setBillFormId("cdm_ebstatuschange");
                List qFiltersCol = showParameter.getListFilterParameter().getQFilters();
                qFiltersCol.add(qFilter);
                this.getView().showForm((FormShowParameter)showParameter);
            } else {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u4fee\u6539\u8bb0\u5f55", (String)"EleDraftRecList_1", (String)"tmc-cdm-formplugin", (Object[])new Object[0]));
            }
        }
        if ("signdealtrackdown".equals(operateKey) && opResult.isSuccess() && opResult.getSuccessPkIds().size() > 0) {
            Object pkValue = event.getOperationResult().getSuccessPkIds().get(0);
            DynamicObject electronicSignDeal = TmcDataServiceHelper.loadSingle(pkValue, (String)"cdm_electronic_sign_deal", (String)"id,sourceid");
            if (!EmptyUtil.isEmpty((DynamicObject)electronicSignDeal) && EmptyUtil.isNoEmpty((Long)electronicSignDeal.getLong("sourceid")) && electronicSignDeal.getLong("sourceid") > 0L) {
                BillShowParameter parameter = new BillShowParameter();
                parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                parameter.setAppId("cdm");
                parameter.setFormId("cdm_receivablebill");
                parameter.setPkId((Object)electronicSignDeal.getLong("sourceid"));
                parameter.setStatus(OperationStatus.VIEW);
                this.getView().showForm((FormShowParameter)parameter);
            } else {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u8054\u67e5\u6570\u636e\u3002", (String)"CdmBizResource_167", (String)"tmc-cdm-common", (Object[])new Object[0]));
            }
        }
        BillList billList = (BillList)this.getControl("billlistap");
        billList.clearSelection();
        billList.refresh();
    }

    public void confirmCallBack(MessageBoxClosedEvent e) {
        super.confirmCallBack(e);
        if ("existChangeBillConfirm".equals(e.getCallBackId()) && e.getResult() == MessageBoxResult.Yes) {
            String successString = this.getPageCache().get("successIds");
            BillShowParameter sp = new BillShowParameter();
            sp.setBillTypeId("cdm_ebstatuschange");
            sp.setFormId("cdm_ebstatuschange");
            sp.setPkId((Object)successString);
            sp.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            this.getView().showForm((FormShowParameter)sp);
            this.getPageCache().remove("successIds");
            BillList billList = (BillList)this.getControl("billlistap");
            billList.clearSelection();
            billList.refresh();
        }
    }
}

