/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cdm.formplugin.elcDraft;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.control.Button;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.tmc.fbp.common.enums.BankFuncEnum;
import kd.tmc.fbp.common.helper.TmcAccountHelper;
import kd.tmc.fbp.common.helper.TmcOrgDataHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.formplugin.edit.AbstractTmcBillEdit;

public class QueryPreElectronicBillEdit
extends AbstractTmcBillEdit {
    private static final String BTNOK = "btnok";

    public void registerListener(EventObject e) {
        Button btnok = (Button)this.getView().getControl(BTNOK);
        btnok.addClickListener((ClickListener)this);
        this.companyRegisterListener();
        this.defaultAccountF7Filter();
    }

    private void companyRegisterListener() {
        BasedataEdit company;
        if (this.getModel().getProperty("company") != null && (company = (BasedataEdit)this.getControl("company")) != null) {
            company.addBeforeF7SelectListener(beforeF7SelectEvent -> {
                ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
                CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "company");
                showParameter.setCloseCallBack(closeCallBack);
                String appId = this.getView().getFormShowParameter().getAppId();
                Long userId = RequestContext.get().getCurrUserId();
                List authOrgIds = TmcOrgDataHelper.getAuthorizedBankOrgId((Long)userId, (String)appId, (String)"cdm_pre_elecbill_query", (String)"47150e89000000ac");
                QFilter idFilter = new QFilter("id", "in", (Object)authOrgIds);
                ArrayList<QFilter> listQFilter = new ArrayList<QFilter>(4);
                listQFilter.add(idFilter);
                showParameter.getListFilterParameter().setQFilters(listQFilter);
            });
        }
    }

    private void defaultAccountF7Filter() {
        BasedataEdit accountObj = (BasedataEdit)this.getControl("defaultaccount");
        accountObj.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            DynamicObject orgObj = (DynamicObject)this.getModel().getValue("company");
            DynamicObject channelObj = (DynamicObject)this.getModel().getValue("directconnchannel");
            if (Objects.isNull(orgObj)) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u8d44\u91d1\u7ec4\u7ec7", (String)"QueryPreElectronicBillEdit_2", (String)"tmc-cdm-formplugin", (Object[])new Object[0]));
                beforeF7SelectEvent.setCancel(Boolean.TRUE.booleanValue());
                return;
            }
            Long channelId = channelObj.getLong("id");
            QFilter orgFilter = new QFilter("company", "=", orgObj.getPkValue());
            QFilter channelFilter = new QFilter("directconnchannel", "=", (Object)channelId);
            DynamicObject[] electricDirects = BusinessDataServiceHelper.load((String)"cdm_electicdirconset", (String)"id,defaultaccount", (QFilter[])new QFilter[]{orgFilter, channelFilter});
            ArrayList<Object> accountIds = new ArrayList<Object>();
            for (DynamicObject electricDirect : electricDirects) {
                if (!EmptyUtil.isNoEmpty((DynamicObject)electricDirect.getDynamicObject("defaultaccount"))) continue;
                accountIds.add(electricDirect.getDynamicObject("defaultaccount").getPkValue());
            }
            ListShowParameter showPara = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            long orgId = Long.parseLong(orgObj.getPkValue().toString());
            QFilter electricDirectIdsFilter = new QFilter("id", "in", accountIds);
            QFilter accountAuthAssignFilter = TmcAccountHelper.getAccountBankFilterByOrg((Long)orgId);
            QFilter bizObjFilter = new QFilter("bank.bank_cate.id", "=", (Object)channelId);
            QFilter isEBFilter = new QFilter("issetbankinterface", "=", (Object)"1");
            QFilter beBankFilter = new QFilter("bebankfunc", "like", (Object)("%" + BankFuncEnum.ECD.getValue() + "%"));
            showPara.getListFilterParameter().setQFilters(Arrays.asList(electricDirectIdsFilter, accountAuthAssignFilter, bizObjFilter, isEBFilter, beBankFilter));
        });
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        ListSelectedRow row;
        ListSelectedRowCollection rows;
        super.closedCallBack(e);
        String actionId = e.getActionId();
        if ("company".equals(actionId) && !EmptyUtil.isEmpty((Collection)(rows = (ListSelectedRowCollection)e.getReturnData())) && !EmptyUtil.isEmpty((Object)(row = rows.get(0)))) {
            this.getModel().setValue("company", row.getPrimaryKeyValue());
        }
    }

    public void click(EventObject evt) {
        Control source = (Control)evt.getSource();
        HashMap<String, Object> returnData = new HashMap<String, Object>();
        if (StringUtils.equals((CharSequence)BTNOK, (CharSequence)source.getKey())) {
            DynamicObject company = (DynamicObject)this.getModel().getValue("company");
            DynamicObject directConnChannel = (DynamicObject)this.getModel().getValue("directconnchannel");
            DynamicObject defaultAccount = (DynamicObject)this.getModel().getValue("defaultaccount");
            String interfaceType = (String)this.getModel().getValue("interfacetype");
            if (EmptyUtil.isEmpty((DynamicObject)company)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u8d44\u91d1\u7ec4\u7ec7!", (String)"QueryPreElectronicBillEdit_0", (String)"tmc-cdm-formplugin", (Object[])new Object[0]));
                return;
            }
            if (EmptyUtil.isEmpty((DynamicObject)defaultAccount)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u7968\u636e\u8d26\u6237!", (String)"QueryPreElectronicBillEdit_1", (String)"tmc-cdm-formplugin", (Object[])new Object[0]));
                return;
            }
            returnData.put("company", company.getPkValue());
            returnData.put("directconnchannel", directConnChannel.getPkValue());
            returnData.put("defaultaccount", defaultAccount.getPkValue());
            returnData.put("interfacetype", interfaceType);
            this.getView().returnDataToParent(returnData);
            this.getView().close();
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        ChangeData[] changeSet = e.getChangeSet();
        ChangeData changeData = changeSet[0];
        String name = e.getProperty().getName();
        if ("company".equals(name)) {
            Object newValue = changeData.getNewValue();
            if (newValue == null) {
                return;
            }
            this.getModel().setValue("defaultaccount", null);
        }
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        Long orgId = RequestContext.get().getOrgId();
        this.getModel().setValue("company", (Object)orgId);
        this.setDefaultAccount();
    }

    private void setDefaultAccount() {
        DynamicObject orgObj = (DynamicObject)this.getModel().getValue("company");
        if (EmptyUtil.isNoEmpty((DynamicObject)orgObj)) {
            DynamicObject channelObj = (DynamicObject)this.getModel().getValue("directconnchannel");
            Long channelId = channelObj.getLong("id");
            QFilter orgFilter = new QFilter("company", "=", orgObj.getPkValue());
            QFilter channelFilter = new QFilter("directconnchannel", "=", (Object)channelId);
            Object[] electricDirects = BusinessDataServiceHelper.load((String)"cdm_electicdirconset", (String)"id,defaultaccount", (QFilter[])new QFilter[]{orgFilter, channelFilter});
            if (!EmptyUtil.isEmpty((Object[])electricDirects)) {
                this.getModel().setValue("defaultaccount", (Object)electricDirects[0].getDynamicObject("defaultaccount").getLong("id"));
            }
        }
    }
}

