/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cdm.formplugin.payablebill;

import com.alibaba.fastjson.JSON;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.datamodel.events.AfterAddRowEventArgs;
import kd.bos.entity.datamodel.events.AfterDeleteEntryEventArgs;
import kd.bos.entity.datamodel.events.AfterDeleteRowEventArgs;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.BeforeClickEvent;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.tmc.cdm.common.bean.CreditLimitF7ResBean;
import kd.tmc.cdm.common.bean.CreditLimitUseBean;
import kd.tmc.cdm.common.enums.DraftTranStatusEnum;
import kd.tmc.cdm.common.helper.DraftHelper;
import kd.tmc.cdm.common.helper.TradeBillWorkcalendarHelper;
import kd.tmc.cdm.common.resource.CdmBizResource;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.formplugin.edit.AbstractTmcBillEdit;

public class DiscountApplyBillEdit
extends AbstractTmcBillEdit
implements RowClickEventListener {
    private static final BigDecimal STANDARAMOUNT = new BigDecimal("0.01");
    private boolean skipPropChange;
    private static Log logger = LogFactory.getLog(DiscountApplyBillEdit.class);

    public void registerListener(EventObject e) {
        super.registerListener(e);
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("inquiryentrys");
        entryGrid.addRowClickListener((RowClickEventListener)this);
        this.creditlimitClick();
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        DynamicObjectCollection entrys = this.getModel().getEntryEntity("entrys");
        int size = entrys.size();
        ArrayList<Object> draftBillIds = new ArrayList<Object>(size);
        for (int i = 0; i < size; ++i) {
            boolean isinvalid = ((DynamicObject)entrys.get(i)).getBoolean("isinvalid");
            if (isinvalid) continue;
            DynamicObject draftBill = ((DynamicObject)entrys.get(i)).getDynamicObject("draftbill");
            BigDecimal billAmt = ((DynamicObject)entrys.get(i)).getBigDecimal("billamt");
            if (EmptyUtil.isEmpty((BigDecimal)billAmt)) {
                this.getModel().setValue("billamt", (Object)draftBill.getBigDecimal("amount"), i);
            }
            draftBillIds.add(draftBill.getPkValue());
        }
        this.getPageCache().put("selectedDraft", JSON.toJSONString(draftBillIds));
        DynamicObject creditlimit = this.getModel().getDataEntity().getDynamicObject("creditlimited");
        if (EmptyUtil.isNoEmpty((DynamicObject)creditlimit)) {
            long billId = this.getModel().getDataEntity().getLong("id");
            this.loadCreditUse(billId);
        }
    }

    private void loadCreditUse(Long sourceBillId) {
        DynamicObjectCollection entrys = (DynamicObjectCollection)this.getModel().getValue("entrys");
        if (EmptyUtil.isEmpty((Long)sourceBillId) || EmptyUtil.isEmpty((DynamicObjectCollection)entrys)) {
            return;
        }
        QFilter source_qFilter = new QFilter("sourcebillid", "=", (Object)sourceBillId);
        QFilter isrele_qFilter = new QFilter("isrelease", "=", (Object)"0");
        Object[] creditUses = TmcDataServiceHelper.load((String)"cfm_credituse", (String)"sourcebillentryid, currency, realamt", (QFilter[])new QFilter[]{source_qFilter, isrele_qFilter});
        if (EmptyUtil.isNoEmpty((Object[])creditUses)) {
            Object creditUs = creditUses[0];
            Long currency = creditUs.getDynamicObject("currency").getLong("id");
            BigDecimal realamt = creditUs.getBigDecimal("realamt");
            this.getModel().setValue("creditcurrency", (Object)currency);
            this.getModel().setValue("amountofcreditquery", (Object)realamt);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String propertyKey = e.getProperty().getName();
        if (this.skipPropChange) {
            this.skipPropChange = false;
            return;
        }
        ChangeData[] changeData = e.getChangeSet();
        Object newValue = changeData[0].getNewValue();
        Object oldValue = changeData[0].getOldValue();
        int rowIndex = changeData[0].getRowIndex();
        switch (propertyKey) {
            case "bizdate": {
                this.calRoughlyInterest();
                break;
            }
            case "discountdays": {
                this.calRoughlyInterest();
                break;
            }
            case "rate": {
                this.calRoughlyInterest();
                break;
            }
            case "interestday": {
                this.calRoughlyInterest();
                break;
            }
            case "amount": {
                this.calDiscAmt();
                break;
            }
            case "bankcharge": {
                this.calDiscAmt();
                break;
            }
            case "roughlyinterest": {
                this.calDiscAmt();
                break;
            }
            case "openprice": {
                this.calActualPrice(rowIndex);
                break;
            }
            case "preferentialpoints": {
                this.calActualPrice(rowIndex);
                break;
            }
            case "actualprice": {
                this.getModel().setValue("rate", newValue);
                break;
            }
            case "isselect": {
                this.setSingleSelect(rowIndex);
                break;
            }
            case "servicecharge": {
                this.getModel().setValue("bankcharge", this.getModel().getValue("servicecharge", rowIndex));
                break;
            }
            case "adjustdays": {
                this.getModel().setValue("discountdays", this.getModel().getValue("adjustdays", rowIndex));
                break;
            }
            case "billamt": {
                DynamicObject draftbill = (DynamicObject)this.getModel().getValue("draftbill", rowIndex);
                if (EmptyUtil.isEmpty((DynamicObject)draftbill)) {
                    this.getView().showErrorNotification(new CdmBizResource().getTipSelectDraftBillShort());
                    return;
                }
                BigDecimal billAmount = draftbill.getBigDecimal("amount");
                if (EmptyUtil.isNoEmpty((Object)newValue)) {
                    BigDecimal splitAmt = (BigDecimal)newValue;
                    if (STANDARAMOUNT.compareTo(splitAmt) > 0 || billAmount.compareTo(splitAmt) < 0) {
                        this.validateSplitAmount(oldValue, rowIndex, billAmount);
                        return;
                    }
                } else {
                    this.validateSplitAmount(oldValue, rowIndex, billAmount);
                    return;
                }
                DynamicObjectCollection selectEntrys = this.getModel().getEntryEntity("entrys");
                BigDecimal sumAmount = BigDecimal.ZERO;
                for (DynamicObject selectEntry : selectEntrys) {
                    boolean isinvalid = selectEntry.getBoolean("isinvalid");
                    if (isinvalid) continue;
                    BigDecimal billamt = selectEntry.getBigDecimal("billamt");
                    sumAmount = sumAmount.add(billamt);
                }
                this.getModel().setValue("amount", (Object)sumAmount);
                this.calRoughlyInterest();
                this.calDiscAmt();
                BigDecimal billamt = (BigDecimal)this.getModel().getValue("billamt", rowIndex);
                this.getModel().setValue("actualcreditamount", (Object)billamt, rowIndex);
                this.updateCreditAmount();
                break;
            }
            case "currency": 
            case "drafttype": {
                this.getModel().deleteEntryData("entrys");
                this.getModel().setValue("amount", null);
                if (!propertyKey.equals("drafttype")) break;
                DynamicObject draftTypeDy = this.getModel().getDataEntity().getDynamicObject("drafttype");
                if (null != draftTypeDy) {
                    DynamicObject credittype = draftTypeDy.getDynamicObject("credittype");
                    if (null == credittype) break;
                    this.getModel().setValue("credittype", credittype.getPkValue());
                    break;
                }
                this.getModel().setValue("credittype", null);
                break;
            }
            case "creditlimited": {
                if (newValue != null) break;
                this.getModel().setValue("creditcurrency", null);
                this.getModel().setValue("amountofcreditquery", null);
                break;
            }
            case "recbody": {
                this.getModel().setValue("creditlimited", null);
                break;
            }
            case "quoteorganization": {
                Boolean isSelect = (Boolean)this.getModel().getValue("isselect", rowIndex);
                if (!isSelect.booleanValue()) break;
                if (null == newValue) {
                    this.getModel().setValue("recbody", null);
                    break;
                }
                this.getModel().setValue("recbody", (Object)((DynamicObject)newValue).getLong("id"));
                break;
            }
        }
    }

    public void afterAddRow(AfterAddRowEventArgs e) {
        super.afterAddRow(e);
        this.updateCreditAmount();
    }

    public void afterDeleteRow(AfterDeleteRowEventArgs e) {
        super.afterDeleteRow(e);
        this.updateCreditAmount();
    }

    public void afterDeleteEntry(AfterDeleteEntryEventArgs e) {
        super.afterDeleteEntry(e);
        this.updateCreditAmount();
        this.getModel().setValue("roughlyinterest", null);
    }

    private void updateCreditAmount() {
        this.getModel().setValue("creditlimited", null);
    }

    private void validateSplitAmount(Object oldValue, int rowIndex, BigDecimal billAmount) {
        this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u5b50\u7968\u5305\u91d1\u989d\u4fee\u6539\u8303\u56f4\u5728 0.01 ~ %s\u4e4b\u95f4\u3002", (String)"TradeBillTplEdit_29", (String)"tmc-cdm-formplugin", (Object[])new Object[0]), billAmount));
        this.skipPropChange = true;
        this.getModel().setValue("billamt", oldValue, rowIndex);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        DynamicObjectCollection collection;
        super.beforeDoOperation(args);
        AbstractOperate operate = (AbstractOperate)args.getSource();
        String opKey = operate.getOperateKey();
        IDataModel model = this.getModel();
        DynamicObject discountApplyBill = model.getDataEntity(true);
        if ("selectdraft".equals(opKey)) {
            DynamicObject company = discountApplyBill.getDynamicObject("company");
            if (EmptyUtil.isEmpty((DynamicObject)company)) {
                this.getView().showTipNotification(new CdmBizResource().getTipCompany(), Integer.valueOf(2000));
                args.setCancel(true);
                return;
            }
            DynamicObject draftType = discountApplyBill.getDynamicObject("drafttype");
            if (EmptyUtil.isEmpty((DynamicObject)draftType)) {
                this.getView().showTipNotification(new CdmBizResource().getTipDrafttypeShort(), Integer.valueOf(2000));
                args.setCancel(true);
                return;
            }
            DynamicObject currency = discountApplyBill.getDynamicObject("currency");
            if (EmptyUtil.isEmpty((DynamicObject)currency)) {
                this.getView().showTipNotification(new CdmBizResource().getTipCurrCheck(), Integer.valueOf(2000));
                args.setCancel(true);
                return;
            }
        }
        if ("save".equals(opKey) || "submit".equals(opKey)) {
            boolean isSelect = false;
            DynamicObjectCollection dynamicObjects = this.getModel().getEntryEntity("inquiryentrys");
            for (DynamicObject dynamicObject : dynamicObjects) {
                if (!dynamicObject.getBoolean("isselect")) continue;
                isSelect = true;
            }
            if (!isSelect) {
                this.getView().showTipNotification(new CdmBizResource().getTipMustSelectInquiryShort(), Integer.valueOf(2000));
                args.setCancel(true);
                return;
            }
        }
        if ("newinquireentry".equals(opKey) && (EmptyUtil.isEmpty((DynamicObjectCollection)(collection = discountApplyBill.getDynamicObjectCollection("entrys"))) || collection.size() < 1)) {
            this.getView().showTipNotification(new CdmBizResource().getTipSelectDraftBillShort(), Integer.valueOf(2000));
            args.setCancel(true);
            return;
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        String operateKey = afterDoOperationEventArgs.getOperateKey();
        if ("selectdraft".equals(operateKey)) {
            ListShowParameter param = ShowFormHelper.createShowListForm((String)"cdm_draftbillf7", (boolean)true, (int)2, (boolean)true);
            param.setShowTitle(false);
            param.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "selectdraft_action_id"));
            String caption = ResManager.loadKDString((String)"\u6536\u7968\u767b\u8bb0", (String)"TradeBillTplEdit_5", (String)"tmc-cdm-formplugin", (Object[])new Object[0]);
            param.setCaption(caption);
            param.setMultiSelect(true);
            param.getListFilterParameter().setQFilters(this.getDiscountApplyQFilters());
            this.getView().showForm((FormShowParameter)param);
        } else if ("deleteentry".equals(operateKey)) {
            this.sumDraftAmtAndCount();
            this.calRoughlyInterest();
            this.calDiscAmt();
        } else if ("newinquireentry".equals(operateKey)) {
            DynamicObject targetBill = this.getModel().getDataEntity(true);
            DynamicObjectCollection inquiryEntrys = targetBill.getDynamicObjectCollection("inquiryentrys");
            if (!EmptyUtil.isEmpty((DynamicObjectCollection)inquiryEntrys)) {
                DynamicObject currency = targetBill.getDynamicObject("currency");
                if (inquiryEntrys.size() == 1 && !EmptyUtil.isEmpty((DynamicObject)currency)) {
                    this.getModel().setValue("quotecurrency", currency.getPkValue(), 0);
                } else if (inquiryEntrys.size() > 1) {
                    DynamicObject setQuoteCurrency;
                    DynamicObject firstQuoteCurrency = (DynamicObject)this.getModel().getValue("quotecurrency", 0);
                    DynamicObject dynamicObject = setQuoteCurrency = firstQuoteCurrency != null ? firstQuoteCurrency : currency;
                    if (!EmptyUtil.isEmpty((DynamicObject)setQuoteCurrency)) {
                        this.getModel().setValue("quotecurrency", setQuoteCurrency.getPkValue(), inquiryEntrys.size() - 1);
                    }
                }
                this.getModel().setValue("isselect", (Object)true, inquiryEntrys.size() - 1);
            }
        } else if (operateKey.equals("save")) {
            ArrayList draftBillIds = new ArrayList();
            DynamicObjectCollection entrys = this.getModel().getEntryEntity("entrys");
            entrys.stream().filter(p -> !EmptyUtil.isEmpty((DynamicObject)p.getDynamicObject("draftbill"))).forEach(v -> draftBillIds.add(v.getDynamicObject("draftbill").getPkValue()));
            if (!CollectionUtils.isEmpty(draftBillIds)) {
                this.getPageCache().put("selectedDraft", JSON.toJSONString(draftBillIds));
            }
        } else if ("beforeinvalidentry".equals(operateKey)) {
            boolean issubmittrade = (Boolean)this.getModel().getValue("ispushtradebill");
            if (issubmittrade) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u53ea\u80fd\u5bf9\u672a\u8fdb\u884c\u63d0\u4ea4\u4e1a\u52a1\u5904\u7406\u7684\u5355\u636e\u7684\u5206\u5f55\u8fdb\u884c\u64cd\u4f5c\u3002", (String)"DiscountApplyBillEdit_3", (String)"tmc-cdm-formplugin", (Object[])new Object[0]), Integer.valueOf(2000));
                return;
            }
            EntryGrid entryGrid = (EntryGrid)this.getControl("entrys");
            int[] selectRows = entryGrid.getSelectRows();
            if (null == selectRows || selectRows.length == 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u8981\u4f5c\u5e9f\u7684\u5206\u5f55\u3002", (String)"DiscountApplyBillEdit_1", (String)"tmc-cdm-formplugin", (Object[])new Object[0]), Integer.valueOf(2000));
                return;
            }
            DynamicObjectCollection entity = this.getModel().getEntryEntity("entrys");
            boolean hasPayable = false;
            HashSet<Long> draftIdSet = new HashSet<Long>(16);
            for (int selectRow : selectRows) {
                DynamicObject entryData = (DynamicObject)entity.get(selectRow);
                long draftId = entryData.getDynamicObject("draftbill").getLong("id");
                draftIdSet.add(draftId);
                hasPayable = entryData.getBoolean("isinvalid");
                if (hasPayable) break;
            }
            if (hasPayable) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u53ea\u80fd\u5bf9\u672a\u8fdb\u884c\u4f5c\u5e9f\u7684\u5206\u5f55\u64cd\u4f5c\u4f5c\u5e9f", (String)"DiscountApplyBillEdit_2", (String)"tmc-cdm-formplugin", (Object[])new Object[0]));
            } else if (EmptyUtil.isNoEmpty(draftIdSet)) {
                OperateOption operateOption = OperateOption.create();
                operateOption.setVariableValue("invalidDraftId", SerializationUtils.toJsonString(draftIdSet));
                OperationResult operationResult = this.getView().invokeOperation("invaildentry", operateOption);
                if (!operationResult.isSuccess()) {
                    logger.info("edit operationResult.getMessage:" + operationResult.getMessage());
                }
                this.getView().invokeOperation("refresh");
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        Object returnData = closedCallBackEvent.getReturnData();
        IDataModel model = this.getModel();
        if ("selectdraft_action_id".equals(actionId)) {
            ListSelectedRowCollection rows = (ListSelectedRowCollection)returnData;
            if (EmptyUtil.isEmpty((Collection)rows)) {
                return;
            }
            ArrayList<Object> pks = new ArrayList<Object>();
            rows.stream().filter(o -> EmptyUtil.isNoEmpty((Object)o.getPrimaryKeyValue())).forEach(v -> pks.add(v.getPrimaryKeyValue()));
            this.batchFillEntry(pks);
            Integer discountDay = TradeBillWorkcalendarHelper.getDiscountDayScountentryOff((IDataModel)model, (Object)returnData);
            model.setValue("discountdays", (Object)discountDay);
        } else if (StringUtils.equals((CharSequence)"creditlimited", (CharSequence)actionId) && returnData instanceof String) {
            CreditLimitF7ResBean res = (CreditLimitF7ResBean)SerializationUtils.fromJsonString((String)((String)returnData), CreditLimitF7ResBean.class);
            Long creditLimitId = res.getCreditLimitId();
            if (this.getModel().getDataEntity().getBigDecimal("amount").compareTo(res.getRealBizAmt()) != 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5360\u7528\u6388\u4fe1\u989d\u5ea6\u5fc5\u987b\u548c\u7968\u636e\u5408\u8ba1\u91d1\u989d\u76f8\u540c\uff0c\u8bf7\u91cd\u65b0\u5360\u7528\u6388\u4fe1\u3002", (String)"DiscountApplyBillEdit_3_1", (String)"tmc-cdm-formplugin", (Object[])new Object[0]));
                return;
            }
            this.getModel().setValue("creditlimited", (Object)creditLimitId);
            this.getModel().setValue("creditcurrency", (Object)res.getTargetCurrencyId());
            this.getModel().setValue("amountofcreditquery", (Object)res.getExchangeAmt());
        }
    }

    private void batchFillEntry(List<Object> draftIds) {
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        List draftListIds = draftIds.stream().filter(Objects::nonNull).map(o -> Long.valueOf(o.toString())).collect(Collectors.toList());
        DynamicObject[] drafts = TmcDataServiceHelper.load((String)"cdm_draftbillf7", (String)"acceptername,supperbillamount,amount,draftbilltype,currency,company,draftbillstatus", (QFilter[])new QFilter[]{new QFilter("id", "in", draftListIds)});
        model.forceClearNoDataRow();
        TableValueSetter vs = new TableValueSetter(new String[0]);
        vs.addField("draftbill", new Object[0]);
        vs.addField("billamt", new Object[0]);
        vs.addField("actualcreditamount", new Object[0]);
        vs.addField("oldstatus", new Object[0]);
        for (int i = 0; i < drafts.length; ++i) {
            DynamicObject draft = drafts[i];
            if (i == 0) {
                model.setValue("drafttype", draft.getDynamicObject("draftbilltype").getPkValue());
                model.setValue("company", draft.getDynamicObject("company").getPkValue());
                this.getView().setEnable(Boolean.FALSE, new String[]{"company"});
            }
            vs.addRow(new Object[]{draft.getPkValue(), draft.getBigDecimal("amount"), draft.getBigDecimal("amount"), draft.getString("draftbillstatus")});
        }
        model.batchCreateNewEntryRow("entrys", vs);
        this.sumDraftAmtAndCount();
        this.calRoughlyInterest();
        this.calDiscAmt();
        this.updateCreditAmount();
    }

    private void sumDraftAmtAndCount() {
        DynamicObject targetBill = this.getModel().getDataEntity(true);
        DynamicObjectCollection entryList = targetBill.getDynamicObjectCollection("entrys");
        BigDecimal totalAmount = entryList.stream().filter(Objects::nonNull).filter(o -> !EmptyUtil.isEmpty((BigDecimal)o.getBigDecimal("billamt")) && !o.getBoolean("isinvalid")).map(o -> o.getBigDecimal("billamt")).reduce(BigDecimal.ZERO, BigDecimal::add);
        int count = entryList.stream().filter(v -> !EmptyUtil.isEmpty((DynamicObject)v.getDynamicObject("draftbill"))).toArray().length;
        if (0 == count) {
            this.getView().setEnable(Boolean.TRUE, new String[]{"company"});
        }
        this.getModel().setValue("amount", (Object)totalAmount);
        this.getModel().setValue("draftcount", (Object)count);
    }

    private List<QFilter> getDiscountApplyQFilters() {
        DynamicObject currency;
        DynamicObject draftType;
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>(10);
        IDataModel model = this.getModel();
        DynamicObject discountApplyBill = model.getDataEntity(true);
        DynamicObject company = discountApplyBill.getDynamicObject("company");
        if (EmptyUtil.isNoEmpty((DynamicObject)company)) {
            qFilters.add(new QFilter("company", "in", company.getPkValue()));
        }
        if (EmptyUtil.isNoEmpty((DynamicObject)(draftType = discountApplyBill.getDynamicObject("drafttype")))) {
            qFilters.add(new QFilter("draftbilltype", "in", draftType.getPkValue()));
        }
        if (EmptyUtil.isNoEmpty((DynamicObject)(currency = discountApplyBill.getDynamicObject("currency")))) {
            qFilters.add(new QFilter("currency", "=", currency.getPkValue()));
        }
        qFilters.add(new QFilter("billpool", "is null", null).or(new QFilter("billpool", "=", (Object)0)));
        ArrayList selectedDaftIds = new ArrayList();
        DynamicObjectCollection selectDraftEntrys = model.getEntryEntity("entrys");
        if (EmptyUtil.isNoEmpty((DynamicObjectCollection)selectDraftEntrys)) {
            selectDraftEntrys.stream().filter(v -> !EmptyUtil.isEmpty((DynamicObject)v.getDynamicObject("draftbill"))).forEach(v -> selectedDaftIds.add(v.getDynamicObject("draftbill").getPkValue()));
        }
        if (selectedDaftIds.size() > 0) {
            qFilters.add(new QFilter("id", "not in", selectedDaftIds));
        }
        qFilters.add(new QFilter("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue()));
        List draftIds = (List)JSON.parseObject((String)this.getPageCache().get("selectedDraft"), List.class);
        ArrayList targetIds = new ArrayList();
        draftIds.stream().filter(v -> !selectedDaftIds.contains(v)).forEach(o -> targetIds.add(o));
        qFilters.add(new QFilter("availableamount", ">", (Object)0));
        qFilters.add(new QFilter("rptype", "=", (Object)"receivebill"));
        qFilters.add(new QFilter("draftbillstatus", "in", (Object)new String[]{"registered", "collocated"}));
        qFilters.add(new QFilter("draftbilltranstatus", "=", (Object)DraftTranStatusEnum.SUCCESS.getValue()));
        return qFilters;
    }

    public void entryRowClick(RowClickEvent evt) {
        super.entryRowClick(evt);
        EntryGrid entryGrid = (EntryGrid)evt.getSource();
        String entryKey = entryGrid.getKey();
        int currentRow = evt.getRow();
        if (currentRow < 0) {
            return;
        }
        if ("inquiryentrys".equals(entryKey)) {
            DynamicObject selectedRow = entryGrid.getEntryData().getDataEntitys()[currentRow];
            DynamicObject quoteOrganization = selectedRow.getDynamicObject("quoteorganization");
            if (!EmptyUtil.isEmpty((DynamicObject)quoteOrganization)) {
                this.getModel().setValue("recbody", quoteOrganization.getPkValue());
            } else {
                this.getModel().setValue("recbody", null);
            }
            this.getModel().setValue("interestday", selectedRow.get("quoteinterestday"));
            this.getModel().setValue("discountdays", selectedRow.get("adjustdays"));
            this.getModel().setValue("rate", selectedRow.get("actualprice"));
            this.getModel().setValue("bankcharge", selectedRow.get("servicecharge"));
            this.getModel().setValue("isselect", (Object)true, currentRow);
        }
    }

    private void calRoughlyInterest() {
        BigDecimal roughlyInterest = DraftHelper.calRoughlyInterest((DynamicObject)this.getModel().getDataEntity(true));
        this.getModel().setValue("roughlyinterest", (Object)roughlyInterest);
    }

    private void calDiscAmt() {
        this.getModel().setValue("discamt", (Object)DraftHelper.calDiscAmt((DynamicObject)this.getModel().getDataEntity(true)));
    }

    private void calActualPrice(int rowIndex) {
        this.getModel().setValue("actualprice", (Object)this.calActualPrice(this.getModel().getDataEntity(true), rowIndex), rowIndex);
    }

    private void setSingleSelect(int rowIndex) {
        boolean isSelect = (Boolean)this.getModel().getValue("isselect", rowIndex);
        if (isSelect) {
            DynamicObjectCollection dynamicObjects = this.getModel().getEntryEntity("inquiryentrys");
            for (int i = 0; i < dynamicObjects.size(); ++i) {
                if (i != rowIndex) {
                    this.getModel().setValue("isselect", (Object)false, i);
                    continue;
                }
                DynamicObject quoteOrganization = ((DynamicObject)dynamicObjects.get(i)).getDynamicObject("quoteorganization");
                if (null == quoteOrganization) continue;
                this.getModel().setValue("recbody", (Object)quoteOrganization.getLong("id"));
            }
        }
    }

    public BigDecimal calActualPrice(DynamicObject targetBill, int rowIndex) {
        DynamicObjectCollection inquiryentrys = targetBill.getDynamicObjectCollection("inquiryentrys");
        DynamicObject inquiryentry = (DynamicObject)inquiryentrys.get(rowIndex);
        BigDecimal openPrice = BigDecimal.ZERO;
        BigDecimal preferentialPoints = BigDecimal.ZERO;
        if (!EmptyUtil.isEmpty((DynamicObject)inquiryentry)) {
            openPrice = inquiryentry.getBigDecimal("openprice");
            preferentialPoints = inquiryentry.getBigDecimal("preferentialpoints");
            if (null == openPrice || null == preferentialPoints) {
                return null;
            }
        }
        return openPrice.subtract(preferentialPoints.divide(new BigDecimal(100)));
    }

    private void creditlimitClick() {
        BasedataEdit creditLimitEdit = (BasedataEdit)this.getControl("creditlimited");
        if (EmptyUtil.isNoEmpty((Object)creditLimitEdit)) {
            creditLimitEdit.addBeforeF7SelectListener(evt -> {
                String message = this.creditLimitValidator();
                if (EmptyUtil.isNoEmpty((String)message)) {
                    this.getView().showErrorNotification(message);
                    evt.setCancel(true);
                    return;
                }
                CreditLimitUseBean useBean = new CreditLimitUseBean();
                Long id = (Long)this.getModel().getValue("id");
                if (id == null || id.equals(0L)) {
                    id = DB.genLongId((String)this.getModel().getDataEntityType().getAlias());
                    this.getModel().setValue("id", (Object)id);
                }
                useBean.setPkId(id);
                useBean.setBillNo((String)this.getModel().getValue("billno"));
                useBean.setEntityName("cdm_discount_apply");
                useBean.setOrgId((Long)((DynamicObject)this.getModel().getValue("company")).getPkValue());
                DynamicObject draweraccountDO = this.getModel().getDataEntity().getDynamicObject("recbody");
                useBean.setFinOrgId((Long)draweraccountDO.getPkValue());
                useBean.setCurrencyId((Long)((DynamicObject)this.getModel().getValue("currency")).getPkValue());
                DynamicObject draftbilltype = this.getModel().getDataEntity().getDynamicObject("drafttype");
                if (EmptyUtil.isNoEmpty((DynamicObject)draftbilltype)) {
                    DynamicObject cresditTypeDy = this.getModel().getDataEntity().getDynamicObject("credittype");
                    useBean.setCreditTypeId((Long)cresditTypeDy.getPkValue());
                }
                useBean.setCreditVariety(draftbilltype.getString("name"));
                useBean.setBizAmt((BigDecimal)this.getModel().getValue("amount"));
                useBean.setMaxAmt((BigDecimal)this.getModel().getValue("amount"));
                useBean.setStartDate((Date)this.getModel().getValue("bizdate"));
                DynamicObjectCollection entrys = this.getModel().getEntryEntity("entrys");
                DynamicObject maxDateDy = entrys.stream().filter(e -> !e.getBoolean("isinvalid")).max(Comparator.comparing(e -> e.getDynamicObject("draftbill").getDate("draftbillexpiredate"))).get();
                useBean.setEndDate(maxDateDy.getDynamicObject("draftbill").getDate("draftbillexpiredate"));
                FormShowParameter sp = evt.getFormShowParameter();
                sp.setCustomParam("KEY_F7PARAM", (Object)useBean);
                sp.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "creditlimited"));
            });
        }
    }

    private String creditLimitValidator() {
        StringBuilder message = new StringBuilder();
        if (EmptyUtil.isEmpty((Object)this.getModel().getValue("amount")) || ((BigDecimal)this.getModel().getValue("amount")).compareTo(BigDecimal.ZERO) == 0) {
            message.append(new CdmBizResource().getCreditAmountChecknull());
            return message.toString();
        }
        if (this.getModel().getValue("currency") == null) {
            message.append(new CdmBizResource().getPbCurrencyChecknull());
            return message.toString();
        }
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entrys");
        if (entryEntity == null || entryEntity.size() == 0) {
            message.append(new CdmBizResource().getPbDraftChecknull());
            return message.toString();
        }
        if (EmptyUtil.isEmpty((Object)this.getModel().getValue("recbody"))) {
            message.append(new CdmBizResource().getTbDiscountBodyChecknull());
            return message.toString();
        }
        return message.toString();
    }

    public void beforeClick(BeforeClickEvent evt) {
        String key;
        super.click((EventObject)evt);
        Control c = (Control)evt.getSource();
        switch (key = c.getKey().toLowerCase()) {
            case "creditlimited": {
                DynamicObject dataEntity = this.getModel().getDataEntity();
                DynamicObject recbody = dataEntity.getDynamicObject("recbody");
                BigDecimal amount = dataEntity.getBigDecimal("amount");
                if (EmptyUtil.isEmpty((DynamicObject)recbody)) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6388\u4fe1\u5360\u7528\u9700\u8981\u660e\u786e\u4f7f\u7528\u8d34\u73b0\u673a\u6784\u7684\u6388\u4fe1\u989d\u5ea6\uff0c\u8bf7\u5148\u9009\u62e9\u8d34\u73b0\u673a\u6784", (String)"DiscountApplyBillEdit_37", (String)"tmc-cdm-formplugin", (Object[])new Object[0]));
                    evt.setCancel(true);
                }
                if (BigDecimal.ZERO.compareTo(amount) < 0) break;
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8d34\u73b0\u7684\u7968\u636e", (String)"TradeBillTplEdit_32_2", (String)"tmc-cdm-formplugin", (Object[])new Object[0]));
                evt.setCancel(true);
            }
        }
    }
}

