/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cdm.formplugin.receivablebill;

import com.alibaba.fastjson.JSONArray;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.filter.CommonFilterColumn;
import kd.bos.filter.FilterColumn;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.FilterContainerSearchClickArgs;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.events.BeforeFilterF7SelectEvent;
import kd.bos.list.BillList;
import kd.bos.list.ListShowParameter;
import kd.bos.mvc.list.ListDataProvider;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.cdm.common.enums.DraftBillStatusEnum;
import kd.tmc.cdm.common.helper.CasHelper;
import kd.tmc.fbp.common.helper.TmcOrgDataHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.formplugin.list.AbstractTmcBillBaseList;

public class BillDetailList
extends AbstractTmcBillBaseList {
    String rpType = null;
    private FilterContainerInitArgs initArgs;
    private static final String SURETYREMAINAMOUNT = "suretyremainamount";
    private static final String AMOUNTOFCREDIT = "amountofcredit";

    public void filterContainerInit(FilterContainerInitArgs args) {
        ListShowParameter listShowParameter;
        Map filterMap;
        super.filterContainerInit(args);
        this.initArgs = args;
        if (this.getPageCache().get("init") == null) {
            this.getPageCache().put("init", "true");
            this.initFilterContainer(args);
        }
        if (!ObjectUtils.isEmpty((Object)(filterMap = (Map)(listShowParameter = (ListShowParameter)this.getView().getFormShowParameter()).getCustomParam("filterMap")))) {
            for (FilterColumn filterColumn : args.getCommonFilterColumns()) {
                if ("company.name".equals(filterColumn.getFieldName())) {
                    JSONArray company = (JSONArray)filterMap.get("company");
                    filterColumn.setDefaultValue(company.get(0).toString());
                }
                if ("rptype".equals(filterColumn.getFieldName())) {
                    filterColumn.setDefaultValues(new Object[]{filterMap.get("rptype")});
                }
                if (!"bizdate".equals(filterColumn.getFieldName())) continue;
                JSONArray bizDateJson = (JSONArray)filterMap.get("bizdate");
                filterColumn.setDefaultValues(new Object[]{""});
            }
        }
    }

    public void filterContainerSearchClick(FilterContainerSearchClickArgs args) {
        super.filterContainerSearchClick(args);
        Map filterValue = args.getFilterValues();
        List customFilterList = (List)filterValue.get("customfilter");
        if (EmptyUtil.isEmpty((Collection)customFilterList)) {
            return;
        }
        if (EmptyUtil.isNoEmpty((Object)customFilterList)) {
            for (Map map : customFilterList) {
                String value;
                String fieldName = ((List)map.get("FieldName")).size() > 0 ? ((List)map.get("FieldName")).get(0).toString() : "";
                String string = value = ((List)map.get("Value")).size() > 0 ? ((List)map.get("Value")).get(0).toString() : "";
                if (!fieldName.startsWith("rptype") || StringUtils.equals((CharSequence)this.rpType, (CharSequence)value)) continue;
                this.rpType = value;
                this.getPageCache().put("rpType", this.rpType);
                this.initFilterContainer(this.initArgs);
            }
        }
    }

    public void setFilter(SetFilterEvent e) {
        super.setFilter(e);
        this.addOrgIsolateFilter(e);
    }

    private void addOrgIsolateFilter(SetFilterEvent e) {
        QFilter mainOrgQFilter = e.getMainOrgQFilter();
        List orgIds = null;
        orgIds = Objects.nonNull(mainOrgQFilter) ? (ArrayList)e.getMainOrgQFilter().getValue() : TmcOrgDataHelper.getAuthorizedBankOrgId((Long)RequestContext.get().getCurrUserId(), (String)this.getView().getFormShowParameter().getAppId(), (String)((BillList)e.getSource()).getBillFormId(), (String)"47150e89000000ac");
        e.getQFilters().add(new QFilter("company", "in", (Object)orgIds));
    }

    public void filterColumnSetFilter(SetFilterEvent args) {
        super.filterColumnSetFilter(args);
        CommonFilterColumn filterCol = (CommonFilterColumn)args.getSource();
        if (StringUtils.startsWith((CharSequence)filterCol.getFieldName(), (CharSequence)"company.")) {
            args.getQFilters().addAll(Arrays.asList(this.getCompanyFilter()));
        }
    }

    public void filterContainerBeforeF7Select(BeforeFilterF7SelectEvent args) {
        super.filterContainerBeforeF7Select(args);
        String fieldName = args.getFieldName();
        if (StringUtils.startsWith((CharSequence)fieldName, (CharSequence)"company.")) {
            args.getQfilters().addAll(Arrays.asList(this.getCompanyFilter()));
        }
    }

    private QFilter[] getCompanyFilter() {
        String appId = this.getView().getFormShowParameter().getAppId();
        Long userId = Long.valueOf(RequestContext.get().getUserId());
        List authOrgIds = TmcOrgDataHelper.getAuthorizedBankOrgId((Long)userId, (String)appId, (String)this.getDataEntityName(), (String)"47150e89000000ac");
        QFilter companyOrgFilter = new QFilter("id", "in", (Object)authOrgIds);
        return new QFilter[]{companyOrgFilter};
    }

    private void initFilterContainer(FilterContainerInitArgs args) {
        for (FilterColumn filterColumn : args.getFilterContainerInitEvent().getCommonFilterColumns()) {
            CommonFilterColumn commonFilterColumn = (CommonFilterColumn)filterColumn;
            String fieldName = commonFilterColumn.getFieldName();
            if ("draftbillstatus".equals(fieldName)) {
                if ("paybill".equals(this.rpType)) {
                    commonFilterColumn.setComboItems(this.buildPayBillTicketStatusComboItems());
                } else {
                    commonFilterColumn.setComboItems(this.buildRecBillTicketStatusComboItems());
                }
            }
            if (!fieldName.startsWith("company") || this.rpType != null) continue;
            commonFilterColumn.setDefaultValue("");
        }
    }

    private List<ComboItem> buildPayBillTicketStatusComboItems() {
        List<String> ticketStatus = Arrays.asList(DraftBillStatusEnum.REGISTERED.getValue(), DraftBillStatusEnum.PAYOFFED.getValue());
        return ticketStatus.stream().map(o -> {
            ComboItem item = new ComboItem();
            item.setCaption(new LocaleString(DraftBillStatusEnum.getName((String)o)));
            item.setValue(o);
            return item;
        }).collect(Collectors.toList());
    }

    private List<ComboItem> buildRecBillTicketStatusComboItems() {
        List<String> ticketStatus = Arrays.asList(DraftBillStatusEnum.REGISTERED.getValue(), DraftBillStatusEnum.ENDORSED.getValue(), DraftBillStatusEnum.DISCOUNTED.getValue(), DraftBillStatusEnum.COLLECTED.getValue(), DraftBillStatusEnum.PLEDGED.getValue(), DraftBillStatusEnum.COLLOCATED.getValue());
        return ticketStatus.stream().map(o -> {
            ComboItem item = new ComboItem();
            item.setCaption(new LocaleString(DraftBillStatusEnum.getName((String)o)));
            item.setValue(o);
            return item;
        }).collect(Collectors.toList());
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        super.billListHyperLinkClick(args);
        String fieldName = args.getHyperLinkClickEvent().getFieldName();
        if ("claimnoticebillno".equals(fieldName)) {
            args.setCancel(true);
            BillList list = (BillList)this.getControl("billlistap");
            Object focusRowPkId = list.getFocusRowPkId();
            DynamicObject recving = BusinessDataServiceHelper.loadSingle((Object)focusRowPkId, (String)"cdm_receivablebill", (String)"id,claimnoticebillno");
            String recBillNo = recving.getString("claimnoticebillno");
            if (!StringUtils.isEmpty((CharSequence)recBillNo)) {
                QFilter filter = new QFilter("billno", "=", (Object)recBillNo);
                DynamicObject recbillDo = BusinessDataServiceHelper.loadSingle((String)"cas_claimcenterbill", (String)"id,billstatus", (QFilter[])new QFilter[]{filter});
                if (!CasHelper.isEmpty((Object)recbillDo)) {
                    BillShowParameter showParameter = new BillShowParameter();
                    showParameter.setStatus(OperationStatus.VIEW);
                    showParameter.setFormId("cas_claimcenterbill");
                    showParameter.setPkId(recbillDo.getPkValue());
                    showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                    this.getView().showForm((FormShowParameter)showParameter);
                }
            }
        }
    }

    public void beforeCreateListDataProvider(BeforeCreateListDataProviderArgs args) {
        super.beforeCreateListDataProvider(args);
        args.setListDataProvider((IListDataProvider)new GetListDataProvider());
    }

    static class GetListDataProvider
    extends ListDataProvider {
        GetListDataProvider() {
        }

        public DynamicObjectCollection getData(int arg0, int arg1) {
            String rptype;
            DynamicObjectCollection rows = super.getData(arg0, arg1);
            if (rows.isEmpty()) {
                return rows;
            }
            ArrayList ids = new ArrayList(rows.size());
            boolean isContainSurety = false;
            boolean isContainCredit = false;
            if (((DynamicObject)rows.get(0)).getDataEntityType().getProperties().containsKey((Object)"rptype") && "paybill".equals(rptype = ((DynamicObject)rows.get(0)).getString("rptype"))) {
                if (((DynamicObject)rows.get(0)).getDataEntityType().getProperties().containsKey((Object)BillDetailList.SURETYREMAINAMOUNT)) {
                    isContainSurety = true;
                }
                if (((DynamicObject)rows.get(0)).getDataEntityType().getProperties().containsKey((Object)BillDetailList.AMOUNTOFCREDIT)) {
                    isContainCredit = true;
                }
            }
            rows.forEach(row -> ids.add(row.getLong("id")));
            if (ids.size() == 0) {
                return rows;
            }
            Map<Object, Object> draftIdAndCreditMap = new HashMap(8);
            Map<Object, Object> draftIdAndSuretyMap = new HashMap(8);
            if (isContainCredit || isContainSurety) {
                DynamicObjectCollection suretybills;
                Set hasSuretyPayDraftIdSet;
                QFilter isrele_qFilter;
                QFilter source_qFilter;
                DynamicObjectCollection creditUses;
                Set hasCreditPayDraftIdSet;
                DynamicObjectCollection payDraftList = QueryServiceHelper.query((String)"cdm_payablebill", (String)"id,creditlimit,paybilltype", (QFilter[])new QFilter[]{new QFilter("id", "in", ids), new QFilter("rptype", "=", (Object)"paybill")});
                if (isContainCredit && EmptyUtil.isNoEmpty(hasCreditPayDraftIdSet = payDraftList.stream().filter(e -> EmptyUtil.isNoEmpty((Long)e.getLong("creditlimit"))).map(x -> x.getLong("id")).collect(Collectors.toSet())) && EmptyUtil.isNoEmpty((DynamicObjectCollection)(creditUses = QueryServiceHelper.query((String)"cfm_credituse", (String)"sourcebillentryid,sourcebillid, realamt", (QFilter[])new QFilter[]{source_qFilter = new QFilter("sourcebillid", "in", hasCreditPayDraftIdSet), isrele_qFilter = new QFilter("isrelease", "=", (Object)"0")})))) {
                    draftIdAndCreditMap = creditUses.stream().collect(Collectors.groupingBy(e -> e.getLong("sourcebillid")));
                }
                if (isContainSurety && EmptyUtil.isNoEmpty(hasSuretyPayDraftIdSet = payDraftList.stream().filter(e -> EmptyUtil.isNoEmpty((String)e.getString("paybilltype")) && e.getString("paybilltype").contains("guarantee")).map(x -> x.getLong("id")).collect(Collectors.toSet())) && EmptyUtil.isNoEmpty((DynamicObjectCollection)(suretybills = QueryServiceHelper.query((String)"fbd_suretybill", (String)"entry.debtbillid,surplusamount,id", (QFilter[])new QFilter[]{source_qFilter = new QFilter("entry.debtbillid", "in", hasSuretyPayDraftIdSet)})))) {
                    draftIdAndSuretyMap = suretybills.stream().collect(Collectors.groupingBy(e -> e.getLong("entry.debtbillid")));
                }
            }
            for (DynamicObject row2 : rows) {
                List suretyDyList;
                long draftBillId;
                List creditDyList;
                if (isContainCredit && EmptyUtil.isNoEmpty(draftIdAndCreditMap) && draftIdAndCreditMap.size() > 0 && EmptyUtil.isNoEmpty((Object)(creditDyList = (List)draftIdAndCreditMap.get(draftBillId = row2.getLong("id"))))) {
                    DynamicObject creditDy = (DynamicObject)creditDyList.get(0);
                    BigDecimal realamt = creditDy.getBigDecimal("realamt");
                    row2.set(BillDetailList.AMOUNTOFCREDIT, (Object)realamt);
                }
                if (!isContainSurety || !EmptyUtil.isNoEmpty(draftIdAndSuretyMap) || draftIdAndSuretyMap.size() <= 0 || !EmptyUtil.isNoEmpty((Object)(suretyDyList = (List)draftIdAndSuretyMap.get(draftBillId = row2.getLong("id"))))) continue;
                DynamicObject suretyDy = (DynamicObject)suretyDyList.get(0);
                BigDecimal surplusamount = suretyDy.getBigDecimal("surplusamount");
                row2.set(BillDetailList.SURETYREMAINAMOUNT, (Object)surplusamount);
            }
            return rows;
        }
    }
}

