/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cdm.formplugin.receivablebill;

import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.DataEntitySerializer;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.cache.IAppCache;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.MessageTypes;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.list.ListView;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.parameter.SystemParamServiceHelper;
import kd.tmc.cdm.business.helper.RecBillAutoClaimNoticeHelper;
import kd.tmc.cdm.business.service.LockDraftHelper;
import kd.tmc.cdm.common.enums.ClaimAuthorityEnum;
import kd.tmc.cdm.common.enums.ClaimStatusEnum;
import kd.tmc.cdm.common.enums.DraftBillStatusEnum;
import kd.tmc.cdm.common.enums.RecTypeEnum;
import kd.tmc.cdm.common.helper.CasHelper;
import kd.tmc.cdm.common.helper.DraftHelper;
import kd.tmc.cdm.common.helper.PermissionHelper;
import kd.tmc.cdm.common.helper.RecClaimBillHelper;
import kd.tmc.cdm.common.helper.RecClaimHelper;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.helper.TmcAppCache;
import kd.tmc.fbp.common.helper.TmcOperateServiceHelper;
import kd.tmc.fbp.common.helper.TmcParameterHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.formplugin.list.AbstractTmcBillBaseList;

public class RecClaimBillList
extends AbstractTmcBillBaseList {
    private static final Log logger = LogFactory.getLog(RecClaimBillList.class);
    private static IAppCache cache = TmcAppCache.get((String)"cas", (String)"intelrec", (String)"claim");
    private static final String SYSTEMTYPE = "tmc-cdm-formplugin";

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String operateKey = evt.getItemKey();
        BillList list = (BillList)this.getControl("billlistap");
        ListSelectedRowCollection selectedRows = list.getSelectedRows();
        Object[] selectids = selectedRows.getPrimaryKeyValues();
        if (EmptyUtil.isEmpty((Object[])selectids)) {
            return;
        }
        switch (operateKey) {
            case "noticeclaim": {
                List recTypeDraftBillNos;
                List noticeSelectIds = selectedRows.stream().map(o -> Long.parseLong(o.getPrimaryKeyValue().toString())).collect(Collectors.toList());
                QFilter noticeRecFilter = new QFilter("id", "in", noticeSelectIds);
                Object[] noticeRecBills = BusinessDataServiceHelper.load((String)"cdm_receivablebill", (String)"id,claimnoticebillno,draftbillno,rectype,company,draftbillstatus", (QFilter[])new QFilter[]{noticeRecFilter});
                if (EmptyUtil.isNoEmpty((Object[])noticeRecBills) && (recTypeDraftBillNos = Arrays.stream(noticeRecBills).filter(o -> StringUtils.isNotEmpty((CharSequence)o.getString("rectype"))).map(e -> e.getString("draftbillno")).collect(Collectors.toList())).size() > 0) {
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"%s\u5df2\u5173\u8054\u6536\u6b3e\uff0c\u4e0d\u80fd\u64cd\u4f5c\u901a\u77e5\u8ba4\u9886", (String)"RecClaimBillList_114", (String)SYSTEMTYPE, (Object[])new Object[0]), String.join((CharSequence)";", recTypeDraftBillNos)));
                }
                this.noticeClaim(selectids);
                break;
            }
            case "cancelnotice": {
                this.cancelNotice(selectids);
                break;
            }
            case "handgenbill": {
                List selectIds = selectedRows.stream().map(o -> Long.parseLong(o.getPrimaryKeyValue().toString())).collect(Collectors.toList());
                QFilter recFilter = new QFilter("id", "in", selectIds);
                Object[] recBills = BusinessDataServiceHelper.load((String)"cdm_receivablebill", (String)"id,claimnoticebillno,draftbillno,rectype,company,draftbillstatus", (QFilter[])new QFilter[]{recFilter});
                if (EmptyUtil.isNoEmpty((Object[])recBills)) {
                    List draftBillNos = Arrays.stream(recBills).filter(o -> StringUtils.isNotEmpty((CharSequence)o.getString("claimnoticebillno"))).map(e -> e.getString("draftbillno")).collect(Collectors.toList());
                    if (draftBillNos.size() > 0) {
                        throw new KDBizException(String.format(ResManager.loadKDString((String)"%s\u5df2\u53d1\u8d77\u8fc7\u6536\u6b3e\u8ba4\u9886\u901a\u77e5\uff0c\u4e0d\u80fd\u64cd\u4f5c\u5355\u636e\u8f6c\u6362\u751f\u5355", (String)"RecClaimBillList_111", (String)SYSTEMTYPE, (Object[])new Object[0]), String.join((CharSequence)";", draftBillNos)));
                    }
                    List recTypeDraftBillNos = Arrays.stream(recBills).filter(o -> StringUtils.isNotEmpty((CharSequence)o.getString("rectype"))).map(e -> e.getString("draftbillno")).collect(Collectors.toList());
                    if (recTypeDraftBillNos.size() > 0) {
                        throw new KDBizException(String.format(ResManager.loadKDString((String)"%s\u5df2\u5173\u8054\u6536\u6b3e\uff0c\u4e0d\u80fd\u64cd\u4f5c\u5355\u636e\u8f6c\u6362\u751f\u5355", (String)"RecClaimBillList_112", (String)SYSTEMTYPE, (Object[])new Object[0]), String.join((CharSequence)";", recTypeDraftBillNos)));
                    }
                    Map<Long, List<DynamicObject>> companyMaps = Arrays.stream(recBills).collect(Collectors.groupingBy(o -> o.getDynamicObject("company").getLong("id")));
                    String appId = AppMetadataCache.getAppInfo((String)"cdm").getId();
                    for (Map.Entry<Long, List<DynamicObject>> longListEntry : companyMaps.entrySet()) {
                        List<DynamicObject> recBillGroup = longListEntry.getValue();
                        long companyId = longListEntry.getKey();
                        String noticeClaimAllowStatus = (String)TmcParameterHelper.getAppParameter((String)appId, (Long)companyId, (String)"noticeclaimallowstatus");
                        List allowStatusDraftBillNos = recBillGroup.stream().filter(o -> !noticeClaimAllowStatus.contains(o.getString("draftbillstatus"))).map(e -> e.getString("draftbillno")).collect(Collectors.toList());
                        if (allowStatusDraftBillNos.size() <= 0) continue;
                        throw new KDBizException(String.format(ResManager.loadKDString((String)"%s\u7968\u636e\u72b6\u6001\u4e0d\u652f\u6301\u5355\u636e\u8f6c\u6362\u751f\u5355", (String)"RecClaimBillList_113", (String)SYSTEMTYPE, (Object[])new Object[0]), String.join((CharSequence)";", allowStatusDraftBillNos)));
                    }
                }
                this.showRecInfo(selectids);
                break;
            }
        }
    }

    private void showRecInfo(Object[] selectids) {
        List selectIdList = Arrays.stream(selectids).collect(Collectors.toList());
        this.getPageCache().put("genSelectIds", SerializationUtils.toJsonString(selectIdList));
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("cdm_recinfo");
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "cdm_recinfo"));
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        this.getView().showForm(showParameter);
    }

    private void checkOpPerm(String operKey, String operKeyName, DynamicObject[] receivablebills) {
        if (CasHelper.isEmpty((DynamicObject[])receivablebills)) {
            return;
        }
        Map operateMetaMap = EntityMetadataCache.getDataEntityOperate((String)"cdm_receivablebill", (String)operKey);
        Object permission = operateMetaMap.get("permission");
        boolean hasPerm = true;
        HashSet<Long> orgIds = new HashSet<Long>(receivablebills.length);
        for (DynamicObject receivablebill : receivablebills) {
            orgIds.add(receivablebill.getDynamicObject("company").getLong("id"));
        }
        logger.info("checkOpPerm is start :" + SerializationUtils.toJsonString(orgIds));
        for (Long org : orgIds) {
            hasPerm = PermissionHelper.checkCurrentUserPermission((long)org, (String)"cdm_receivablebill", (String)(permission + ""));
            if (hasPerm) continue;
        }
        if (!hasPerm) {
            logger.info(String.format(ResManager.loadKDString((String)"\u5f53\u524d\u7528\u6237\u6ca1\u6709%s\u7684\u6743\u9650\uff01", (String)"RecWorkbenchPlugin_5", (String)SYSTEMTYPE, (Object[])new Object[0]), operKeyName));
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5f53\u524d\u7528\u6237\u6ca1\u6709%s\u7684\u6743\u9650\uff01", (String)"RecWorkbenchPlugin_5", (String)SYSTEMTYPE, (Object[])new Object[0]), operKeyName));
        }
    }

    private void cancelNotice(Object[] selectids) {
        Throwable qFilter;
        DynamicObject[] recvingBills = this.getSelectRow(selectids);
        this.checkOpPerm("cancelnotice", ResManager.loadKDString((String)"\u53d6\u6d88\u901a\u77e5\u8ba4\u9886", (String)"RecClaimBillList_8", (String)SYSTEMTYPE, (Object[])new Object[0]), recvingBills);
        OperationResult result = new OperationResult();
        result.setBillCount(recvingBills.length);
        HashSet<String> noticeNos = new HashSet<String>(16);
        HashMap billNoMap = new HashMap();
        for (DynamicObject recvingBill : recvingBills) {
            String claimBillno = recvingBill.getString("claimnoticebillno");
            String recvingBillString = recvingBill.getString("billno");
            if (CasHelper.isNotEmpty((Object)claimBillno)) {
                String billno = recvingBill.getString("claimnoticebillno");
                noticeNos.add(billno);
                if (billNoMap.containsKey(billno)) {
                    ((Set)billNoMap.get(billno)).add(recvingBillString);
                    continue;
                }
                HashSet<String> billnoSet = new HashSet<String>(16);
                billnoSet.add(recvingBillString);
                billNoMap.put(billno, billnoSet);
                continue;
            }
            result.addErrorInfo(CasHelper.getOperateErrorInfo((Object)recvingBill.getPkValue(), (String)String.format(ResManager.loadKDString((String)"\u53ea\u6709\u5df2\u53d1\u8d77\u6536\u6b3e\u8ba4\u9886\u901a\u77e5\uff0c\u4e14\u5904\u4e8e\u201c\u5f85\u8ba4\u9886\u201d\u72b6\u6001\u7684\uff0c\u624d\u80fd\u53d6\u6d88\u901a\u77e5\u8ba4\u9886\uff01\u5e94\u6536\u7968\u636e\uff08\u5355\u636e\u7f16\u53f7\uff1a%s\uff09\u53d6\u6d88\u901a\u77e5\u8ba4\u9886\u5931\u8d25", (String)"RecClaimBillList_37", (String)SYSTEMTYPE, (Object[])new Object[0]), recvingBill.getString("billno")), (String)ResManager.loadKDString((String)"\u53d6\u6d88\u901a\u77e5\u8ba4\u9886", (String)"RecClaimBillList_8", (String)SYSTEMTYPE, (Object[])new Object[0])));
        }
        HashSet<Object> claimIds = new HashSet<Object>(noticeNos.size());
        HashSet<Long> cancelSuccessIds = new HashSet<Long>(noticeNos.size());
        HashSet<Object> detailIds = new HashSet<Object>(noticeNos.size());
        HashSet<Object> eleSignIds = new HashSet<Object>(noticeNos.size());
        HashMap claimType = new HashMap(claimIds.size());
        HashMap<String, List<Object>> typeValue = null;
        ArrayList<String> noticeMes = null;
        DynamicObjectCollection dycoll = null;
        StringBuilder message = new StringBuilder();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-M-dd");
        if (noticeNos.size() > 0) {
            DynamicObject[] noticeBills;
            for (DynamicObject noticeBill : noticeBills = BusinessDataServiceHelper.load((String)"cas_claimcenterbill", (String)"id,billno,claimstatus,sourceid,sourcetype,currency,mergestatus,isunclaim,reamount,oppunit,description,tradetime,tradedetailno,claimnoticebillno,receredtype,entryentity1.claimtype,entryentity1.claimtypeid", (QFilter[])new QFilter[]{new QFilter("billno", "in", noticeNos)})) {
                String mergestatus = noticeBill.getString("mergestatus");
                if (!"0".equals(mergestatus)) {
                    Set recBillNos2 = (Set)billNoMap.get(noticeBill.getString("billno"));
                    for (String string : recBillNos2) {
                        result.addErrorInfo(CasHelper.getOperateErrorInfo((Object)noticeBill.getPkValue(), (String)String.format(ResManager.loadKDString((String)"\u53ea\u6709\u672a\u5408\u5e76\u72b6\u6001\u7684\u6536\u6b3e\u8ba4\u9886\u5355\uff0c\u624d\u80fd\u53d6\u6d88\u901a\u77e5\u8ba4\u9886\uff01\u5355\u636e\u7f16\u53f7\uff1a%s\u53d6\u6d88\u901a\u77e5\u8ba4\u9886\u5931\u8d25", (String)"RecClaimBillList_9", (String)SYSTEMTYPE, (Object[])new Object[0]), string), (String)ResManager.loadKDString((String)"\u53d6\u6d88\u901a\u77e5\u8ba4\u9886", (String)"RecClaimBillList_8", (String)SYSTEMTYPE, (Object[])new Object[0])));
                    }
                    continue;
                }
                if (noticeBill.getBoolean("isunclaim")) {
                    Set recBillNos = (Set)billNoMap.get(noticeBill.getString("billno"));
                    for (String string : recBillNos) {
                        result.addErrorInfo(CasHelper.getOperateErrorInfo((Object)noticeBill.getPkValue(), (String)String.format(ResManager.loadKDString((String)"\u901a\u77e5\u5355\u5df2\u7ecf\u8fdb\u884c\u4e86\u672a\u8ba4\u9886\u5165\u8d26\u64cd\u4f5c\uff0c\u5355\u636e\u7f16\u53f7\uff1a%s\u53d6\u6d88\u901a\u77e5\u8ba4\u9886\u5931\u8d25", (String)"RecClaimBillList_24", (String)SYSTEMTYPE, (Object[])new Object[0]), string), (String)ResManager.loadKDString((String)"\u53d6\u6d88\u901a\u77e5\u8ba4\u9886", (String)"RecClaimBillList_8", (String)SYSTEMTYPE, (Object[])new Object[0])));
                    }
                    continue;
                }
                qFilter = new QFilter("claimno", "=", (Object)noticeBill.getString("billno"));
                DynamicObject[] ids = BusinessDataServiceHelper.load((String)"cas_claimbill", (String)"id", (QFilter[])new QFilter[]{qFilter});
                if (ids.length > 0) {
                    Set set = (Set)billNoMap.get(noticeBill.getString("billno"));
                    for (String recBillNo : set) {
                        result.addErrorInfo(CasHelper.getOperateErrorInfo((Object)noticeBill.getPkValue(), (String)String.format(ResManager.loadKDString((String)"\u53ea\u6709\u5df2\u53d1\u8d77\u6536\u6b3e\u8ba4\u9886\u901a\u77e5\uff0c\u4e14\u4e0d\u5b58\u5728\u672a\u5904\u7406\u7684\u8ba4\u9886\u5355\uff0c\u624d\u80fd\u53d6\u6d88\u901a\u77e5\u8ba4\u9886\uff01\u5e94\u6536\u7968\u636e\uff08\u5355\u636e\u7f16\u53f7\uff1a%s\uff09\u53d6\u6d88\u901a\u77e5\u8ba4\u9886\u5931\u8d25", (String)"RecClaimBillList_24_1", (String)SYSTEMTYPE, (Object[])new Object[0]), recBillNo), (String)ResManager.loadKDString((String)"\u53d6\u6d88\u901a\u77e5\u8ba4\u9886", (String)"RecClaimBillList_24_2", (String)SYSTEMTYPE, (Object[])new Object[0])));
                    }
                    continue;
                }
                if (!ClaimStatusEnum.WAIT.getValue().equals(noticeBill.getString("claimstatus"))) {
                    Set set = (Set)billNoMap.get(noticeBill.getString("billno"));
                    for (String recBillNo : set) {
                        result.addErrorInfo(CasHelper.getOperateErrorInfo((Object)noticeBill.getPkValue(), (String)String.format(ResManager.loadKDString((String)"\u53ea\u6709\u5df2\u53d1\u8d77\u6536\u6b3e\u8ba4\u9886\u901a\u77e5\u4e14\u72b6\u6001\u4e3a\u5f85\u8ba4\u9886\u7684\u5355\u636e\uff0c\u624d\u80fd\u53d6\u6d88\u901a\u77e5\u8ba4\u9886\u3002\u5355\u636e\u7f16\u53f7\u201c%s\u201d\u53d6\u6d88\u901a\u77e5\u8ba4\u9886\u5931\u8d25\u3002", (String)"RecClaimBillList_25", (String)SYSTEMTYPE, (Object[])new Object[0]), recBillNo), (String)ResManager.loadKDString((String)"\u53d6\u6d88\u901a\u77e5\u8ba4\u9886", (String)"RecClaimBillList_8", (String)SYSTEMTYPE, (Object[])new Object[0])));
                    }
                    continue;
                }
                claimIds.add(noticeBill.getPkValue());
                cancelSuccessIds.add(noticeBill.getLong("sourceid"));
                if ("cdm_receivablebill".equals(noticeBill.get("sourcetype"))) {
                    detailIds.add(noticeBill.get("sourceid"));
                } else if ("cdm_electronic_sign_deal".equals(noticeBill.get("sourcetype"))) {
                    eleSignIds.add(noticeBill.get("sourceid"));
                }
                dycoll = noticeBill.getDynamicObjectCollection("entryentity1");
                typeValue = new HashMap<String, List<Object>>(16);
                typeValue.put("userids", dycoll.stream().filter(dy -> StringUtils.equals((CharSequence)ClaimAuthorityEnum.USER.getValue(), (CharSequence)dy.getString("claimtype"))).map(dy -> dy.get("claimtypeid")).collect(Collectors.toList()));
                typeValue.put("usergroupids", dycoll.stream().filter(dy -> StringUtils.equals((CharSequence)ClaimAuthorityEnum.USERGROUP.getValue(), (CharSequence)dy.getString("claimtype"))).map(dy -> dy.get("claimtypeid")).collect(Collectors.toList()));
                typeValue.put("orgids", dycoll.stream().filter(dy -> StringUtils.equals((CharSequence)ClaimAuthorityEnum.USERORG.getValue(), (CharSequence)dy.getString("claimtype"))).map(dy -> dy.get("claimtypeid")).collect(Collectors.toList()));
                typeValue.put("roleids", dycoll.stream().filter(dy -> StringUtils.equals((CharSequence)ClaimAuthorityEnum.ROLER.getValue(), (CharSequence)dy.getString("claimtype"))).map(dy -> dy.get("claimtypeid")).collect(Collectors.toList()));
                noticeMes = new ArrayList<String>(16);
                noticeMes.add(String.format(ResManager.loadKDString((String)"1\u7b14\u6536\u6b3e\uff08\u91d1\u989d\uff1a%1$s%2$s\uff09\u5df2\u53d6\u6d88\u901a\u77e5\u8ba4\u9886", (String)"RecClaimBillList_15", (String)SYSTEMTYPE, (Object[])new Object[0]), noticeBill.getDynamicObject("currency").getString("sign"), CasHelper.formatDecimal((BigDecimal)noticeBill.getBigDecimal("reamount"), (int)2)));
                typeValue.put("title", noticeMes);
                noticeMes = new ArrayList(16);
                if (EmptyUtil.isNoEmpty((Object)noticeBill.getDate("tradetime"))) {
                    noticeMes.add(String.format(ResManager.loadKDString((String)"\u4ee5\u4e0b\u6536\u6b3e\u5df2\u53d6\u6d88\u901a\u77e5\u8ba4\u9886\u3002\r\n\u6536\u6b3e\u91d1\u989d\uff1a%1$s%2$s\r\n\u5bf9\u65b9\u6237\u540d\uff1a%3$s\r\n\u6458\u8981\uff1a%4$s\r\n\u4ea4\u6613\u65f6\u95f4\uff1a%5$s\r\n\u5e94\u6536\u7968\u636e\u5355\u636e\u7f16\u53f7 \uff1a%6$s", (String)"RecClaimBillList_17", (String)SYSTEMTYPE, (Object[])new Object[0]), noticeBill.getDynamicObject("currency").getString("sign"), CasHelper.formatDecimal((BigDecimal)noticeBill.getBigDecimal("reamount"), (int)2), noticeBill.getString("oppunit"), noticeBill.getString("description"), sdf.format(noticeBill.getDate("tradetime")), noticeBill.getString("tradedetailno")));
                } else {
                    noticeMes.add(String.format(ResManager.loadKDString((String)"\u4ee5\u4e0b\u6536\u6b3e\u5df2\u53d6\u6d88\u901a\u77e5\u8ba4\u9886\u3002\r\n\u6536\u6b3e\u91d1\u989d\uff1a%1$s%2$s\r\n\u5bf9\u65b9\u6237\u540d\uff1a%3$s\r\n\u6458\u8981\uff1a%4$s\r\n\u5e94\u6536\u7968\u636e\u5355\u636e\u7f16\u53f7 \uff1a%5$s", (String)"RecClaimBillList_18", (String)SYSTEMTYPE, (Object[])new Object[0]), noticeBill.getDynamicObject("currency").getString("sign"), CasHelper.formatDecimal((BigDecimal)noticeBill.getBigDecimal("reamount"), (int)2), noticeBill.getString("oppunit"), noticeBill.getString("description"), noticeBill.getString("tradedetailno")));
                }
                typeValue.put("content", noticeMes);
                claimType.put(noticeBill.getPkValue(), typeValue);
            }
        }
        if (claimIds.size() > 0) {
            OperationResult execOperate;
            block52: {
                logger.info("will open two tx");
                QFilter idFilter = new QFilter("id", "in", cancelSuccessIds);
                Object[] cancelSuccessBills = BusinessDataServiceHelper.load((String)"cdm_receivablebill", (String)"id,claimnoticebillno,rectype", (QFilter[])new QFilter[]{idFilter});
                if (EmptyUtil.isNoEmpty((Object[])cancelSuccessBills)) {
                    for (Object recving : cancelSuccessBills) {
                        recving.set("rectype", (Object)"");
                    }
                    SaveServiceHelper.save((DynamicObject[])cancelSuccessBills);
                }
                execOperate = null;
                Set<String> recClaimnoticebillnoSet = this.getClaimBillno(detailIds, false);
                Set<String> souClaimnoticebillnoSet = this.getClaimBillno(eleSignIds, true);
                qFilter = null;
                try (TXHandle tx = TX.requiresNew();){
                    execOperate = TmcOperateServiceHelper.execOperateWithoutThrow((String)"delete", (String)"cas_claimcenterbill", (Object[])claimIds.toArray(), (OperateOption)OperateOption.create());
                    if (!execOperate.isSuccess() && execOperate.getAllErrorInfo().size() > 0) {
                        result.addErrorInfo((OperateErrorInfo)execOperate.getAllErrorInfo().get(0));
                        break block52;
                    }
                    Throwable throwable = null;
                    try (TXHandle tx2 = TX.requiresNew();){
                        try {
                            RecClaimBillHelper.cancelWriteClaimNo((Object[])detailIds.toArray(), (Object[])eleSignIds.toArray(), recClaimnoticebillnoSet, souClaimnoticebillnoSet);
                        }
                        catch (Exception e) {
                            logger.error("second tx exception :", (Throwable)e);
                            tx2.markRollback();
                            tx.markRollback();
                            execOperate.getSuccessPkIds().clear();
                        }
                    }
                    catch (Throwable throwable2) {
                        Throwable throwable3 = throwable2;
                        throw throwable2;
                    }
                }
                catch (Throwable throwable) {
                    qFilter = throwable;
                    throw throwable;
                }
            }
            HashMap claimTypeTemp = new HashMap(claimIds.size());
            List successPkid = execOperate.getSuccessPkIds();
            for (Map.Entry entry : claimType.entrySet()) {
                if (!successPkid.contains(entry.getKey())) continue;
                claimTypeTemp.put(entry.getKey(), entry.getValue());
            }
            if (null != claimTypeTemp && claimTypeTemp.size() > 0) {
                RecClaimHelper.sendClaimNoticeMessage(claimTypeTemp, (String)"cancel");
            }
        }
        if (result.getAllErrorInfo().size() > 0) {
            ((ListView)this.getView()).refresh();
            this.getPageCache().put("operationresult", DataEntitySerializer.serializerToString((Object)result));
            CasHelper.showOperationResultMulti((OperationResult)result, (String)ResManager.loadKDString((String)"\u53d6\u6d88\u901a\u77e5\u8ba4\u9886", (String)"RecClaimBillList_8", (String)SYSTEMTYPE, (Object[])new Object[0]), (IFormView)this.getView());
        } else {
            ((ListView)this.getView()).refresh();
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u64cd\u4f5c\u6210\u529f", (String)"RecClaimBillList_2", (String)SYSTEMTYPE, (Object[])new Object[0]));
        }
    }

    private Set<String> getClaimBillno(Set<Object> detailIds, boolean isSource) {
        ArrayList<Long> longRecBillIds = new ArrayList<Long>(8);
        for (Object recvingId : detailIds) {
            if (recvingId instanceof String && !StringUtils.isBlank((Object)recvingId)) {
                longRecBillIds.add(Long.valueOf(recvingId.toString()));
                continue;
            }
            assert (recvingId instanceof Long);
            longRecBillIds.add((Long)recvingId);
        }
        QFilter qFilter = null;
        qFilter = isSource ? new QFilter("sourcebillid", "in", longRecBillIds) : new QFilter("id", "in", longRecBillIds);
        DynamicObject[] recvings = BusinessDataServiceHelper.load((String)"cdm_receivablebill", (String)"id,claimnoticebillno", (QFilter[])new QFilter[]{qFilter});
        HashSet<String> claimnoticebillnoSet = new HashSet<String>(16);
        for (DynamicObject recving : recvings) {
            String claimnoticebillno = recving.getString("claimnoticebillno");
            if (!EmptyUtil.isNoEmpty((String)claimnoticebillno)) continue;
            claimnoticebillnoSet.add(claimnoticebillno);
        }
        return claimnoticebillnoSet;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void noticeClaim(Object[] ids) {
        long startTimeTobook = System.currentTimeMillis();
        logger.info("noticeClaim is start :" + SerializationUtils.toJsonString((Object)ids) + ",startTimeTobook:" + startTimeTobook);
        DynamicObject[] receivablebills = this.getSelectRow(ids);
        this.checkOpPerm("noticeclaim", ResManager.loadKDString((String)"\u901a\u77e5\u8ba4\u9886", (String)"RecClaimBillList_7", (String)SYSTEMTYPE, (Object[])new Object[0]), receivablebills);
        ArrayList<DynamicObject> noticeds = new ArrayList<DynamicObject>(10);
        ArrayList<DynamicObject> unnotices = new ArrayList<DynamicObject>(10);
        HashSet<Long> orgSet = new HashSet<Long>(10);
        boolean isMoreBills = receivablebills.length > 1;
        ArrayList<String> errorMsg = new ArrayList<String>(16);
        logger.info("curr bill is start");
        String appId = AppMetadataCache.getAppInfo((String)"cdm").getId();
        Set companyIdSet = Arrays.stream(receivablebills).map(e -> e.getDynamicObject("company").getLong("id")).collect(Collectors.toSet());
        logger.info("companyIdSet size:" + SerializationUtils.toJsonString(companyIdSet));
        HashMap<DynamicObject[], String> companyIdAndSysMap = new HashMap<DynamicObject[], String>(6);
        for (DynamicObject[] companyId : companyIdSet) {
            String noticeClaimAllowStatus = (String)SystemParamServiceHelper.getAppParameter((String)appId, (String)"08", (Long)companyId, (String)"noticeclaimallowstatus");
            companyIdAndSysMap.put(companyId, noticeClaimAllowStatus);
        }
        Map billIdAndExsitMap = DraftHelper.existsRecBillByBatch((Object[])ids);
        for (DynamicObject receivablebill : receivablebills) {
            Long draftEntryId;
            String source = receivablebill.getString("source");
            if ("cas".equalsIgnoreCase(source)) {
                if (!isMoreBills) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6536\u6b3e\u5355\u4e0b\u63a8\u7684\u6536\u7968\u767b\u8bb0\u4e0d\u80fd\u518d\u53d1\u8d77\u901a\u77e5\u8ba4\u9886", (String)"RecClaimBillList_28", (String)SYSTEMTYPE, (Object[])new Object[0]));
                    return;
                }
                errorMsg.add(String.format(ResManager.loadKDString((String)"%s\uff1a\u6536\u6b3e\u5355\u4e0b\u63a8\u7684\u6536\u7968\u767b\u8bb0\u4e0d\u80fd\u518d\u53d1\u8d77\u901a\u77e5\u8ba4\u9886", (String)"RecClaimBillList_40", (String)SYSTEMTYPE, (Object[])new Object[0]), receivablebill.get("billno")));
            }
            if (EmptyUtil.isNoEmpty((Long)(draftEntryId = Long.valueOf(receivablebill.getLong("allocbillentryid"))))) {
                if (!isMoreBills) {
                    this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"%s\uff1a\u7968\u636e\u8c03\u5ea6\u4ea7\u751f\u7684\u6536\u7968\u767b\u8bb0\u4e0d\u80fd\u901a\u77e5\u8ba4\u9886\u3002", (String)"RecClaimBillList_38", (String)SYSTEMTYPE, (Object[])new Object[0]), receivablebill.get("billno")));
                    return;
                }
                errorMsg.add(String.format(ResManager.loadKDString((String)"%s\uff1a\u7968\u636e\u8c03\u5ea6\u4ea7\u751f\u7684\u6536\u7968\u767b\u8bb0\u4e0d\u80fd\u901a\u77e5\u8ba4\u9886\u3002", (String)"RecClaimBillList_38", (String)SYSTEMTYPE, (Object[])new Object[0]), receivablebill.get("billno")));
            }
            if (!StringUtils.equals((CharSequence)BillStatusEnum.AUDIT.getValue(), (CharSequence)receivablebill.getString("billstatus"))) {
                if (!isMoreBills) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u672a\u5ba1\u6838\u6216\u5df2\u9000\u7968\u7684\u7684\u6570\u636e\u4e0d\u80fd\u901a\u77e5\u8ba4\u9886", (String)"RecClaimBillList_10", (String)SYSTEMTYPE, (Object[])new Object[0]));
                    return;
                }
                errorMsg.add(String.format("%s:" + ResManager.loadKDString((String)"\u672a\u5ba1\u6838\u6216\u5df2\u9000\u7968\u7684\u7684\u6570\u636e\u4e0d\u80fd\u901a\u77e5\u8ba4\u9886", (String)"RecClaimBillList_10", (String)SYSTEMTYPE, (Object[])new Object[0]), receivablebill.get("billno")));
            }
            orgSet.add(receivablebill.getDynamicObject("company").getLong("id"));
            if (orgSet.size() > 1) {
                if (!isMoreBills) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u591a\u4e2a\u8d44\u91d1\u7ec4\u7ec7\u7684\u5e94\u6536\u7968\u636e\u6279\u91cf\u901a\u77e5\u8ba4\u9886\u3002", (String)"RecClaimBillList_39", (String)SYSTEMTYPE, (Object[])new Object[0]));
                    return;
                }
                errorMsg.add(String.format("%s:" + ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u591a\u4e2a\u8d44\u91d1\u7ec4\u7ec7\u7684\u5e94\u6536\u7968\u636e\u6279\u91cf\u901a\u77e5\u8ba4\u9886\u3002", (String)"RecClaimBillList_39", (String)SYSTEMTYPE, (Object[])new Object[0]), receivablebill.get("billno")));
            }
            boolean electTag = receivablebill.getBoolean("electag");
            String draftTranStatus = receivablebill.getString("draftbilltranstatus");
            if (electTag && !"success".equals(draftTranStatus)) {
                if (!isMoreBills) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u63d0\u4ea4\u7535\u7968\u4e3a\u662f\u4e14\u7535\u7968\u5904\u7406\u72b6\u6001\u4e0d\u662f\u4ea4\u6613\u6210\u529f\u7684\u5355\u636e\u4e0d\u80fd\u901a\u77e5\u8ba4\u9886", (String)"RecClaimBillList_26", (String)SYSTEMTYPE, (Object[])new Object[0]));
                    return;
                }
                errorMsg.add(String.format("%s:" + ResManager.loadKDString((String)"\u63d0\u4ea4\u7535\u7968\u4e3a\u662f\u4e14\u7535\u7968\u5904\u7406\u72b6\u6001\u4e0d\u662f\u4ea4\u6613\u6210\u529f\u7684\u5355\u636e\u4e0d\u80fd\u901a\u77e5\u8ba4\u9886", (String)"RecClaimBillList_26", (String)SYSTEMTYPE, (Object[])new Object[0]), receivablebill.get("billno")));
            }
            String draftbillstatus = receivablebill.getString("draftbillstatus");
            String noticeClaimAllowStatus = (String)companyIdAndSysMap.get(receivablebill.getLong("company.id"));
            if (EmptyUtil.isEmpty((String)noticeClaimAllowStatus)) {
                String showErrorMsg = ResManager.loadKDString((String)"\u7cfb\u7edf\u53c2\u6570\u9650\u5b9a\u4e0d\u5141\u8bb8\u53d1\u8d77\u901a\u77e5\u8ba4\u9886", (String)"RecClaimBillList_33", (String)SYSTEMTYPE, (Object[])new Object[0]);
                if (!isMoreBills) {
                    this.getView().showErrorNotification(showErrorMsg);
                    return;
                }
                errorMsg.add(String.format("%s:" + showErrorMsg, receivablebill.get("billno")));
            } else if (!noticeClaimAllowStatus.contains(draftbillstatus) || !"success".equals(draftTranStatus)) {
                String errorTips = this.getErrorTips(noticeClaimAllowStatus);
                String string = String.format(ResManager.loadKDString((String)"\u7968\u636e\u72b6\u6001\u4e3a%s\uff0c\u4e14\u4ea4\u6613\u72b6\u6001\u4e3a\u4ea4\u6613\u6210\u529f\u7684\u7968\u636e\u624d\u53ef\u4ee5\u901a\u77e5\u8ba4\u9886", (String)"RecClaimBillList_31", (String)SYSTEMTYPE, (Object[])new Object[0]), errorTips);
                if (!isMoreBills) {
                    this.getView().showErrorNotification(string);
                    return;
                }
                errorMsg.add(String.format("%s:" + string, receivablebill.get("billno")));
            }
            if (billIdAndExsitMap.containsKey(receivablebill.getLong("id"))) {
                if (!isMoreBills) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u7968\u636e\u5df2\u751f\u6210\u6536\u6b3e\u5355\u5e76\u786e\u8ba4\u6536\u6b3e\uff0c\u4e0d\u80fd\u901a\u77e5\u8ba4\u9886\u3002", (String)"RecClaimBillList_29", (String)SYSTEMTYPE, (Object[])new Object[0]));
                    return;
                }
                errorMsg.add(String.format("%s:" + ResManager.loadKDString((String)"\u7968\u636e\u5df2\u751f\u6210\u6536\u6b3e\u5355\u5e76\u786e\u8ba4\u6536\u6b3e\uff0c\u4e0d\u80fd\u901a\u77e5\u8ba4\u9886\u3002", (String)"RecClaimBillList_29", (String)SYSTEMTYPE, (Object[])new Object[0]), receivablebill.get("billno")));
            }
            HashSet<Long> draftIds = new HashSet<Long>(8);
            draftIds.add(receivablebill.getLong("id"));
            Set set = LockDraftHelper.draftIsQuoteRecs(draftIds);
            if (!EmptyUtil.isEmpty((Collection)set)) {
                String showErrorMsg = ResManager.loadKDString((String)"\u8be5\u7968\u636e\u5df2\u7ecf\u5173\u8054\u6536\u6b3e\u5904\u7406\uff0c\u65e0\u9700\u901a\u77e5\u8ba4\u9886", (String)"RecClaimBillList_34", (String)SYSTEMTYPE, (Object[])new Object[0]);
                if (!isMoreBills) {
                    this.getView().showErrorNotification(showErrorMsg);
                    return;
                }
                errorMsg.add(String.format("%s:" + showErrorMsg, receivablebill.get("billno")));
            }
            if (EmptyUtil.isEmpty((String)((String)receivablebill.get("claimnoticebillno")))) {
                unnotices.add(receivablebill);
                continue;
            }
            noticeds.add(receivablebill);
        }
        logger.info("curr bill is end");
        if (errorMsg.size() > 0 && isMoreBills) {
            StringBuilder stringBuilder = new StringBuilder();
            Iterator noticeClaimAllowStatus = errorMsg.iterator();
            while (true) {
                if (!noticeClaimAllowStatus.hasNext()) {
                    this.batchInputTip("", stringBuilder.toString());
                    return;
                }
                String str = (String)noticeClaimAllowStatus.next();
                stringBuilder.append(str).append(";").append("\r\n");
            }
        }
        ArrayList<DynamicObject> failIds = new ArrayList<DynamicObject>(10);
        ArrayList<DynamicObject> successIds = new ArrayList<DynamicObject>(10);
        StringBuilder recPayRuleFailMessage = new StringBuilder();
        HashMap<String, String> ruleNotice = new HashMap<String, String>(16);
        logger.info("will unnotices is start");
        if (EmptyUtil.isNoEmpty(unnotices)) {
            logger.info("unnotices size is:" + unnotices.size());
            logger.info("curr unnotices is start");
            for (DynamicObject unnotice : unnotices) {
                long id = unnotice.getLong("id");
                DynamicObject ruleResult = RecBillAutoClaimNoticeHelper.getClaimInfoByNoticeRule((Long)id, (String)"noticeclaim");
                if (EmptyUtil.isEmpty((DynamicObject)ruleResult)) {
                    logger.info("ruleResult is null");
                    failIds.add(unnotice);
                    continue;
                }
                Object tag = ruleResult.get("e_savenotifi_TAG");
                Object noticeGroup = ruleResult.get("e_noticegroup");
                if (!ObjectUtils.isEmpty((Object)noticeGroup) && "D".equals(noticeGroup)) {
                    HashMap<String, Long> hashMap = new HashMap<String, Long>(16);
                    hashMap.put("billid", id);
                    hashMap.put("ruleentryid", ruleResult.getLong("id"));
                    Map map = RecBillAutoClaimNoticeHelper.getNoticeObjectExt(hashMap);
                    tag = SerializationUtils.toJsonString((Object)map);
                }
                if ("noticeclaim".equals(ruleResult.get("e_handlescheme")) && !EmptyUtil.isEmpty((Object)tag)) {
                    successIds.add(unnotice);
                    String string = Long.toString(id);
                    cache.put(string, tag);
                    cache.put(id + "rulesname", ruleResult.get("e_rulesname"));
                    ruleNotice.put(string, tag.toString());
                    continue;
                }
                failIds.add(unnotice);
            }
            logger.info("curr unnotices is end");
        }
        OperationResult result = null;
        if (!successIds.isEmpty()) {
            Object[] successPkIds = successIds.stream().map(e -> e.get("id")).toArray();
            logger.info("successPkIds is:" + SerializationUtils.toJsonString((Object)successPkIds));
            long beginPushTime = System.currentTimeMillis();
            result = TmcOperateServiceHelper.execOperateWithoutThrow((String)"pushandsave", (String)"cdm_receivablebill", (Object[])successPkIds, (OperateOption)OperateOption.create());
            logger.info("pushandsave is end" + (System.currentTimeMillis() - beginPushTime));
            List pushAndSaveIds = result.getSuccessPkIds();
            for (DynamicObject successId : successIds) {
                Object object = successId.getPkValue();
                if (!pushAndSaveIds.contains(object)) continue;
                successId.set("rectype", (Object)"6");
            }
            SaveServiceHelper.save((DynamicObject[])successIds.toArray(new DynamicObject[0]));
            this.getPageCache().put("successIds", String.join((CharSequence)",", successIds.stream().map(e -> e.get("id").toString()).collect(Collectors.toList())));
        }
        if (!failIds.isEmpty()) {
            logger.info("failIds is not emtry");
            ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener("claimconfirm", (IFormPlugin)this);
            String confirmMessage = "";
            noticeds.stream().forEach(detail -> recPayRuleFailMessage.append(String.format(ResManager.loadKDString((String)"%s\uff1a\u5df2\u53d1\u8d77\u8fc7\u6536\u6b3e\u8ba4\u9886\u901a\u77e5\uff0c\u65e0\u9700\u518d\u901a\u77e5\u8ba4\u9886\u3002\r\n", (String)"RecClaimBillList_4", (String)SYSTEMTYPE, (Object[])new Object[0]), detail.get("billno"))));
            successIds.stream().forEach(detail -> recPayRuleFailMessage.append(String.format(ResManager.loadKDString((String)"%s\uff1a\u901a\u77e5\u8ba4\u9886\u64cd\u4f5c\u6210\u529f\u3002\r\n", (String)"RecClaimBillList_5", (String)SYSTEMTYPE, (Object[])new Object[0]), detail.get("billno"))));
            failIds.stream().forEach(detail -> recPayRuleFailMessage.append(String.format(ResManager.loadKDString((String)"%s\uff1a\u65e0\u6cd5\u6309\u65b9\u6848\u901a\u77e5\u8ba4\u9886\uff0c\u53ef\u80fd\u662f\u672a\u8fdb\u884c\u89c4\u5219\u8bbe\u7f6e\uff0c\u6216\u672a\u9002\u914d\u5230\u65b9\u6848\u3002\u53ef\u6307\u5b9a\u53c2\u4e0e\u8ba4\u9886\u7528\u6237\u4fe1\u606f\u540e\u53d1\u8d77\u901a\u77e5\u3002\r\n", (String)"RecClaimBillList_1", (String)SYSTEMTYPE, (Object[])new Object[0]), detail.get("billno"))));
            confirmMessage = noticeds.isEmpty() ? String.format(ResManager.loadKDString((String)"\u5171%1$s\u6761\u8bb0\u5f55\uff0c\u5df2\u6309\u89c4\u5219\u901a\u77e5\u8ba4\u9886%2$s\u6761\uff0c\u9700\u6307\u5b9a\u53c2\u4e0e\u8ba4\u9886\u7528\u6237\u4fe1\u606f%3$s\u6761\uff0c\u786e\u8ba4\u662f\u5426\u7ee7\u7eed\uff1f", (String)"RecClaimBillList_0", (String)SYSTEMTYPE, (Object[])new Object[0]), ids.length, successIds.size(), failIds.size()) : String.format(ResManager.loadKDString((String)"\u5171%1$s\u6761\u8bb0\u5f55\uff0c\u65e0\u9700\u901a\u77e5%2$s\u6761\uff0c\u5df2\u6309\u89c4\u5219\u901a\u77e5\u8ba4\u9886%3$s\u6761\uff0c\u9700\u6307\u5b9a\u53c2\u4e0e\u8ba4\u9886\u7528\u6237\u4fe1\u606f%4$s\u6761\uff0c\u786e\u8ba4\u662f\u5426\u7ee7\u7eed\uff1f", (String)"RecClaimBillList_6", (String)SYSTEMTYPE, (Object[])new Object[0]), ids.length, noticeds.size(), successIds.size(), failIds.size());
            this.getView().showConfirm(confirmMessage, recPayRuleFailMessage.toString(), MessageBoxOptions.OKCancel, ConfirmTypes.Default, confirmCallBacks);
            List failIdsList = failIds.stream().map(e -> e.get("id").toString()).collect(Collectors.toList());
            logger.info("failIdsList is:" + SerializationUtils.toJsonString(failIdsList));
            this.getPageCache().put("failids", String.join((CharSequence)",", failIdsList));
        } else {
            if (noticeds.isEmpty()) {
                logger.info("noticeds is empty");
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u64cd\u4f5c\u6210\u529f", (String)"RecClaimBillList_2", (String)SYSTEMTYPE, (Object[])new Object[0]));
            } else {
                List noticedsList = noticeds.stream().map(e -> e.get("id").toString()).collect(Collectors.toList());
                logger.info("noticedsList is:" + SerializationUtils.toJsonString(noticedsList));
                noticeds.stream().forEach(detail -> recPayRuleFailMessage.append(String.format(ResManager.loadKDString((String)"%s\uff1a\u5df2\u53d1\u8d77\u8fc7\u6536\u6b3e\u8ba4\u9886\u901a\u77e5\uff0c\u65e0\u9700\u518d\u901a\u77e5\u8ba4\u9886\u3002\r\n", (String)"RecClaimBillList_4", (String)SYSTEMTYPE, (Object[])new Object[0]), detail.get("billno"))));
                unnotices.stream().forEach(detail -> recPayRuleFailMessage.append(String.format(ResManager.loadKDString((String)"%s\uff1a\u901a\u77e5\u8ba4\u9886\u64cd\u4f5c\u6210\u529f\u3002\r\n", (String)"RecClaimBillList_5", (String)SYSTEMTYPE, (Object[])new Object[0]), detail.get("billno"))));
                this.getView().showMessage(String.format(ResManager.loadKDString((String)"\u5171%1$s\u6761\u8bb0\u5f55\uff0c\u5df2\u901a\u77e5\u8ba4\u9886%2$s\u6761\uff0c\u65e0\u9700\u901a\u77e5%3$s\u6761", (String)"RecClaimBillList_3", (String)SYSTEMTYPE, (Object[])new Object[0]), receivablebills.length, unnotices.size(), noticeds.size()), recPayRuleFailMessage.toString(), MessageTypes.Default);
            }
            if (result != null) {
                this.noticeMessage(ruleNotice);
                this.getPageCache().remove("successIds");
            }
            ((ListView)this.getView()).refresh();
        }
        logger.info("noticeClaim is end :" + (System.currentTimeMillis() - startTimeTobook));
    }

    private String getErrorTips(String noticeClaimAllowStatus) {
        List<String> allowStatusList = Arrays.asList(noticeClaimAllowStatus.split(","));
        StringBuilder errorTips = new StringBuilder();
        for (String allowStatus : allowStatusList) {
            if (StringUtils.equals((CharSequence)allowStatus, (CharSequence)DraftBillStatusEnum.REGISTERED.getValue())) {
                errorTips.append(DraftBillStatusEnum.REGISTERED.getName()).append(ResManager.loadKDString((String)"\u6216", (String)"RecClaimBillList_30", (String)SYSTEMTYPE, (Object[])new Object[0]));
                continue;
            }
            if (StringUtils.equals((CharSequence)allowStatus, (CharSequence)DraftBillStatusEnum.PLEDGED.getValue())) {
                errorTips.append(DraftBillStatusEnum.PLEDGED.getName()).append(ResManager.loadKDString((String)"\u6216", (String)"RecClaimBillList_30", (String)SYSTEMTYPE, (Object[])new Object[0]));
                continue;
            }
            if (StringUtils.equals((CharSequence)allowStatus, (CharSequence)DraftBillStatusEnum.COLLOCATED.getValue())) {
                errorTips.append(DraftBillStatusEnum.COLLOCATED.getName()).append(ResManager.loadKDString((String)"\u6216", (String)"RecClaimBillList_30", (String)SYSTEMTYPE, (Object[])new Object[0]));
                continue;
            }
            if (StringUtils.equals((CharSequence)allowStatus, (CharSequence)DraftBillStatusEnum.ENDORSED.getValue())) {
                errorTips.append(DraftBillStatusEnum.ENDORSED.getName()).append(ResManager.loadKDString((String)"\u6216", (String)"RecClaimBillList_30", (String)SYSTEMTYPE, (Object[])new Object[0]));
                continue;
            }
            if (StringUtils.equals((CharSequence)allowStatus, (CharSequence)DraftBillStatusEnum.DISCOUNTED.getValue())) {
                errorTips.append(DraftBillStatusEnum.DISCOUNTED.getName()).append(ResManager.loadKDString((String)"\u6216", (String)"RecClaimBillList_30", (String)SYSTEMTYPE, (Object[])new Object[0]));
                continue;
            }
            if (!StringUtils.equals((CharSequence)allowStatus, (CharSequence)DraftBillStatusEnum.COLLECTED.getValue())) continue;
            errorTips.append(DraftBillStatusEnum.COLLECTED.getName()).append(ResManager.loadKDString((String)"\u6216", (String)"RecClaimBillList_30", (String)SYSTEMTYPE, (Object[])new Object[0]));
        }
        return errorTips.substring(0, errorTips.length() - 1);
    }

    private void batchInputTip(String title, String content) {
        FormShowParameter parameters = new FormShowParameter();
        parameters.getOpenStyle().setShowType(ShowType.Modal);
        parameters.setFormId("bos_operationresult");
        parameters.setShowTitle(false);
        parameters.setCustomParam("title", (Object)title);
        StringBuilder buf = new StringBuilder();
        buf.append("<div style='overflow:auto;word-wrap:break-word;word-break:break-all;width:100%'>");
        parameters.setCustomParam("errorMsg", (Object)buf.append(content));
        this.getView().showForm(parameters);
    }

    private void noticeMessage(Map<String, String> ruleNotice) {
        HashMap claimTypeMap = new HashMap(ruleNotice.size());
        HashMap<String, List> typeValue = null;
        for (Map.Entry<String, String> rule : ruleNotice.entrySet()) {
            Map map = (Map)SerializationUtils.fromJsonString((String)rule.getValue(), Map.class);
            typeValue = new HashMap<String, List>(16);
            typeValue.put("usergroupids", (List)map.get("usergroupids"));
            typeValue.put("orgids", (List)map.get("orgids"));
            typeValue.put("roleids", (List)map.get("roleids"));
            typeValue.put("userids", (List)map.get("userids"));
            claimTypeMap.put(rule.getKey(), typeValue);
        }
        RecClaimHelper.sendClaimNoticeMessage(claimTypeMap, (String)"notice");
    }

    public void confirmCallBack(MessageBoxClosedEvent e) {
        super.confirmCallBack(e);
        if (e.getCallBackId().equals("claimconfirm") && e.getResult() == MessageBoxResult.Yes) {
            FormShowParameter formParameter = new FormShowParameter();
            formParameter.setFormId("cas_noticeclaim");
            formParameter.getOpenStyle().setShowType(ShowType.Modal);
            formParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "noticetype"));
            BillList list = (BillList)this.getControl("billlistap");
            ListSelectedRowCollection selectedRows = list.getSelectedRows();
            Object[] receivablebills = BusinessDataServiceHelper.load((String)"cdm_receivablebill", (String)"id, billno, claimnoticebillno , receredtype , company,rectype", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)selectedRows.getPrimaryKeyValues())});
            if (EmptyUtil.isNoEmpty((Object[])receivablebills)) {
                formParameter.setCustomParam("orgId", receivablebills[0].getDynamicObject("company").getPkValue());
            }
            this.getView().showForm(formParameter);
        } else {
            String successString = this.getPageCache().get("successIds");
            if (EmptyUtil.isNotEmpty((CharSequence)successString)) {
                String[] successIds = successString.split(",");
                HashMap<String, String> ruleNotice = new HashMap<String, String>(successIds.length);
                for (int i = 0; i < successIds.length; ++i) {
                    ruleNotice.put(successIds[i], (String)cache.get(successIds[i], String.class));
                }
                this.noticeMessage(ruleNotice);
            }
            this.getPageCache().remove("successIds");
            ((ListView)this.getView()).refresh();
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        if ("noticetype".equals(closedCallBackEvent.getActionId())) {
            Object returnData = closedCallBackEvent.getReturnData();
            if (EmptyUtil.isEmpty((Object)returnData)) {
                return;
            }
            Map noticeData = (Map)returnData;
            String jsonString = SerializationUtils.toJsonString((Object)noticeData);
            String failidString = this.getPageCache().get("failids");
            String[] failids = failidString.split(",");
            HashMap<String, String> ruleNotice = new HashMap<String, String>(failids.length);
            for (int i = 0; i < failids.length; ++i) {
                cache.put(failids[i], (Object)jsonString);
                ruleNotice.put(failids[i], jsonString);
            }
            Object[] ids = (Long[])Arrays.stream(failids).mapToLong(Long::valueOf).boxed().toArray(Long[]::new);
            logger.info("closedCallBack ids is:" + SerializationUtils.toJsonString((Object)ids));
            OperationResult result = TmcOperateServiceHelper.execOperateWithoutThrow((String)"pushandsave", (String)"cdm_receivablebill", (Object[])ids, (OperateOption)OperateOption.create());
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u64cd\u4f5c\u6210\u529f", (String)"RecClaimBillList_2", (String)SYSTEMTYPE, (Object[])new Object[0]));
            String successString = this.getPageCache().get("successIds");
            if (EmptyUtil.isNotEmpty((CharSequence)successString)) {
                String[] successIds = successString.split(",");
                for (int i = 0; i < successIds.length; ++i) {
                    ruleNotice.put(successIds[i], (String)cache.get(successIds[i], String.class));
                }
            }
            this.noticeMessage(ruleNotice);
            Object[] receivablebills = BusinessDataServiceHelper.load((String)"cdm_receivablebill", (String)"id, billno, claimnoticebillno , receredtype , company,rectype", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)ids)});
            if (EmptyUtil.isNoEmpty((Object[])receivablebills)) {
                for (Object receivablebill : receivablebills) {
                    receivablebill.set("rectype", (Object)"6");
                }
                SaveServiceHelper.save((DynamicObject[])receivablebills);
            }
            this.getPageCache().remove("successIds");
            ((ListView)this.getView()).refresh();
        } else if ("cdm_recinfo".equals(closedCallBackEvent.getActionId())) {
            Map returnData = (Map)closedCallBackEvent.getReturnData();
            if (returnData == null) {
                return;
            }
            DynamicObject eReceivingType = (DynamicObject)returnData.get("e_receivingtype");
            Object ePayerType = returnData.get("e_payertype");
            Object ePayer = returnData.get("e_payer");
            DynamicObject ePayerId = (DynamicObject)returnData.get("e_payerid");
            Object ePayerBaseType = returnData.get("e_payerbasetype");
            DynamicObject eFundFlowItem = (DynamicObject)returnData.get("e_fundflowitem");
            Object eExplain = returnData.get("e_explain");
            DynamicObject eSettleType = (DynamicObject)returnData.get("e_settletype");
            String genSelectIds = this.getPageCache().get("genSelectIds");
            if (EmptyUtil.isNotEmpty((CharSequence)genSelectIds)) {
                List genSelectIdObj = (List)SerializationUtils.fromJsonString((String)genSelectIds, List.class);
                List genSelectIdList = genSelectIdObj.stream().map(o -> Long.parseLong(o.toString())).collect(Collectors.toList());
                ArrayList<String> draftBillNo = new ArrayList<String>(genSelectIdList.size());
                if (genSelectIdList.size() > 0) {
                    for (Long o2 : genSelectIdList) {
                        DynamicObject[] cdmRecBills = BusinessDataServiceHelper.load((Object[])new Object[]{o2}, (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"cdm_receivablebill"));
                        OperateOption option = OperateOption.create();
                        option.setVariableValue("ishasright", "true");
                        option.setVariableValue("fromGenRecBill", "true");
                        option.setVariableValue("e_receivingtype", eReceivingType == null ? "0" : eReceivingType.getPkValue().toString());
                        option.setVariableValue("e_payertype", ePayerType == null ? "" : ePayerType.toString());
                        option.setVariableValue("e_payer", ePayer == null ? "" : ePayer.toString());
                        option.setVariableValue("e_payerid", ePayerId == null ? "0" : ePayerId.getPkValue().toString());
                        option.setVariableValue("e_payerbasetype", ePayerBaseType == null ? "" : ePayerBaseType.toString());
                        option.setVariableValue("e_fundflowitem", eFundFlowItem == null ? "0" : eFundFlowItem.getPkValue().toString());
                        option.setVariableValue("e_explain", eExplain == null ? "" : eExplain.toString());
                        option.setVariableValue("e_settletype", eSettleType == null ? "0" : eSettleType.getPkValue().toString());
                        OperationResult operationResult = TmcOperateServiceHelper.execOperateWithoutThrow((String)"pushandsaverecbill", (String)"cdm_receivablebill", (Object[])new Object[]{cdmRecBills[0].getPkValue()}, (OperateOption)option);
                        if (operationResult.isSuccess()) {
                            cdmRecBills[0].set("rectype", (Object)RecTypeEnum.HAND_GEN.getValue());
                            cdmRecBills[0].set("rulename", (Object)"");
                            draftBillNo.add(cdmRecBills[0].getString("draftbillno"));
                        }
                        SaveServiceHelper.save((DynamicObject[])cdmRecBills);
                    }
                    if (draftBillNo.size() > 0) {
                        this.getView().showSuccessNotification(String.format(ResManager.loadKDString((String)"%s\u5355\u636e\u8f6c\u6362\u89c4\u5219\u751f\u6210\u6536\u6b3e\u5355\u6210\u529f\u3002", (String)"RecClaimBillList_51", (String)SYSTEMTYPE, (Object[])new Object[0]), String.join((CharSequence)",", draftBillNo)), Integer.valueOf(5000));
                    }
                    this.getPageCache().remove("genSelectIds");
                    ((ListView)this.getView()).refresh();
                }
            }
        }
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        super.billListHyperLinkClick(args);
        String fieldName = args.getHyperLinkClickEvent().getFieldName();
        if ("claimnoticebillno".equals(fieldName)) {
            args.setCancel(true);
            BillList list = (BillList)this.getControl("billlistap");
            Object focusRowPkId = list.getFocusRowPkId();
            DynamicObject recving = BusinessDataServiceHelper.loadSingle((Object)focusRowPkId, (String)"cdm_receivablebill", (String)"id,claimnoticebillno");
            String recBillNo = recving.getString("claimnoticebillno");
            if (!StringUtils.isEmpty((CharSequence)recBillNo)) {
                QFilter filter = new QFilter("billno", "=", (Object)recBillNo);
                DynamicObject recbillDo = BusinessDataServiceHelper.loadSingle((String)"cas_claimcenterbill", (String)"id,billstatus", (QFilter[])new QFilter[]{filter});
                if (!CasHelper.isEmpty((Object)recbillDo)) {
                    BillShowParameter showParameter = new BillShowParameter();
                    showParameter.setStatus(OperationStatus.VIEW);
                    showParameter.setFormId("cas_claimcenterbill");
                    showParameter.setPkId(recbillDo.getPkValue());
                    showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                    this.getView().showForm((FormShowParameter)showParameter);
                }
            }
        }
    }

    public DynamicObject[] getSelectRow(Object[] ids) {
        DynamicObject[] receivablebills = BusinessDataServiceHelper.load((String)"cdm_receivablebill", (String)"id,billstatus,draftbillstatus, billno, claimnoticebillno ,allocbillentryid, receredtype , company,mergestatus,electag,draftbilltranstatus,source,rectype", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)ids)});
        return receivablebills;
    }
}

