/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cdm.formplugin.tradebill;

import java.io.Serializable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.cdm.common.enums.DraftTradeTypeEnum;
import kd.tmc.cdm.common.enums.DraftTranStatusEnum;
import kd.tmc.cdm.common.enums.SourceEnum;
import kd.tmc.cdm.common.helper.CdmCommonHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.formplugin.edit.AbstractTmcBillEdit;

public class TradeBillChangeDraftEdit
extends AbstractTmcBillEdit {
    public void beforeDoOperation(BeforeDoOperationEventArgs event) {
        super.beforeDoOperation(event);
        FormOperate formOperate = (FormOperate)event.getSource();
        String operateKey = formOperate.getOperateKey();
        DynamicObject data = this.getModel().getDataEntity(true);
        HashSet<String> tradeTypeSet = new HashSet<String>(3);
        tradeTypeSet.add(DraftTradeTypeEnum.ENDORSE.getValue());
        tradeTypeSet.add(DraftTradeTypeEnum.PLEDGE.getValue());
        tradeTypeSet.add(DraftTradeTypeEnum.DISCOUNT.getValue());
        if (tradeTypeSet.contains(data.getString("tradetype"))) {
            if ("changedraft".equals(operateKey)) {
                boolean isDrawFail;
                if (this.isRepayOrRejectRefund(data)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u5df2\u7ecf\u5931\u8d25\u91cd\u4ed8\u6216\u62d2\u6536\u9000\u7968\u7684\u7968\u636e\u4e0d\u652f\u6301\u6362\u7968\u64cd\u4f5c\u3002", (String)"TradeBillChangeDraftEdit_3", (String)"tmc-cdm-formplugin", (Object[])new Object[0]));
                    event.setCancel(true);
                    return;
                }
                if (this.isFromDraftAllocate(data)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u6765\u6e90\u662f\u7968\u636e\u8c03\u5ea6\u7684\u5355\u636e\u4e0d\u652f\u6301\u6362\u7968\u64cd\u4f5c\u3002", (String)"TradeBillChangeDraftEdit_6", (String)"tmc-cdm-formplugin", (Object[])new Object[0]));
                    event.setCancel(true);
                }
                if (isDrawFail = ((Boolean)this.getModel().getValue("isdrawfail")).booleanValue()) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u5df2\u7ecf\u786e\u8ba4\u5931\u8d25\u7684\u5355\u636e\u4e0d\u652f\u6301\u6362\u7968\u64cd\u4f5c\u3002", (String)"TradeBillChangeDraftEdit_7", (String)"tmc-cdm-formplugin", (Object[])new Object[0]));
                    event.setCancel(true);
                    return;
                }
            }
        } else if ("changedraft".equals(operateKey)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u53ea\u6709\u80cc\u4e66,\u8d28\u62bc\uff0c\u8d34\u73b0\u4e1a\u52a1\u652f\u6301\u6362\u7968\u3002", (String)"TradeBillChangeDraftEdit_8", (String)"tmc-cdm-formplugin", (Object[])new Object[0]));
            event.setCancel(true);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs event) {
        super.afterDoOperation(event);
        FormOperate formOperate = (FormOperate)event.getSource();
        String operateKey = formOperate.getOperateKey();
        DynamicObject data = this.getModel().getDataEntity(true);
        if ("changedraft".equals(operateKey)) {
            DynamicObjectCollection entries = data.getDynamicObjectCollection("entrys");
            List<DynamicObject> tranFailEntries = entries.stream().filter(e -> DraftTranStatusEnum.FAILING.getValue().equals(e.getString("transtatus")) && !e.getBoolean("entryisrepay") && !e.getBoolean("entryisrejectrefund")).collect(Collectors.toList());
            if (EmptyUtil.isEmpty(tranFailEntries)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u53ef\u6362\u7968\u636e\u3002", (String)"TradeBillChangeDraftEdit_5", (String)"tmc-cdm-formplugin", (Object[])new Object[0]));
                return;
            }
            List<Object> transFailIdList = tranFailEntries.stream().map(e -> e.getDynamicObject("draftbill").getPkValue()).collect(Collectors.toList());
            if (this.haveBillDoingChange(transFailIdList)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6240\u9009\u7968\u636e\u6b63\u5728\u6362\u7968\uff0c\u8bf7\u5b8c\u6210\u6362\u7968\u540e\u518d\u64cd\u4f5c\u3002", (String)"TradeBillChangeDraftEdit_1", (String)"tmc-cdm-formplugin", (Object[])new Object[0]));
                return;
            }
            HashMap needToChangeBillMap = new HashMap(16);
            tranFailEntries.forEach(entry -> {
                HashMap<String, Object> dataMap = new HashMap<String, Object>(8);
                Object pkValue = entry.getDynamicObject("draftbill").getPkValue();
                dataMap.put("billlogid", entry.get("billlogid"));
                dataMap.put("billamt", entry.get("billamt"));
                dataMap.put("tradeEntryId", entry.getPkValue());
                needToChangeBillMap.put(pkValue, dataMap);
            });
            HashMap<String, Object> param = new HashMap<String, Object>();
            HashMap<String, Serializable> customParam = new HashMap<String, Serializable>();
            Long pkValue = Long.parseLong(this.getModel().getValue("id").toString());
            customParam.put("id", pkValue);
            customParam.put("needToChangeBills", needToChangeBillMap);
            param.put("customParam", customParam);
            param.put("formId", "cdm_draftbillchange");
            param.put("showType", ShowType.MainNewTabPage);
            CdmCommonHelper.showWebBill(param, (AbstractFormPlugin)this);
        }
        if ("querychangerecord".equals(operateKey)) {
            if (!event.getOperationResult().isSuccess()) {
                return;
            }
            String tradeBillNo = data.getString("billno");
            QFilter qFilter = new QFilter("tradebillno", "=", (Object)tradeBillNo);
            if (EmptyUtil.isNoEmpty((String)tradeBillNo) && QueryServiceHelper.exists((String)"cdm_draftbillchange", (QFilter[])new QFilter[]{qFilter})) {
                ListShowParameter showParameter = new ListShowParameter();
                showParameter.setFormId("bos_list");
                showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                showParameter.setBillFormId("cdm_draftbillchange");
                List qFiltersCol = showParameter.getListFilterParameter().getQFilters();
                qFiltersCol.add(qFilter);
                this.getView().showForm((FormShowParameter)showParameter);
            } else {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u672c\u5355\u636e\u6682\u65e0\u6362\u7968\u8bb0\u5f55\u3002", (String)"TradeBillChangeDraftEdit_4", (String)"tmc-cdm-formplugin", (Object[])new Object[0]));
            }
        }
    }

    private boolean isRepayOrRejectRefund(DynamicObject tradeBill) {
        DynamicObjectCollection entries = tradeBill.getDynamicObjectCollection("entrys");
        List dataList = entries.stream().filter(e -> DraftTranStatusEnum.FAILING.getValue().equals(e.getString("transtatus"))).collect(Collectors.toList());
        return EmptyUtil.isNoEmpty(dataList) && dataList.stream().allMatch(e -> e.getBoolean("entryisrepay") || e.getBoolean("entryisrejectrefund"));
    }

    private boolean haveBillDoingChange(List<Object> selectBillIds) {
        DynamicObject tradeBill = TmcDataServiceHelper.loadSingle((Object)this.getModel().getValue("id"), (String)"cdm_drafttradebill");
        DynamicObjectCollection entries = tradeBill.getDynamicObjectCollection("entrys");
        for (DynamicObject entry : entries) {
            if (!entry.getBoolean("isinchange") || !selectBillIds.contains(entry.getDynamicObject("draftbill").getPkValue())) continue;
            return true;
        }
        return false;
    }

    private boolean haveBillIsChange() {
        DynamicObject data = this.getModel().getDataEntity(true);
        if (!data.getDataEntityState().getFromDatabase()) {
            return false;
        }
        DynamicObject tradeBillDB = TmcDataServiceHelper.loadSingle((Object)this.getModel().getValue("id"), (String)"cdm_drafttradebill");
        DynamicObjectCollection entriesDB = tradeBillDB.getDynamicObjectCollection("entrys");
        Map<Long, DynamicObject> isChangeBillIdToBillMapDB = entriesDB.stream().filter(entry -> entry.getBoolean("changeflag")).collect(Collectors.toMap(e -> e.getDynamicObject("draftbill").getLong("id"), x -> x));
        if (EmptyUtil.isEmpty(isChangeBillIdToBillMapDB) || isChangeBillIdToBillMapDB.size() == 0) {
            return false;
        }
        DynamicObjectCollection entries = data.getDynamicObjectCollection("entrys");
        Map<Long, DynamicObject> isChangeBillIdToBillMap = entries.stream().filter(entry -> entry.getBoolean("changeflag")).collect(Collectors.toMap(e -> e.getDynamicObject("draftbill").getLong("id"), x -> x));
        if (EmptyUtil.isEmpty(isChangeBillIdToBillMap) || isChangeBillIdToBillMap.size() == 0) {
            return true;
        }
        for (Long billId : isChangeBillIdToBillMap.keySet()) {
            if (isChangeBillIdToBillMapDB.containsKey(billId)) continue;
            return true;
        }
        return isChangeBillIdToBillMapDB.size() != isChangeBillIdToBillMap.size();
    }

    private boolean isFromDraftAllocate(DynamicObject data) {
        return StringUtils.equals((CharSequence)SourceEnum.CDM_DRAFT_ALLOCATE.getValue(), (CharSequence)data.getString("source"));
    }
}

