/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cdm.formplugin.tradebill;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.IBillModel;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.datamodel.events.AfterDeleteRowEventArgs;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.cdm.business.abstracts.tradebill.DraftTradeFactory;
import kd.tmc.cdm.business.abstracts.tradebill.EndorseDraftTrade;
import kd.tmc.cdm.common.enums.BillMediumEnum;
import kd.tmc.cdm.common.enums.DraftTradeTypeEnum;
import kd.tmc.cdm.common.property.TradeBillChangeProp;
import kd.tmc.cdm.common.resource.CdmBizResource;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.formplugin.edit.AbstractTmcBillEdit;
import org.apache.commons.lang3.StringUtils;

public class TradeBillChangeEdit
extends AbstractTmcBillEdit {
    private static final BigDecimal SPLIT_AMOUNT = new BigDecimal("0.01");

    protected void initControlEvi() {
        BasedataEdit draftBillF7 = (BasedataEdit)this.getControl("draftbill");
        draftBillF7.addBeforeF7SelectListener(evt -> {
            ListShowParameter showParameter = (ListShowParameter)evt.getFormShowParameter();
            showParameter.setCaption(ResManager.loadKDString((String)"\u6536\u7968\u767b\u8bb0", (String)"TradeBillTplEdit_5", (String)"tmc-cdm-formplugin", (Object[])new Object[0]));
            showParameter.setMultiSelect(true);
            showParameter.getListFilterParameter().setQFilters(this.getDraftQFilters());
        });
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.handleTradeBillChangeDataForDetails();
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.handleTradeBillChangeData();
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        String operateKey;
        super.afterDoOperation(afterDoOperationEventArgs);
        switch (operateKey = afterDoOperationEventArgs.getOperateKey()) {
            case "selectbill": {
                this.selectBill();
                break;
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent event) {
        super.closedCallBack(event);
        String actionId = event.getActionId();
        Object returnData = event.getReturnData();
        switch (actionId) {
            case "selectbill": {
                ListSelectedRowCollection rows = (ListSelectedRowCollection)returnData;
                if (EmptyUtil.isEmpty((Collection)rows)) {
                    return;
                }
                this.batchFillHaveChangeBillEntry(rows.stream().map(ListSelectedRow::getPrimaryKeyValue).collect(Collectors.toList()));
                this.sumDraftAmtAndCount("havechange_entry");
                break;
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String propName = e.getProperty().getName();
        ChangeData[] valSet = e.getChangeSet();
        Object propValue = valSet[0].getNewValue();
        Object oldValue = valSet[0].getOldValue();
        int rowIndex = valSet[0].getRowIndex();
        switch (propName) {
            case "billamt": {
                DynamicObject draftBill = (DynamicObject)this.getModel().getValue("draftbill", rowIndex);
                if (EmptyUtil.isEmpty((DynamicObject)draftBill)) {
                    this.getView().showErrorNotification(new CdmBizResource().getTipSelectDraftBillShort());
                    return;
                }
                boolean result = this.validateSplitAmount(draftBill, oldValue, propValue, rowIndex);
                if (result) {
                    return;
                }
                this.sumDraftAmtAndCount("havechange_entry");
                break;
            }
            case "draftbill": {
                this.sumDraftAmtAndCount("havechange_entry");
                break;
            }
        }
    }

    public void afterDeleteRow(AfterDeleteRowEventArgs e) {
        String key;
        super.afterDeleteRow(e);
        switch (key = e.getEntryProp().getName()) {
            case "havechange_entry": {
                this.sumDraftAmtAndCount("havechange_entry");
                break;
            }
        }
    }

    private boolean validateSplitAmount(DynamicObject draftBill, Object oldValue, Object newValue, int rowIndex) {
        BigDecimal billAmount = draftBill.getBigDecimal("amount");
        boolean reset = false;
        if (EmptyUtil.isNoEmpty((Object)newValue)) {
            BigDecimal splitAmt = (BigDecimal)newValue;
            if (SPLIT_AMOUNT.compareTo(splitAmt) > 0 || billAmount.compareTo(splitAmt) < 0) {
                reset = true;
            }
        } else {
            reset = true;
        }
        if (reset) {
            this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u5b50\u7968\u5305\u91d1\u989d\u4fee\u6539\u8303\u56f4\u5728 0.01 ~ %s\u4e4b\u95f4\u3002", (String)"TradeBillTplEdit_29", (String)"tmc-cdm-formplugin", (Object[])new Object[0]), billAmount));
            this.getModel().setValue("billamt", oldValue, rowIndex);
        }
        return reset;
    }

    private void handleTradeBillChangeDataForDetails() {
        DynamicObject draft;
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        Long pkValue = (Long)customParams.get("id");
        if (EmptyUtil.isNoEmpty((Long)pkValue)) {
            return;
        }
        DynamicObjectCollection haveChangeEntries = this.getModel().getEntryEntity("havechange_entry");
        DynamicObjectCollection beChangeEntries = this.getModel().getEntryEntity("bechange_entry");
        ArrayList draftBillIds = new ArrayList(beChangeEntries.size() + haveChangeEntries.size());
        draftBillIds.addAll(haveChangeEntries.stream().map(e -> e.getDynamicObject("draftbill").getLong("id")).collect(Collectors.toList()));
        draftBillIds.addAll(beChangeEntries.stream().map(e -> e.getDynamicObject("b_draftbill").getLong("id")).collect(Collectors.toList()));
        DynamicObjectCollection draftList = QueryServiceHelper.query((String)"cdm_draftbillf7", (String)"id,amount,subbillrange,subbillquantity,subbillstartflag,subbillendflag,lockedamount,usedamount,availableamount", (QFilter[])new QFilter[]{new QFilter("id", "in", draftBillIds)});
        Map<Object, Object> draftMap = new HashMap(8);
        if (EmptyUtil.isNoEmpty((DynamicObjectCollection)draftList)) {
            draftMap = draftList.stream().collect(Collectors.toMap(d -> d.getLong("id"), x -> x));
        }
        for (DynamicObject e2 : haveChangeEntries) {
            draft = (DynamicObject)draftMap.get(e2.getDynamicObject("draftbill").getLong("id"));
            if (EmptyUtil.isEmpty((DynamicObject)draft)) continue;
            e2.set("billamountfield", (Object)draft.getBigDecimal("amount"));
            e2.set("subbillrangefield", (Object)draft.getString("subbillrange"));
            e2.set("subbillquantityfield", (Object)draft.getLong("subbillquantity"));
            e2.set("subbillstartflagfield", (Object)draft.getLong("subbillstartflag"));
            e2.set("subbillendflagfield", (Object)draft.getLong("subbillendflag"));
        }
        for (DynamicObject e2 : beChangeEntries) {
            draft = (DynamicObject)draftMap.get(e2.getDynamicObject("b_draftbill").getLong("id"));
            if (EmptyUtil.isEmpty((DynamicObject)draft)) continue;
            e2.set("b_billamountfield", (Object)draft.getBigDecimal("amount"));
            e2.set("b_subbillrangefield", (Object)draft.getString("subbillrange"));
            e2.set("b_subbillquantityfield", (Object)draft.getLong("subbillquantity"));
            e2.set("b_subbillstartflagfield", (Object)draft.getLong("subbillstartflag"));
            e2.set("b_subbillendflagfield", (Object)draft.getLong("subbillendflag"));
        }
        this.getView().updateView("havechange_entry");
        this.getView().updateView("bechange_entry");
    }

    private void batchFillBeChangeBillEntry(Map<Object, Map<String, Object>> needToChangeBillMap) {
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        List draftListIds = needToChangeBillMap.keySet().stream().map(k -> Long.parseLong(k.toString())).collect(Collectors.toList());
        DynamicObject[] drafts = TmcDataServiceHelper.load((String)"cdm_draftbillf7", (String)"id,amount,draftbilltype,draftbillstatus,eledraftstatus,issplit,eledraftstatusnew,availableamount,subbillrange,subbillquantity,subbillstartflag,subbillendflag", (QFilter[])new QFilter[]{new QFilter("id", "in", draftListIds)});
        TableValueSetter vs = new TableValueSetter(new String[0]);
        vs.addField("b_draftbill", new Object[0]);
        vs.addField("b_billamt", new Object[0]);
        vs.addField("b_billamountfield", new Object[0]);
        vs.addField("b_subbillrangefield", new Object[0]);
        vs.addField("b_subbillquantityfield", new Object[0]);
        vs.addField("b_subbillstartflagfield", new Object[0]);
        vs.addField("b_subbillendflagfield", new Object[0]);
        vs.addField("b_oldstatus", new Object[0]);
        vs.addField("b_billoldelestatus", new Object[0]);
        vs.addField("b_billlogid", new Object[0]);
        vs.addField("b_tradeentryid", new Object[0]);
        Arrays.stream(drafts).filter(Objects::nonNull).forEach(draft -> {
            boolean isSplitAndEleBill = this.isSplitAndEleBill((DynamicObject)draft);
            String billEleOldStatus = isSplitAndEleBill ? draft.getString("eledraftstatusnew") : draft.getString("eledraftstatus");
            BigDecimal draftAmount = draft.getBigDecimal("amount");
            String subRange = draft.getString("subbillrange");
            long quantity = draft.getLong("subbillquantity");
            long startFlag = draft.getLong("subbillstartflag");
            long endFlag = draft.getLong("subbillendflag");
            Map dataMap = (Map)needToChangeBillMap.get(draft.getLong("id"));
            Long logId = Long.parseLong(((Object)dataMap.getOrDefault("billlogid", 0L)).toString());
            BigDecimal billamt = dataMap.getOrDefault("billamt", BigDecimal.ZERO);
            Long tradeEntryId = Long.parseLong(((Object)dataMap.getOrDefault("tradeEntryId", 0L)).toString());
            vs.addRow(new Object[]{draft.getPkValue(), billamt, draftAmount, subRange, quantity, startFlag, endFlag, draft.getString("draftbillstatus"), billEleOldStatus, logId, tradeEntryId});
        });
        model.batchCreateNewEntryRow("bechange_entry", vs);
    }

    private void batchFillHaveChangeBillEntry(List<Object> draftListIds) {
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        DynamicObject[] drafts = TmcDataServiceHelper.load((String)"cdm_draftbillf7", (String)"id,amount,draftbilltype,draftbillstatus,eledraftstatus,issplit,eledraftstatusnew,availableamount,subbillrange,subbillquantity,subbillstartflag,subbillendflag", (QFilter[])new QFilter[]{new QFilter("id", "in", draftListIds)});
        TableValueSetter vs = new TableValueSetter(new String[0]);
        vs.addField("draftbill", new Object[0]);
        vs.addField("billamt", new Object[0]);
        vs.addField("billamountfield", new Object[0]);
        vs.addField("subbillrangefield", new Object[0]);
        vs.addField("subbillquantityfield", new Object[0]);
        vs.addField("subbillstartflagfield", new Object[0]);
        vs.addField("subbillendflagfield", new Object[0]);
        vs.addField("oldstatus", new Object[0]);
        vs.addField("billoldelestatus", new Object[0]);
        Arrays.stream(drafts).filter(Objects::nonNull).forEach(draft -> {
            boolean isSplitAndEleBill = this.isSplitAndEleBill((DynamicObject)draft);
            String billEleOldStatus = isSplitAndEleBill ? draft.getString("eledraftstatusnew") : draft.getString("eledraftstatus");
            BigDecimal transAmount = draft.getBigDecimal("availableamount");
            BigDecimal draftAmount = draft.getBigDecimal("amount");
            String subRange = draft.getString("subbillrange");
            long quantity = draft.getLong("subbillquantity");
            long startFlag = draft.getLong("subbillstartflag");
            long endFlag = draft.getLong("subbillendflag");
            vs.addRow(new Object[]{draft.getPkValue(), transAmount, draftAmount, subRange, quantity, startFlag, endFlag, draft.getString("draftbillstatus"), billEleOldStatus});
        });
        model.batchCreateNewEntryRow("havechange_entry", vs);
    }

    private boolean isSplitAndEleBill(DynamicObject draftBill) {
        DynamicObject draftType = (DynamicObject)this.getModel().getValue("drafttype");
        return draftBill.getBoolean("issplit") && EmptyUtil.isNoEmpty((DynamicObject)draftType) && StringUtils.equals((CharSequence)draftType.getString("billmedium"), (CharSequence)BillMediumEnum.ELECTRIC.getValue());
    }

    private void sumDraftAmtAndCount(String entryKey) {
        boolean isHaveChange = StringUtils.equals((CharSequence)"havechange_entry", (CharSequence)entryKey);
        String draftBillKey = isHaveChange ? "draftbill" : "b_draftbill";
        String billamtKey = isHaveChange ? "billamt" : "b_billamt";
        DynamicObject tradeChangeBill = this.getModel().getDataEntity(true);
        DynamicObjectCollection entryList = tradeChangeBill.getDynamicObjectCollection(entryKey);
        BigDecimal amount = entryList.stream().filter(o -> EmptyUtil.isNoEmpty((DynamicObject)o.getDynamicObject(draftBillKey))).map(o -> o.getBigDecimal(billamtKey)).reduce(BigDecimal.ZERO, BigDecimal::add);
        int count = entryList.stream().filter(v -> EmptyUtil.isNoEmpty((DynamicObject)v.getDynamicObject(draftBillKey))).toArray().length;
        this.getModel().setValue(isHaveChange ? "havechangeamount" : "bechangeamount", (Object)amount);
        this.getModel().setValue(isHaveChange ? "havechangecount" : "bechangecount", (Object)count);
    }

    private void selectBill() {
        ListShowParameter param = ShowFormHelper.createShowListForm((String)"cdm_draftbillf7", (boolean)true, (int)2, (boolean)true);
        param.setShowTitle(false);
        param.setCustomParam("tradetype", this.getModel().getValue("tradetype"));
        param.setCaption(ResManager.loadKDString((String)"\u6536\u7968\u767b\u8bb0", (String)"TradeBillTplEdit_5", (String)"tmc-cdm-formplugin", (Object[])new Object[0]));
        param.getListFilterParameter().setQFilters(this.getDraftQFilters());
        param.setMultiSelect(true);
        param.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "selectbill"));
        this.getView().showForm((FormShowParameter)param);
    }

    private void handleTradeBillChangeData() {
        this.handleTradeBillData();
        this.handleBeChangeBillData();
    }

    private void handleTradeBillData() {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        Long pkValue = (Long)customParams.get("id");
        if (EmptyUtil.isEmpty((Long)pkValue)) {
            return;
        }
        DynamicObject tradeBill = BusinessDataServiceHelper.loadSingle((Object)pkValue, (String)"cdm_drafttradebill", (String)String.join((CharSequence)",", TradeBillChangeProp.TRADE_BILL_SELECT_PROPERTIES));
        IBillModel model = (IBillModel)this.getModel();
        model.setValue("tradetype", tradeBill.get("tradetype"));
        model.setValue("tradebillno", tradeBill.get("billno"));
        model.setValue("company", tradeBill.get("company"));
        model.setValue("drafttype", tradeBill.get("drafttype"));
        model.setValue("currency", tradeBill.get("currency"));
        model.setValue("sourcebillid", (Object)pkValue);
    }

    private void handleBeChangeBillData() {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        Map needToChangeBillMap = (Map)customParams.get("needToChangeBills");
        if (EmptyUtil.isEmpty((Object)needToChangeBillMap)) {
            return;
        }
        this.batchFillBeChangeBillEntry(needToChangeBillMap);
        this.sumDraftAmtAndCount("bechange_entry");
    }

    private List<QFilter> getDraftQFilters() {
        DraftTradeTypeEnum type = DraftTradeTypeEnum.getByValue((String)((String)this.getModel().getValue("tradetype")));
        if (EmptyUtil.isEmpty((Object)type)) {
            return null;
        }
        EndorseDraftTrade endorseDraftTrade = (EndorseDraftTrade)DraftTradeFactory.getDraftTrade((DraftTradeTypeEnum)type);
        if (EmptyUtil.isEmpty((Object)endorseDraftTrade)) {
            return null;
        }
        return endorseDraftTrade.getDraftChangeBillQFilters(this.getModel());
    }
}

