/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cdm.webapi.api;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import kd.bos.bill.IBillWebApiPlugin;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.api.ApiResult;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.StringUtils;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.cdm.webapi.bizdto.BillAvaliableDto;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;

public class BillAvailableSelectorPlugin
implements IBillWebApiPlugin {
    public ApiResult doCustomService(Map<String, Object> params) {
        ApiResult result = new ApiResult();
        result.setSuccess(true);
        try {
            DynamicObject bosOrg;
            String draftBillExpireDateStrEnd;
            String draftBillExpireDateStrStart;
            String bizDateEndStr;
            String companyName = (String)params.get("companyName");
            if (StringUtils.isEmpty((Object)companyName)) {
                result.setErrorCode("2001");
                result.setMessage(ResManager.loadKDString((String)"\u516c\u53f8\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"BillAvailableSelectorPlugin_1", (String)"tmc-cdm-webapi", (Object[])new Object[0]));
                return result;
            }
            QFilter[] qFilters = new QFilter[10];
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            String hasPool = (String)params.get("hasPool");
            String bizDateStartStr = (String)params.get("bizDateStart");
            if (!StringUtils.isEmpty((Object)bizDateStartStr)) {
                QFilter bizDateFilter;
                Date bizDateStart = dateFormat.parse(bizDateStartStr);
                qFilters[3] = bizDateFilter = new QFilter("bizdate", ">=", (Object)bizDateStart);
            }
            if (!StringUtils.isEmpty((Object)(bizDateEndStr = (String)params.get("bizDateEnd")))) {
                QFilter bizDateFilter;
                Date bizDateEnd = dateFormat.parse(bizDateEndStr);
                qFilters[4] = bizDateFilter = new QFilter("bizdate", "<", (Object)bizDateEnd);
            }
            if (!StringUtils.isEmpty((Object)(draftBillExpireDateStrStart = (String)params.get("draftBillExpireDateStart")))) {
                QFilter draftBillExpireDateFilter;
                Date draftBillExpireDateStart = dateFormat.parse(draftBillExpireDateStrStart);
                qFilters[5] = draftBillExpireDateFilter = new QFilter("draftbillexpiredate", ">=", (Object)draftBillExpireDateStart);
            }
            if (!StringUtils.isEmpty((Object)(draftBillExpireDateStrEnd = (String)params.get("draftBillExpireDateEnd")))) {
                QFilter draftBillExpireDateFilter;
                Date draftBillExpireDateEnd = dateFormat.parse(draftBillExpireDateStrEnd);
                qFilters[6] = draftBillExpireDateFilter = new QFilter("draftbillexpiredate", "<", (Object)draftBillExpireDateEnd);
            }
            if (hasPool == null) {
                hasPool = Boolean.TRUE.toString();
            }
            QFilter companyFilter = new QFilter("company", "=", (bosOrg = TmcDataServiceHelper.loadSingle((String)"bos_org", (String)"id", (QFilter[])new QFilter[]{new QFilter("name", "=", (Object)companyName)})) == null ? Integer.valueOf(0) : bosOrg.getPkValue());
            QFilter draftbillstatusFilter = new QFilter("draftbillstatus", "=", (Object)"registered");
            QFilter draftbilltranstatusFilter = new QFilter("draftbilltranstatus", "=", (Object)"success");
            qFilters[0] = companyFilter;
            qFilters[1] = draftbillstatusFilter;
            qFilters[2] = draftbilltranstatusFilter;
            ArrayList<BillAvaliableDto> entityList = new ArrayList<BillAvaliableDto>();
            this.buildResult(qFilters, entityList, "cdm_receivablebill");
            if ("1".equals(hasPool) || Boolean.TRUE.toString().equals(hasPool)) {
                this.buildResult(qFilters, entityList, "cdm_pooldraftbill_query");
            }
            if (entityList.isEmpty()) {
                result.setErrorCode("2002");
                result.setMessage(ResManager.loadKDString((String)"\u65e0\u53ef\u7528\u7968\u636e", (String)"BillAvailableSelectorPlugin_2", (String)"tmc-cdm-webapi", (Object[])new Object[0]));
            }
            result.setData(entityList);
        }
        catch (Exception e) {
            result.setErrorCode("2000");
            result.setMessage(ResManager.loadKDString((String)String.format("BillAvailableSelectorPlugin has err: %s", e.getMessage()), (String)"BillAvailableSelectorPlugin_3", (String)"tmc-cdm-webapi", (Object[])new Object[0]));
        }
        return result;
    }

    private void buildResult(QFilter[] qFilters, List<BillAvaliableDto> entityList, String entrtyName) {
        DynamicObjectCollection billpoolObjects = QueryServiceHelper.query((String)entrtyName, (String)"id", (QFilter[])qFilters);
        if (!billpoolObjects.isEmpty()) {
            DynamicObject[] billPools;
            ArrayList pkArr = new ArrayList();
            billpoolObjects.forEach(billPoolObj -> pkArr.add(billPoolObj.get("id")));
            for (DynamicObject pool : billPools = TmcDataServiceHelper.load((Object[])pkArr.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)entrtyName))) {
                BillAvaliableDto entity = new BillAvaliableDto();
                entity.setBillNo(pool.getString("billno"));
                entity.setDraftBillNo(pool.getString("draftbillno"));
                entity.setBizDate(pool.getDate("bizdate"));
                DynamicObject dynamicObject = pool.getDynamicObject("draftbilltype");
                if (dynamicObject != null) {
                    entity.setDraftbilltype(dynamicObject.getString("name"));
                }
                DynamicObjectCollection backInfoObjs = pool.getDynamicObjectCollection("endorseentry");
                ArrayList<BillAvaliableDto.BackInfoEntity> infoEntitys = new ArrayList<BillAvaliableDto.BackInfoEntity>();
                backInfoObjs.forEach(backInfoObj -> {
                    if (backInfoObj == null) {
                        return;
                    }
                    BillAvaliableDto.BackInfoEntity backInfoEntity = new BillAvaliableDto.BackInfoEntity();
                    if (backInfoObj.getDate("signdate") != null) {
                        backInfoEntity.setBizDate(backInfoObj.getDate("signdate"));
                    } else if (backInfoObj.getDate("pledgereleasedate") != null) {
                        backInfoEntity.setBizDate(backInfoObj.getDate("pledgereleasedate"));
                    }
                    backInfoEntity.setBillOpType(backInfoObj.getString("endorsetype"));
                    infoEntitys.add(backInfoEntity);
                });
                entity.setBackInfoList(infoEntitys);
                entityList.add(entity);
            }
        }
    }
}

