/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cdm.webapi.api;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.stream.Collectors;
import kd.bos.bill.IBillWebApiPlugin;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.api.ApiResult;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.StringUtils;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.cdm.webapi.bizdto.ElectronicSignDealDto;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;

public class ElectronicSignDealPlugin
implements IBillWebApiPlugin {
    public ApiResult doCustomService(Map<String, Object> params) {
        ApiResult result = new ApiResult();
        result.setSuccess(true);
        try {
            List<ElectronicSignDealDto> entityList;
            DynamicObject bosOrgForName;
            QFilter conNoFilter;
            String bankTypeNo = (String)params.get("bankTypeNo");
            String draftType = (String)params.get("draftType");
            String companyName = (String)params.get("companyName");
            String billno = (String)params.get("billNo");
            if (StringUtils.isEmpty((Object)bankTypeNo)) {
                result.setErrorCode("2001");
                result.setMessage(ResManager.loadKDString((String)"\u5fc5\u586b\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a", (String)"ElectronicSignDealPlugin_0", (String)"tmc-cdm-webapi", (Object[])new Object[0]));
                return result;
            }
            DynamicObject bankTypeDy = TmcDataServiceHelper.loadSingle((String)"bd_bankcgsetting", (String)"id", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)bankTypeNo)});
            if (bankTypeDy == null) {
                result.setErrorCode("2001");
                result.setMessage(ResManager.loadKDString((String)"\u94f6\u884c\u7c7b\u522b\u4e0d\u5b58\u5728", (String)"ElectronicSignDealPlugin_1", (String)"tmc-cdm-webapi", (Object[])new Object[0]));
                return result;
            }
            DynamicObject[] electicdiRconsetDys = TmcDataServiceHelper.load((String)"cdm_electicdirconset", (String)"id,defaultaccount", (QFilter[])new QFilter[]{new QFilter("directconnchannel", "=", bankTypeDy.getPkValue())});
            if (electicdiRconsetDys.length <= 0) {
                result.setErrorCode("2001");
                result.setMessage(ResManager.loadKDString((String)"\u94f6\u884c\u7c7b\u522b\u4e0b\u7684\u94f6\u884c\u8d26\u6237\u4e0d\u5b58\u5728", (String)"ElectronicSignDealPlugin_2", (String)"tmc-cdm-webapi", (Object[])new Object[0]));
                return result;
            }
            ArrayList<Object> accounts = new ArrayList<Object>();
            for (DynamicObject dy : electicdiRconsetDys) {
                if (dy == null) continue;
                DynamicObject bankDy = dy.getDynamicObject("defaultaccount");
                accounts.add(bankDy.get("bankaccountnumber"));
            }
            QFilter[] qFilters = new QFilter[10];
            qFilters[0] = conNoFilter = new QFilter("collectionacctext", "in", accounts);
            String companyCode = null;
            if (!StringUtils.isEmpty((Object)companyName) && (bosOrgForName = TmcDataServiceHelper.loadSingle((String)"bos_org", (String)"id", (QFilter[])new QFilter[]{new QFilter("name", "=", (Object)companyName)})) != null) {
                QFilter companyFilter;
                companyCode = String.valueOf(bosOrgForName.getPkValue());
                qFilters[1] = companyFilter = new QFilter("company", "=", bosOrgForName.getPkValue());
            }
            if (!StringUtils.isEmpty((Object)draftType)) {
                QFilter draftTypeFilter;
                qFilters[2] = draftTypeFilter = new QFilter("drafttype", "=", (Object)draftType);
            }
            if (!StringUtils.isEmpty((Object)billno)) {
                QFilter billnoFilter;
                qFilters[3] = billnoFilter = new QFilter("billno", "like", (Object)("%" + billno + "%"));
            }
            if ((entityList = this.buildResult(qFilters, "cdm_electronic_sign_deal", companyName, companyCode)).isEmpty()) {
                result.setErrorCode("2002");
                result.setMessage(ResManager.loadKDString((String)"\u65e0\u53ef\u7528\u7968\u636e", (String)"ElectronicSignDealPlugin_3", (String)"tmc-cdm-webapi", (Object[])new Object[0]));
            }
            result.setData(entityList);
        }
        catch (Exception e) {
            result.setErrorCode("2000");
            result.setMessage(ResManager.loadKDString((String)String.format("ElectronicSignDealPlugin has err: %s", e.getMessage()), (String)"ElectronicSignDealPlugin_4", (String)"tmc-cdm-webapi", (Object[])new Object[0]));
        }
        return result;
    }

    private List<ElectronicSignDealDto> buildResult(QFilter[] qFilters, String entrtyName, String companyName, String companyCode) {
        DynamicObjectCollection signObjects = QueryServiceHelper.query((String)entrtyName, (String)"id", (QFilter[])qFilters);
        List<ElectronicSignDealDto> resultList = new ArrayList<ElectronicSignDealDto>();
        if (!signObjects.isEmpty()) {
            ArrayList pkArr = new ArrayList();
            signObjects.forEach(billPoolObj -> pkArr.add(billPoolObj.get("id")));
            DynamicObject[] signDys = TmcDataServiceHelper.load((Object[])pkArr.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)entrtyName));
            ArrayList<ElectronicSignDealDto> entityList = new ArrayList<ElectronicSignDealDto>(signDys.length);
            for (DynamicObject dy : signDys) {
                ElectronicSignDealDto dealDto = new ElectronicSignDealDto();
                dealDto.setBillno(dy.getString("billno"));
                dealDto.setAcceptpromiseraccount(dy.getString("acceptpromiseraccount"));
                dealDto.setAcceptpromiseraddr(dy.getString("acceptpromiseraddr"));
                dealDto.setAcceptpromisername(dy.getString("acceptpromisername"));
                dealDto.setAmount(dy.getBigDecimal("amount"));
                dealDto.setCollectionacctext(dy.getString("collectionacctext"));
                dealDto.setCollectionbanktext(dy.getString("collectionbanktext"));
                dealDto.setCollectionertext(dy.getString("collectionertext"));
                dealDto.setCompanyName(companyName);
                dealDto.setCompanyCode(companyCode);
                DynamicObject currency = dy.getDynamicObject("currency");
                dealDto.setCurrency(currency == null ? "" : currency.getString("name"));
                dealDto.setDrafttype(dy.getString("drafttype"));
                dealDto.setExchangebillexpiredate(dy.getDate("exchangebillexpiredate"));
                dealDto.setIssuepromiseraccount(dy.getString("issuepromiseraccount"));
                dealDto.setIssuepromiseraddr(dy.getString("issuepromiseraddr"));
                dealDto.setIssuepromisername(dy.getString("issuepromisername"));
                dealDto.setIssueticketacctext(dy.getString("issueticketacctext"));
                dealDto.setIssueticketbanktext(dy.getString("issueticketbanktext"));
                dealDto.setIssueticketcreditlevel(dy.getString("issueticketcreditlevel"));
                dealDto.setIssueticketdate(dy.getDate("issueticketdate"));
                dealDto.setIssueticketertext(dy.getString("issueticketertext"));
                dealDto.setIssueticketexpiredate(dy.getDate("issueticketexpiredate"));
                dealDto.setIssueticketgrade(dy.getString("issueticketgrade"));
                dealDto.setIstransfer(dy.getString("istransfer"));
                dealDto.setPromisecreditlevel(dy.getString("promisecreditlevel"));
                dealDto.setPromisedate(dy.getDate("promisedate"));
                dealDto.setPromiseexpiredate(dy.getDate("promiseexpiredate"));
                dealDto.setPromisegrade(dy.getString("promisegrade"));
                dealDto.setPromiseinfo(dy.getString("promiseinfo"));
                dealDto.setPromiseracctext(dy.getString("promiseracctext"));
                dealDto.setPromiserbankno(dy.getString("promiserbankno"));
                dealDto.setPromiserbanktext(dy.getString("promiserbanktext"));
                dealDto.setPromisertext(dy.getString("promisertext"));
                dealDto.setTicketstatus(dy.getString("ticketstatus"));
                dealDto.setTradecontractno(dy.getString("tradecontractno"));
                DynamicObjectCollection entrys = dy.getDynamicObjectCollection("entryentity");
                if (entrys != null && !entrys.isEmpty()) {
                    ArrayList<ElectronicSignDealDto.BackInfoEntity> backInfoEntities = new ArrayList<ElectronicSignDealDto.BackInfoEntity>();
                    for (DynamicObject entry : entrys) {
                        backInfoEntities.add(this.backInfoBuild(entry));
                    }
                    dealDto.setBackInfoList(backInfoEntities);
                }
                entityList.add(dealDto);
                if (entityList.isEmpty()) continue;
                resultList = entityList.stream().collect(Collectors.collectingAndThen(Collectors.toCollection(() -> new TreeSet<ElectronicSignDealDto>(Comparator.comparing(ElectronicSignDealDto::getBillno))), ArrayList::new));
            }
        }
        return resultList;
    }

    private ElectronicSignDealDto.BackInfoEntity backInfoBuild(DynamicObject entry) {
        if (entry == null) {
            return null;
        }
        ElectronicSignDealDto.BackInfoEntity bacnkInfo = new ElectronicSignDealDto.BackInfoEntity();
        bacnkInfo.setBusinesscode(entry.getString("businesscode"));
        bacnkInfo.setInitiatorbankcnaps(entry.getString("initiatorbankcnaps"));
        bacnkInfo.setInitiatorname(entry.getString("initiatorname"));
        bacnkInfo.setOpponentbankcnaps(entry.getString("opponentbankcnaps"));
        bacnkInfo.setOpponentname(entry.getString("opponentname"));
        bacnkInfo.setSigndate(entry.getString("signdate"));
        bacnkInfo.setSubtype(entry.getString("subtype"));
        return bacnkInfo;
    }
}

