/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.pbd.plugin;

import java.sql.ResultSet;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.entity.datamodel.events.IDataModelChangeListener;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Toolbar;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.ItemClickListener;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.StringUtils;

public abstract class DrpUserAssignBasePlugin
extends AbstractFormPlugin
implements BeforeF7SelectListener,
IDataModelChangeListener {
    private static final String F_FID = "id";
    private static final String F_user = "user";
    private static final String F_drpusertype = "drpusertype";
    private static final String F_usertype = "usertype";
    private static final String F_drpcustomer = "drpcustomer";
    private static final String F_bizpartneruserid = "bizpartneruserid";
    private static final String F_loginorg = "loginorg";
    private static final String F_issalemanager = "issalemanager";
    private static final String BARITEM_SAVE = "baritem_save";
    private static final String DEFAULTVALUE_DRPUSERTYPE_COMMONUSER = "1";
    private static final String FORMID_DRP_USERGROUP_USER = "drp_usergroup_user";
    private static final String ID_SYSTEM_USER_TYPE_USER = "1";
    private static final String ID_SYSTEM_USER_TYPE_CUSTOMER = "2";
    private static final String ID_SYSTEM_USER_TYPE_CHANNEL = "4";
    private static final String ID_SYSTEM_USER_TYPE_DOT = "6";
    private static final String ENTRYFIELD_DIM_NUM = "dim_num";
    private static final String ENTRYFIELD_DIM_NAME = "dim_name";
    private static final String ENTRYFIELD_DIM_ENTITYNUM = "dimentitynum";
    protected static final String CUSTOM_QFILTER_DIMOBJ = "CustomQFilter_DimObjIds";
    protected static final String CUSTOM_QFILTER_USER = "CustomQFilter_UserIds";
    protected static final String CUSTOM_QFILTER_ROLE = "CustomQFilter_RoleIds";

    public void initialize() {
        super.initialize();
        Toolbar toolbarMain = this.getToolbar();
        if (toolbarMain != null) {
            toolbarMain.addItemClickListener(new ItemClickListener(){

                public void itemClick(ItemClickEvent evt) {
                    String itemKey = evt.getItemKey();
                    if (itemKey.equals(DrpUserAssignBasePlugin.BARITEM_SAVE)) {
                        DrpUserAssignBasePlugin.this.save();
                    }
                }
            });
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        DynamicObject drpCustomer = this.getF7Value(F_drpcustomer);
        if (drpCustomer != null) {
            this.getView().setEnable(Boolean.FALSE, new String[]{F_drpcustomer});
        } else {
            this.getView().setEnable(Boolean.TRUE, new String[]{F_drpcustomer});
        }
        String userType = String.valueOf(this.getValue(F_usertype));
        if (userType.contains(ID_SYSTEM_USER_TYPE_CUSTOMER) || userType.contains(ID_SYSTEM_USER_TYPE_CHANNEL)) {
            this.getView().setVisible(Boolean.TRUE, new String[]{F_drpcustomer});
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{F_drpcustomer});
        }
        if (StringUtils.isNotEmpty((String)userType)) {
            this.setCustomerDimObjIds(String.valueOf(this.getValue(F_usertype)), drpCustomer != null ? drpCustomer.getLong(F_FID) : 0L);
        }
        QFilter userTypeFilter = new QFilter(F_usertype, "=", (Object)"1").or(new QFilter(F_usertype, "like", (Object)"%2%")).or(new QFilter(F_usertype, "like", (Object)"%4%")).or(new QFilter(F_usertype, "=", (Object)ID_SYSTEM_USER_TYPE_DOT));
        this.getPageCache().put(CUSTOM_QFILTER_USER, userTypeFilter.toSerializedString());
    }

    private void setCustomerDimObjIds(String userType, long drpCusotmerId) {
        if (userType.contains(ID_SYSTEM_USER_TYPE_CUSTOMER) || userType.contains(ID_SYSTEM_USER_TYPE_CHANNEL)) {
            if (drpCusotmerId > 0L) {
                String longId = BusinessDataServiceHelper.loadSingleFromCache((Object)drpCusotmerId, (String)"mdr_customer", (String)"longid").getString("longid");
                this.getPageCache().put(CUSTOM_QFILTER_DIMOBJ, new QFilter("longid", "like", (Object)(longId + "%")).toSerializedString());
            } else {
                this.getPageCache().put(CUSTOM_QFILTER_DIMOBJ, new QFilter(F_FID, "=", (Object)0L).toSerializedString());
            }
        } else {
            this.getPageCache().put(CUSTOM_QFILTER_DIMOBJ, new QFilter(F_FID, "in", ((HashSet)BaseDataServiceHelper.getBaseDataFilter((String)"mdr_customer", (Long)RequestContext.get().getOrgId()).getValue()).stream().map(r -> String.valueOf(r)).collect(Collectors.toList())).toSerializedString());
        }
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        DynamicObject user = this.getF7Value(F_user);
        if (user != null && user.getLong(F_FID) > 0L) {
            long drpCustomerId;
            Map<String, Object> drpUser = this.queryDrpUserInfo(user.get(F_FID));
            if (drpUser.get("FDRPUSERTYPE") != null && StringUtils.isNotEmpty((String)drpUser.get("FDRPUSERTYPE").toString())) {
                this.setValue(F_drpusertype, drpUser.get("FDRPUSERTYPE"));
            } else {
                this.setValue(F_drpusertype, "1");
            }
            this.setValue(F_issalemanager, drpUser.get("FISSALEMANAGER"));
            this.setValue(F_usertype, drpUser.get("FUSERTYPE"));
            this.setValue(F_bizpartneruserid, drpUser.get("FBIZPARTERUSERID") == null ? Long.valueOf(0L) : drpUser.get("FBIZPARTERUSERID"));
            this.setValue(F_loginorg, RequestContext.get().getOrgId());
            if (drpUser.get("FCUSTOMERINFOID") != null && (drpCustomerId = Long.parseLong(drpUser.get("FCUSTOMERINFOID").toString())) > 0L) {
                this.setValue(F_drpcustomer, drpCustomerId);
                if (this.getModel().getEntryRowCount(this.getLeftEntryControlKey()) == 0) {
                    int curIndex = this.getModel().createNewEntryRow(this.getLeftEntryControlKey());
                    this.getModel().setValue(this.getDimIdentityControlKey(), (Object)drpCustomerId, curIndex);
                    this.getModel().setValue(ENTRYFIELD_DIM_ENTITYNUM, (Object)"mdr_customer", curIndex);
                    this.getModel().setValue(ENTRYFIELD_DIM_NUM, (Object)drpCustomerId, curIndex);
                    DynamicObject drpCustomer = BusinessDataServiceHelper.loadSingleFromCache((Object)drpCustomerId, (String)"mdr_customer", (String)"name");
                    if (drpCustomer != null) {
                        this.getModel().setValue(ENTRYFIELD_DIM_NAME, drpCustomer.get("name"), curIndex);
                    }
                    this.selectDimObjListRow(0);
                }
            }
        }
    }

    private Map<String, Object> queryDrpUserInfo(Object userId) {
        StringBuilder sql = new StringBuilder();
        sql.append("SELECT T1.FID FUSERID,T1.FUSERTYPE,T2.FDRPUSERTYPE,T2.FISSALEMANAGER,T3.FID FBIZPARTERUSERID,T4.FCUSTOMERINFOID\t ");
        sql.append("FROM T_SEC_USER T1 ");
        sql.append("LEFT JOIN T_SEC_USER_D T2 ON T1.FID = T2.FID ");
        sql.append("LEFT JOIN T_SEC_BIZPARTNERUSER T3 ON T1.FID = T3.FUSERID ");
        sql.append("LEFT JOIN T_SEC_BIZPARTNERUSER_C T4 ON T3.FID = T4.FID ");
        sql.append("WHERE T1.FID = ? ");
        return (Map)DB.query((DBRoute)DBRoute.of((String)"sys"), (String)sql.toString(), (Object[])new Object[]{userId}, (ResultSetHandler)new ResultSetHandler<Map<String, Object>>(){

            public Map<String, Object> handle(ResultSet rs) throws Exception {
                HashMap<String, Object> result = new HashMap<String, Object>(6);
                while (rs.next()) {
                    result.put("FUSERID", rs.getObject("FUSERID"));
                    result.put("FUSERTYPE", rs.getObject("FUSERTYPE"));
                    result.put("FDRPUSERTYPE", rs.getObject("FDRPUSERTYPE"));
                    result.put("FISSALEMANAGER", rs.getObject("FISSALEMANAGER"));
                    result.put("FBIZPARTERUSERID", rs.getObject("FBIZPARTERUSERID"));
                    result.put("FCUSTOMERINFOID", rs.getObject("FCUSTOMERINFOID"));
                }
                return result;
            }
        });
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addF7Listener(this, F_user, F_drpcustomer);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String key;
        super.propertyChanged(e);
        switch (key = e.getProperty().getName()) {
            case "user": {
                DynamicObject user = this.getF7Value(F_user);
                if (user != null && user.getLong(F_FID) > 0L) {
                    Map<String, Object> drpUser = this.queryDrpUserInfo(user.get(F_FID));
                    if (drpUser.get("FDRPUSERTYPE") != null && StringUtils.isNotEmpty((String)drpUser.get("FDRPUSERTYPE").toString())) {
                        this.setValue(F_drpusertype, drpUser.get("FDRPUSERTYPE"));
                    } else {
                        this.setValue(F_drpusertype, "1");
                    }
                    this.setValue(F_issalemanager, drpUser.get("FISSALEMANAGER"));
                    this.setValue(F_usertype, drpUser.get("FUSERTYPE"));
                    this.setValue(F_bizpartneruserid, drpUser.get("FBIZPARTERUSERID") == null ? Long.valueOf(0L) : drpUser.get("FBIZPARTERUSERID"));
                    this.setValue(F_loginorg, RequestContext.get().getOrgId());
                    if (drpUser.get("FCUSTOMERINFOID") != null) {
                        long drpCustomerId = Long.parseLong(drpUser.get("FCUSTOMERINFOID").toString());
                        if (drpCustomerId > 0L) {
                            this.setValue(F_drpcustomer, drpCustomerId);
                            if (this.getModel().getEntryRowCount(this.getLeftEntryControlKey()) == 0) {
                                int curIndex = this.getModel().createNewEntryRow(this.getLeftEntryControlKey());
                                this.getModel().setValue(this.getDimIdentityControlKey(), (Object)drpCustomerId, curIndex);
                                this.getModel().setValue(ENTRYFIELD_DIM_ENTITYNUM, (Object)"mdr_customer", curIndex);
                                this.getModel().setValue(ENTRYFIELD_DIM_NUM, (Object)drpCustomerId, curIndex);
                                DynamicObject drpCustomer = BusinessDataServiceHelper.loadSingleFromCache((Object)drpCustomerId, (String)"mdr_customer", (String)"name");
                                if (drpCustomer != null) {
                                    this.getModel().setValue(ENTRYFIELD_DIM_NAME, drpCustomer.get("name"), curIndex);
                                }
                                this.selectDimObjListRow(0);
                            }
                            this.getView().setEnable(Boolean.FALSE, new String[]{F_drpcustomer});
                        }
                    } else {
                        this.getView().setEnable(Boolean.TRUE, new String[]{F_drpcustomer});
                    }
                    String userType = String.valueOf(drpUser.get("FUSERTYPE"));
                    if (userType.contains(ID_SYSTEM_USER_TYPE_CUSTOMER) || userType.contains(ID_SYSTEM_USER_TYPE_CHANNEL)) {
                        this.getView().setVisible(Boolean.TRUE, new String[]{F_drpcustomer});
                        break;
                    }
                    this.getView().setVisible(Boolean.FALSE, new String[]{F_drpcustomer});
                    break;
                }
                this.setValue(F_drpusertype, "1");
                this.setValue(F_issalemanager, Boolean.FALSE);
                this.setValue(F_usertype, "");
                this.setValue(F_bizpartneruserid, 0L);
                this.setValue(F_drpcustomer, null);
                this.setValue(F_loginorg, RequestContext.get().getOrgId());
                this.getView().setEnable(Boolean.FALSE, new String[]{F_drpcustomer});
                this.getView().setVisible(Boolean.FALSE, new String[]{F_drpcustomer});
                break;
            }
            case "drpcustomer": {
                DynamicObject drpCustomer = this.getF7Value(F_drpcustomer);
                if (drpCustomer != null) {
                    this.getView().setEnable(Boolean.FALSE, new String[]{F_drpcustomer});
                } else {
                    this.getView().setEnable(Boolean.TRUE, new String[]{F_drpcustomer});
                }
                String userType = String.valueOf(this.getValue(F_usertype));
                if (!StringUtils.isNotEmpty((String)userType) || drpCustomer == null) break;
                this.setCustomerDimObjIds(userType, drpCustomer.getLong(F_FID));
            }
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        String key;
        switch (key = e.getProperty().getName()) {
            case "user": {
                QFilter userTypeFilter = new QFilter(F_usertype, "=", (Object)"1").or(new QFilter(F_usertype, "like", (Object)"%2%")).or(new QFilter(F_usertype, "like", (Object)"%4%")).or(new QFilter(F_usertype, "=", (Object)ID_SYSTEM_USER_TYPE_DOT));
                ((ListShowParameter)e.getFormShowParameter()).getListFilterParameter().setFilter(userTypeFilter);
            }
        }
    }

    protected void save() {
        DynamicObject drpUser;
        DynamicObject user = this.getF7Value(F_user);
        if (user != null && user.getLong(F_FID) > 0L && (drpUser = BusinessDataServiceHelper.loadSingle((Object)user.getPkValue(), (String)FORMID_DRP_USERGROUP_USER)) != null) {
            drpUser.set(F_drpusertype, this.getValue(F_drpusertype));
            drpUser.set(F_issalemanager, this.getValue(F_issalemanager));
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{drpUser});
        }
        DynamicObject drpCustomer = this.getF7Value(F_drpcustomer);
        long bizPartnerUserId = Long.parseLong(this.getValue(F_bizpartneruserid).toString());
        if (bizPartnerUserId > 0L && drpCustomer != null) {
            this.saveDrpCustomerUserC(bizPartnerUserId, drpCustomer.getLong(F_FID));
        }
    }

    private void saveDrpCustomerUserC(final long bizPartnerUserId, final long customerId) {
        if (bizPartnerUserId > 0L && customerId > 0L) {
            DB.query((DBRoute)DBRoute.of((String)"sys"), (String)"SELECT FCUSTOMERINFOID FROM T_SEC_BIZPARTNERUSER_C WHERE FID = ?", (Object[])new Object[]{bizPartnerUserId}, (ResultSetHandler)new ResultSetHandler<Map<String, Object>>(){

                public Map<String, Object> handle(ResultSet rs) throws Exception {
                    if (!rs.next()) {
                        DB.execute((DBRoute)DBRoute.of((String)"sys"), (String)"INSERT INTO T_SEC_BIZPARTNERUSER_C(FID,FCUSTOMERINFOID)VALUES(?,?)", (Object[])new Object[]{bizPartnerUserId, customerId});
                    }
                    return null;
                }
            });
        }
    }

    protected void addF7Listener(BeforeF7SelectListener form, String ... f7Name) {
        BasedataEdit f7 = null;
        int len = f7Name.length;
        for (int i = 0; i < len; ++i) {
            f7 = (BasedataEdit)this.getControl(f7Name[i]);
            if (f7 == null) continue;
            f7.addBeforeF7SelectListener(form);
        }
    }

    protected DynamicObject getF7Value(String f7Name) {
        return this.getModel().getDataEntity().getDynamicObject(f7Name);
    }

    protected Object getValue(String key) {
        return this.getModel().getValue(key);
    }

    protected void setValue(String key, Object value) {
        this.getModel().setValue(key, value);
    }

    protected abstract Toolbar getToolbar();

    private void selectDimObjListRow(int rowIndex) {
        EntryGrid eg = (EntryGrid)this.getControl(this.getLeftEntryControlKey());
        int entryCount = this.getModel().getEntryRowCount(this.getLeftEntryControlKey());
        if (entryCount == 0 || rowIndex + 1 > entryCount) {
            return;
        }
        eg.selectRows(rowIndex);
        eg.getEntryState().selectRow(rowIndex);
        eg.getEntryState().setFocusRow(rowIndex);
        eg.entryRowClick(Integer.valueOf(rowIndex));
    }

    protected abstract String getLeftEntryControlKey();

    protected abstract String getDimIdentityControlKey();
}

