/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.pbd.plugin.edit;

import java.util.Collection;
import java.util.EventObject;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bd.pbd.SupplierGradeModel;
import kd.bd.pbd.mservice.PbdSupplierGradeServiceImp;
import kd.bos.base.AbstractBasePlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.logging.BizLog;
import kd.bos.orm.util.CollectionUtils;

public class PbdSupGradeEdit
extends AbstractBasePlugIn {
    PbdSupplierGradeServiceImp supplierGradeService = new PbdSupplierGradeServiceImp();

    public void beforeBindData(EventObject e) {
        List historyGrade;
        super.afterBindData(e);
        DynamicObject dataEntity = this.getModel().getDataEntity();
        Long orgid = dataEntity.getLong("createorg.id");
        Long bdsupplierid = dataEntity.getLong("bdsupplier.id");
        DynamicObjectCollection dynamicObjects = this.supplierGradeService.queryGrade(orgid, bdsupplierid, this.getModel().getDataEntityType().getName());
        if (!CollectionUtils.isEmpty((Collection)dynamicObjects)) {
            this.initEntry(dynamicObjects, "entry");
        }
        if (!CollectionUtils.isEmpty((Collection)(historyGrade = this.supplierGradeService.queryHistoryGrade(orgid, bdsupplierid)))) {
            historyGrade.sort((x, y) -> {
                if (Objects.nonNull(y.getDateform()) && Objects.nonNull(x.getDateform())) {
                    return y.getDateform().compareTo(x.getDateform());
                }
                return 0;
            });
            this.initHistoryEntry(historyGrade, "entryold");
        }
    }

    private void initEntry(DynamicObjectCollection supgradeData, String entryName) {
        this.getModel().beginInit();
        this.getModel().deleteEntryData(entryName);
        if (!CollectionUtils.isEmpty((Collection)supgradeData)) {
            TableValueSetter vs = new TableValueSetter(new String[0]);
            DataEntityPropertyCollection properties = this.getModel().getDataEntity(Boolean.TRUE.booleanValue()).getDynamicObjectCollection(entryName).getDynamicObjectType().getProperties();
            List props = properties.stream().map(x -> x.getName()).collect(Collectors.toList());
            for (int i = 0; i < supgradeData.size(); ++i) {
                DynamicObject supgrade = (DynamicObject)supgradeData.get(i);
                List supgradeNames = supgrade.getDataEntityType().getProperties().stream().map(x -> x.getName()).collect(Collectors.toList());
                for (String prop : props) {
                    Object value;
                    if ("seq".equals(prop)) {
                        vs.set("seq", (Object)(i + 1), i);
                        continue;
                    }
                    if (!prop.contains(entryName) || !supgradeNames.contains(prop) || !Objects.nonNull(value = supgrade.get(prop))) continue;
                    vs.set(prop, value, i);
                }
            }
            ((AbstractFormDataModel)this.getModel()).batchCreateNewEntryRow(entryName, vs);
            this.getModel().endInit();
        } else {
            BizLog.log((String)" initEntry gradeData is null");
        }
    }

    private void initHistoryEntry(List<SupplierGradeModel> supplierGradeModels, String entryName) {
        this.getModel().beginInit();
        this.getModel().deleteEntryData(entryName);
        TableValueSetter vs = new TableValueSetter(new String[0]);
        DataEntityPropertyCollection properties = this.getModel().getDataEntity(Boolean.TRUE.booleanValue()).getDynamicObjectCollection(entryName).getDynamicObjectType().getProperties();
        List props = properties.stream().map(x -> x.getName()).collect(Collectors.toList());
        for (int i = 0; i < supplierGradeModels.size(); ++i) {
            SupplierGradeModel supplierGradeModel = supplierGradeModels.get(i);
            for (String prop : props) {
                if ("seq".equals(prop)) {
                    vs.set("seq", (Object)(i + 1), i);
                    continue;
                }
                Object value = this.supplierGradeService.propMapGradeModel(prop, supplierGradeModel);
                if (!Objects.nonNull(value)) continue;
                vs.set(prop, value, i);
            }
        }
        ((AbstractFormDataModel)this.getModel()).batchCreateNewEntryRow(entryName, vs);
        this.getModel().endInit();
    }
}

