/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.pbd.plugin.list;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.plugin.StandardTreeListPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;

public class DrpUserGroupTreeList
extends StandardTreeListPlugin {
    private static final String OP_ADD_CUSTOMER_USER = "addcustomeruser";
    private static final String OP_ADD_MARKET_USER = "addmarketuser";
    private static final String OP_UPDATE_DRP_CUSTOMER_ADMIN = "updatedrpcustomeradmin";
    private static final String OP_UPDATE_DRP_CUSTOMER_USER = "updatedrpcustomeruser";
    private static final String OP_REFRESH = "refresh";
    private static final String FORMID_CUSTOMER_USER = "drp_customer_user";
    private static final String FORMID_MARKET_USER = "drp_market_user";
    private static final String FORMID_DRP_CUSTOMER = "mdr_customer";
    private static final String FORMID_DRP_USER = "dbd_drp_user";
    private static final String FORMID_DRP_CUSTOMER_ADMIN = "dbd_customer_admin";
    private static final String FSP_SHOWFORSPECIAL = "FormShowParam_ShowForSpecialUser";
    private static final String FSP_DIM = "FormShowParam_dimension";
    private static final String FSP_FORMNAME_ASSIGNROLE = "formShowParam_formName_assignRole";
    private static final String FSP_FORMNAME_ASSIGNPERM = "formShowParam_formName_assignPerm";
    private static final String FSP_CTRLTYPE_NAME = "FormShowParam_CtrlType_Name";
    private static final String FSP_DIMOBJIDS = "FormShowParam_dimensionObjIds";
    private static final String FSP_HIDE_FIELDPERMTAB = "FormShowParam_Hide_FieldPermTab";
    private static final String FSP_HIDE_DATAPERMTAB = "FormShowParam_Hide_DataPermTab";
    private static final String ROLE_DRPCUSTOMERADMIN_ID = "0K9C0OY=N6LU";
    private static final String ROLE_MALLUSER_ID = "/BC33IELP+WA";

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String key;
        super.beforeDoOperation(args);
        switch (key = ((AbstractOperate)args.getSource()).getOperateKey()) {
            case "addcustomeruser": {
                this.showAddNewPage(FORMID_CUSTOMER_USER, ShowType.Modal);
                break;
            }
            case "addmarketuser": {
                this.showAddNewPage(FORMID_MARKET_USER, ShowType.MainNewTabPage);
                break;
            }
            case "updatedrpcustomeradmin": {
                this.updateDrpCustomerAdmin();
                break;
            }
            case "updatedrpcustomeruser": {
                this.updateDrpCustomerUser();
                break;
            }
        }
    }

    private void showAddNewPage(String formId, ShowType showType) {
        BillShowParameter parameter = new BillShowParameter();
        parameter.getOpenStyle().setShowType(showType);
        parameter.setFormId(formId);
        parameter.setStatus(OperationStatus.ADDNEW);
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, OP_REFRESH));
        this.getView().showForm((FormShowParameter)parameter);
    }

    public void setFilter(SetFilterEvent e) {
        QFilter userTypeFilter = new QFilter("usertype", "=", (Object)"1").or(new QFilter("usertype", "like", (Object)"%2%")).or(new QFilter("usertype", "like", (Object)"%4%")).or(new QFilter("usertype", "=", (Object)"6"));
        e.getQFilters().add(userTypeFilter);
    }

    public void preOpenForm(PreOpenFormEventArgs e) {
        super.preOpenForm(e);
        e.getFormShowParameter().setCustomParam(FSP_SHOWFORSPECIAL, (Object)"true");
        e.getFormShowParameter().setCustomParam(FSP_DIM, (Object)"DIM_CUSTOMER");
        e.getFormShowParameter().setCustomParam(FSP_FORMNAME_ASSIGNROLE, (Object)"perm_user_assignrole_drp");
        e.getFormShowParameter().setCustomParam(FSP_FORMNAME_ASSIGNPERM, (Object)"perm_user_assignperm_drp");
        e.getFormShowParameter().setCustomParam(FSP_CTRLTYPE_NAME, (Object)ResManager.loadKDString((String)"\u6e20\u9053", (String)"DrpUserGroupTreeList_0", (String)"bd-pbd-formplugin", (Object[])new Object[0]));
        e.getFormShowParameter().setCustomParam(FSP_HIDE_FIELDPERMTAB, (Object)"true");
        e.getFormShowParameter().setCustomParam(FSP_HIDE_DATAPERMTAB, (Object)"true");
    }

    private void updateDrpCustomerAdmin() {
        DynamicObjectCollection drpCustomerAdmins = QueryServiceHelper.query((String)FORMID_DRP_CUSTOMER_ADMIN, (String)"customer,user", (QFilter[])new QFilter[0]);
        Map customerIdsInAdmin = drpCustomerAdmins.stream().collect(Collectors.groupingBy(r -> r.getLong("user"), Collectors.mapping(r -> r.getLong("customer"), Collectors.toList())));
        DynamicObjectCollection permRoles = QueryServiceHelper.query((String)"perm_userrole", (String)"user,org", (QFilter[])new QFilter[]{new QFilter("dimtype", "=", (Object)FORMID_DRP_CUSTOMER), new QFilter("role", "=", (Object)ROLE_DRPCUSTOMERADMIN_ID)});
        ArrayList<DynamicObject> userRoleNewObjList = new ArrayList<DynamicObject>();
        Map customerIdsInUserHavePerm = permRoles.stream().collect(Collectors.groupingBy(r -> r.getLong("user"), Collectors.mapping(r -> r.getLong("org"), Collectors.toList())));
        for (Map.Entry customerIdsInUserHavePermEntry : customerIdsInAdmin.entrySet()) {
            Long userId = customerIdsInUserHavePermEntry.getKey();
            List drpCustomerIds = customerIdsInUserHavePermEntry.getValue();
            List customerIdsHavePerm = customerIdsInUserHavePerm.get(userId);
            if (customerIdsHavePerm != null) {
                drpCustomerIds.removeAll(customerIdsHavePerm);
            }
            if (CollectionUtils.isEmpty(drpCustomerIds)) continue;
            for (Long drpCustomerId : drpCustomerIds) {
                userRoleNewObjList.add(this.createUserRoleNewObj(userId, drpCustomerId, ROLE_DRPCUSTOMERADMIN_ID));
            }
        }
        if (!CollectionUtils.isEmpty(userRoleNewObjList)) {
            SaveServiceHelper.save((IDataEntityType)((DynamicObject)userRoleNewObjList.get(0)).getDataEntityType(), (Object[])userRoleNewObjList.toArray());
        }
        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u6e20\u9053\u7ba1\u7406\u5458\u5386\u53f2\u6570\u636e\u5347\u7ea7\u5b8c\u6210\uff01", (String)"DrpUserGroupTreeList_1", (String)"bd-pbd-formplugin", (Object[])new Object[0]));
    }

    private void updateDrpCustomerUser() {
        DynamicObjectCollection drpCustomerUsers = QueryServiceHelper.query((String)FORMID_DRP_USER, (String)"owner,sysuser", (QFilter[])new QFilter[0]);
        Map customerIdsInUser = drpCustomerUsers.stream().collect(Collectors.groupingBy(r -> r.getLong("sysuser"), Collectors.mapping(r -> r.getLong("owner"), Collectors.toList())));
        DynamicObjectCollection permRoles = QueryServiceHelper.query((String)"perm_userrole", (String)"user,org", (QFilter[])new QFilter[]{new QFilter("dimtype", "=", (Object)FORMID_DRP_CUSTOMER), new QFilter("role", "=", (Object)ROLE_MALLUSER_ID)});
        ArrayList<DynamicObject> userRoleNewObjList = new ArrayList<DynamicObject>();
        Map customerIdsInUserHavePerm = permRoles.stream().collect(Collectors.groupingBy(r -> r.getLong("user"), Collectors.mapping(r -> r.getLong("org"), Collectors.toList())));
        for (Map.Entry customerIdsInUserHavePermEntry : customerIdsInUser.entrySet()) {
            Long userId = customerIdsInUserHavePermEntry.getKey();
            List drpCustomerIds = customerIdsInUserHavePermEntry.getValue();
            List customerIdsHavePerm = customerIdsInUserHavePerm.get(userId);
            if (customerIdsHavePerm != null) {
                drpCustomerIds.removeAll(customerIdsHavePerm);
            }
            if (CollectionUtils.isEmpty(drpCustomerIds)) continue;
            for (Long drpCustomerId : drpCustomerIds) {
                userRoleNewObjList.add(this.createUserRoleNewObj(userId, drpCustomerId, ROLE_MALLUSER_ID));
            }
        }
        if (!CollectionUtils.isEmpty(userRoleNewObjList)) {
            SaveServiceHelper.save((IDataEntityType)((DynamicObject)userRoleNewObjList.get(0)).getDataEntityType(), (Object[])userRoleNewObjList.toArray());
        }
        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u6e20\u9053\u7528\u6237\u5386\u53f2\u6570\u636e\u5347\u7ea7\u5b8c\u6210\uff01", (String)"DrpUserGroupTreeList_2", (String)"bd-pbd-formplugin", (Object[])new Object[0]));
    }

    private DynamicObject createUserRoleNewObj(Object userId, Object mdrCustomerId, Object roleId) {
        DynamicObject userRoleNewObj = BusinessDataServiceHelper.newDynamicObject((String)"perm_userrole");
        userRoleNewObj.set("org", mdrCustomerId);
        userRoleNewObj.set("role", roleId);
        userRoleNewObj.set("user", userId);
        userRoleNewObj.set("dimtype", (Object)FORMID_DRP_CUSTOMER);
        userRoleNewObj.set("source", (Object)"2");
        return userRoleNewObj;
    }
}

