/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.assistant.service;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import kd.bd.assistant.api.IBaseData;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.org.OrgServiceHelper;

public class BaseDataService
implements IBaseData {
    public static final String DEFAULTCTRLSTRATEGY_ENTITYID = "bd_bddefctrlstrtgy";
    public static final String BDCTRLSTRTGY_ENTITYID = "bd_bdctrlstrtgy";
    public static final String ORG_ENTITYID = "bos_org";
    public static final String ORGVIEW_ENTITYID = "bos_orgviewdata";
    public static final String ORGBIZ_ENTITYID = "bos_org_biz";
    public static final String MANAGESTRATEGY_CREATEORG = "2";
    public static final String MANAGESTRATEGY_CU = "1";
    public static final String CTRLSTRATEGY_CU_ASSIGN = "1";
    public static final String CTRLSTRATEGY_CU_FREE_ASSIGN = "2";
    public static final String CTRLSTRATEGY_OU_ASSIGN = "3";
    public static final String CTRLSTRATEGY_OU_FREE_ASSIGN = "4";
    public static final String CTRLSTRATEGY_GLOBAL_SHARE = "5";
    public static final String CTRLSTRATEGY_CU_SHARE = "6";
    public static final String CTRLSTRATEGY_PRIVATE = "7";
    public static final String BASEDATAUSEREGSUFFIX = "UseReg";
    public static final String BASEDATAEXCSUFFIX = "Exc";
    public static final String ENTITYID_WORKCALENDAR = "bd_workcalendar";

    public String getBaseDataFilter(String entityID, Long orgID) {
        StringBuilder filterStr = new StringBuilder(200);
        String dataBaseUsingTableName = this.getDataBaseUsingTableName();
        String usingOrgFieldName = this.getUsingOrgFieldName();
        String dataBaseFieldName = this.getDataBaseFieldName();
        filterStr.append("select ").append(dataBaseFieldName).append(" from ").append(dataBaseUsingTableName).append(" where ").append(usingOrgFieldName).append(" = ").append(orgID);
        return filterStr.toString();
    }

    protected String getDataBaseFieldName() {
        String dataBaseFieldName = "FDataID";
        return dataBaseFieldName;
    }

    protected String getUsingOrgFieldName() {
        String usingOrgFieldName = "ForgID";
        return usingOrgFieldName;
    }

    protected String getDataBaseUsingTableName() {
        String dataBaseUsingTableName = "T_BD_MaterialPurchasUse";
        return dataBaseUsingTableName;
    }

    public void batchAssign(String entityID, Long[] dataIDs, Long[] orgIDs) {
    }

    public void batchUnAssign(String entityID, Long[] dataIDs, Long[] orgIDs) {
    }

    public void baseDataAddnewHandler(DynamicObject dataInfo, Long orgID) {
        DynamicObject bdctrlstrtgy;
        if (dataInfo == null) {
            return;
        }
        ArrayList<Long> useOrgList = new ArrayList<Long>();
        DynamicObject createOrg = (DynamicObject)dataInfo.get("createorg");
        if (createOrg != null) {
            orgID = (Long)createOrg.getPkValue();
        }
        if ((bdctrlstrtgy = this.getCtrlStrtgy(dataInfo)) == null) {
            DynamicObject defaultCtrlStrtgy = this.getDefaultCtrlStrtgy(dataInfo);
            if (defaultCtrlStrtgy == null) {
                return;
            }
            String defaultctrlstrategy = defaultCtrlStrtgy.getString("defaultctrlstrategy");
            if (CTRLSTRATEGY_PRIVATE.equals(defaultctrlstrategy) && createOrg != null) {
                useOrgList.add((Long)createOrg.getPkValue());
            }
        } else {
            DynamicObject manageOrg = this.getManageOrg(dataInfo);
            List entrys = (List)bdctrlstrtgy.get("entryentity");
            DynamicObject entry = (DynamicObject)entrys.get(0);
            String ctrlstrategy = (String)entry.get("ctrlstrategy");
            if ("1".equals(ctrlstrategy) || "2".equals(ctrlstrategy)) {
                if (createOrg != null) {
                    useOrgList.add((Long)createOrg.getPkValue());
                }
                if (manageOrg == null) {
                    return;
                }
                if (createOrg != null && manageOrg != null && !createOrg.getPkValue().equals(manageOrg.getPkValue())) {
                    useOrgList.add((Long)manageOrg.getPkValue());
                }
                DynamicObject basedataview = (DynamicObject)bdctrlstrtgy.get("basedataview");
                DynamicObject ctrlview = (DynamicObject)basedataview.get("ctrlview");
                List<Long> subordinateOrgList = this.getDirectSubordinateOrgList((Long)ctrlview.getPkValue(), (Long)manageOrg.getPkValue());
                useOrgList.addAll(subordinateOrgList);
            } else if (CTRLSTRATEGY_OU_ASSIGN.equals(ctrlstrategy) || CTRLSTRATEGY_OU_FREE_ASSIGN.equals(ctrlstrategy)) {
                if (createOrg != null) {
                    useOrgList.add((Long)createOrg.getPkValue());
                }
                if (createOrg != null && manageOrg != null && !createOrg.getPkValue().equals(manageOrg.getPkValue())) {
                    useOrgList.add((Long)manageOrg.getPkValue());
                }
            }
        }
        this.saveBaseDataUseReg(dataInfo, orgID, useOrgList);
    }

    private DynamicObject getDefaultCtrlStrtgy(DynamicObject dataInfo) {
        QFilter basedataFilter;
        QFilter[] filters;
        String selectFields;
        DynamicObject defaultCtrlStrtgy = null;
        String entityID = dataInfo.getDataEntityType().getName();
        ORM orm = ORM.create();
        DynamicObjectCollection list = orm.query(DEFAULTCTRLSTRATEGY_ENTITYID, selectFields = "*", filters = new QFilter[]{basedataFilter = new QFilter("basedataid", "=", (Object)entityID)});
        if (list != null && list.size() == 1) {
            defaultCtrlStrtgy = (DynamicObject)list.get(0);
        }
        return defaultCtrlStrtgy;
    }

    private List<Long> getDirectSubordinateOrgList(Long orgViewId, Long parentOrgId) {
        OrgServiceHelper orgServiceHelper = new OrgServiceHelper();
        List lstOrgs = orgServiceHelper.getDirectSubordinateOrgList(orgViewId, parentOrgId);
        ArrayList<Long> subordinateOrgList = new ArrayList<Long>(lstOrgs.size());
        for (DynamicObject org : lstOrgs) {
            subordinateOrgList.add((Long)org.getPkValue());
        }
        return subordinateOrgList;
    }

    private void saveBaseDataUseReg(DynamicObject dataInfo, Long orgID, List<Long> useOrgList) {
        String baseDataTableName = dataInfo.getDataEntityType().getAlias();
        String bsaeDataUseRegTableName = baseDataTableName + BASEDATAUSEREGSUFFIX;
        String insertSql = "insert into " + bsaeDataUseRegTableName + "(FOrgID, FDataID, FCreateOrgID) values(?, ?, ?)";
        ArrayList<Object[]> paramsList = new ArrayList<Object[]>(useOrgList.size());
        Object[] params = null;
        for (Long useOrgID : useOrgList) {
            params = new Object[]{useOrgID, dataInfo.getPkValue(), orgID};
            paramsList.add(params);
        }
        DB.executeBatch((DBRoute)DBRoute.basedata, (String)insertSql, paramsList);
    }

    private DynamicObject getManageOrg(DynamicObject dataInfo) {
        DynamicObject manageOrg = null;
        DynamicObject bdctrlstrtgy = this.getCtrlStrtgy(dataInfo);
        if (bdctrlstrtgy == null) {
            return manageOrg;
        }
        List entrys = (List)bdctrlstrtgy.get("entryentity");
        DynamicObject entry = (DynamicObject)entrys.get(0);
        String managestrategy = (String)entry.get("managestrategy");
        if ("2".equals(managestrategy)) {
            manageOrg = (DynamicObject)dataInfo.get("createorg");
        } else if ("1".equals(managestrategy)) {
            manageOrg = (DynamicObject)bdctrlstrtgy.get("cu");
        }
        return manageOrg;
    }

    public void baseDataDeleteHandler(DynamicObject dataInfo, Long orgID) {
        boolean bl;
        String baseDataTableName = dataInfo.getDataEntityType().getAlias();
        try {
            String bsaeDataUseRegTableName = baseDataTableName + BASEDATAUSEREGSUFFIX;
            String deleteUseRegSql = "delete from " + bsaeDataUseRegTableName + " where FDataID = ?";
            bl = DB.execute((DBRoute)DBRoute.basedata, (String)deleteUseRegSql, (Object[])new Object[]{dataInfo.getPkValue()});
        }
        catch (Exception bsaeDataUseRegTableName) {
            // empty catch block
        }
        try {
            String bsaeDataExcTableName = baseDataTableName + BASEDATAEXCSUFFIX;
            String deleteExcSql = "delete from " + bsaeDataExcTableName + " where FDataID = ?";
            bl = DB.execute((DBRoute)DBRoute.basedata, (String)deleteExcSql, (Object[])new Object[]{dataInfo.getPkValue()});
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void orgAddnewHandler(DynamicObject orgInfo) {
    }

    public void handleManageOrg(DynamicObject dataInfo) {
        if (dataInfo == null) {
            return;
        }
        DynamicObject manageOrg = this.getManageOrg(dataInfo);
        dataInfo.set("org", (Object)manageOrg);
    }

    private DynamicObject getCtrlStrtgy(DynamicObject dataInfo) {
        QFilter createorgFilter;
        QFilter basedataFilter;
        QFilter[] filters;
        String selectFields;
        DynamicObject bdctrlstrtgy = null;
        String entityID = dataInfo.getDataEntityType().getName();
        DynamicObject createOrg = (DynamicObject)dataInfo.get("createorg");
        if (createOrg == null) {
            return bdctrlstrtgy;
        }
        Long orgID = (Long)createOrg.getPkValue();
        ORM orm = ORM.create();
        DynamicObjectCollection list = orm.query(BDCTRLSTRTGY_ENTITYID, selectFields = "*,cu.*,basedataview.*, basedataview.ctrlview.*, entryentity.*", filters = new QFilter[]{basedataFilter = new QFilter("basedataview.basedata", "=", (Object)entityID), createorgFilter = new QFilter("entryentity.createorg", "=", (Object)orgID)});
        if (list != null && list.size() == 1) {
            bdctrlstrtgy = (DynamicObject)list.get(0);
        }
        return bdctrlstrtgy;
    }

    public String getWorkCalendarVersion(Long orgId) {
        return null;
    }

    public DynamicObject getWorkCalendar(Long orgId) {
        int top;
        String orderBys;
        QFilter orgIdFilter;
        QFilter[] filters;
        String selectFields;
        DynamicObject workCalendar = null;
        ORM orm = ORM.create();
        DynamicObjectCollection list = orm.query(ENTITYID_WORKCALENDAR, selectFields = "*, dateentry.*", filters = new QFilter[]{orgIdFilter = new QFilter("createorg.id", "=", (Object)orgId)}, orderBys = "dateentry.workdate asc", top = 1);
        if (list != null && list.size() > 0) {
            workCalendar = (DynamicObject)list.get(0);
        } else {
            List superiorOrgs = OrgServiceHelper.getSuperiorOrgs((long)orgId);
            if (superiorOrgs != null && superiorOrgs.size() == 1) {
                return this.getWorkCalendar((Long)superiorOrgs.get(0));
            }
        }
        return workCalendar;
    }

    public DynamicObject getWorkCalendar(Long orgId, Date startDate, Date endDate) {
        int top;
        String orderBys;
        QFilter endDateFilter;
        QFilter startDateFilter;
        QFilter orgIdFilter;
        QFilter[] filters;
        String selectFields;
        DynamicObject workCalendar = null;
        ORM orm = ORM.create();
        DynamicObjectCollection list = orm.query(ENTITYID_WORKCALENDAR, selectFields = "*, dateentry.*", filters = new QFilter[]{orgIdFilter = new QFilter("createorg.id", "=", (Object)orgId), startDateFilter = new QFilter("dateentry.workdate", ">=", (Object)startDate), endDateFilter = new QFilter("dateentry.workdate", "<=", (Object)endDate)}, orderBys = "dateentry.workdate asc", top = 1);
        if (list != null && list.size() > 0) {
            workCalendar = (DynamicObject)list.get(0);
        }
        return workCalendar;
    }

    public boolean isWorkDay(Long orgId, Date date) {
        return false;
    }

    public boolean isRestDay(Long orgId, Date date) {
        return false;
    }

    public boolean isWeekendDay(Long orgId, Date date) {
        return false;
    }

    public boolean isWorkTime(Long orgId, Date date) {
        return false;
    }

    public int getCalHolidays(Long orgId, Date arg0, Date arg1) {
        return 0;
    }

    public int getCalRestDays(Long orgId, Date arg0, Date arg1) {
        return 0;
    }

    public int getCalWorkDays(Long orgId, Date arg0, Date arg1) {
        return 0;
    }

    public Boolean isHalfHolidays(Long orgId, Date arg0) {
        return null;
    }
}

