/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.sbd.opplugin;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.api.ApiResult;
import kd.bos.entity.plugin.ImportLogger;
import kd.bos.form.field.ComboItem;
import kd.bos.form.plugin.impt.BatchImportPlugin;
import kd.bos.form.plugin.impt.ImportBillData;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.trace.TraceSpan;
import kd.bos.trace.Tracer;

public class InspectCfgImportOp
extends BatchImportPlugin {
    public List<ComboItem> getOverrideFieldsConfig() {
        List list = super.getOverrideFieldsConfig();
        ArrayList<ComboItem> newList = new ArrayList<ComboItem>(list.size());
        for (ComboItem c : list) {
            if (!"masterid".equals(c.getValue()) && !"createorg".equals(c.getValue())) continue;
            newList.add(c);
        }
        return newList;
    }

    protected ApiResult save(List<ImportBillData> rowdatas, ImportLogger logger) {
        try (TraceSpan span = Tracer.create((String)"InspectCfgImportOp", (String)"beforeImportBill");){
            if (rowdatas.isEmpty()) {
                ApiResult apiResult = null;
                return apiResult;
            }
            this.beforeImportBill(rowdatas, logger);
        }
        return super.save(rowdatas, logger);
    }

    private void beforeImportBill(List<ImportBillData> rowDatas, ImportLogger logger) {
        ArrayList<String> materialNumberList = new ArrayList<String>(rowDatas.size());
        JSONObject jsonData = null;
        for (ImportBillData rowData : rowDatas) {
            jsonData = rowData == null ? new JSONObject() : rowData.getData();
            JSONObject material = jsonData.getJSONObject("masterid");
            String materialNumber = material == null ? "" : material.getString("number");
            materialNumberList.add(materialNumber);
        }
        QFilter[] filter = new QFilter[]{new QFilter("number", "in", materialNumberList)};
        Map materialMap = BusinessDataServiceHelper.loadFromCache((String)"bd_material", (String)"status,enable,createorg,ctrlstrategy", (QFilter[])filter);
        HashMap<String, DynamicObject> materialNumberMap = new HashMap<String, DynamicObject>(materialMap.size());
        for (DynamicObject material : materialMap.values()) {
            String materialNumber = material.getString("number");
            materialNumberMap.put(materialNumber, material);
        }
        HashMap<Integer, String> errMsgLog = new HashMap<Integer, String>(rowDatas.size());
        Iterator<ImportBillData> rowDataIterator = rowDatas.iterator();
        while (rowDataIterator.hasNext()) {
            String materialCreatrOrgNum;
            ImportBillData billData = rowDataIterator.next();
            if (billData == null) continue;
            jsonData = billData.getData();
            JSONObject importMaterial = jsonData.getJSONObject("masterid");
            String materialNumber = importMaterial == null ? "" : importMaterial.getString("number");
            DynamicObject material = (DynamicObject)materialNumberMap.get(materialNumber);
            int errMsgRowIndex = billData.getStartIndex();
            if (material == null) {
                errMsgLog.put(errMsgRowIndex, materialNumber);
                logger.log(Integer.valueOf(errMsgRowIndex), ResManager.loadKDString((String)"\u5bfc\u5165\u7684\u7269\u6599\u6570\u636e\u4e0d\u5b58\u5728\uff0c\u5f15\u5165\u5931\u8d25\u3002", (String)"InspectCfgImportOp_0", (String)"bd-sbd-opplugin", (Object[])new Object[0])).fail();
                rowDataIterator.remove();
                continue;
            }
            JSONObject createorgObj = jsonData.getJSONObject("createorg");
            DynamicObject createorg = material.getDynamicObject("createorg");
            if (material.getInt("enable") == 0) {
                errMsgLog.put(errMsgRowIndex, materialNumber);
                logger.log(Integer.valueOf(errMsgRowIndex), ResManager.loadKDString((String)"\u5bfc\u5165\u7684\u7269\u6599\u6570\u636e\uff0c\u4e0d\u5141\u8bb8\u4f7f\u7528\u72b6\u6001\u4e3a\u7981\u7528\uff0c\u5f53\u524d\u6570\u636e\u4e0d\u7b26\u5408\u8981\u6c42\uff0c\u5f15\u5165\u5931\u8d25\u3002", (String)"InspectCfgImportOp_2", (String)"bd-sbd-opplugin", (Object[])new Object[0])).fail();
                rowDataIterator.remove();
            }
            if (createorgObj == null) {
                errMsgLog.put(errMsgRowIndex, materialNumber);
                logger.log(Integer.valueOf(errMsgRowIndex), ResManager.loadKDString((String)"\u5bfc\u5165\u7684\u6570\u636e\u672a\u4f20\u5165\u521b\u5efa\u7ec4\u7ec7\u5f15\u5165\u5931\u8d25\u3002", (String)"InspectCfgImportOp_1", (String)"bd-sbd-opplugin", (Object[])new Object[0])).fail();
                rowDataIterator.remove();
                continue;
            }
            String createorgNumber = createorgObj.getString("number");
            if (createorgNumber.equals(materialCreatrOrgNum = createorg.getString("number")) || "5".equals(material.getString("ctrlstrategy")) || "7".equals(material.getString("ctrlstrategy")) || "C".equals(material.getString("status"))) continue;
            errMsgLog.put(errMsgRowIndex, materialNumber);
            logger.log(Integer.valueOf(errMsgRowIndex), ResManager.loadKDString((String)"\u5bfc\u5165\u7684\u7269\u6599\u6570\u636e\uff0c\u6570\u636e\u72b6\u6001\u5fc5\u987b\u662f\u5df2\u5ba1\u6838\uff0c\u5f53\u524d\u6570\u636e\u4e0d\u7b26\u5408\u8981\u6c42\uff0c\u5f15\u5165\u5931\u8d25\u3002", (String)"InspectCfgImportOp_3", (String)"bd-sbd-opplugin", (Object[])new Object[0])).fail();
            rowDataIterator.remove();
        }
    }
}

