/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.sbd.opplugin;

import kd.bd.sbd.consts.Inspect_cfgConst;
import kd.bd.sbd.validator.MaterialInspectValidator;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;

public class MaterialInspectSaveOp
extends AbstractOperationServicePlugIn {
    public void onAddValidators(AddValidatorsEventArgs e) {
        e.addValidator((AbstractValidator)new MaterialInspectValidator());
    }

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        e.getFieldKeys().add("entryqcp");
        e.getFieldKeys().add("entryfinish");
        e.getFieldKeys().add("purchaseorg");
        e.getFieldKeys().add("supplier");
        e.getFieldKeys().add("produceorg");
        e.getFieldKeys().add("material");
        e.getFieldKeys().add("nocheckflg");
        e.getFieldKeys().add("qcpflg");
        e.getFieldKeys().add("osqcpflg");
        e.getFieldKeys().add("finishflg");
        e.getFieldKeys().add("procedureflg");
        e.getFieldKeys().add("prodpatrolflag");
        e.getFieldKeys().add("productretflg");
        e.getFieldKeys().add("deliveryflg");
        e.getFieldKeys().add("returnsflg");
        e.getFieldKeys().add("stockflg");
        e.getFieldKeys().add("entryentity.inspecttype");
        e.getFieldKeys().add("entryentity.nocheckflag");
    }

    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        super.beforeExecuteOperationTransaction(e);
        for (DynamicObject obj : e.getDataEntities()) {
            this.synHistoryFieldValue(obj);
        }
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        for (DynamicObject obj : e.getDataEntities()) {
            DynamicObject material = obj.getDynamicObject("masterid");
            if (null == material) continue;
            obj.set("number", (Object)material.getString("number"));
            obj.set("name", (Object)material.getString("name"));
        }
    }

    private void synHistoryFieldValue(DynamicObject obj) {
        DynamicObjectCollection entryEntity = obj.getDynamicObjectCollection("entryentity");
        Boolean nocheckFlg = Boolean.FALSE;
        this.setDefaultValue(obj);
        for (DynamicObject dynObj : entryEntity) {
            String fieldName;
            Long inspectTypeId = dynObj.getLong("inspecttype.id");
            boolean nocheckFlag = dynObj.getBoolean("nocheckflag");
            if (nocheckFlag && !nocheckFlg.booleanValue()) {
                nocheckFlg = Boolean.TRUE;
            }
            if ((fieldName = (String)Inspect_cfgConst.transMap.get(inspectTypeId)) == null) continue;
            obj.set(fieldName, (Object)Boolean.TRUE);
        }
        obj.set("nocheckflg", (Object)nocheckFlg);
    }

    private void setDefaultValue(DynamicObject obj) {
        obj.set("qcpflg", (Object)Boolean.FALSE);
        obj.set("osqcpflg", (Object)Boolean.FALSE);
        obj.set("finishflg", (Object)Boolean.FALSE);
        obj.set("procedureflg", (Object)Boolean.FALSE);
        obj.set("prodpatrolflag", (Object)Boolean.FALSE);
        obj.set("productretflg", (Object)Boolean.FALSE);
        obj.set("deliveryflg", (Object)Boolean.FALSE);
        obj.set("returnsflg", (Object)Boolean.FALSE);
        obj.set("stockflg", (Object)Boolean.FALSE);
    }
}

