/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.sbd.opplugin;

import java.util.ArrayList;
import java.util.Date;
import java.util.Map;
import kd.bd.sbd.enums.CalDirectionEnum;
import kd.bd.sbd.enums.EndDateCalTypeEnum;
import kd.bd.sbd.enums.StartDateCalTypeEnum;
import kd.bd.sbd.validator.MaterialBizInfoSaveValidator;
import kd.bd.sbd.validator.MaterialInvInfoSaveValidator;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.StringUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.bos.trace.TraceSpan;
import kd.bos.trace.Tracer;
import kd.bos.util.CollectionUtils;

public class MaterialInvInfoSaveOp
extends AbstractOperationServicePlugIn {
    private static final Log log = LogFactory.getLog(MaterialInvInfoSaveOp.class);
    public static final String PROP_INVENTORYUNIT = "inventoryunit";
    public static final String PROP_BASEUNIT = "baseunit";
    public static final String PROP_MASTERID = "masterid";
    public static final String ENABLESHELFLIFEMGR = "enableshelflifemgr";
    public static final String SHELFLIFE = "shelflife";

    public void onAddValidators(AddValidatorsEventArgs e) {
        try (TraceSpan traceSpan = Tracer.create((String)"MaterialInvInfoSaveOp", (String)"onAddValidators");){
            e.addValidator((AbstractValidator)new MaterialInvInfoSaveValidator());
            e.addValidator((AbstractValidator)new MaterialBizInfoSaveValidator());
        }
    }

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        try (TraceSpan traceSpan = Tracer.create((String)"MaterialInvInfoSaveOp", (String)"onPreparePropertys");){
            super.onPreparePropertys(e);
            e.getFieldKeys().add(PROP_BASEUNIT);
            e.getFieldKeys().add(PROP_INVENTORYUNIT);
            e.getFieldKeys().add(ENABLESHELFLIFEMGR);
            e.getFieldKeys().add(SHELFLIFE);
            e.getFieldKeys().add("ismininvalert");
            e.getFieldKeys().add("ismaxinvalert");
            e.getFieldKeys().add("isreorderpointalert");
            e.getFieldKeys().add("issaftyinvalert");
            e.getFieldKeys().add("calculationforenddate");
            e.getFieldKeys().add("leadtimeunit");
            e.getFieldKeys().add("shelflifeunit");
            e.getFieldKeys().add("sngentimepoint");
            e.getFieldKeys().add("caldirection");
            e.getFieldKeys().add("startdatecaltype");
            e.getFieldKeys().add("enablelot");
            e.getFieldKeys().add("ispurchaseinspect");
            e.getFieldKeys().add("isinvinspect");
        }
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        log.info("MaterialInvInfoSaveOp.beginOperationTransaction, record num:" + (e.getDataEntities() == null ? "null" : Integer.valueOf(e.getDataEntities().length)));
        try (TraceSpan traceSpan = Tracer.create((String)"MaterialInvInfoSaveOp", (String)"beginOperationTransaction");){
            for (DynamicObject obj : e.getDataEntities()) {
                DynamicObject material = obj.getDynamicObject(PROP_MASTERID);
                obj.set(PROP_BASEUNIT, material.get(PROP_BASEUNIT));
                String sngentimepoint = obj.getString("sngentimepoint");
                if (StringUtils.isEmpty((Object)sngentimepoint)) {
                    obj.set("sngentimepoint", (Object)"4");
                }
                this.setCalStartDateVal(obj);
            }
            this.checkLotAndShelflifeUpdate(e.getDataEntities());
        }
    }

    private void setCalStartDateVal(DynamicObject data) {
        String calDirection = data.getString("caldirection");
        String calCulForEndDate = data.getString("calculationforenddate");
        if (CalDirectionEnum.CALBOTH.getValue().equals(calDirection) && (EndDateCalTypeEnum.STARTDATEADDSHELFLIFE.getValue().equals(calCulForEndDate) || EndDateCalTypeEnum.STARTDATEADDLASTDAY.getValue().equals(calCulForEndDate))) {
            data.set("startdatecaltype", (Object)StartDateCalTypeEnum.ENDDATEMINUSSHELFLIFE.getValue());
        } else if (CalDirectionEnum.CALBOTH.getValue().equals(calDirection) && EndDateCalTypeEnum.STARTDATEADDSHELFLIFEMINUSONE.getValue().equals(calCulForEndDate)) {
            data.set("startdatecaltype", (Object)StartDateCalTypeEnum.ENDDATEMINUSSHELFLIFEADDONE.getValue());
        } else if (CalDirectionEnum.CALSTARTDATE.getValue().equals(calDirection) && StringUtils.isEmpty((Object)calCulForEndDate)) {
            data.set("startdatecaltype", (Object)StartDateCalTypeEnum.ENDDATEMINUSSHELFLIFE.getValue());
        } else if (CalDirectionEnum.CALNONE.getValue().equals(calDirection) || CalDirectionEnum.CALENDDATE.getValue().equals(calDirection)) {
            data.set("startdatecaltype", null);
        }
    }

    private void checkLotAndShelflifeUpdate(DynamicObject[] dataEntities) {
        ArrayList<Object> pkList = new ArrayList<Object>(dataEntities.length);
        for (DynamicObject data : dataEntities) {
            pkList.add(data.getPkValue());
        }
        QFilter qFilter = new QFilter("id", "in", pkList);
        Map matInvMap = BusinessDataServiceHelper.loadFromCache((String)"bd_materialinventoryinfo", (String)"id,enablelot, enableshelflifemgr", (QFilter[])new QFilter[]{qFilter});
        if (matInvMap.isEmpty()) {
            return;
        }
        ArrayList<DynamicObject> logList = new ArrayList<DynamicObject>();
        String logEntity = "bd_materialinvlotlog";
        for (DynamicObject data : dataEntities) {
            DynamicObject log;
            DynamicObject oldData = (DynamicObject)matInvMap.get(data.getPkValue());
            if (oldData == null) continue;
            if (oldData.getBoolean("enablelot") != data.getBoolean("enablelot")) {
                log = BusinessDataServiceHelper.newDynamicObject((String)logEntity);
                log.set("materielinvinfoid", data.getPkValue());
                log.set("updatetype", (Object)"A");
                log.set("operation", (Object)(data.getBoolean("enablelot") ? "A" : "B"));
                log.set("operationtime", (Object)new Date());
                log.set("updateuser", (Object)UserServiceHelper.getCurrentUserId());
                logList.add(log);
            }
            if (oldData.getBoolean(ENABLESHELFLIFEMGR) == data.getBoolean(ENABLESHELFLIFEMGR)) continue;
            log = BusinessDataServiceHelper.newDynamicObject((String)logEntity);
            log.set("materielinvinfoid", data.getPkValue());
            log.set("updatetype", (Object)"B");
            log.set("operation", (Object)(data.getBoolean(ENABLESHELFLIFEMGR) ? "A" : "B"));
            log.set("operationtime", (Object)new Date());
            log.set("updateuser", (Object)UserServiceHelper.getCurrentUserId());
            logList.add(log);
        }
        if (CollectionUtils.isNotEmpty(logList)) {
            SaveServiceHelper.save((DynamicObject[])logList.toArray(new DynamicObject[logList.size()]));
        }
    }
}

