/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.assistant.bom;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;

public class VersionRuleBusiness {
    public static final String ENTITY_RULE = "bd_bomversionrule_new";
    public static final String KEY_ISDEFAULTA = "isdefault";
    public static final String KEY_ISDEFAULTB = "isdefaultroute";
    public static final String KEY_ISDEFAULTC = "isdefaultprograme";
    public static final String APPNUMBER = "bd-assistant-business";

    public String getSelectProperties() {
        StringBuilder sb = new StringBuilder();
        sb.append("multype");
        sb.append(",isdefault");
        sb.append(",isdefaultroute");
        sb.append(",isdefaultprograme");
        sb.append(",number");
        sb.append(",id");
        sb.append(",modifytime");
        sb.append(",modifier");
        return sb.toString();
    }

    public String updateDefault(Long ruleId, boolean isDefaultA, boolean isDefaultB, boolean isDefaultC) {
        ArrayList<DynamicObject> rules = new ArrayList<DynamicObject>(16);
        DynamicObject rule = BusinessDataServiceHelper.loadSingle((Object)ruleId, (String)ENTITY_RULE, (String)this.getSelectProperties());
        rule.set(KEY_ISDEFAULTA, (Object)isDefaultA);
        rule.set(KEY_ISDEFAULTB, (Object)isDefaultB);
        rule.set(KEY_ISDEFAULTC, (Object)isDefaultC);
        if (!this.checkHasDefaultA(rule)) {
            return ResManager.loadKDString((String)"\u4e0d\u5b58\u5728\u5176\u4ed6\u9ed8\u8ba4BOM\u7c7b\u578b\u7684\u89c4\u5219\uff08\u5fc5\u987b\u5b58\u5728\u4e00\u4e2a\u53ef\u7528\u7684BOM\u7c7b\u578b\u89c4\u5219\uff09\u3002", (String)"VersionRuleBusiness_06", (String)APPNUMBER, (Object[])new Object[0]);
        }
        if (!this.checkHasDefaultB(rule)) {
            return ResManager.loadKDString((String)"\u4e0d\u5b58\u5728\u5176\u4ed6\u9ed8\u8ba4\u5de5\u827a\u8def\u7ebf\u7c7b\u578b\u7684\u89c4\u5219\uff08\u5fc5\u987b\u5b58\u5728\u4e00\u4e2a\u53ef\u7528\u7684\u5de5\u827a\u8def\u7ebf\u7c7b\u578b\u89c4\u5219\uff09\u3002", (String)"VersionRuleBusiness_07", (String)APPNUMBER, (Object[])new Object[0]);
        }
        if (!this.checkHasDefaultC(rule)) {
            return ResManager.loadKDString((String)"\u4e0d\u5b58\u5728\u5176\u4ed6\u9ed8\u8ba4\u4ea7\u54c1\u914d\u65b9\u7c7b\u578b\u7684\u89c4\u5219\uff08\u5fc5\u987b\u5b58\u5728\u4e00\u4e2a\u53ef\u7528\u7684\u4ea7\u54c1\u914d\u65b9\u7c7b\u578b\u89c4\u5219\uff09\u3002", (String)"VersionRuleBusiness_08", (String)APPNUMBER, (Object[])new Object[0]);
        }
        rule.set("modifytime", (Object)new Date());
        rule.set("modifier", (Object)RequestContext.get().getCurrUserId());
        rules.add(rule);
        this.clearOtherDataDefault(rule, rules);
        SaveServiceHelper.update((DynamicObject[])rules.toArray(new DynamicObject[rules.size()]));
        return "";
    }

    public boolean checkHasDefaultA(DynamicObject rule) {
        if (!rule.getBoolean(KEY_ISDEFAULTA)) {
            QFilter qfilter = new QFilter("id", "<>", (Object)rule.getLong("id"));
            qfilter.and(new QFilter("enable", "=", (Object)"1"));
            qfilter.and(new QFilter(KEY_ISDEFAULTA, "=", (Object)true));
            return QueryServiceHelper.exists((String)ENTITY_RULE, (QFilter[])new QFilter[]{qfilter});
        }
        return true;
    }

    public boolean checkHasDefaultB(DynamicObject rule) {
        if (!rule.getBoolean(KEY_ISDEFAULTB)) {
            QFilter qfilter = new QFilter("id", "<>", (Object)rule.getLong("id"));
            qfilter.and(new QFilter("enable", "=", (Object)"1"));
            qfilter.and(new QFilter(KEY_ISDEFAULTB, "=", (Object)true));
            return QueryServiceHelper.exists((String)ENTITY_RULE, (QFilter[])new QFilter[]{qfilter});
        }
        return true;
    }

    public boolean checkHasDefaultC(DynamicObject rule) {
        if (!rule.getBoolean(KEY_ISDEFAULTC)) {
            QFilter qfilter = new QFilter("id", "<>", (Object)rule.getLong("id"));
            qfilter.and(new QFilter("enable", "=", (Object)"1"));
            qfilter.and(new QFilter(KEY_ISDEFAULTC, "=", (Object)true));
            return QueryServiceHelper.exists((String)ENTITY_RULE, (QFilter[])new QFilter[]{qfilter});
        }
        return true;
    }

    public void clearOtherDataDefault(DynamicObject rule, List<DynamicObject> rules) {
        DynamicObject[] others;
        boolean isDefaultA = rule.getBoolean(KEY_ISDEFAULTA);
        boolean isDefaultB = rule.getBoolean(KEY_ISDEFAULTB);
        boolean isDefaultC = rule.getBoolean(KEY_ISDEFAULTC);
        if ((isDefaultA || isDefaultB || isDefaultC) && (others = BusinessDataServiceHelper.load((String)ENTITY_RULE, (String)this.getSelectProperties(), (QFilter[])this.buildQueryFilter(rule.getLong("id")))) != null && others.length > 0) {
            for (DynamicObject dy : others) {
                boolean isUpdate = false;
                if (isDefaultA && dy.getBoolean(KEY_ISDEFAULTA)) {
                    dy.set(KEY_ISDEFAULTA, (Object)false);
                    isUpdate = true;
                }
                if (isDefaultB && dy.getBoolean(KEY_ISDEFAULTB)) {
                    dy.set(KEY_ISDEFAULTB, (Object)false);
                    isUpdate = true;
                }
                if (isDefaultC && dy.getBoolean(KEY_ISDEFAULTC)) {
                    dy.set(KEY_ISDEFAULTC, (Object)false);
                    isUpdate = true;
                }
                if (!isUpdate) continue;
                dy.set("modifytime", (Object)new Date());
                dy.set("modifier", (Object)RequestContext.get().getCurrUserId());
                rules.add(dy);
            }
        }
    }

    public QFilter[] buildQueryFilter(Long ruleId) {
        QFilter qfilter = new QFilter("id", "<>", (Object)ruleId);
        qfilter.and(new QFilter("enable", "=", (Object)"1"));
        QFilter qfilterA = new QFilter(KEY_ISDEFAULTA, "=", (Object)true);
        QFilter qfilterB = new QFilter(KEY_ISDEFAULTB, "=", (Object)true);
        QFilter qfilterC = new QFilter(KEY_ISDEFAULTC, "=", (Object)true);
        return new QFilter[]{qfilter.and(qfilterA.or(qfilterB).or(qfilterC))};
    }

    public String checkHasOtherDefault(Long ruleId) {
        return this.checkHasOtherDefault(BusinessDataServiceHelper.loadSingle((Object)ruleId, (String)ENTITY_RULE, (String)this.getSelectProperties()));
    }

    public String checkHasOtherDefault(DynamicObject rule) {
        boolean isDefaultA = rule.getBoolean(KEY_ISDEFAULTA);
        boolean isDefaultB = rule.getBoolean(KEY_ISDEFAULTB);
        boolean isDefaultC = rule.getBoolean(KEY_ISDEFAULTC);
        return this.checkHasOtherDefault((Long)rule.getPkValue(), rule.getString("number"), isDefaultA, isDefaultB, isDefaultC);
    }

    private String getRuleNumberMsg(String ruleNumber, String tagName) {
        return String.format(ResManager.loadKDString((String)"\u89c4\u5219\u7f16\u7801\u201c%1$s\u201d: \u5df2\u5b58\u5728\u9ed8\u8ba4\u7684%2$s\uff0c\u662f\u5426\u786e\u5b9a\u8fdb\u884c\u9ed8\u8ba4\u503c\u5207\u6362\uff1f", (String)"VersionRuleBusiness_04", (String)APPNUMBER, (Object[])new Object[0]), ruleNumber, tagName);
    }

    private String getTagName(boolean isExistsA, boolean isExistsB, boolean isExistsC) {
        return isExistsB ? ResManager.loadKDString((String)"\u201c\u5de5\u827a\u8def\u7ebf\u89c4\u5219\u201d", (String)"VersionRuleBusiness_02", (String)APPNUMBER, (Object[])new Object[0]) : (isExistsC ? ResManager.loadKDString((String)"\u201c\u4ea7\u54c1\u914d\u65b9\u89c4\u5219\u201d", (String)"VersionRuleBusiness_03", (String)APPNUMBER, (Object[])new Object[0]) : ResManager.loadKDString((String)"\u201cBOM\u89c4\u5219\u201d", (String)"VersionRuleBusiness_01", (String)APPNUMBER, (Object[])new Object[0]));
    }

    public String checkHasOtherDefault(Long ruleId, String ruleNumber, boolean isDefaultA, boolean isDefaultB, boolean isDefaultC) {
        boolean isExistsA = false;
        boolean isExistsB = false;
        boolean isExistsC = false;
        StringBuilder msg = new StringBuilder();
        if (isDefaultA || isDefaultB || isDefaultC) {
            DynamicObjectCollection coll = QueryServiceHelper.query((String)ENTITY_RULE, (String)this.getSelectProperties(), (QFilter[])this.buildQueryFilter(ruleId));
            for (DynamicObject otherRule : coll) {
                if (isDefaultA && otherRule.getBoolean(KEY_ISDEFAULTA)) {
                    isExistsA = true;
                }
                if (isDefaultB && otherRule.getBoolean(KEY_ISDEFAULTB)) {
                    isExistsB = true;
                }
                if (!isDefaultC || !otherRule.getBoolean(KEY_ISDEFAULTC)) continue;
                isExistsC = true;
            }
            String tagName = this.getTagName(isExistsA, isExistsB, isExistsC);
            msg.append(this.getRuleNumberMsg(ruleNumber, tagName));
        }
        return isExistsA || isExistsB || isExistsC ? msg.toString() : "";
    }
}

