/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.assistant.cal;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.Input;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.algo.input.OrmInput;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;

public class CalBalanceValidator {
    public static Set<Object> getNotZeroBalMaterial(Set<Long> pubMaterialIds, Map<Long, Set<Long>> privateOrg2MaterialIds) {
        Set<Object> notZeroMaterial = new HashSet<Object>(4);
        if (pubMaterialIds == null || pubMaterialIds.isEmpty() && (privateOrg2MaterialIds == null || privateOrg2MaterialIds.isEmpty())) {
            return notZeroMaterial;
        }
        privateOrg2MaterialIds = privateOrg2MaterialIds == null ? new HashMap<Long, Set<Long>>(4) : privateOrg2MaterialIds;
        boolean isContainsPub = pubMaterialIds != null && !pubMaterialIds.isEmpty();
        Map<Long, Set<Long>> costaccount2OwnerMap = CalBalanceValidator.getEnableCostAccount(isContainsPub, privateOrg2MaterialIds.keySet());
        Map<Integer, Set<Long>> period2CostaccountMap = CalBalanceValidator.getPeriod2CostAccountMap(costaccount2OwnerMap.keySet());
        DataSet balDS = CalBalanceValidator.getNotZeroBal(period2CostaccountMap, costaccount2OwnerMap, pubMaterialIds, privateOrg2MaterialIds);
        notZeroMaterial = CalBalanceValidator.getNotZeroBalMaterialByBalDS(balDS, pubMaterialIds);
        return notZeroMaterial;
    }

    private static Set<Object> getNotZeroBalMaterialByBalDS(DataSet balDS, Set<Long> pubMaterialIds) {
        HashSet<Object> notZeroMaterial = new HashSet<Object>(4);
        for (Row row : balDS) {
            Long calorg = row.getLong("calorg");
            Long owner = row.getLong("owner");
            Long material = row.getLong("material");
            if (pubMaterialIds != null && pubMaterialIds.contains(material)) {
                notZeroMaterial.add(material);
                continue;
            }
            notZeroMaterial.add(calorg + "#" + material);
            notZeroMaterial.add(owner + "#" + material);
        }
        return notZeroMaterial;
    }

    public static boolean isNewBalance() {
        return (Boolean)DispatchServiceHelper.invokeBizService((String)"fi", (String)"cal", (String)"CalBalanceService", (String)"isNewPeriodBal", (Object[])new Object[0]);
    }

    private static DataSet getNotZeroBal(Map<Integer, Set<Long>> period2CostaccountMap, Map<Long, Set<Long>> costaccount2OwnerMap, Set<Long> pubMaterialIds, Map<Long, Set<Long>> privateOrg2MaterialIds) {
        DataSet balDS;
        QFilter inoutFilter;
        QFilter beginFilter;
        String entity;
        if (CalBalanceValidator.isNewBalance()) {
            entity = "cal_bal";
            beginFilter = new QFilter("baseqty_bal", "<>", (Object)0).or("standardcost_bal", "<>", (Object)0).or("actualcost_bal", "<>", (Object)0);
            inoutFilter = new QFilter("baseqty_in", "<>", (Object)0).or("standardcost_in", "<>", (Object)0).or("actualcost_in", "<>", (Object)0).or("baseqty_out", "<>", (Object)0).or("standardcost_out", "<>", (Object)0).or("actualcost_out", "<>", (Object)0);
        } else {
            entity = "cal_balance";
            beginFilter = new QFilter("periodendqty", "<>", (Object)0).or("periodendstandardcost", "<>", (Object)0).or("periodendactualcost", "<>", (Object)0);
            inoutFilter = new QFilter("periodinqty", "<>", (Object)0).or("periodinstandardcost", "<>", (Object)0).or("periodinactualcost", "<>", (Object)0).or("periodissueqty", "<>", (Object)0).or("periodissuestandardcost", "<>", (Object)0).or("periodissueactualcost", "<>", (Object)0);
        }
        ArrayList inputs = new ArrayList(4);
        for (Map.Entry<Integer, Set<Long>> integerSetEntry : period2CostaccountMap.entrySet()) {
            int period = integerSetEntry.getKey();
            Set<Long> costAccountIds = integerSetEntry.getValue();
            Lists.partition(Arrays.asList(costAccountIds.toArray(new Long[0])), (int)50).forEach(costAccountIdlist -> {
                HashSet materialIds = new HashSet(4);
                if (pubMaterialIds != null && !pubMaterialIds.isEmpty()) {
                    materialIds.addAll(pubMaterialIds);
                }
                for (Long costaccountId : costAccountIdlist) {
                    Set ownerIds = (Set)costaccount2OwnerMap.get(costaccountId);
                    if (ownerIds == null) continue;
                    for (Long ownerId : ownerIds) {
                        Set privateMat = (Set)privateOrg2MaterialIds.get(ownerId);
                        if (privateMat == null || privateMat.isEmpty()) continue;
                        materialIds.addAll(privateMat);
                    }
                }
                Lists.partition(Arrays.asList(materialIds.toArray(new Long[0])), (int)1000).forEach(materialList -> {
                    QFilter begin = new QFilter("endperiod", ">=", (Object)period);
                    begin.and("period", "<", (Object)period);
                    begin.and("costaccount", "in", costAccountIdlist);
                    begin.and("material", "in", materialList);
                    begin.and(beginFilter);
                    OrmInput beginInput = new OrmInput(CalBalanceValidator.class.getName(), entity, "calorg,owner,material", begin.toArray());
                    inputs.add(beginInput);
                    QFilter inout = new QFilter("endperiod", ">", (Object)period);
                    inout.and("period", ">=", (Object)period);
                    inout.and("costaccount", "in", costAccountIdlist);
                    inout.and("material", "in", materialList);
                    inout.and(inoutFilter);
                    OrmInput inOutInput = new OrmInput(CalBalanceValidator.class.getName(), entity, "calorg,owner,material", inout.toArray());
                    inputs.add(inOutInput);
                });
            });
        }
        if (inputs.isEmpty()) {
            RowMeta rowMeta = ORM.create().createRowMeta(entity, "calorg,owner,material");
            balDS = Algo.create((String)CalBalanceValidator.class.getName()).createDataSet(new ArrayList(16), rowMeta);
        } else {
            balDS = Algo.create((String)CalBalanceValidator.class.getName()).createDataSet((Input[])inputs.toArray(new OrmInput[0]));
        }
        return balDS;
    }

    private static Map<Long, Set<Long>> getEnableCostAccount(boolean isContainsPub, Set<Long> privateOrgIds) {
        QFilter filter = new QFilter("enable", "=", (Object)Boolean.TRUE);
        Map<Long, Set<Long>> allCalorgId2OwnerIds = CalBalanceValidator.getAllCalOrgId2OwnerIds(privateOrgIds, isContainsPub);
        if (!isContainsPub) {
            filter.and("calorg", "in", allCalorgId2OwnerIds.keySet());
        }
        HashMap<Long, Set<Long>> map = new HashMap<Long, Set<Long>>(4);
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)CalBalanceValidator.class.getName(), (String)"cal_bd_costaccount", (String)"id,calorg", (QFilter[])filter.toArray(), null);){
            for (Row row : ds) {
                Set<Long> owners = allCalorgId2OwnerIds.get(row.getLong("calorg"));
                if (owners == null) {
                    owners = new HashSet<Long>(4);
                    owners.add(row.getLong("calorg"));
                }
                map.put(row.getLong("id"), owners);
            }
        }
        return map;
    }

    private static Map<Long, Set<Long>> getAllCalOrgId2OwnerIds(Set<Long> privateOrgIds, boolean isContainsPub) {
        QFilter bizOrgQf = null;
        if (!isContainsPub && !privateOrgIds.isEmpty()) {
            bizOrgQf = new QFilter("bizorgentry.bizorg", "in", privateOrgIds);
        }
        DynamicObjectCollection accSysColl = QueryServiceHelper.query((String)"bd_accountingsys", (String)"id,number,name,bizorgentry.bizorg as ownerid,bizorgentry.bizacctorg as calorgid", (QFilter[])new QFilter[]{bizOrgQf}, null);
        HashMap<Long, Set<Long>> allCalorgId2OwnerIds = new HashMap<Long, Set<Long>>(4);
        for (DynamicObject dynamicObject : accSysColl) {
            Long calorgid = dynamicObject.getLong("calorgid");
            Long ownerid = dynamicObject.getLong("ownerid");
            Set ownerids = allCalorgId2OwnerIds.computeIfAbsent(calorgid, k -> new HashSet(4));
            ownerids.add(ownerid);
            ownerids.add(calorgid);
        }
        return allCalorgId2OwnerIds;
    }

    private static Map<Integer, Set<Long>> getPeriod2CostAccountMap(Set<Long> costaccountIds) {
        HashMap<Integer, Set<Long>> period2CostaccountMap = new HashMap<Integer, Set<Long>>(4);
        if (costaccountIds.isEmpty()) {
            return period2CostaccountMap;
        }
        QFilter filter = new QFilter("entry.costaccount", "in", costaccountIds);
        filter.and("entry.isenabled", "=", (Object)true);
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)CalBalanceValidator.class.getName(), (String)"cal_sysctrlentity", (String)"entry.costaccount,entry.currentperiod.periodyear,entry.currentperiod.periodnumber", (QFilter[])filter.toArray(), null);){
            for (Row row : ds) {
                Integer year = row.getInteger("entry.currentperiod.periodyear");
                Integer number = row.getInteger("entry.currentperiod.periodnumber");
                Long costaccount = row.getLong("entry.costaccount");
                if (year == null || number == null) continue;
                int period = year * 100 + number;
                Set costAccounts = period2CostaccountMap.computeIfAbsent(period, k -> new HashSet(4));
                costAccounts.add(costaccount);
            }
        }
        return period2CostaccountMap;
    }
}

