/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.assistant.opplugin.costcenter;

import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.cache.AppCache;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;

public class CostCenterSaveOp
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        List fieldKeys = e.getFieldKeys();
        fieldKeys.add("costcenterfield");
        fieldKeys.add("sourcefield");
        fieldKeys.add("sourcefieldtype");
        fieldKeys.add("entryentity");
        fieldKeys.add("enable");
        fieldKeys.add("billtype");
        fieldKeys.add("businessbill");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        e.getValidators().add(new AbstractValidator(){

            public void validate() {
                ExtendedDataEntity[] dataEntities = this.getDataEntities();
                if (dataEntities == null || dataEntities.length == 0) {
                    return;
                }
                for (ExtendedDataEntity data : dataEntities) {
                    DynamicObject dataEntity = data.getDataEntity();
                    DynamicObject businessBill = dataEntity.getDynamicObject("businessbill");
                    if (businessBill == null) continue;
                    String businessBillNumber = businessBill.getString("number");
                    QFilter qFilter = new QFilter("businessbill", "=", (Object)businessBillNumber);
                    DynamicObject billType = dataEntity.getDynamicObject("billtype");
                    if (billType != null) {
                        Long billTypeId = billType.getLong("id");
                        qFilter.and("billtype", "=", (Object)billTypeId);
                    }
                    Long id = dataEntity.getLong("id");
                    qFilter.and("id", "!=", (Object)id);
                    DynamicObject existFieldMap = QueryServiceHelper.queryOne((String)"bos_costcenterfieldmap", (String)"number,name", (QFilter[])qFilter.toArray());
                    if (existFieldMap == null) continue;
                    this.addErrorMessage(data, String.format(ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25\u3002\u5f53\u524d\u4e1a\u52a1\u5bf9\u8c61\u4e0e\u53d6\u503c\u914d\u7f6e\u5355\u3010%1$s/%2$s\u3011\u91cd\u590d\u3002", (String)"CostCenterSaveOp_0", (String)"bd-assistant-opplugin", (Object[])new Object[0]), existFieldMap.getString("number"), existFieldMap.getString("name")));
                }
            }
        });
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        DynamicObject[] dataEntities = e.getDataEntities();
        if (dataEntities != null && dataEntities.length > 0) {
            for (DynamicObject dataEntity : dataEntities) {
                String entityNum = dataEntity.getDynamicObject("businessbill").getString("number");
                String configCacheKey = entityNum.concat("costcenterconfig");
                String enableCacheKey = entityNum.concat("costcenterenable");
                AppCache.get((String)"macc").remove("costcenter:" + configCacheKey);
                AppCache.get((String)"macc").remove("costcenter:" + enableCacheKey);
            }
        }
    }
}

