/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.assistant.opplugin.wbs;

import java.util.List;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.entity.validate.ValidateResult;
import kd.bos.exception.KDBizException;
import kd.bos.servicehelper.operation.OperationServiceHelper;

public class ProjectParamSaveOp
extends AbstractOperationServicePlugIn {
    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        super.endOperationTransaction(e);
        DynamicObject[] dataEntities = e.getDataEntities();
        Object[] idList = new Object[dataEntities.length];
        for (int i = 0; i < dataEntities.length; ++i) {
            idList[i] = dataEntities[i].getPkValue();
        }
        OperateOption operateOption = OperateOption.create();
        operateOption.setVariableValue("ignorewarn", String.valueOf(true));
        operateOption.setVariableValue("ignoreinteraction", String.valueOf(true));
        operateOption.setVariableValue("strictvalidation", String.valueOf(true));
        operateOption.setVariableValue("ishasright", String.valueOf(true));
        operateOption.setVariableValue("isStrict", String.valueOf(false));
        OperationResult submitResult = OperationServiceHelper.executeOperate((String)"submit", (String)"bd_projectparam", (Object[])idList, (OperateOption)operateOption);
        this.executeOperate(submitResult);
        OperationResult auditResult = OperationServiceHelper.executeOperate((String)"audit", (String)"bd_projectparam", (Object[])idList, (OperateOption)operateOption);
        this.executeOperate(auditResult);
    }

    private void executeOperate(OperationResult operationResult) {
        String errorMsg = this.getErrorMsg(operationResult);
        if (StringUtils.isNotEmpty((CharSequence)errorMsg)) {
            throw new KDBizException(errorMsg);
        }
    }

    private String getErrorMsg(OperationResult operationResult) {
        StringBuilder errMsg = new StringBuilder();
        List validateErrors = operationResult.getValidateResult().getValidateErrors();
        for (ValidateResult validateResult : validateErrors) {
            List allErrorInfo = validateResult.getAllErrorInfo();
            String validatorKey = validateResult.getValidatorKey();
            allErrorInfo.forEach(operateErrorInfo -> {
                String message = operateErrorInfo.getMessage();
                errMsg.append(validatorKey).append(message);
            });
        }
        for (OperateErrorInfo errorInfo : operationResult.getAllErrorInfo()) {
            String message = errorInfo.getMessage();
            errMsg.append(message);
        }
        return errMsg.toString();
    }
}

