/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.assistant.plugin.basedata;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ArrayUtils;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.flex.FlexEntityMetaUtils;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.form.flex.FlexFormMetaUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.bos.servicehelper.productsetting.ProductSettingServiceHelper;

public class AssgrpSaveOp
extends AbstractOperationServicePlugIn {
    private static final String[] inBaseData = new String[]{"filterdesc", "filtercondition"};
    private static final String[] inAssistantBaseData = new String[]{"assistanttype"};

    public void onAddValidators(AddValidatorsEventArgs e) {
        e.addValidator(new AbstractValidator(){

            public void validate() {
                if (ProductSettingServiceHelper.hasBlackFeature((String)"fibd", (String)"asstacttype")) {
                    Stream.of(this.dataEntities).filter(v -> !v.getDataEntity().getString("ctrlstrategy").equals("5")).forEach(v -> this.addErrorMessage((ExtendedDataEntity)v, ResManager.loadKDString((String)"\u5f53\u524d\u4ea7\u54c1\u6a21\u5f0f\u4e0d\u652f\u6301\u8be5\u63a7\u5236\u7b56\u7565\u3002", (String)"AssgrpSaveOp_0", (String)"bd-assistant-opplugin", (Object[])new Object[0])));
                }
                Arrays.stream(this.dataEntities).filter(extEntity -> {
                    DynamicObject entity = extEntity.getDataEntity();
                    if ("1".equals(entity.getString("valuetype"))) {
                        if (null == entity.getDynamicObject("valuesource")) {
                            return false;
                        }
                        MainEntityType sourceEntityType = MetadataServiceHelper.getDataEntityType((String)entity.getDynamicObject("valuesource").getPkValue().toString());
                        return sourceEntityType instanceof BillEntityType && 12 == sourceEntityType.getPrimaryKey().getDbType();
                    }
                    return false;
                }).forEach(entity -> this.addErrorMessage((ExtendedDataEntity)entity, ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u8bbe\u7f6e\u4e3b\u952e\u4e3a\u5b57\u7b26\u4e32\u7c7b\u578b\u7684\u503c\u6765\u6e90\u3002", (String)"AssgrpSaveOp_1", (String)"bd-assistant-opplugin", (Object[])new Object[0])));
                this.checkAsstNameUnique();
            }

            private void checkAsstNameUnique() {
                List<String> shareCtrls = Arrays.asList("5", "6");
                for (ExtendedDataEntity dataEntity : this.dataEntities) {
                    DynamicObject asst = dataEntity.getDataEntity();
                    String ctrlStrategy = asst.getString("ctrlstrategy");
                    if (!shareCtrls.contains(ctrlStrategy)) continue;
                    Boolean fromDatabase = asst.getDataEntityState().getFromDatabase();
                    String number = asst.getString("number");
                    if (fromDatabase.booleanValue()) {
                        BusinessDataServiceHelper.loadSingle((Object)asst.getPkValue(), (String)"bd_asstacttype");
                        DynamicObject dbAssist = QueryServiceHelper.queryOne((String)"bd_asstacttype", (String)"number", (QFilter[])new QFilter("id", "=", asst.getPkValue()).toArray());
                        if (Objects.nonNull(dbAssist) && !number.equals(dbAssist.getString("number"))) {
                            fromDatabase = false;
                        }
                    }
                    String regex = "^[a-z0-9A-Z]+$";
                    if (!fromDatabase.booleanValue() && !Pattern.matches(regex, number)) {
                        this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u6838\u7b97\u7ef4\u5ea6\u7684\u7f16\u7801\uff08%s\uff09\u4e0d\u5141\u8bb8\u6709\u4efb\u4f55\u7b26\u53f7\u548c\u4e2d\u6587\uff0c\u53ea\u80fd\u662f\u82f1\u6587\u5927\u5c0f\u5199\u548c\u6570\u5b57\u3002", (String)"AssgrpSaveOp_3", (String)"bd-assistant-opplugin", (Object[])new Object[0]), number));
                        continue;
                    }
                    String asstName = asst.getString("name");
                    long createorgId = asst.getLong("createorg_id");
                    boolean isExists = false;
                    if (asst.getDataEntityState().getFromDatabase()) {
                        DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)"bd_asstacttype", (String)"createorg,name,ctrlstrategy", (QFilter[])new QFilter("id", "=", (Object)asst.getLong("id")).toArray());
                        if (!asstName.equals(dynamicObject.getString("name")) || !ctrlStrategy.equals(dynamicObject.getString("ctrlStrategy")) || createorgId != dynamicObject.getLong("createorg")) {
                            isExists = this.checkCurrNameExists(true, dataEntity, ctrlStrategy, asstName);
                        }
                    } else {
                        isExists = this.checkCurrNameExists(false, dataEntity, ctrlStrategy, asstName);
                    }
                    if (!isExists) continue;
                    this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u201c\u540d\u79f0\u201d \u503c \u201c%s\u201d \u5df2\u5b58\u5728\uff0c\u8bf7\u8f93\u5165\u5176\u4ed6\u503c\u3002", (String)"AssgrpSaveOp_2", (String)"bd-assistant-opplugin", (Object[])new Object[0]), asstName));
                    return;
                }
            }

            private boolean checkCurrNameExists(boolean fromDB, ExtendedDataEntity dataEntity, String ctrlStrategy, String asstName) {
                QFilter filter;
                boolean isExists = false;
                if ("5".equals(ctrlStrategy)) {
                    filter = new QFilter("name", "=", (Object)asstName);
                    if (fromDB) {
                        filter.and("id", "!=", (Object)dataEntity.getDataEntity().getLong("id"));
                    }
                    isExists = QueryServiceHelper.exists((String)"bd_asstacttype", (QFilter[])filter.toArray());
                }
                if ("6".equals(ctrlStrategy)) {
                    filter = new QFilter("name", "=", (Object)asstName);
                    filter.and("ctrlstrategy", "=", (Object)"5");
                    if (fromDB) {
                        filter.and("id", "!=", (Object)dataEntity.getDataEntity().getLong("id"));
                    }
                    if (!(isExists = QueryServiceHelper.exists((String)"bd_asstacttype", (QFilter[])filter.toArray()))) {
                        Long createOrg = dataEntity.getDataEntity().getLong("createorg_id");
                        List orgIds = OrgUnitServiceHelper.getAllSubordinateOrgs((String)"10", Collections.singletonList(createOrg), (boolean)true);
                        List superOrgIds = OrgUnitServiceHelper.getAllSuperiorOrgs((String)"10", (long)createOrg);
                        if (!superOrgIds.isEmpty()) {
                            orgIds.addAll(superOrgIds);
                        }
                        QFilter orgFilter = new QFilter("createorg", "in", (Object)orgIds);
                        orgFilter.and("name", "=", (Object)asstName);
                        orgFilter.and("ctrlstrategy", "=", (Object)"6");
                        orgFilter.and("id", "!=", (Object)dataEntity.getDataEntity().getLong("id"));
                        isExists = QueryServiceHelper.exists((String)"bd_asstacttype", (QFilter[])orgFilter.toArray());
                    }
                }
                return isExists;
            }
        });
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        String baseData = "1";
        String assistantBaseData = "2";
        String other = "3";
        block10: for (DynamicObject entity : e.getDataEntities()) {
            String type;
            switch (type = (String)entity.get("valuetype")) {
                case "1": {
                    this.repairInvalidData(entity, inAssistantBaseData);
                    continue block10;
                }
                case "2": {
                    this.repairInvalidData(entity, inBaseData);
                    continue block10;
                }
                case "3": {
                    this.repairInvalidData(entity, (String[])ArrayUtils.addAll((Object[])inBaseData, (Object[])inAssistantBaseData));
                }
            }
        }
    }

    private void repairInvalidData(DynamicObject entity, String[] array) {
        for (String key : array) {
            Object object = entity.get(key);
            if (object == null) continue;
            if (object instanceof String && !"".equals(object.toString())) {
                entity.set(key, (Object)"");
                continue;
            }
            entity.set(key, null);
        }
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        if (e.getOperationKey().equals("save")) {
            FlexEntityMetaUtils.clearFlexEntityMeta();
            FlexFormMetaUtils.clearFlexFormMeta();
        }
    }
}

