/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.assistant.plugin.basedata;

import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bd.assistant.plugin.resource.BankAcctBizResource;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataRefrenceHelper;
import org.apache.commons.collections.CollectionUtils;

public class BankAccountSaveValidator
extends AbstractValidator {
    public void validate() {
        BankAcctBizResource resource = new BankAcctBizResource();
        Date currentDate = null;
        ExtendedDataEntity[] bankAcctEntities = this.getDataEntities();
        List banAcctIdList = Arrays.stream(bankAcctEntities).map(v -> v.getDataEntity().getPkValue()).collect(Collectors.toList());
        List orgIdList = Arrays.stream(bankAcctEntities).map(v -> v.getDataEntity().getDynamicObject("company").getPkValue()).collect(Collectors.toList());
        DynamicObject[] bankAcctsFromDB = BusinessDataServiceHelper.load((String)"bd_accountbanks", (String)"company,isdefaultpay,isdefaultrec,bankaccountnumber", (QFilter[])new QFilter[]{new QFilter("id", "not in", banAcctIdList), new QFilter("company", "in", orgIdList), new QFilter("acctstatus", "!=", (Object)"closed")});
        Map<Object, Object> orgAcctMap = new HashMap(16);
        if (bankAcctsFromDB.length > 0) {
            orgAcctMap = Arrays.stream(bankAcctsFromDB).collect(Collectors.groupingBy(v -> v.getDynamicObject("company").getPkValue()));
        }
        DynamicObject[] bankAccts = BusinessDataServiceHelper.load((Object[])banAcctIdList.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"bd_accountbanks"));
        HashMap bankAcctFromDBMap = Arrays.stream(bankAccts).collect(Collectors.toMap(v -> v.getPkValue(), p -> p, (o1, o2) -> o1, HashMap::new));
        for (ExtendedDataEntity dataEntity : bankAcctEntities) {
            List bankAcctFromDBs;
            DynamicObject capitalOrg;
            DynamicObject bankAccount = dataEntity.getDataEntity();
            Object bankAcctId = bankAccount.getPkValue();
            DynamicObject bankAcctFromDB = bankAcctFromDBMap.getOrDefault(bankAcctId, null);
            if (bankAcctFromDB != null && BaseDataRefrenceHelper.isRefrenced((String)bankAccount.getDataEntityType().getName(), (Object)bankAccount.getPkValue()) && this.isCurrencyChange(bankAccount, bankAcctFromDB).booleanValue()) {
                this.addErrorMessage(dataEntity, resource.getCurrencyChangeError());
                this.getOption().getVariables().put("currencyIsReduce", "true");
                bankAccount.set("currency", (Object)bankAcctFromDB.getDynamicObjectCollection("currency"));
                bankAccount.set("defaultcurrency", (Object)bankAcctFromDB.getDynamicObject("defaultcurrency"));
            }
            currentDate = new Date();
            Date openDate = bankAccount.getDate("opendate");
            if (null != openDate && currentDate.before(openDate)) {
                this.addErrorMessage(dataEntity, resource.getOpendateError());
            }
            DynamicObjectCollection currencys = bankAccount.getDynamicObjectCollection("currency");
            DynamicObject defCurrency = bankAccount.getDynamicObject("defaultcurrency");
            if (null == currencys) {
                this.addErrorMessage(dataEntity, resource.getCurrencyError());
            }
            if (null == defCurrency) {
                this.addErrorMessage(dataEntity, resource.getDefCurrError());
            }
            if (null == (capitalOrg = bankAccount.getDynamicObject("company")) || CollectionUtils.isEmpty((Collection)(bankAcctFromDBs = (List)orgAcctMap.getOrDefault(capitalOrg.getPkValue(), null)))) continue;
            boolean isdefaultpayment = bankAccount.getBoolean("isdefaultpay");
            List defltPayAccts = bankAcctFromDBs.stream().filter(v -> v.getBoolean("isdefaultpay")).collect(Collectors.toList());
            if (isdefaultpayment && !CollectionUtils.isEmpty(defltPayAccts)) {
                this.addErrorMessage(dataEntity, String.format(resource.getMultioutacctError(), ((DynamicObject)defltPayAccts.get(0)).getString("bankaccountnumber")));
            }
            boolean isdefaultreck = bankAccount.getBoolean("isdefaultrec");
            List defltRecAccts = bankAcctFromDBs.stream().filter(v -> v.getBoolean("isdefaultrec")).collect(Collectors.toList());
            if (!isdefaultreck || CollectionUtils.isEmpty(defltRecAccts)) continue;
            this.addErrorMessage(dataEntity, String.format(resource.getMultiinacctError(), ((DynamicObject)defltRecAccts.get(0)).getString("bankaccountnumber")));
        }
    }

    private Boolean isCurrencyChange(DynamicObject bankAcct, DynamicObject bankAcctFromDB) {
        DynamicObjectCollection currency = bankAcct.getDynamicObjectCollection("currency");
        DynamicObjectCollection currencysFromDB = bankAcctFromDB.getDynamicObjectCollection("currency");
        List currencyList = currency.stream().map(v -> v.getDynamicObject("fbasedataid").getPkValue()).collect(Collectors.toList());
        for (DynamicObject currencyFromDB : currencysFromDB) {
            if (currencyList.contains(currencyFromDB.getDynamicObject("fbasedataid").getPkValue())) continue;
            return true;
        }
        return false;
    }
}

