/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.assistant.plugin.basedata;

import kd.bd.assistant.helper.FinTreeHelper;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.servicehelper.BusinessDataServiceHelper;

public class FinTreeSaveValidator
extends AbstractValidator {
    public void validate() {
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            DynamicObject data = dataEntity.getDataEntity();
            boolean isFromDb = data.getDataEntityState().getFromDatabase();
            boolean isParentChanged = FinTreeHelper.isParentChanged(data);
            DynamicObject parentRef = data.getDynamicObject("parent");
            if (!isFromDb || !isParentChanged || null == parentRef) continue;
            DynamicObject parent = BusinessDataServiceHelper.loadSingle((Object)parentRef.getPkValue(), (String)parentRef.getDataEntityType().getName());
            String pLongNumber = parent.getString("longnumber");
            String mLongNumber = data.getString("longnumber");
            if (StringUtils.equals((CharSequence)mLongNumber, (CharSequence)pLongNumber)) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u4e0d\u80fd\u9009\u81ea\u5df1\u4f5c\u4e3a\u4e0a\u7ea7", (String)"FinTreeSaveValidator_0", (String)"bos-bd-opplugin", (Object[])new Object[0]));
                continue;
            }
            if (!pLongNumber.startsWith(mLongNumber)) continue;
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u4e0d\u80fd\u6307\u5b9a\u81ea\u5df1\u7684\u5b50\u8282\u70b9\u4e3a\u4e0a\u7ea7", (String)"FinTreeSaveValidator_1", (String)"bos-bd-opplugin", (Object[])new Object[0]));
        }
    }
}

