/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.assistant.plugin.basedata.importexport;

import java.util.HashMap;
import java.util.Map;
import kd.bd.assistant.plugin.basedata.importexport.AssistantDataGroupBuilder;
import kd.bd.assistant.plugin.basedata.importexport.IImportBuilder;
import kd.bd.assistant.plugin.basedata.importexport.NameAndNumberBuilder;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.events.BeforeImportDataEventArgs;
import kd.bos.entity.property.BasedataProp;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;

public class GLImportHelper {
    public static final String KEY_IMPORT_PROP = "importprop";
    public static final String KEY_ID = "id";
    private final Map<String, IImportBuilder> builderMap;
    private final AbstractFormPlugin p;
    private static final Map<String, IImportBuilder> rebuildMethodMap = new HashMap<String, IImportBuilder>(8);
    private static final IImportBuilder defaultBuilder = new NameAndNumberBuilder();

    public GLImportHelper(AbstractFormPlugin p) {
        this.p = p;
        this.builderMap = new HashMap<String, IImportBuilder>();
    }

    public void registerBuilder(String buildOn) {
        this.builderMap.put(buildOn, rebuildMethodMap.getOrDefault(this.getEntityByKey(buildOn), defaultBuilder));
    }

    public void build(BeforeImportDataEventArgs e, String ... entityToBuild) {
        for (String entity : entityToBuild) {
            IImportBuilder builder = this.builderMap.get(entity);
            if (builder == null) continue;
            this.doRebuild(e, entity, builder);
        }
    }

    private void doRebuild(BeforeImportDataEventArgs e, String condition, IImportBuilder builder) {
        Object obj = e.getSourceData().get(condition);
        if (!(obj instanceof Map)) {
            return;
        }
        Map val = (Map)obj;
        DynamicObjectCollection dynCollection = QueryServiceHelper.query((String)this.getEntityByKey(condition), (String)KEY_ID, (QFilter[])builder.build(this.p, e, condition).toArray());
        if (dynCollection.size() <= 0) {
            val.put(KEY_ID, 0L);
        } else {
            val.put(KEY_ID, ((DynamicObject)dynCollection.get(0)).get(KEY_ID));
        }
        val.put(KEY_IMPORT_PROP, KEY_ID);
    }

    private String getEntityByKey(String key) {
        MainEntityType mainType = this.p.getView().getModel().getDataEntityType();
        return ((BasedataProp)mainType.getProperty(key)).getBaseEntityId();
    }

    static {
        rebuildMethodMap.put("bos_assistantdatagroup", new AssistantDataGroupBuilder());
    }
}

