/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.assistant.plugin.bom;

import java.util.Date;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;

public class BOMVersionSaveValidator
extends AbstractValidator {
    private static final String OPERATE_SAVE = "save";
    private static final String KEY_BOMVERSION = "bd_bomversion";

    public void validate() {
        String operate = this.getOperateKey();
        if (OPERATE_SAVE.equals(operate)) {
            ExtendedDataEntity[] objs;
            block0: for (ExtendedDataEntity obj : objs = this.getDataEntities()) {
                DynamicObject bomversion = obj.getDataEntity();
                DynamicObject material = bomversion.getDynamicObject("material");
                if (material == null) {
                    this.addErrorMessage(obj, ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u7269\u6599\u3002", (String)"BOMVersionSaveValidator_0", (String)"bd-assistant-opplugin", (Object[])new Object[0]));
                    continue;
                }
                DynamicObject createorg = bomversion.getDynamicObject("createorg");
                if (createorg == null) {
                    this.addErrorMessage(obj, ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u521b\u5efa\u7ec4\u7ec7\u3002", (String)"BOMVersionSaveValidator_1", (String)"bd-assistant-opplugin", (Object[])new Object[0]));
                    continue;
                }
                DynamicObject bomversionrule = bomversion.getDynamicObject("bomversionrule");
                if (bomversionrule == null) {
                    this.addErrorMessage(obj, ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u7248\u672c\u89c4\u5219\u3002", (String)"BOMVersionSaveValidator_2", (String)"bd-assistant-opplugin", (Object[])new Object[0]));
                    continue;
                }
                String name = bomversion.getString("name");
                if (StringUtils.isBlank((CharSequence)name)) {
                    this.addErrorMessage(obj, ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u7248\u672c\u3002", (String)"BOMVersionSaveValidator_3", (String)"bd-assistant-opplugin", (Object[])new Object[0]));
                    continue;
                }
                Date effectdate = bomversion.getDate("effectdate");
                if (effectdate == null) {
                    this.addErrorMessage(obj, ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u751f\u6548\u65f6\u95f4\u3002", (String)"BOMVersionSaveValidator_4", (String)"bd-assistant-opplugin", (Object[])new Object[0]));
                    continue;
                }
                Date invaliddate = bomversion.getDate("invaliddate");
                if (invaliddate == null) {
                    this.addErrorMessage(obj, ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u5931\u6548\u65f6\u95f4\u3002", (String)"BOMVersionSaveValidator_5", (String)"bd-assistant-opplugin", (Object[])new Object[0]));
                    continue;
                }
                if (effectdate.after(invaliddate)) {
                    this.addErrorMessage(obj, ResManager.loadKDString((String)"\u751f\u6548\u65f6\u95f4\u5fc5\u987b\u5c0f\u4e8e\u5931\u6548\u65f6\u95f4\u3002", (String)"BOMVersionSaveValidator_6", (String)"bd-assistant-opplugin", (Object[])new Object[0]));
                    continue;
                }
                QFilter qFilter = new QFilter("material", "=", material.getPkValue());
                QFilter qFilter2 = new QFilter("createorg", "=", createorg.getPkValue());
                String selectFields = "name,effectdate,invaliddate,id";
                DynamicObjectCollection versions = QueryServiceHelper.query((String)KEY_BOMVERSION, (String)selectFields, (QFilter[])new QFilter[]{qFilter, qFilter2});
                for (int i = 0; i < versions.size(); ++i) {
                    DynamicObject version = (DynamicObject)versions.get(i);
                    Date oldeffectdate = version.getDate("effectdate");
                    Date oldinvaliddate = version.getDate("invaliddate");
                    if (oldeffectdate == null || oldinvaliddate == null || version.getString("id").equals(bomversion.getPkValue().toString()) || oldeffectdate.compareTo(effectdate) < 0) continue;
                    this.addErrorMessage(obj, String.format(ResManager.loadKDString((String)"\u7269\u6599[%1$s]\u5728[%2$s]\u7ec4\u7ec7\u4e0b\u5b58\u5728\u751f\u6548\u65f6\u95f4\u5927\u4e8e\u65b0\u7248\u672c[%3$s]\u7684\u65e7\u7248\u672c[%4$s]\uff0c\u8bf7\u4fee\u6539\u65b0\u7248\u672c\u6216\u65e7\u7248\u672c\u7684\u751f\u6548\u65f6\u95f4\u3002", (String)"BOMVersionSaveValidator_7", (String)"bd-assistant-opplugin", (Object[])new Object[0]), material.getString("number"), createorg.getString("name"), name, version.getString("name")));
                    continue block0;
                }
            }
        }
    }
}

