/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.master.service;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bd.master.enums.MasterUniquenessError;
import kd.bd.master.enums.QFilterType;
import kd.bd.master.helper.MasterValidatorCfgHelper;
import kd.bd.master.inf.MatserCheckInf;
import kd.bd.master.util.CheckDataUtil;
import kd.bd.master.vo.ErrorVo;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;

public class SupplierCheckService
implements MatserCheckInf {
    private static final Log logger = LogFactory.getLog(SupplierCheckService.class);
    private CheckDataUtil checkDataUtil = new CheckDataUtil();

    @Override
    @Deprecated
    public List<ErrorVo> checkPersonData(List<ExtendedDataEntity> dataEntities) {
        return null;
    }

    @Override
    @Deprecated
    public List<ErrorVo> checkOtherData(List<ExtendedDataEntity> dataEntities) {
        return null;
    }

    @Override
    public List<ErrorVo> checkOtherData(List<ExtendedDataEntity> dataEntities, String op) {
        return this.checkNoPersonTypeData(dataEntities, op);
    }

    @Override
    public List<ErrorVo> checkPersonData(List<ExtendedDataEntity> dataEntities, String op) {
        return this.checkPersonTypeData(dataEntities, op);
    }

    private List<ErrorVo> checkNoPersonTypeData(List<ExtendedDataEntity> dataEntities, String op) {
        ArrayList<ErrorVo> errors = new ArrayList<ErrorVo>();
        logger.info("SupplierCheckService.checkNoPersonTypeData dataEntities sise:" + dataEntities.size());
        errors.addAll(this.checkData(dataEntities, op));
        return errors;
    }

    private List<ErrorVo> checkPersonTypeData(List<ExtendedDataEntity> dataEntities, String op) {
        ArrayList<ErrorVo> errors = new ArrayList<ErrorVo>();
        logger.info("SupplierCheckService.checkPersonTypeData dataEntities sise:" + dataEntities.size());
        errors.addAll(this.validatePersonData(dataEntities, op));
        return errors;
    }

    private List<ErrorVo> validatePersonData(List<ExtendedDataEntity> exitDatas, String op) {
        ArrayList<ErrorVo> errors = new ArrayList<ErrorVo>();
        if (exitDatas != null && exitDatas.size() > 0) {
            HashMap<Object, Set<String>> numberMap = new HashMap<Object, Set<String>>();
            HashMap<ExtendedDataEntity, String> nameAndIdnos = new HashMap<ExtendedDataEntity, String>(exitDatas.size());
            ArrayList<Long> ids = new ArrayList<Long>(exitDatas.size());
            for (ExtendedDataEntity extendedDataEntity : exitDatas) {
                ids.add(extendedDataEntity.getDataEntity().getLong("id"));
                errors.addAll(this.checkDataUtil.constructPersonTypeData(numberMap, nameAndIdnos, extendedDataEntity, op));
            }
            if (numberMap != null && numberMap.size() > 0) {
                for (Map.Entry entry : numberMap.entrySet()) {
                    if (op.equals("save")) {
                        errors.addAll(this.checkDataUtil.queryDuplicatedData(entry, exitDatas, ids, QFilterType.EXITNUMBER, "bd_supplier", "number", MasterUniquenessError.ORGNUMBEREXIT));
                        continue;
                    }
                    errors.addAll(this.checkDataUtil.queryDuplicatedData(entry, exitDatas, ids, QFilterType.EXITNUMBER, "bd_supplier", "number", MasterUniquenessError.ORGNUMBEREXITSUMBIT));
                }
            }
            if (nameAndIdnos != null && nameAndIdnos.size() > 0) {
                if (op.equals("save")) {
                    errors.addAll(this.checkDataUtil.queryNameAndIdnoDuplicatedData(nameAndIdnos, ids, exitDatas, "bd_supplier", MasterUniquenessError.NAMEANDIDCARDEXIT));
                } else {
                    errors.addAll(this.checkDataUtil.queryNameAndIdnoDuplicatedData(nameAndIdnos, ids, exitDatas, "bd_supplier", MasterUniquenessError.NAMEANDIDCARDEXITSUMBIT));
                }
            }
        }
        return errors;
    }

    private List<ErrorVo> checkData(List<ExtendedDataEntity> exitDatas, String op) {
        ArrayList<ErrorVo> errors = new ArrayList<ErrorVo>();
        if (exitDatas != null && exitDatas.size() > 0) {
            ArrayList<Long> ids = new ArrayList<Long>(exitDatas.size());
            HashMap<Object, Set<String>> numbers = new HashMap<Object, Set<String>>();
            HashMap<Object, Set<String>> names = new HashMap<Object, Set<String>>();
            boolean checkName = MasterValidatorCfgHelper.getValidatorResult("bd_supplier", op.equals("save") ? "sup_name_save" : "sup_name_submit", op);
            for (ExtendedDataEntity extendedDataEntity : exitDatas) {
                errors.addAll(this.checkDataUtil.constructExitData(ids, numbers, names, extendedDataEntity, checkName, op));
            }
            if (numbers != null && numbers.size() > 0) {
                for (Map.Entry entry : numbers.entrySet()) {
                    if (op.equals("save")) {
                        errors.addAll(this.checkDataUtil.queryDuplicatedData(entry, exitDatas, ids, QFilterType.EXITNUMBER, "bd_supplier", "number", MasterUniquenessError.ORGNUMBEREXIT));
                        continue;
                    }
                    errors.addAll(this.checkDataUtil.queryDuplicatedData(entry, exitDatas, ids, QFilterType.EXITNUMBER, "bd_supplier", "number", MasterUniquenessError.ORGNUMBEREXITSUMBIT));
                }
            }
            if (checkName && names != null && names.size() > 0) {
                for (Map.Entry entry : names.entrySet()) {
                    if (op.equals("save")) {
                        errors.addAll(this.checkDataUtil.queryDuplicatedData(entry, exitDatas, ids, QFilterType.ExitNAME, "bd_supplier", "name", MasterUniquenessError.ORGNAMEEXIT));
                        continue;
                    }
                    errors.addAll(this.checkDataUtil.queryDuplicatedData(entry, exitDatas, ids, QFilterType.ExitNAME, "bd_supplier", "name", MasterUniquenessError.ORGNAMEEXITSUMBIT));
                }
            }
        }
        return errors;
    }
}

