/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.master.util;

import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import kd.bd.master.enums.MaterialInfoEnum;
import kd.bd.master.vo.OperationApiVo;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperationResult;
import org.apache.commons.collections4.map.HashedMap;

public class ErrorInfoConverUtil {
    public static void billPKErrorMapping(Map<String, OperationApiVo> pkErrorMap, OperationResult result) {
        Map dataMap = result.getBillNos();
        List errorInfoList = result.getAllErrorOrValidateInfo();
        block0: for (Map.Entry map : dataMap.entrySet()) {
            String key = map.getKey().toString();
            Long id = Long.valueOf(key);
            if (result.getSuccessPkIds().contains(id)) {
                pkErrorMap.put(id.toString(), new OperationApiVo(id.toString(), (String)map.getValue(), "", "true"));
                continue;
            }
            for (IOperateInfo ori : errorInfoList) {
                String pk = String.valueOf(ori.getPkValue());
                if (!key.equals(pk)) continue;
                String error = ori.getMessage();
                OperationApiVo value = pkErrorMap.get(pk);
                if (value != null) {
                    String newError = value.getMessage() + ";" + error;
                    pkErrorMap.put(pk, new OperationApiVo(pk, (String)map.getValue(), newError, "false"));
                    continue block0;
                }
                pkErrorMap.put(pk, new OperationApiVo(pk, (String)map.getValue(), error, "false"));
                continue block0;
            }
        }
    }

    public static Map<String, OperationApiVo> buildMaterialBizInfoErrorMapping(DynamicObject[] materialBizInfoArr, OperationResult operResult) {
        HashedMap resultMap = new HashedMap(materialBizInfoArr.length);
        List errorInfoList = operResult.getAllErrorOrValidateInfo();
        HashedMap errorInfoMap = new HashedMap(errorInfoList.size());
        errorInfoList.stream().forEach(arg_0 -> ErrorInfoConverUtil.lambda$buildMaterialBizInfoErrorMapping$0((Map)errorInfoMap, arg_0));
        for (DynamicObject materialBizInfo : materialBizInfoArr) {
            String materialId = materialBizInfo.getDynamicObject("masterid").getString("id");
            String materialBizInfoId = materialBizInfo.getString("id");
            String materialBizInfoFormId = materialBizInfo.getDynamicObjectType().getName();
            String mtBizInfoErrMapKey = ErrorInfoConverUtil.getMtBizInfoErrMapKey(materialId, materialBizInfoFormId);
            if (operResult.getSuccessPkIds().contains(Long.parseLong(materialBizInfoId))) {
                resultMap.put(mtBizInfoErrMapKey, new OperationApiVo(materialBizInfoId, "", "", "true"));
                continue;
            }
            StringJoiner errMsgJoiner = new StringJoiner(":");
            errMsgJoiner.add(materialBizInfoFormId).add((CharSequence)errorInfoMap.get(materialBizInfoId));
            resultMap.put(mtBizInfoErrMapKey, new OperationApiVo(materialBizInfoId, "", errMsgJoiner.toString(), "false"));
        }
        return resultMap;
    }

    public static String getMtBizInfoErrMapKey(String materialId, String materialBizInfoFormId) {
        StringJoiner strJoiner = new StringJoiner("!");
        strJoiner.add(materialId).add(materialBizInfoFormId);
        return strJoiner.toString();
    }

    public static String getErrorInfo(String tabName, List<IOperateInfo> operateInfos) {
        if (operateInfos != null && operateInfos.size() > 0) {
            StringBuilder errorInfos = new StringBuilder();
            errorInfos.append(MaterialInfoEnum.getDescByCode((String)tabName));
            for (IOperateInfo operateInfo : operateInfos) {
                errorInfos.append(operateInfo.getMessage());
                errorInfos.append(" ");
            }
            return errorInfos.toString();
        }
        return "";
    }

    private static /* synthetic */ void lambda$buildMaterialBizInfoErrorMapping$0(Map errorInfoMap, IOperateInfo e) {
        errorInfoMap.put(e.getPkValue().toString(), e.getMessage());
    }
}

