/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.master;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kd.bd.master.util.GroupStandardUtils;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.base.AbstractBasedataController;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.FormMetadataCache;
import kd.bos.form.field.events.BaseDataCustomControllerEvent;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;

public class BasedataGroupStandardFilterController
extends AbstractBasedataController {
    private static final long serialVersionUID = -4787764868522094426L;
    public static final String ROOTNODEID = "8609760E-EF83-4775-A9FF-CCDEC7C0B689";
    public static final String ENTITY_CUSTOMER = "bd_customer";
    public static final String ENTITY_SUPPLIER = "bd_supplier";
    public static final String ENTITY_MATERIAL = "bd_material";
    public static final String ENTITY_GROUPDETAIL = "groupdetail";
    public static final String ENTITY_GROUPSTANDARD = "groupstandard";
    public static final String ENTITY_GROUP = "group";
    public static final String PROP_ID = "id";
    public static final String PROP_STANDARD = "standard";
    public static final String PROP_PARENT = "parent";
    public static final String PROP_GROUP = "group";
    public static final String PROP_SUPPLIER = "supplier";
    public static final String PROP_CUSTOMER = "customer";
    public static final String PROP_MATERIAL = "material";
    public static final String PROP_LONGNUMBER = "longnumber";
    public static final String PROP_PURPOSE = "purpose";
    public static final String CP_GROUPSTANDARD = "groupStandard";
    public static final String ISSHOWALLNOORG = "isShowAllNoOrg";
    public static final String ISSHOWALLNOORG_TRUE = "true";
    public static final String BASEDATA_FUZZY = "FUZZY";

    public void buildBaseDataCoreFilter(BaseDataCustomControllerEvent event) {
        ListShowParameter listShowParameter = event.getListShowParameter();
        if (!listShowParameter.isLookUp()) {
            return;
        }
        String entityNumber = listShowParameter.getBillFormId();
        if (StringUtils.isBlank((CharSequence)entityNumber)) {
            return;
        }
        String masterDataEntity = FormMetadataCache.getFormConfig((String)entityNumber).getEntityTypeId();
        QFilter filter = this.genRefreshFilter(ROOTNODEID, masterDataEntity, listShowParameter);
        if (filter == null) {
            return;
        }
        ArrayList<QFilter> qfilters = new ArrayList<QFilter>();
        List listFilters = listShowParameter.getListFilterParameter().getQFilters();
        qfilters.addAll(listFilters);
        qfilters.add(filter);
        ORM orm = ORM.create();
        HashSet<Long> ids = new HashSet<Long>();
        try (DataSet ds = orm.queryDataSet(((Object)((Object)this)).getClass().getName(), masterDataEntity, PROP_ID, qfilters.toArray(new QFilter[0]), null);){
            for (Row row : ds) {
                if (row.getLong(PROP_ID) == null) continue;
                ids.add(row.getLong(PROP_ID));
            }
        }
        QFilter qf = new QFilter(PROP_ID, "in", ids);
        event.addQFilter(qf);
    }

    private QFilter genRefreshFilter(String nodeId, String entityNumber, ListShowParameter param) {
        String entity = entityNumber;
        String selectfield = "";
        if (entity.contains(PROP_CUSTOMER)) {
            entity = ENTITY_CUSTOMER;
            selectfield = PROP_CUSTOMER;
        } else if (entity.contains(PROP_SUPPLIER)) {
            entity = ENTITY_SUPPLIER;
            selectfield = PROP_SUPPLIER;
        } else if (entity.contains(PROP_MATERIAL)) {
            entity = ENTITY_MATERIAL;
            selectfield = PROP_MATERIAL;
        }
        QFilter qFilter = null;
        String defGroupStandard = GroupStandardUtils.getDefGroupStandard((ListShowParameter)param, (String)entity);
        Set useOrgs = GroupStandardUtils.getCreateOrgs((ListShowParameter)param, (String)entity, (String)defGroupStandard, null);
        String alias = BusinessDataServiceHelper.newDynamicObject((String)entity).getDataEntityType().getAlias();
        Set groupOrgs = new HashSet();
        Set<Long> groupStandards = new HashSet();
        if (!useOrgs.isEmpty()) {
            groupOrgs = GroupStandardUtils.getGroupOrgId((String)entity, (Set)useOrgs);
            groupStandards = GroupStandardUtils.getGroupStandard((String)entity, (Set)useOrgs, (boolean)true);
        }
        if (groupStandards == null || groupStandards.size() == 0) {
            groupStandards = new HashSet(1);
            String defStandard = GroupStandardUtils.getDefGroupStandard((String)entity);
            groupStandards.add(Long.valueOf(defStandard));
        }
        ArrayList<Long> paramList = new ArrayList<Long>();
        StringBuilder useTable = new StringBuilder();
        useTable.append(" RIGHT JOIN ").append(alias).append(ENTITY_GROUPDETAIL).append(" ur on ur.f").append(selectfield).append("id = ").append(entity).append(".fid ");
        if (StringUtils.isNotBlank((CharSequence)defGroupStandard)) {
            useTable.append(" and ur.fstandardId = ? ");
            paramList.add(Long.valueOf(defGroupStandard));
        } else {
            useTable.append(" and ur.fstandardId in ( ");
            for (int i = 0; i < groupStandards.size(); ++i) {
                if (i == 0) {
                    useTable.append('?');
                    continue;
                }
                useTable.append(",?");
            }
            useTable.append(" ) ");
            paramList.addAll(groupStandards);
        }
        String isShowAllNoOrg = (String)param.getCustomParam(ISSHOWALLNOORG);
        if (!ISSHOWALLNOORG_TRUE.equals(isShowAllNoOrg)) {
            StringBuilder useOrgStr = new StringBuilder();
            if (groupOrgs != null && groupOrgs.size() >= 1) {
                for (Long useOrg : groupOrgs) {
                    if (StringUtils.isBlank((CharSequence)useOrgStr)) {
                        useOrgStr.append(useOrg);
                        continue;
                    }
                    useOrgStr.append(',').append(useOrg);
                }
                if (StringUtils.isNotBlank((CharSequence)useOrgStr)) {
                    useTable.append(" and  ur.fcreateorgId in ( ").append((CharSequence)useOrgStr).append(')');
                }
            }
        }
        qFilter = QFilter.joinSQL((String)entity, (String)useTable.toString(), (Object[])paramList.toArray(new Object[0]));
        return qFilter;
    }
}

