/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.master;

import java.util.EventObject;
import java.util.List;
import kd.bos.base.AbstractBasePlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.BizDataEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;

public class DefaultGroupStandardSettingEditPlugin
extends AbstractBasePlugIn
implements BeforeF7SelectListener {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit object = (BasedataEdit)this.getControl("object");
        object.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        String key = evt.getProperty().getName();
        ListShowParameter param = (ListShowParameter)evt.getFormShowParameter();
        if ("object".equals(key)) {
            List qFilters = param.getListFilterParameter().getQFilters();
            qFilters.add(new QFilter("modeltype", "!=", (Object)"ReportFormModel"));
        }
    }

    public void afterCopyData(EventObject e) {
        super.afterCopyData(e);
        this.getModel().setValue("object", null);
        this.getModel().setValue("ispreset", (Object)false);
        this.getModel().setDataChanged(false);
    }

    public void createNewData(BizDataEventArgs e) {
        super.createNewData(e);
        BasedataEdit mat = (BasedataEdit)this.getControl("matgroupstandardcode");
        mat.setMustInput(true);
    }

    public void beforeBindData(EventObject e) {
        this.changeGroupStandardByMasterType();
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String name = e.getProperty().getName();
        if ("mastertype".equals(name)) {
            this.changeGroupStandardByMasterType();
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate foper = (FormOperate)args.getSource();
        String key = foper.getOperateKey();
        if ("save".equals(key)) {
            String masterType = (String)this.getModel().getValue("mastertype");
            DynamicObject value = null;
            if ("bd_material".equals(masterType)) {
                value = (DynamicObject)this.getModel().getValue("matgroupstandardcode");
            } else if ("bd_customer".equals(masterType)) {
                value = (DynamicObject)this.getModel().getValue("cusgroupstandardcode");
            } else if ("bd_supplier".equals(masterType)) {
                value = (DynamicObject)this.getModel().getValue("supgroupstandardcode");
            } else {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u4e3b\u6570\u636e\u7c7b\u578b\u4e0d\u6b63\u786e\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"DefaultGroupStandardSettingEditPlugin_3", (String)"bd-master-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            String number = value.getString("number");
            this.checkNumber(number, masterType, args);
            this.checkObject(args);
        }
    }

    private void checkObject(BeforeDoOperationEventArgs args) {
        QFilter q = new QFilter("number", "=", ((DynamicObject)this.getModel().getValue("object")).get("number"));
        QFilter[] qs = new QFilter[]{q};
        DynamicObject objDym = BusinessDataServiceHelper.loadSingleFromCache((String)"bos_entityobject", (String)"id", (QFilter[])qs);
        if (objDym == null) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u4e1a\u52a1\u5bf9\u8c61\u5df2\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"DefaultGroupStandardSettingEditPlugin_4", (String)"bd-master-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
        }
    }

    private void checkNumber(String number, String masterType, BeforeDoOperationEventArgs args) {
        QFilter q = new QFilter("number", "=", (Object)number);
        QFilter qEnable = new QFilter("enable", "=", (Object)"1");
        QFilter[] qs = new QFilter[]{q.and(qEnable)};
        DynamicObject supDym = BusinessDataServiceHelper.loadSingleFromCache((String)(masterType + "groupstandard"), (String)"id", (QFilter[])qs);
        if (supDym == null) {
            if ("bd_material".equals(masterType)) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u7269\u6599\u5206\u7c7b\u6807\u51c6\u7f16\u7801\u5df2\u88ab\u7981\u7528\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"DefaultGroupStandardSettingEditPlugin_0", (String)"bd-master-formplugin", (Object[])new Object[0]));
            } else if ("bd_customer".equals(masterType)) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5ba2\u6237\u5206\u7c7b\u6807\u51c6\u7f16\u7801\u5df2\u88ab\u7981\u7528\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"DefaultGroupStandardSettingEditPlugin_1", (String)"bd-master-formplugin", (Object[])new Object[0]));
            } else if ("bd_supplier".equals(masterType)) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u4f9b\u5e94\u5546\u5206\u7c7b\u6807\u51c6\u7f16\u7801\u5df2\u88ab\u7981\u7528\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"DefaultGroupStandardSettingEditPlugin_2", (String)"bd-master-formplugin", (Object[])new Object[0]));
            }
            args.setCancel(true);
        }
    }

    private void changeGroupStandardByMasterType() {
        String mastertype = (String)this.getModel().getValue("mastertype");
        BasedataEdit mat = (BasedataEdit)this.getControl("matgroupstandardcode");
        BasedataEdit cus = (BasedataEdit)this.getControl("cusgroupstandardcode");
        BasedataEdit sup = (BasedataEdit)this.getControl("supgroupstandardcode");
        mat.setMustInput(false);
        cus.setMustInput(false);
        sup.setMustInput(false);
        if ("bd_material".equals(mastertype)) {
            mat.setMustInput(true);
        } else if ("bd_customer".equals(mastertype)) {
            cus.setMustInput(true);
        } else if ("bd_supplier".equals(mastertype)) {
            sup.setMustInput(true);
        }
    }
}

