/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.master;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.EventObject;
import kd.bd.master.inf.IColsSelectStrategy;
import kd.bd.master.inf.MetaHelper;
import kd.bd.master.inf.SelectParams;
import kd.bd.master.inf.SimpleStrategy;
import kd.bd.master.util.FormShowParameterUtil;
import kd.bd.master.util.MultiLangUtil;
import kd.bos.base.AbstractBasePlugIn;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.servicehelper.BusinessDataServiceHelper;

public class PropertiesconfigEditPlugin
extends AbstractBasePlugIn {
    public void afterLoadData(EventObject e) {
        super.afterLoadData(e);
        IDataModel model = this.getModel();
        Object targetObj = model.getValue("targetobj");
        String langName = RequestContext.get().getLang().name();
        String targetObjNumber = targetObj instanceof DynamicObject ? ((DynamicObject)targetObj).getString("number") : "";
        MainEntityType targetObjDt = "".equals(targetObjNumber) ? null : EntityMetadataCache.getDataEntityType((String)targetObjNumber);
        int count = model.getEntryRowCount("colsmap");
        for (int i = 0; i < count; ++i) {
            this.bindColNames(i, langName, targetObjDt);
        }
        model.setDataChanged(false);
    }

    private void bindColNames(int index, String langName, MainEntityType targetObjDt) {
        IDataModel model = this.getModel();
        String targetValue = String.valueOf(model.getValue("targetobjcolno", index));
        if (targetObjDt != null && StringUtils.isNotBlank((CharSequence)targetValue)) {
            String targetColName = MultiLangUtil.getEntityKeyWithLang((String)langName, (MainEntityType)targetObjDt, (String)targetValue);
            model.setValue("targetobjcolno", (Object)targetColName, index);
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"targetobjcolno"});
    }

    public void click(EventObject evt) {
        String key;
        switch (key = ((Control)evt.getSource()).getKey()) {
            case "targetobjcolno": {
                this.clickTargetObjCol(evt);
                break;
            }
        }
    }

    private void clickTargetObjCol(EventObject evt) {
        DynamicObject targetObj = (DynamicObject)this.getModel().getValue("targetobj");
        if (targetObj == null) {
            return;
        }
        this.showColsTreePage(targetObj.getString("number"), null, "targetObjColCB");
    }

    private void showColsTreePage(String entityNumber, IColsSelectStrategy strategy, String key) {
        IColsSelectStrategy selectStrategy = strategy;
        if (selectStrategy == null) {
            selectStrategy = new SimpleStrategy();
        }
        SelectParams params = new SelectParams();
        MetaHelper metaHelper = new MetaHelper(selectStrategy, entityNumber);
        String jsonTree = metaHelper.buildTree2JSON();
        params.setJsonTree(jsonTree);
        FormShowParameter fp = FormShowParameterUtil.readyColsTreePage((String)"bd_colstree_select", (ShowType)ShowType.Modal, (SelectParams)params, (CloseCallBack)new CloseCallBack((IFormPlugin)this, key));
        this.getView().showForm(fp);
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        String actionId;
        switch (actionId = e.getActionId()) {
            case "targetObjColCB": {
                this.targetObjColCloseCallBack(e);
                break;
            }
        }
    }

    private void targetObjColCloseCallBack(ClosedCallBackEvent e) {
        IDataModel model = this.getModel();
        int index = model.getEntryCurrentRowIndex("colsmap");
        Object data = e.getReturnData();
        JSONArray jsonArray = JSON.parseArray((String)((String)data));
        if (jsonArray == null || jsonArray.isEmpty()) {
            return;
        }
        JSONObject info = jsonArray.getJSONObject(0);
        model.setValue("targetobjcol", (Object)info.getString("id"), index);
        model.setValue("targetobjcolno", (Object)info.getString("text"), index);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String key = e.getProperty().getName();
        ChangeData[] valueSet = e.getChangeSet();
        switch (key) {
            case "targetobj": {
                this.changeTargetObj(e);
                break;
            }
            case "targetobjcolno": {
                int rowIndex = valueSet[0].getRowIndex();
                if (!StringUtils.isBlank((Object)valueSet[0].getNewValue())) break;
                this.getModel().setValue("targetobjcol", (Object)"", rowIndex);
            }
        }
    }

    private void changeTargetObj(PropertyChangedArgs e) {
        ChangeData[] datas;
        IDataModel model = this.getModel();
        model.deleteEntryData("colsmap");
        for (ChangeData changeData : datas = e.getChangeSet()) {
            DynamicObject newValue = (DynamicObject)changeData.getNewValue();
            if (newValue == null) continue;
            model.setValue("bizapp", (Object)newValue.getDynamicObject("bizappid"));
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        DynamicObject entityObject = BusinessDataServiceHelper.newDynamicObject((String)"bos_entityobject");
        entityObject.set("id", (Object)"bd_material");
        this.getModel().setValue("targetobj", (Object)entityObject);
    }
}

