/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.master.list;

import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import kd.bd.master.util.GroupStandardUtils;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.ITreeModel;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.entity.property.GroupProp;
import kd.bos.entity.tree.TreeNode;
import kd.bos.filter.CommonFilterColumn;
import kd.bos.filter.FilterContainer;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.control.Control;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.RefreshNodeEvent;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.events.BeforeCreateListColumnsArgs;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.FilterContainerSearchClickArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.PagerClickEvent;
import kd.bos.form.events.PagerClickListener;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.events.BeforeFilterF7SelectEvent;
import kd.bos.form.field.events.BeforeFilterF7SelectListener;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.ListColumn;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.list.SeqColumnType;
import kd.bos.list.events.BuildTreeListFilterEvent;
import kd.bos.list.events.ListRowClickEvent;
import kd.bos.list.plugin.StandardTreeListPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.list.ListDataProvider;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;

public class UnitCodeTreeListPlugin
extends StandardTreeListPlugin
implements PagerClickListener,
BeforeFilterF7SelectListener {
    private static Log logger = LogFactory.getLog(UnitCodeTreeListPlugin.class);
    public static final String ROOTNODEID = "8609760E-EF83-4775-A9FF-CCDEC7C0B689";
    private Set<String> hideSet = new HashSet<String>();
    private static final String TREEVIEW = "treeview";
    public static final String NUMBER = "number";
    public static final String NAME = "name";
    public static final String SOURCE = "showsource";
    public static final String DATAID = "dataid";
    public static final String CREATEORG = "org";
    public static final String PROP_FSEQ = "fseq";
    public static final String BIZPARTNER = "bizpartner";
    public static final String MASTERID = "masterid";
    private static final String CREATEORG_FILEDNAME = "createorg.id";
    private static final String REFRESHNODE_CALLBACK = "refreshNodeCallback";
    private static final String RELATIONSUP_CLOSECALLBACK = "relationsupCloseCallBack";
    private static final String RELATIONCUS_CLOSECALLBACK = "relationcusCloseCallBack";

    public void initialize() {
        FilterContainer fc = (FilterContainer)this.getControl("filtercontainerap");
        fc.addBeforeF7SelectListener((BeforeFilterF7SelectListener)this);
    }

    public void beforeCreateListColumns(BeforeCreateListColumnsArgs args) {
        super.beforeCreateListColumns(args);
        String[][] arrays = new String[][]{{ResManager.loadKDString((String)"\u5e8f\u53f7", (String)"UnitCodeTreeListPlugin_0", (String)"bd-master-formplugin", (Object[])new Object[0]), PROP_FSEQ}, {ResManager.loadKDString((String)"\u5206\u5f55\u5185\u7801", (String)"UnitCodeTreeListPlugin_1", (String)"bd-master-formplugin", (Object[])new Object[0]), "id"}, {ResManager.loadKDString((String)"\u7f16\u7801", (String)"UnitCodeTreeListPlugin_2", (String)"bd-master-formplugin", (Object[])new Object[0]), NUMBER}, {ResManager.loadKDString((String)"\u540d\u79f0", (String)"UnitCodeTreeListPlugin_3", (String)"bd-master-formplugin", (Object[])new Object[0]), NAME}, {ResManager.loadKDString((String)"\u6765\u6e90", (String)"UnitCodeTreeListPlugin_4", (String)"bd-master-formplugin", (Object[])new Object[0]), SOURCE}, {ResManager.loadKDString((String)"\u521b\u5efa\u7ec4\u7ec7", (String)"UnitCodeTreeListPlugin_5", (String)"bd-master-formplugin", (Object[])new Object[0]), CREATEORG}, {ResManager.loadKDString((String)"\u5546\u52a1\u4f19\u4f34", (String)"UnitCodeTreeListPlugin_6", (String)"bd-master-formplugin", (Object[])new Object[0]), BIZPARTNER}};
        this.hideSet.add("id");
        List listColumns = args.getListColumns();
        listColumns.clear();
        for (String[] arr : arrays) {
            ListColumn listColumn = this.createListColumn(arr);
            listColumns.add(listColumn);
        }
        args.setListColumns(listColumns);
    }

    public ListColumn createListColumn(String[] arr) {
        return this.createListColumn(arr, "14%");
    }

    public ListColumn createListColumn(String[] arr, String width) {
        ListColumn listColumn = new ListColumn();
        listColumn.setCaption(new LocaleString(arr[0]));
        listColumn.setClassName("className");
        listColumn.setFieldName(arr[1]);
        listColumn.setKey("key" + arr[1]);
        listColumn.setTextAlign("left");
        listColumn.setParentViewKey("gridview");
        listColumn.setListFieldKey(arr[1]);
        listColumn.setSeq(2);
        if (this.hideSet.contains(arr[1])) {
            listColumn.setVisible(0);
        } else {
            listColumn.setVisible(11);
        }
        if (PROP_FSEQ.equals(arr[1])) {
            listColumn.setSeqColumnType(SeqColumnType.EntitySeq.name());
        } else {
            listColumn.setWidth(new LocaleString(width));
        }
        return listColumn;
    }

    public void beforeCreateListDataProvider(BeforeCreateListDataProviderArgs args) {
        super.beforeCreateListDataProvider(args);
        args.setListDataProvider((IListDataProvider)new UnitCodeListDataProviderImpl());
    }

    public void pagerClick(PagerClickEvent pagerclickevent) {
    }

    public void listRowDoubleClick(ListRowClickEvent evt) {
        evt.setCancel(true);
    }

    public void initializeTree(EventObject e) {
        super.initializeTree(e);
        this.initTree();
    }

    private void initTree() {
        TreeNode root = this.getTreeModel().createRootNode();
        if (root != null) {
            root.setChildren(new ArrayList(0));
            this.getTreeModel().setRoot(root);
            String rootId = root.getId();
            this.getTreeModel().setCurrentNodeId((Object)rootId);
            logger.info("\u5ba2\u5546\u5206\u6790\u7801\u6839\u8282\u70b9ID\u4e3a\uff1a" + rootId);
        }
    }

    public void refreshNode(RefreshNodeEvent e) {
        String nodeId = e.getNodeId().toString();
        List<TreeNode> treeNodes = this.getTreeChildren(nodeId);
        e.setChildNodes(treeNodes);
    }

    private List<TreeNode> getTreeChildren(String nodeId) {
        ArrayList<TreeNode> treeNodes = new ArrayList<TreeNode>();
        if (!ROOTNODEID.equals(nodeId)) {
            return treeNodes;
        }
        String createorg = this.getPageCache().get("createOrg");
        if (createorg == null) {
            return treeNodes;
        }
        DynamicObject strucObj = QueryServiceHelper.queryOne((String)"bos_org_structure", (String)"longnumber", (QFilter[])new QFilter[]{new QFilter(CREATEORG, "=", (Object)createorg)});
        if (strucObj == null) {
            return treeNodes;
        }
        String longnumber = strucObj.getString("longnumber");
        List longnumberList = GroupStandardUtils.getAllSuperiorLongnumber((String)longnumber, (String)"!");
        HashSet<String> orgSets = new HashSet<String>();
        ORM ormOv = ORM.create();
        DynamicObject[] dynamicObjectArray = null;
        try (DataSet ds = ormOv.queryDataSet(UnitCodeTreeListPlugin.class.getName(), "bos_org_structure", CREATEORG, new QFilter[]{new QFilter("longnumber", "in", (Object)longnumberList)});){
            for (Row row : ds) {
                if (row.getString(CREATEORG) == null) continue;
                orgSets.add(row.getString(CREATEORG));
            }
        }
        catch (Throwable object) {
            dynamicObjectArray = object;
            throw object;
        }
        if (ROOTNODEID.equals(nodeId)) {
            DynamicObject[] loads;
            for (DynamicObject group : loads = BusinessDataServiceHelper.load((String)"bd_bizpartnerunitcode", (String)"id,name", (QFilter[])new QFilter[]{new QFilter("createorg", "in", orgSets)}, (String)"id asc")) {
                if (group.getPkValue() == null) continue;
                TreeNode treeNode = new TreeNode();
                treeNode.setId(group.getPkValue().toString());
                treeNode.setParentid(ROOTNODEID);
                treeNode.setText(group.getString(NAME));
                treeNodes.add(treeNode);
            }
        }
        return treeNodes;
    }

    public void filterContainerInit(FilterContainerInitArgs args) {
        super.filterContainerInit(args);
        List filterColumnList = args.getFilterContainerInitEvent().getCommonFilterColumns();
        LocaleString orgPropertyName = new LocaleString(ResManager.loadKDString((String)"\u4e1a\u52a1\u7ec4\u7ec7", (String)"UnitCodeTreeListPlugin_9", (String)"bd-master-formplugin", (Object[])new Object[0]));
        ListShowParameter listShowParameter = (ListShowParameter)this.getView().getFormShowParameter();
        if (listShowParameter.isLookUp()) {
            return;
        }
        CommonFilterColumn orgColumn = new CommonFilterColumn();
        orgColumn.setCaption(orgPropertyName);
        orgColumn.setFieldName(CREATEORG_FILEDNAME);
        orgColumn.setMustInput(true);
        orgColumn.setEntityField(false);
        if (filterColumnList.contains(orgColumn)) {
            return;
        }
        String createOrg = this.getPageCache().get("createOrg");
        ArrayList<ComboItem> combos = new ArrayList<ComboItem>();
        long userId = Long.parseLong(RequestContext.get().getUserId());
        String appNumber = this.getView().getFormShowParameter().getAppId();
        MainEntityType met = EntityMetadataCache.getDataEntityType((String)"bd_bizpartnerunitcode");
        String appid = null;
        if (!StringUtils.isBlank((CharSequence)appNumber)) {
            try {
                appid = AppMetadataCache.getAppInfo((String)appNumber).getId();
            }
            catch (Exception ex) {
                appid = met.getAppId();
            }
        }
        String defaultOrg = "";
        HasPermOrgResult result = PermissionServiceHelper.getAllPermOrgs((Long)userId, (String)appid, (String)"bd_bizpartnerunitcode", (String)"47156aff000000ac");
        DynamicObjectCollection col = GroupStandardUtils.getOrgByViewAndPermOrg((Object)"16", (HasPermOrgResult)result);
        if (col == null || col.size() < 1) {
            return;
        }
        long longinOrg = RequestContext.get().getOrgId();
        for (DynamicObject org : col) {
            if (org == null || org.get("id") == null) continue;
            if (StringUtils.isBlank((CharSequence)createOrg) && String.valueOf(org.get("id")).equals(longinOrg + "")) {
                defaultOrg = String.valueOf(longinOrg);
            }
            ComboItem item = new ComboItem();
            item.setCaption(new LocaleString(org.getString(NAME)));
            item.setValue(String.valueOf(org.get("id")));
            combos.add(item);
        }
        if (StringUtils.isBlank((CharSequence)defaultOrg)) {
            defaultOrg = ((DynamicObject)col.get(0)).get("id").toString();
        }
        orgColumn.setComboItems(combos);
        orgColumn.setType("enum");
        if (StringUtils.isBlank((CharSequence)createOrg)) {
            orgColumn.setDefaultValue(defaultOrg);
        } else {
            orgColumn.setDefaultValue(createOrg);
        }
        filterColumnList.add(0, orgColumn);
        if (StringUtils.isBlank((CharSequence)createOrg)) {
            this.getPageCache().put("createOrg", defaultOrg);
            TreeView treeView = this.getTreeListView().getTreeView();
            TreeNode root = this.getTreeModel().createRootNode();
            if (root == null) {
                this.treeListView.refreshTreeView();
            } else {
                this.treeListView.getTreeView().deleteAllNodes();
                treeView.addNode(root);
                treeView.treeNodeClick("", root.getId());
            }
        } else {
            this.getPageCache().put("createOrg", createOrg);
        }
        this.clearPageCache();
    }

    public void setFilter(SetFilterEvent e) {
        super.setFilter(e);
        List filters = e.getQFilters();
        Iterator iterator = filters.iterator();
        while (iterator.hasNext()) {
            QFilter qFilter = (QFilter)iterator.next();
            String property = qFilter.getProperty();
            if (!property.equals(CREATEORG_FILEDNAME)) continue;
            iterator.remove();
        }
        Object currentNodeId = this.getTreeModel().getCurrentNodeId();
        if (currentNodeId != null) {
            this.getPageCache().put("currentNodeId", currentNodeId.toString());
        } else {
            this.getPageCache().put("currentNodeId", this.getTreeModel().getRoot().getId());
        }
    }

    public void treeNodeClick(TreeNodeEvent e) {
        String nodeId = e.getNodeId().toString();
        TreeNode rootNode = this.getTreeModel().getRoot();
        if (rootNode == null || rootNode.getTreeNode(nodeId, 20) == null) {
            return;
        }
        this.treeListView.getTreeView().queryTreeNodeChildren(e.getParentNodeId().toString(), nodeId);
    }

    public void beforeF7Select(BeforeFilterF7SelectEvent event) {
        HasPermOrgResult result;
        DynamicObjectCollection col;
        if (!"bos_org".equals(event.getRefEntityId())) {
            return;
        }
        String appNumber = this.getView().getFormShowParameter().getAppId();
        long userId = Long.parseLong(RequestContext.get().getUserId());
        MainEntityType met = EntityMetadataCache.getDataEntityType((String)"bd_bizpartnerunitcode");
        String appid = null;
        if (!StringUtils.isBlank((CharSequence)appNumber)) {
            try {
                appid = AppMetadataCache.getAppInfo((String)appNumber).getId();
            }
            catch (Exception ex) {
                appid = met.getAppId();
            }
        }
        if ((col = GroupStandardUtils.getOrgByViewAndPermOrg((Object)"16", (HasPermOrgResult)(result = PermissionServiceHelper.getAllPermOrgs((Long)userId, (String)appid, (String)"bd_bizpartnerunitcode", (String)"47156aff000000ac")))) == null || col.size() < 1) {
            return;
        }
        ArrayList<Long> orgIds = new ArrayList<Long>();
        for (DynamicObject viewOrg : col) {
            if (viewOrg == null || viewOrg.get("id") == null) continue;
            orgIds.add(Long.valueOf(viewOrg.get("id").toString()));
        }
        ArrayList<QFilter> filterList = new ArrayList<QFilter>();
        QFilter idsFilter = new QFilter("id", "in", orgIds);
        filterList.add(idsFilter);
        event.addCustomParam("orgFuncId", (Object)"16");
        event.addCustomParam("orgViewSchemeNumber", (Object)"16");
        event.getQfilters().addAll(filterList);
    }

    public void filterContainerSearchClick(FilterContainerSearchClickArgs args) {
        Map filterValues = args.getSearchClickEvent().getFilterValues();
        List customFiterList = (List)filterValues.get("customfilter");
        if (customFiterList == null) {
            return;
        }
        String orgId = null;
        for (Map customFiter : customFiterList) {
            String createOrg;
            List orgIds;
            List fieldNames = (List)customFiter.get("FieldName");
            if (fieldNames == null || fieldNames.size() == 0 || !CREATEORG_FILEDNAME.equals(fieldNames.get(0)) || (orgIds = (List)customFiter.get("Value")) == null || orgIds.size() == 0) continue;
            orgId = String.valueOf(orgIds.get(0));
            if (orgId.equals(createOrg = this.getPageCache().get("createOrg"))) {
                return;
            }
            this.getPageCache().put("createOrg", orgId);
            TreeView treeView = this.getTreeListView().getTreeView();
            TreeNode root = this.getTreeModel().createRootNode();
            if (root == null) {
                this.treeListView.refreshTreeView();
            } else {
                this.treeListView.getTreeView().deleteAllNodes();
                treeView.addNode(root);
                treeView.treeNodeClick("", root.getId());
            }
            this.clearPageCache();
            break;
        }
    }

    private void clearPageCache() {
        String searchNodesCacheKey = this.getView().getPageId() + "_searchNodes";
        String matchNodesCacheKey = this.getView().getPageId() + "_matchNodes";
        String oldSearchTextCacheKey = this.getView().getPageId() + "_oldSearchText";
        String searchIndexCacheKey = this.getView().getPageId() + "_searchIndex";
        this.getPageCache().remove(searchNodesCacheKey);
        this.getPageCache().remove(matchNodesCacheKey);
        this.getPageCache().remove(oldSearchTextCacheKey);
        this.getPageCache().remove(searchIndexCacheKey);
    }

    public void buildTreeListFilter(BuildTreeListFilterEvent e) {
        e.setCancel(true);
        e.addQFilter(this.genRefreshFilter(e.getNodeId().toString()));
    }

    private QFilter genRefreshFilter(String nodeId) {
        QFilter qFilter = null;
        if (ROOTNODEID.equals(nodeId)) {
            qFilter = new QFilter(MASTERID, "=", (Object)0);
            return qFilter;
        }
        qFilter = new QFilter(MASTERID, "=", (Object)nodeId);
        return qFilter;
    }

    public void treeToolbarClick(EventObject e) {
        ITreeModel treeModel = this.getTreeModel();
        Control ctl = (Control)e.getSource();
        GroupProp prop = this.getTreeModel().getGroupProp();
        String entityId = "bd_bizpartnerunitcode";
        String currentNodeId = (String)treeModel.getCurrentNodeId();
        String userId = RequestContext.get().getUserId();
        String createOrg = this.getPageCache().get("createOrg");
        MainEntityType met = EntityMetadataCache.getDataEntityType((String)"bd_bizpartnerunitcode");
        String appNumber = this.getView().getFormShowParameter().getAppId();
        String appid = null;
        if (!StringUtils.isBlank((CharSequence)appNumber)) {
            try {
                appid = AppMetadataCache.getAppInfo((String)appNumber).getId();
            }
            catch (Exception ex) {
                appid = met.getAppId();
            }
        }
        if (ctl.getKey().equals("btnnew")) {
            boolean hasRight;
            boolean bl = hasRight = PermissionServiceHelper.checkPermission((long)Long.parseLong(userId), (String)"DIM_ORG", (long)Long.parseLong(createOrg), (String)appid, (String)"bd_bizpartnerunitcode", (String)"47156aff000000ac") == 1;
            if (!hasRight) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u5f53\u524d\u7ec4\u7ec7\u4e0b\u7684\u65b0\u589e\u64cd\u4f5c\u6743\u9650\uff0c\u7981\u6b62\u64cd\u4f5c\u3002", (String)"UnitCodeTreeListPlugin_10", (String)"bd-master-formplugin", (Object[])new Object[0]));
                return;
            }
            this.addGroupNode(entityId, currentNodeId, createOrg);
        } else if (ctl.getKey().equals("btnedit")) {
            boolean hasRight;
            boolean bl = hasRight = PermissionServiceHelper.checkPermission((long)Long.parseLong(userId), (String)"DIM_ORG", (long)Long.parseLong(createOrg), (String)appid, (String)"bd_bizpartnerunitcode", (String)"4715a0df000000ac") == 1;
            if (!hasRight) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u5f53\u524d\u7ec4\u7ec7\u4e0b\u7684\u4fee\u6539\u64cd\u4f5c\u6743\u9650\uff0c\u7981\u6b62\u64cd\u4f5c\u3002", (String)"UnitCodeTreeListPlugin_11", (String)"bd-master-formplugin", (Object[])new Object[0]));
                return;
            }
            if (this.getTreeModel().getRoot().getId().equals(currentNodeId)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0d\u5141\u8bb8\u7f16\u8f91\u6839\u8282\u70b9\u3002", (String)"UnitCodeTreeListPlugin_12", (String)"bd-master-formplugin", (Object[])new Object[0]));
                return;
            }
            if (StringUtils.isBlank((CharSequence)currentNodeId)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6709\u6548\u7684\u5206\u7ec4\u8282\u70b9\u3002", (String)"UnitCodeTreeListPlugin_13", (String)"bd-master-formplugin", (Object[])new Object[0]));
                return;
            }
            if (!prop.isNeedRefreshTree()) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u7981\u7528\u5237\u65b0\u60c5\u51b5\u4e0d\u5141\u8bb8\u4fee\u6539\u8282\u70b9\u3002", (String)"UnitCodeTreeListPlugin_14", (String)"bd-master-formplugin", (Object[])new Object[0]));
                return;
            }
            this.editGroupNode(entityId, currentNodeId, createOrg);
        } else if (ctl.getKey().equals("btndel")) {
            boolean hasRight;
            DynamicObject unitCode = BusinessDataServiceHelper.loadSingle((String)"bd_bizpartnerunitcode", (String)"id,createorg", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)currentNodeId)});
            String createorg = "";
            if (unitCode.get("createorg") instanceof DynamicObject) {
                createorg = unitCode.getDynamicObject("createorg").getPkValue().toString();
            } else if (unitCode.get("createorg") instanceof Long) {
                createorg = String.valueOf(unitCode.getLong("createorg"));
            }
            if (StringUtils.isBlank((CharSequence)createOrg) || StringUtils.isBlank((CharSequence)createorg) || !createOrg.equals(createorg)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0d\u80fd\u5220\u9664\u5176\u4ed6\u7ec4\u7ec7\u521b\u5efa\u7684\u6570\u636e\u3002", (String)"UnitCodeTreeListPlugin_15", (String)"bd-master-formplugin", (Object[])new Object[0]));
                return;
            }
            boolean bl = hasRight = PermissionServiceHelper.checkPermission((long)Long.parseLong(userId), (String)"DIM_ORG", (long)Long.parseLong(createOrg), (String)appid, (String)"bd_bizpartnerunitcode", (String)"4715e1f1000000ac") == 1;
            if (!hasRight) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u5f53\u524d\u7ec4\u7ec7\u4e0b\u7684\u5220\u9664\u64cd\u4f5c\u6743\u9650\uff0c\u7981\u6b62\u64cd\u4f5c\u3002", (String)"UnitCodeTreeListPlugin_16", (String)"bd-master-formplugin", (Object[])new Object[0]));
                return;
            }
            if (this.getTreeModel().getRoot().getId().equals(currentNodeId)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0d\u5141\u8bb8\u5220\u9664\u6839\u8282\u70b9\u3002", (String)"UnitCodeTreeListPlugin_17", (String)"bd-master-formplugin", (Object[])new Object[0]));
                return;
            }
            if (StringUtils.isBlank((CharSequence)currentNodeId)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6709\u6548\u7684\u5206\u7ec4\u8282\u70b9\u3002", (String)"UnitCodeTreeListPlugin_13", (String)"bd-master-formplugin", (Object[])new Object[0]));
                return;
            }
            if (!prop.isNeedRefreshTree()) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u7981\u7528\u5237\u65b0\u60c5\u51b5\u4e0d\u5141\u8bb8\u5220\u9664\u8282\u70b9\u3002", (String)"UnitCodeTreeListPlugin_18", (String)"bd-master-formplugin", (Object[])new Object[0]));
                return;
            }
            this.getPageCache().put("currentNodeId", currentNodeId);
            TreeView tv = (TreeView)this.getView().getControl(TREEVIEW);
            Map focusNode = tv.getTreeState().getFocusNode();
            String text = focusNode.get("text").toString();
            ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener("group_bar_del", (IFormPlugin)this);
            String strs = String.format(ResManager.loadKDString((String)"\u60a8\u786e\u8ba4\u5220\u9664\u5ba2\u5546\u7edf\u4e00\u7801%s\uff1f ", (String)"UnitCodeTreeListPlugin_19", (String)"bd-master-formplugin", (Object[])new Object[0]), text);
            this.getView().showConfirm(strs, MessageBoxOptions.YesNo, confirmCallBacks);
        }
    }

    private void addGroupNode(String entityId, String currentNodeId, String createOrg) {
        BillShowParameter formShowParameter = this.createFormShowParameter(entityId, currentNodeId, "group_bar_add");
        formShowParameter.setCustomParam("operate", (Object)"addnew");
        formShowParameter.setCustomParam(CREATEORG, (Object)createOrg);
        CloseCallBack callBack = new CloseCallBack((IFormPlugin)this, REFRESHNODE_CALLBACK);
        formShowParameter.setCloseCallBack(callBack);
        this.getView().showForm((FormShowParameter)formShowParameter);
    }

    private void editGroupNode(String entityId, String currentNodeId, String createOrg) {
        BillShowParameter formShowParameter = this.createFormShowParameter(entityId, currentNodeId, "group_bar_edit");
        formShowParameter.setPkId(this.getTreeModel().getCurrentNodeId());
        formShowParameter.setCustomParam(CREATEORG, (Object)createOrg);
        formShowParameter.setStatus(OperationStatus.EDIT);
        formShowParameter.setCustomParam("operate", (Object)"edit");
        CloseCallBack callBack = new CloseCallBack((IFormPlugin)this, REFRESHNODE_CALLBACK);
        formShowParameter.setCloseCallBack(callBack);
        this.getView().showForm((FormShowParameter)formShowParameter);
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        Object returnData;
        String callBackId = e.getActionId();
        Object currentNodeId = this.getTreeModel().getCurrentNodeId();
        if (REFRESHNODE_CALLBACK.equals(callBackId)) {
            TreeView treeView = this.getTreeListView().getTreeView();
            TreeNode root = this.getTreeModel().createRootNode();
            if (root == null) {
                this.treeListView.refreshTreeView();
            } else {
                this.treeListView.getTreeView().deleteAllNodes();
                treeView.addNode(root);
                treeView.treeNodeClick("", root.getId());
            }
            treeView.treeNodeClick("", currentNodeId.toString());
        } else if (RELATIONSUP_CLOSECALLBACK.equals(callBackId)) {
            returnData = e.getReturnData();
            if (returnData == null || ((ListSelectedRowCollection)returnData).size() <= 0) {
                return;
            }
            if (currentNodeId != null && !ROOTNODEID.equals(currentNodeId)) {
                ListSelectedRowCollection rows = (ListSelectedRowCollection)returnData;
                ArrayList<Long> ids = new ArrayList<Long>(rows.size());
                for (ListSelectedRow row : rows) {
                    ids.add(Long.valueOf(String.valueOf(row.getPrimaryKeyValue())));
                }
                DynamicObject unitCode = BusinessDataServiceHelper.loadSingle((String)"bd_bizpartnerunitcode", (String)"id,entryentity.source,entryentity.dataid,entryentity.bizpartnerid", (QFilter[])new QFilter[]{new QFilter("id", "=", currentNodeId)});
                DynamicObjectCollection entryentitys = unitCode.getDynamicObjectCollection("entryentity");
                for (Object entryentity : entryentitys) {
                    Long dataid = 0L;
                    if (entryentity.get(DATAID) instanceof DynamicObject) {
                        dataid = (Long)entryentity.getDynamicObject(DATAID).getPkValue();
                    } else if (entryentity.get(DATAID) instanceof Long) {
                        dataid = entryentity.getLong(DATAID);
                    }
                    if (!"bd_supplier".equals(entryentity.get("source").toString()) || dataid == 0L || !ids.contains(dataid)) continue;
                    ids.remove(dataid);
                }
                DynamicObjectCollection datas = QueryServiceHelper.query((String)"bd_supplier", (String)"id,bizpartner", (QFilter[])new QFilter[]{new QFilter("id", "in", ids)});
                for (DynamicObject data : datas) {
                    DynamicObject entryentity = new DynamicObject(unitCode.getDynamicObjectCollection("entryentity").getDynamicObjectType());
                    entryentity.set("source", (Object)"bd_supplier");
                    entryentity.set(DATAID, data.get("id"));
                    entryentity.set("bizpartnerid", data.get(BIZPARTNER));
                    entryentitys.add((Object)entryentity);
                }
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{unitCode});
            }
        } else if (RELATIONCUS_CLOSECALLBACK.equals(callBackId)) {
            returnData = e.getReturnData();
            if (returnData == null || ((ListSelectedRowCollection)returnData).size() <= 0) {
                return;
            }
            if (currentNodeId != null && !ROOTNODEID.equals(currentNodeId)) {
                ListSelectedRowCollection rows = (ListSelectedRowCollection)returnData;
                ArrayList<Long> ids = new ArrayList<Long>(rows.size());
                for (ListSelectedRow row : rows) {
                    ids.add(Long.valueOf(String.valueOf(row.getPrimaryKeyValue())));
                }
                Iterator unitCode = BusinessDataServiceHelper.loadSingle((String)"bd_bizpartnerunitcode", (String)"entryentity.source,entryentity.dataid,entryentity.bizpartnerid", (QFilter[])new QFilter[]{new QFilter("id", "=", currentNodeId)});
                DynamicObjectCollection entryentitys = unitCode.getDynamicObjectCollection("entryentity");
                for (DynamicObject entryentity : entryentitys) {
                    Long dataid = 0L;
                    if (entryentity.get(DATAID) instanceof DynamicObject) {
                        dataid = (Long)entryentity.getDynamicObject(DATAID).getPkValue();
                    } else if (entryentity.get(DATAID) instanceof Long) {
                        dataid = entryentity.getLong(DATAID);
                    }
                    if (!"bd_customer".equals(entryentity.get("source").toString()) || dataid == 0L || !ids.contains(dataid)) continue;
                    ids.remove(dataid);
                }
                Iterator datas = QueryServiceHelper.query((String)"bd_customer", (String)"id,bizpartner", (QFilter[])new QFilter[]{new QFilter("id", "in", ids)});
                Iterator iterator = datas.iterator();
                while (iterator.hasNext()) {
                    DynamicObject data = (DynamicObject)iterator.next();
                    DynamicObject entryentity = new DynamicObject(unitCode.getDynamicObjectCollection("entryentity").getDynamicObjectType());
                    entryentity.set("source", (Object)"bd_customer");
                    entryentity.set(DATAID, data.get("id"));
                    entryentity.set("bizpartnerid", data.get(BIZPARTNER));
                    entryentitys.add((Object)entryentity);
                }
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{unitCode});
            }
        }
        BillList billList = (BillList)this.getView().getControl("billlistap");
        billList.refresh();
    }

    public void itemClick(ItemClickEvent evt) {
        String itemkey = evt.getItemKey();
        if (!("btn_relationsup".equals(itemkey) || "btn_delete".equals(itemkey) || "btn_relationcus".equals(itemkey))) {
            return;
        }
        ITreeModel treeModel = this.getTreeModel();
        String currentNodeId = (String)treeModel.getCurrentNodeId();
        if (this.getTreeModel().getRoot().getId().equals(currentNodeId)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0d\u5141\u8bb8\u7f16\u8f91\u6839\u8282\u70b9\u3002", (String)"UnitCodeTreeListPlugin_12", (String)"bd-master-formplugin", (Object[])new Object[0]));
            return;
        }
        if (StringUtils.isBlank((CharSequence)currentNodeId)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6709\u6548\u7684\u5206\u7ec4\u8282\u70b9\u3002", (String)"UnitCodeTreeListPlugin_13", (String)"bd-master-formplugin", (Object[])new Object[0]));
            return;
        }
        DynamicObject unitCode = BusinessDataServiceHelper.loadSingle((String)"bd_bizpartnerunitcode", (String)"id,createorg", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)currentNodeId)});
        String createorg = "";
        if (unitCode.get("createorg") instanceof DynamicObject) {
            createorg = unitCode.getDynamicObject("createorg").getPkValue().toString();
        } else if (unitCode.get("createorg") instanceof Long) {
            createorg = String.valueOf(unitCode.getLong("createorg"));
        }
        String createOrg = this.getPageCache().get("createOrg");
        if (StringUtils.isBlank((CharSequence)createOrg) || StringUtils.isBlank((CharSequence)createorg) || !createOrg.equals(createorg)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0d\u80fd\u4fee\u6539\u5176\u4ed6\u7ec4\u7ec7\u521b\u5efa\u7684\u6570\u636e\u3002", (String)"UnitCodeTreeListPlugin_20", (String)"bd-master-formplugin", (Object[])new Object[0]));
            return;
        }
        switch (itemkey.toLowerCase(Locale.ENGLISH)) {
            case "btn_delete": {
                BillList billList = (BillList)this.getView().getControl("billlistap");
                ListSelectedRowCollection rows = billList.getSelectedRows();
                if (rows.size() == 0) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6570\u636e", (String)"UnitCodeTreeListPlugin_21", (String)"bd-master-formplugin", (Object[])new Object[0]));
                    return;
                }
                ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener("btn_delete", (IFormPlugin)this);
                this.getView().showConfirm(ResManager.loadKDString((String)"\u60a8\u786e\u8ba4\u5220\u9664\u5f53\u524d\u9009\u62e9\u5173\u8054\u4fe1\u606f\uff1f", (String)"UnitCodeTreeListPlugin_22", (String)"bd-master-formplugin", (Object[])new Object[0]), MessageBoxOptions.YesNo, confirmCallBacks);
                break;
            }
            case "btn_relationsup": {
                this.showRelatFrom("bd_supplier", RELATIONSUP_CLOSECALLBACK);
                break;
            }
            case "btn_relationcus": {
                this.showRelatFrom("bd_customer", RELATIONCUS_CLOSECALLBACK);
                break;
            }
        }
    }

    private void showRelatFrom(String entityName, String closecallback) {
        String createOrg = this.getPageCache().get("createOrg");
        if (createOrg == null) {
            return;
        }
        ListShowParameter lsp = ShowFormHelper.createShowListForm((String)entityName, (boolean)true);
        QFilter baseDataFilter = BaseDataServiceHelper.getBaseDataFilter((String)entityName, (Long)Long.valueOf(createOrg));
        ListFilterParameter listFilter = lsp.getListFilterParameter();
        List filters = listFilter.getQFilters();
        if (null != filters) {
            filters.add(baseDataFilter);
        } else {
            listFilter.setFilter(baseDataFilter);
        }
        filters = listFilter.getQFilters();
        filters.add(new QFilter("enable", "=", (Object)"1"));
        filters.add(new QFilter("status", "=", (Object)"C"));
        lsp.setCloseCallBack(new CloseCallBack((IFormPlugin)this, closecallback));
        this.getView().showForm((FormShowParameter)lsp);
    }

    public void confirmCallBack(MessageBoxClosedEvent event) {
        super.confirmCallBack(event);
        String callBackId = event.getCallBackId();
        if ("btn_delete".equals(callBackId)) {
            BillList billList = (BillList)this.getView().getControl("billlistap");
            ListSelectedRowCollection rows = billList.getSelectedRows();
            ArrayList<Long> ids = new ArrayList<Long>(rows.size());
            for (ListSelectedRow row : rows) {
                ids.add(Long.valueOf(String.valueOf(row.getPrimaryKeyValue())));
            }
            Object[] obj = new Object[]{};
            StringBuilder sql = new StringBuilder();
            sql.append(" delete from T_BD_BPUnitCodeReg where fentryid  in (?");
            if (ids.size() > 0) {
                obj = new Object[ids.size()];
                for (int i = 0; i < ids.size(); ++i) {
                    if (i != 0) {
                        sql.append(" ,? ");
                    }
                    obj[i] = ids.get(i);
                }
            }
            sql.append(" ) ");
            DB.execute((DBRoute)DBRoute.basedata, (String)sql.toString(), (Object[])obj);
            billList.clearSelection();
            billList.refresh();
        }
    }

    public void filterContainerBeforeF7Select(BeforeFilterF7SelectEvent args) {
        super.filterContainerBeforeF7Select(args);
        String fieldName = args.getFieldName();
        if (CREATEORG_FILEDNAME.equals(fieldName)) {
            HasPermOrgResult result;
            DynamicObjectCollection col;
            String appNumber = this.getView().getFormShowParameter().getAppId();
            long userId = Long.parseLong(RequestContext.get().getUserId());
            MainEntityType met = EntityMetadataCache.getDataEntityType((String)"bd_bizpartnerunitcode");
            String appid = null;
            if (!StringUtils.isBlank((CharSequence)appNumber)) {
                try {
                    appid = AppMetadataCache.getAppInfo((String)appNumber).getId();
                }
                catch (Exception ex) {
                    appid = met.getAppId();
                }
            }
            if ((col = GroupStandardUtils.getOrgByViewAndPermOrg((Object)"16", (HasPermOrgResult)(result = PermissionServiceHelper.getAllPermOrgs((Long)userId, (String)appid, (String)"bd_bizpartnerunitcode", (String)"47156aff000000ac")))) == null || col.size() < 1) {
                return;
            }
            ArrayList<Long> orgIds = new ArrayList<Long>();
            for (DynamicObject viewOrg : col) {
                if (viewOrg == null || viewOrg.get("id") == null) continue;
                orgIds.add(Long.valueOf(viewOrg.get("id").toString()));
            }
            QFilter idsFilter = new QFilter("id", "in", orgIds);
            args.getQfilters().add(idsFilter);
        }
    }

    class UnitCodeListDataProviderImpl
    extends ListDataProvider {
        UnitCodeListDataProviderImpl() {
        }

        public DynamicObjectCollection getData(int start, int limit) {
            DynamicObjectCollection col = new DynamicObject((DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"bd_unitcodetreelist")).getDynamicObjectCollection("entryentity");
            String nodeId = UnitCodeTreeListPlugin.this.getPageCache().get("currentNodeId");
            if (UnitCodeTreeListPlugin.ROOTNODEID.equals(nodeId)) {
                nodeId = "0";
            }
            final HashSet orgIds = new HashSet();
            final HashSet bizpartnerIds = new HashSet();
            Object[] obj = new Object[]{nodeId, nodeId};
            StringBuilder sql = new StringBuilder();
            sql.append(" select bpu.fid,cu.fnumber,cul.fname,cu.fcreateorgid,bpu.fsource,bp.fid,bpu.fentryid from t_bd_customer cu ");
            sql.append(" inner join T_BD_BPUnitCodeReg bpu  on bpu.fdataid = cu.fid ");
            sql.append(" inner join t_bd_bizpartner bp on bp.fid = cu.fbizpartnerid ");
            sql.append(" inner join t_bd_customer_l cul on cul.fid = cu.fid and cul.flocaleid = '").append(Locale.getDefault()).append("' ");
            sql.append(" where bpu.fid = ? ");
            sql.append(" union ");
            sql.append(" select bpu.fid,su.fnumber,sul.fname,su.fcreateorgid,bpu.fsource,bp.fid,bpu.fentryid from t_bd_supplier su ");
            sql.append(" inner join T_BD_BPUnitCodeReg bpu  on bpu.fdataid = su.fid ");
            sql.append(" inner join t_bd_bizpartner bp on bp.fid = su.fbizpartnerid ");
            sql.append(" inner join t_bd_supplier_l sul on sul.fid = su.fid and sul.flocaleid =  '").append(Locale.getDefault()).append("' ");
            sql.append(" where bpu.fid = ? ;");
            List dataList = (List)DB.query((DBRoute)DBRoute.basedata, (String)sql.toString(), (Object[])obj, (ResultSetHandler)new ResultSetHandler<List<Map<String, Object>>>(){

                public List<Map<String, Object>> handle(ResultSet rs) throws Exception {
                    ArrayList<Map<String, Object>> dataList = new ArrayList<Map<String, Object>>(rs.getRow());
                    while (rs.next()) {
                        if (!StringUtils.isNotBlank((CharSequence)rs.getString(1))) continue;
                        HashMap<String, String> dataInfo = new HashMap<String, String>(7);
                        dataInfo.put("id", rs.getString(7));
                        dataInfo.put(UnitCodeTreeListPlugin.MASTERID, rs.getString(1));
                        dataInfo.put(UnitCodeTreeListPlugin.NUMBER, rs.getString(2));
                        dataInfo.put(UnitCodeTreeListPlugin.NAME, rs.getString(3));
                        dataInfo.put(UnitCodeTreeListPlugin.CREATEORG, rs.getString(4));
                        orgIds.add(rs.getString(4));
                        dataInfo.put(UnitCodeTreeListPlugin.SOURCE, "bd_customer".equals(rs.getString(5)) ? ResManager.loadKDString((String)"\u5ba2\u6237", (String)"UnitCodeTreeListPlugin_7", (String)"bd-master-formplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u4f9b\u5e94\u5546", (String)"UnitCodeTreeListPlugin_8", (String)"bd-master-formplugin", (Object[])new Object[0]));
                        dataInfo.put(UnitCodeTreeListPlugin.BIZPARTNER, rs.getString(6));
                        bizpartnerIds.add(rs.getString(6));
                        dataList.add(dataInfo);
                    }
                    return dataList;
                }
            });
            DynamicObjectCollection orgs = QueryServiceHelper.query((String)"bos_org", (String)"id,name", (QFilter[])new QFilter[]{new QFilter("id", "in", orgIds)}, (String)"number asc");
            HashMap<String, String> orgMap = new HashMap<String, String>();
            for (DynamicObject org : orgs) {
                orgMap.put(org.getString("id"), org.getString(UnitCodeTreeListPlugin.NAME));
            }
            DynamicObjectCollection bizpartners = QueryServiceHelper.query((String)"bd_bizpartner", (String)"id,name", (QFilter[])new QFilter[]{new QFilter("id", "in", bizpartnerIds)}, (String)"number asc");
            HashMap<String, String> bizpartnerMap = new HashMap<String, String>();
            for (DynamicObject bizpartner : bizpartners) {
                bizpartnerMap.put(bizpartner.getString("id"), bizpartner.getString(UnitCodeTreeListPlugin.NAME));
            }
            if (dataList == null) {
                UnitCodeTreeListPlugin.this.getPageCache().put("size", "0");
            } else {
                UnitCodeTreeListPlugin.this.getPageCache().put("size", dataList.size() + "");
            }
            if (dataList != null) {
                for (int i = start; i < start + limit && i < dataList.size(); ++i) {
                    Map map = (Map)dataList.get(i);
                    DynamicObject dynamicObject = new DynamicObject(col.getDynamicObjectType());
                    dynamicObject.set("id", map.get("id"));
                    dynamicObject.set(UnitCodeTreeListPlugin.MASTERID, map.get(UnitCodeTreeListPlugin.MASTERID));
                    dynamicObject.set(UnitCodeTreeListPlugin.NUMBER, map.get(UnitCodeTreeListPlugin.NUMBER));
                    dynamicObject.set(UnitCodeTreeListPlugin.NAME, map.get(UnitCodeTreeListPlugin.NAME));
                    dynamicObject.set(UnitCodeTreeListPlugin.SOURCE, map.get(UnitCodeTreeListPlugin.SOURCE));
                    dynamicObject.set(UnitCodeTreeListPlugin.CREATEORG, orgMap.get(map.get(UnitCodeTreeListPlugin.CREATEORG)));
                    dynamicObject.set(UnitCodeTreeListPlugin.BIZPARTNER, bizpartnerMap.get(map.get(UnitCodeTreeListPlugin.BIZPARTNER)));
                    col.add((Object)dynamicObject);
                }
            }
            int dataCount = this.getDataCount();
            this.getQueryResult().setDataCount(dataCount);
            this.getQueryResult().setCollection(col);
            return col;
        }

        public int getDataCount() {
            return Integer.parseInt(UnitCodeTreeListPlugin.this.getPageCache().get("size"));
        }

        public int getRealCount() {
            return Integer.parseInt(UnitCodeTreeListPlugin.this.getPageCache().get("size"));
        }
    }
}

