/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.master;

import java.util.HashSet;
import kd.bd.master.validator.GroupStandardValidator;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.operation.DeleteServiceHelper;

public class GroupStandardDeletePlugin
extends AbstractOperationServicePlugIn {
    public static final String PROP_ID = "id";
    public static final String PROP_BIZPARTNER = "bizpartner";
    public static final String ENTITY_SUPPLIER = "bd_supplier";
    public static final String ENTITY_CUSTOMER = "bd_customer";
    public static final String ENTITY_MATERIAL = "bd_material";
    public static final String ENTITY_BIZPARTNER = "bd_bizpartner";
    public static final String OP_DELETE = "delete";
    public static final String SPLIT_DELETE = "delete";
    public static final String SPLIT_UPDATE = "update";
    public static final String ENTITY_GROUP = "group";
    public static final String PROP_STANDARD = "standard";
    public static final String PROP_PARENT = "parent";
    public static final String PROP_GROUP = "group";

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        GroupStandardValidator validator = new GroupStandardValidator();
        String entityKey = this.billEntityType.getName();
        validator.setEntityKey(entityKey);
        e.addValidator((AbstractValidator)validator);
        String entity = "";
        if (entityKey.contains(ENTITY_SUPPLIER)) {
            entity = ENTITY_SUPPLIER;
        } else if (entityKey.contains(ENTITY_CUSTOMER)) {
            entity = ENTITY_CUSTOMER;
        } else if (entityKey.contains(ENTITY_MATERIAL)) {
            entity = ENTITY_MATERIAL;
        }
        this.getOption().setVariableValue("ignorerefentityids", entity + "group");
    }

    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        super.beforeExecuteOperationTransaction(e);
        DynamicObject[] arrDObj = e.getDataEntities();
        if (arrDObj != null) {
            String entityNumber = e.getDataEntities()[0].getDataEntityType().getName();
            String entity = "";
            if (entityNumber.contains(ENTITY_SUPPLIER)) {
                entity = ENTITY_SUPPLIER;
            } else if (entityNumber.contains(ENTITY_CUSTOMER)) {
                entity = ENTITY_CUSTOMER;
            } else if (entityNumber.contains(ENTITY_MATERIAL)) {
                entity = ENTITY_MATERIAL;
            }
            HashSet<Long> deleteIds = new HashSet<Long>();
            HashSet<Long> standardIds = new HashSet<Long>(arrDObj.length);
            for (DynamicObject tempObj : arrDObj) {
                Long id = (Long)tempObj.get(PROP_ID);
                standardIds.add(id);
            }
            ORM ormOV = ORM.create();
            QFilter standardFilter = new QFilter(PROP_STANDARD, "in", standardIds);
            try (DataSet ds = ormOV.queryDataSet(GroupStandardDeletePlugin.class.getName(), entity + "group", PROP_ID, new QFilter[]{standardFilter});){
                for (Row row : ds) {
                    if (row.getString(PROP_ID) == null) continue;
                    deleteIds.add(Long.parseLong(row.getString(PROP_ID)));
                }
            }
            if (deleteIds.size() > 0) {
                DeleteServiceHelper.delete((String)(entity + "group"), (QFilter[])new QFilter[]{new QFilter(PROP_ID, "in", deleteIds)});
            }
        }
    }
}

