/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.master;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import kd.bd.master.helper.BizpartnerHelper;
import kd.bd.master.validator.SupplierDeleteValidator;
import kd.bos.entity.operate.OperationContext;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.trace.TraceSpan;
import kd.bos.trace.Tracer;

public class Supplier2DeletePlugin
extends AbstractOperationServicePlugIn {
    private static final Log log = LogFactory.getLog(Supplier2DeletePlugin.class);
    private static final String PROP_ID = "id";
    private static final String PROP_SUPPLIER = "supplier";
    private static final String SUPPLIER_PARTNER_ROLE = "1";

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        e.getFieldKeys().add("bizpartner");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        try (TraceSpan span = Tracer.create((String)"Supplier2DeletePlugin", (String)"onAddValidators");){
            super.onAddValidators(e);
            e.addValidator((AbstractValidator)new SupplierDeleteValidator());
            this.getOption().setVariableValue("ignorerefentityids", "bd_supplier,bd_suppliergroupdetail,bd_address,bd_suppliersite");
        }
    }

    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        log.info("Supplier2DeletePlugin.beforeExecuteOperationTransaction, record num:" + (e.getDataEntities() == null ? "null" : Integer.valueOf(e.getDataEntities().length)));
        try (TraceSpan span = Tracer.create((String)"Supplier2DeletePlugin", (String)"beforeExecuteOperationTransaction");){
            OperationContext operContext;
            super.beforeExecuteOperationTransaction(e);
            this.operationContext = operContext = BizpartnerHelper.prepareOperParams((BeforeOperationArgs)e, (String)"bd_supplier");
            List ids = Arrays.asList(e.getDataEntities()).stream().map(d -> (Long)d.get(PROP_ID)).collect(Collectors.toList());
            int delResult = DeleteServiceHelper.delete((String)"bd_suppliergroupdetail", (QFilter[])new QFilter[]{new QFilter(PROP_SUPPLIER, "in", ids)});
            log.info("bd_supplier delete operation, delete bd_customergroupdetail " + delResult + " record");
        }
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        try (TraceSpan span = Tracer.create((String)"Supplier2DeletePlugin", (String)"afterExecuteOperationTransaction");){
            super.afterExecuteOperationTransaction(e);
            BizpartnerHelper.dealWithBizPartner((AfterOperationArgs)e, (OperationContext)this.operationContext, (String)"bd_supplier", (String)SUPPLIER_PARTNER_ROLE);
        }
    }
}

