/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.master.validator;

import java.util.Map;
import kd.bd.master.helper.BizpartnerHelper;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.trace.TraceSpan;
import kd.bos.trace.Tracer;

public class CustomerDeleteValidator
extends AbstractValidator {
    public static final String ENTITY_BIZPARTNER = "bd_bizpartner";
    public static final String ENTITY_CUSTOMER = "bd_customer";
    private static final String MAINENTITY_BIZPARTNERUSER = "bos_bizpartneruser";

    public CustomerDeleteValidator() {
        this.setEntityKey(ENTITY_CUSTOMER);
    }

    public void validate() {
        try (TraceSpan span = Tracer.create((String)"CustomerDeleteValidator", (String)"validate");){
            for (ExtendedDataEntity dataEntity : this.dataEntities) {
                this.checkData(dataEntity);
            }
            this.partnerRefCheck();
        }
    }

    private void checkData(ExtendedDataEntity dataEntity) {
        Long dataId = (Long)dataEntity.getValue("id");
        DynamicObject entity = null;
        try {
            entity = BusinessDataServiceHelper.loadSingle((Object)dataId, (String)ENTITY_CUSTOMER, (String)"id,bizpartner");
        }
        catch (Exception ex) {
            return;
        }
        if (entity == null) {
            return;
        }
        DynamicObject bizPartner = entity.getDynamicObject("bizpartner");
        if (bizPartner == null) {
            return;
        }
        Long bizPartnerId = (Long)bizPartner.getPkValue();
        boolean isExistsInventoryinfo = QueryServiceHelper.exists((String)MAINENTITY_BIZPARTNERUSER, (QFilter[])new QFilter[]{new QFilter("bizpartner", "=", (Object)bizPartnerId)});
        if (isExistsInventoryinfo) {
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5220\u9664\u5931\u8d25\uff0c\u6b64\u5ba2\u6237\u5b58\u5728\u5546\u6237\u4f19\u4f34\u7528\u6237\u4e0d\u5141\u8bb8\u5220\u9664\u3002", (String)"CustomerDeleteValidator_0", (String)"bd-master-opplugin", (Object[])new Object[0]));
            return;
        }
    }

    private void partnerRefCheck() {
        if (!BizpartnerHelper.isEnablePartnerRefCheck()) {
            return;
        }
        Map partnerRefCheckResult = BizpartnerHelper.bizpartnerReferenceChecking((ExtendedDataEntity[])this.dataEntities);
        if (partnerRefCheckResult.isEmpty()) {
            return;
        }
        for (ExtendedDataEntity extDataEntity : this.dataEntities) {
            DynamicObject dataEntity = extDataEntity.getDataEntity();
            String errMsg = (String)partnerRefCheckResult.get(dataEntity.getPkValue());
            if (errMsg == null) continue;
            this.addErrorMessage(extDataEntity, errMsg);
        }
    }
}

