/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.master.validator;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bd.master.helper.MasterDataHelper;
import kd.bd.master.util.GroupStandardUtils;
import kd.bd.master.util.MasterDataUtil;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.trace.TraceSpan;
import kd.bos.trace.Tracer;

public class MasterDataSaveValidator
extends AbstractValidator {
    private MasterDataHelper masterDataHelper = new MasterDataHelper();
    private Map<Long, Boolean> groupLastNews = new HashMap<Long, Boolean>();
    private Map<Long, Long> groupOrgs = new HashMap<Long, Long>();
    private Map<Long, Long> dataGroup = new HashMap<Long, Long>();
    private Map<Long, Set<Long>> groupStandards = new HashMap<Long, Set<Long>>();
    private Map<Long, Set<Long>> dataOrgs = new HashMap<Long, Set<Long>>();
    private Map<Long, Set<Long>> orgParentOrgs = new HashMap<Long, Set<Long>>();
    private Map<Long, ILocaleString> groupNames = new HashMap<Long, ILocaleString>();

    public Set<Long> checkGroupEffective(ExtendedDataEntity[] dataEntity) {
        HashSet<Long> ids = new HashSet<Long>();
        HashSet<Long> groupIds = new HashSet<Long>();
        String entityNumber = this.getEntitNumber(this.getEntityKey());
        String entityName = this.getEntitName(entityNumber);
        DynamicObject defGroup = BusinessDataServiceHelper.loadSingleFromCache((String)(entityNumber + "group"), (String)"id", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)1L), new QFilter("enable", "=", (Object)"1")});
        try (TraceSpan span = Tracer.create((String)"MasterDataSaveValidator", (String)"checkGroupEffective");){
            Long groupid;
            for (ExtendedDataEntity exData : dataEntity) {
                DynamicObject data = exData.getDataEntity();
                Long dataId = Long.valueOf(MasterDataHelper.getDataPk((DynamicObject)data));
                DynamicObjectCollection standards = data.getDynamicObjectCollection("entry_groupstandard");
                if (standards == null || standards.isEmpty()) {
                    if ("submit".equals(this.getOperateKey())) {
                        if (0L == dataId) {
                            continue;
                        }
                    } else if ("save".equals(this.getOperateKey()) && !data.getDataEntityState().getFromDatabase() && defGroup == null) {
                        this.addErrorMessage(exData, ResManager.loadKDString((String)"\u8bf7\u586b\u5199[\u5206\u7c7b\u6807\u51c6]\u9875\u7b7e \u57fa\u672c\u5206\u7c7b\u6807\u51c6\u7684\u5206\u7c7b\u3002", (String)"MasterDataSaveValidator_2", (String)"bd-master-opplugin", (Object[])new Object[0]));
                        break;
                    }
                    ids.add(dataId);
                } else {
                    HashSet<Long> groupids = new HashSet<Long>();
                    Long defgroupId = null;
                    for (DynamicObject dynamicObject : standards) {
                        Long groupid2 = MasterDataUtil.getDataPkByType((Object)dynamicObject.get("groupid"));
                        Long standardid = MasterDataUtil.getDataPkByType((Object)dynamicObject.get("standardid"));
                        if (standardid.equals(712984405228187648L) || standardid.equals(716529547008326656L) || standardid.equals(730148448254487552L)) {
                            defgroupId = groupid2;
                            if (defgroupId == 0L) {
                                this.dataGroup.put(dataId, 1L);
                            } else {
                                this.dataGroup.put(dataId, defgroupId);
                            }
                        }
                        if (groupid2 == 0L) continue;
                        groupIds.add(groupid2);
                        groupids.add(groupid2);
                    }
                    if ((StringUtils.isBlank(defgroupId) || defgroupId != null && defgroupId.equals(1L) || defgroupId != null && defgroupId.equals(0L)) && defGroup == null) {
                        this.addErrorMessage(exData, ResManager.loadKDString((String)"\u8bf7\u586b\u5199[\u5206\u7c7b\u6807\u51c6]\u9875\u7b7e \u57fa\u672c\u5206\u7c7b\u6807\u51c6\u7684\u5206\u7c7b\u3002", (String)"MasterDataSaveValidator_2", (String)"bd-master-opplugin", (Object[])new Object[0]));
                        break;
                    }
                    this.groupStandards.put(dataId, groupids);
                }
                Long createOrgId = MasterDataUtil.getDataPkByType((Object)data.get("createorg"));
                Set orgs = this.orgParentOrgs.get(createOrgId);
                if (orgs == null) {
                    HashSet<Long> createOrg = new HashSet<Long>();
                    createOrg.add(createOrgId);
                    orgs = GroupStandardUtils.getGroupOrgId((String)entityNumber, createOrg);
                    orgs.add(createOrgId);
                    this.orgParentOrgs.put(createOrgId, orgs);
                }
                this.dataOrgs.put(dataId, orgs);
            }
            if (ids.size() > 0) {
                if (StringUtils.isBlank((CharSequence)entityName)) {
                    HashSet<Long> hashSet = groupIds;
                    return hashSet;
                }
                Map map = BusinessDataServiceHelper.loadFromCache((String)(entityNumber + "groupdetail"), (String)("standard,group," + entityName), (QFilter[])new QFilter[]{new QFilter(entityName, "in", ids)});
                for (DynamicObject standard : map.values()) {
                    Long standardid;
                    Long dataId = MasterDataUtil.getDataPkByType((Object)standard.get(entityName));
                    groupid = MasterDataUtil.getDataPkByType((Object)standard.get("group"));
                    Set<Long> groupids = this.groupStandards.get(dataId);
                    if (groupids == null) {
                        groupids = new HashSet<Long>();
                    }
                    if ((standardid = MasterDataUtil.getDataPkByType((Object)standard.get("standard"))).equals(712984405228187648L) || standardid.equals(716529547008326656L) || standardid.equals(730148448254487552L)) {
                        this.dataGroup.put(dataId, groupid);
                    }
                    groupids.add(groupid);
                    this.groupStandards.put(dataId, groupids);
                    groupIds.add(groupid);
                }
            }
            QFilter[] qFilterArray = new QFilter[]{new QFilter("id", "in", groupIds)};
            Map groupCaches = BusinessDataServiceHelper.loadFromCache((String)(entityNumber + "group"), (String)"id,createorg,name,enable,standard", (QFilter[])qFilterArray);
            for (DynamicObject group : groupCaches.values()) {
                groupid = MasterDataUtil.getDataPkByType((Object)group.get("id"));
                Long groupCreateOrgId = MasterDataUtil.getDataPkByType((Object)group.get("createorg"));
                this.groupOrgs.put(groupid, groupCreateOrgId);
                this.groupNames.put(groupid, group.getLocaleString("name"));
            }
            for (ExtendedDataEntity exData : dataEntity) {
                DynamicObject data = exData.getDataEntity();
                Long dataId = Long.valueOf(data.getPkValue().toString());
                Long groupid3 = this.dataGroup.get(dataId);
                if (groupid3 == null || groupid3 == 0L) continue;
                Set<Long> creatrorgIds = this.dataOrgs.get(dataId);
                Long groupCreateOrgId = this.groupOrgs.get(groupid3);
                ILocaleString name = this.groupNames.get(groupid3);
                if (groupCaches.containsKey(groupid3) && !((DynamicObject)groupCaches.get(groupid3)).getBoolean("enable")) {
                    if ("submit".equals(this.getOperateKey())) {
                        this.addErrorMessage(exData, String.format(ResManager.loadKDString((String)"\u5f53\u524d\u5206\u7c7b\u201c%s\u201d\u5df2\u7981\u7528\uff0c\u63d0\u4ea4\u5931\u8d25\u3002", (String)"MasterDataSaveValidator_3", (String)"bd-master-opplugin", (Object[])new Object[0]), name.getLocaleValue()));
                    } else if ("save".equals(this.getOperateKey())) {
                        this.addErrorMessage(exData, String.format(ResManager.loadKDString((String)"\u5f53\u524d\u5206\u7c7b\u201c%s\u201d\u5df2\u7981\u7528\uff0c\u4fdd\u5b58\u5931\u8d25\u3002", (String)"MasterDataSaveValidator_4", (String)"bd-master-opplugin", (Object[])new Object[0]), name.getLocaleValue()));
                    }
                }
                if (creatrorgIds != null && creatrorgIds.size() > 0 && groupCreateOrgId != null && !creatrorgIds.contains(groupCreateOrgId)) {
                    this.addErrorMessage(exData, String.format(ResManager.loadKDString((String)"\u5f53\u524d\u5206\u7c7b\u201c%s\u201d\u5728\u5f53\u524d\u7ec4\u7ec7\u4e0d\u5141\u8bb8\u4f7f\u7528\u3002", (String)"MasterDataSaveValidator_1", (String)"bd-master-opplugin", (Object[])new Object[0]), name.getLocaleValue()));
                }
                DynamicObjectCollection standards = data.getDynamicObjectCollection("entry_groupstandard");
                for (DynamicObject dynamicObject : standards) {
                    Long groupPk = MasterDataUtil.getDataPkByType((Object)dynamicObject.get("groupid"));
                    Long standardid = MasterDataUtil.getDataPkByType((Object)dynamicObject.get("standardid"));
                    if (groupPk == 0L || !groupCaches.containsKey(groupPk) || groupCaches.get(groupPk) == null || ((DynamicObject)groupCaches.get(groupPk)).getDynamicObject("standard") == null || standardid.equals(((DynamicObject)groupCaches.get(groupPk)).getDynamicObject("standard").getLong("id"))) continue;
                    this.addErrorMessage(exData, String.format(ResManager.loadKDString((String)"\u5f53\u524d\u5206\u7c7b\u201c%S\u201d\u4e0d\u662f\u7ed1\u5b9a\u5206\u7c7b\u6807\u51c6\u4e0b\u7684\u5206\u7c7b\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"MasterDataSaveValidator_5", (String)"bd-master-opplugin", (Object[])new Object[0]), ((DynamicObject)groupCaches.get(groupPk)).getLocaleString("name").getLocaleValue()));
                }
            }
        }
        return groupIds;
    }

    public void checkGroupNew(ExtendedDataEntity[] dataEntity, Set<Long> groupIds) {
        try (TraceSpan span = Tracer.create((String)"MasterDataSaveValidator", (String)"checkGroupNew");){
            boolean isGroupLastNew = this.masterDataHelper.getGroupNew();
            if (!isGroupLastNew) {
                return;
            }
            String entityNumber = this.getEntityKey();
            QFilter[] qFilterparentIds = new QFilter[]{new QFilter("parent", "in", groupIds)};
            Map groups = BusinessDataServiceHelper.loadFromCache((String)(entityNumber + "group"), (String)"parent", (QFilter[])qFilterparentIds);
            for (DynamicObject group : groups.values()) {
                Long groupid = MasterDataUtil.getDataPkByType((Object)group.getDynamicObject("parent"));
                this.groupLastNews.put(groupid, Boolean.TRUE);
                this.groupNames.put(groupid, group.getDynamicObject("parent").getLocaleString("name"));
            }
            for (ExtendedDataEntity exData : dataEntity) {
                DynamicObject data = exData.getDataEntity();
                Long dataId = Long.valueOf(data.getPkValue().toString());
                Set<Long> groupids = this.groupStandards.get(dataId);
                if (groupids == null || groupids.isEmpty()) continue;
                for (Long groupid : groupids) {
                    Boolean isLastNew = this.groupLastNews.get(groupid);
                    ILocaleString name = this.groupNames.get(groupid);
                    if (isLastNew == null || !isLastNew.booleanValue()) continue;
                    this.addErrorMessage(exData, String.format(ResManager.loadKDString((String)"\u5f53\u524d\u5206\u7c7b[%s]\u4e0d\u662f\u672b\u7ea7\u5206\u7c7b\uff0c\u7981\u6b62", (String)"MasterDataSaveValidator_0", (String)"bd-master-opplugin", (Object[])new Object[0]), name.getLocaleValue()) + this.getOperationName());
                }
            }
        }
    }

    private String getEntitName(String entityNumber) {
        if ("bd_material".equals(entityNumber)) {
            return "material";
        }
        if ("bd_customer".equals(entityNumber)) {
            return "customer";
        }
        if ("bd_supplier".equals(entityNumber)) {
            return "supplier";
        }
        Set entitys = GroupStandardUtils.getFormmeta((String)entityNumber);
        entitys.add(entityNumber);
        if (entitys.contains("bd_supplier")) {
            return "supplier";
        }
        if (entitys.contains("bd_customer")) {
            return "customer";
        }
        if (entitys.contains("bd_material")) {
            return "material";
        }
        return null;
    }

    private String getEntitNumber(String entityNumber) {
        if ("bd_material".equals(entityNumber)) {
            return "bd_material";
        }
        if ("bd_customer".equals(entityNumber)) {
            return "bd_customer";
        }
        if ("bd_supplier".equals(entityNumber)) {
            return "bd_supplier";
        }
        Set entitys = GroupStandardUtils.getFormmeta((String)entityNumber);
        entitys.add(entityNumber);
        if (entitys.contains("bd_supplier")) {
            return "bd_supplier";
        }
        if (entitys.contains("bd_customer")) {
            return "bd_customer";
        }
        if (entitys.contains("bd_material")) {
            return "bd_material";
        }
        return null;
    }

    public void validate() {
    }
}

