/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.sbd.mservice.upgrade;

import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bd.sbd.consts.Inspect_cfgConst;
import kd.bd.sbd.utils.AverageAssignUtil;
import kd.bd.sbd.utils.IDGenerator;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.db.SqlBuilder;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.bos.threads.ThreadPools;
import kd.bos.util.ExceptionUtils;

public class InspectCfgBillUpdateServiceImpl
implements IUpgradeService {
    private static final Log logger = LogFactory.getLog(InspectCfgBillUpdateServiceImpl.class);
    private static final Long QCP_FLG = 959929179238017024L;
    String[] TYPEARR = new String[]{"finishflg", "qcpflg", "osqcpflg", "procedureflg", "deliveryflg", "returnsflg", "stockflg", "productretflg", "prodpatrolflag"};
    private static List<Long> customBizTypeIdList;

    public UpgradeResult beforeExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        String className = this.getClass().getName();
        ThreadPools.executeOnce((String)className, () -> {
            try {
                this.repairDatas(ver, sqlFileName);
            }
            catch (Exception e) {
                logger.error("Abnormal repair of material quality inspection information data\uff1a" + ExceptionUtils.getExceptionStackTraceMessage((Exception)e));
            }
        });
        return new UpgradeResult();
    }

    private void repairDatas(String idStr, String sqlFileName) {
        String dbKey = "sys";
        DBRoute dbRoute = new DBRoute(dbKey);
        logger.info(String.format("repairDatas idStr=%s||sqlFileName=%s", idStr, sqlFileName));
        if (!DB.exitsTable((DBRoute)dbRoute, (String)"t_bd_inspect_cfg") || !DB.exitsTable((DBRoute)dbRoute, (String)"t_bd_insptcfgentry")) {
            logger.info("table is not exist...");
            return;
        }
        if (StringUtils.isNotBlank((CharSequence)sqlFileName)) {
            idStr = null;
        }
        if (StringUtils.isBlank((CharSequence)idStr) && this.isTableEmpty().booleanValue()) {
            logger.info("Starting to perform standard data repair for material quality inspection information...");
            List<Object> idList = this.getCfgIdList();
            List shardList = AverageAssignUtil.getAssignListByMaxSize(idList, (int)1000);
            for (List subList : shardList) {
                this.excuteUpdate(subList);
            }
            logger.info("Material quality inspection information execution standard data repair completed...");
        } else if (idStr != null) {
            String[] idArr;
            logger.info("Starting to perform accurate data repair for material quality inspection information...");
            ArrayList<Object> selectedIdList = new ArrayList<Object>(16);
            for (String str : idArr = idStr.split(",")) {
                selectedIdList.add(Long.valueOf(str));
            }
            List<Object> idList = this.filterIds(selectedIdList);
            if (!idList.isEmpty()) {
                this.excuteUpdate(idList);
            }
            logger.info("Material quality inspection information execution precision data repair completed...");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void excuteUpdate(List<Object> selectedIdList) {
        try (TXHandle h1 = TX.requiresNew();){
            UpgradeResult result = new UpgradeResult();
            try {
                DataSet cfgDataSet = this.getCfgDataSet(selectedIdList);
                DataSet dataSet = cfgDataSet.copy();
                int count = dataSet.count("fid", false);
                logger.info("excuteUpdate...");
                this.updateValue(cfgDataSet, count);
            }
            catch (Exception e) {
                logger.error("excuteUpdate exception\uff1a" + ExceptionUtils.getExceptionStackTraceMessage((Exception)e));
            }
            finally {
                if (!result.isSuccess()) {
                    logger.info("rollback data...");
                    h1.markRollback();
                }
            }
        }
    }

    private List<Object> getCfgIdList() {
        ArrayList<Object> idList = new ArrayList<Object>(10);
        SqlBuilder sql = new SqlBuilder();
        sql.append("select A.fid from t_bd_inspect_cfg A left join t_bd_insptcfgentry B on A.fid = B.fid where B.fid is null;", new Object[0]);
        DataSet dataSet = DB.queryDataSet((String)this.getClass().getName(), (DBRoute)new DBRoute("sys"), (SqlBuilder)sql);
        while (dataSet.hasNext()) {
            Row row = dataSet.next();
            idList.add(row.getLong("fid"));
        }
        return idList;
    }

    private DataSet getCfgDataSet(List<Object> subList) {
        SqlBuilder sqlBuilder = new SqlBuilder();
        sqlBuilder.append("select fid,ffinishflg finishflg,fqcpflg qcpflg,fosqcpflg osqcpflg,fprocedureflg procedureflg,fdeliveryflg deliveryflg,freturnsflg returnsflg,fstockflg stockflg,fproductretflg productretflg,fprodpatrolflag prodpatrolflag,fnocheckflg from t_bd_inspect_cfg where ", new Object[0]);
        sqlBuilder.appendIn("fid", subList);
        sqlBuilder.append(";", new Object[0]);
        return DB.queryDataSet((String)this.getClass().getName(), (DBRoute)new DBRoute("sys"), (SqlBuilder)sqlBuilder);
    }

    private void updateValue(DataSet dataSet, int count) {
        SqlBuilder insertSql = new SqlBuilder();
        IDGenerator idGenerator = new IDGenerator();
        for (int i = 0; i <= count / 1000; ++i) {
            while (dataSet.hasNext()) {
                Row row = dataSet.next();
                List<Long> inspectTypeList = this.getInspectTypeList(row);
                for (int seq = 0; seq < inspectTypeList.size(); ++seq) {
                    String noCheckFlg = row.getBoolean("fnocheckflg") != false ? "1" : "0";
                    insertSql.append("insert into t_bd_insptcfgentry (fid,fseq,fentryid,finspecttype,fnocheckflag) values (", new Object[0]);
                    insertSql.append("?,", new Object[]{row.getLong("fid")});
                    insertSql.append("?,", new Object[]{seq + 1});
                    insertSql.append("?,", new Object[]{idGenerator.getGlobalId()});
                    insertSql.append("?,", new Object[]{inspectTypeList.get(seq)});
                    if (QCP_FLG.equals(inspectTypeList.get(seq))) {
                        insertSql.append("?", new Object[]{noCheckFlg});
                    } else {
                        insertSql.append("?", new Object[]{"0"});
                    }
                    insertSql.append(");", new Object[0]);
                }
            }
        }
        if (!insertSql.isEmpty()) {
            DB.execute((DBRoute)new DBRoute("sys"), (SqlBuilder)insertSql);
        }
    }

    private List<Long> getInspectTypeList(Row row) {
        ArrayList<Long> inspectTypeList = new ArrayList<Long>(16);
        for (String s : this.TYPEARR) {
            Boolean flag = row.getBoolean(s);
            if (!flag.booleanValue()) continue;
            if ("procedureflg".equals(s)) {
                inspectTypeList.add(960041773667747840L);
                inspectTypeList.add(960042738642880512L);
                continue;
            }
            inspectTypeList.add((Long)this.getKey(Inspect_cfgConst.transMap, s));
        }
        inspectTypeList.addAll(InspectCfgBillUpdateServiceImpl.getCustomBizTypeIdList());
        return inspectTypeList;
    }

    private <K, V> K getKey(Map<K, V> map, V value) {
        for (Map.Entry<K, V> entry : map.entrySet()) {
            if (!entry.getValue().equals(value)) continue;
            return entry.getKey();
        }
        return null;
    }

    private Boolean isTableEmpty() {
        Boolean isEmpty = Boolean.TRUE;
        SqlBuilder sql = new SqlBuilder();
        sql.append("select fid from t_bd_insptcfgentry", new Object[0]);
        DataSet dataSet = DB.queryDataSet((String)this.getClass().getName(), (DBRoute)new DBRoute("sys"), (SqlBuilder)sql).top(1);
        if (!dataSet.isEmpty()) {
            isEmpty = Boolean.FALSE;
        }
        logger.info("is table empty\uff1a" + isEmpty);
        return isEmpty;
    }

    private List<Object> filterIds(List<Object> idList) {
        SqlBuilder sqlBuilder = new SqlBuilder();
        sqlBuilder.append("SELECT FID FROM T_BD_INSPTCFGENTRY where", new Object[0]);
        sqlBuilder.appendIn("FID", idList);
        Set dataSet = (Set)DB.query((DBRoute)DBRoute.of((String)"sys"), (SqlBuilder)sqlBuilder, (ResultSetHandler)new ResultSetHandler<Set<Object>>(){

            public Set<Object> handle(ResultSet resultSet) throws Exception {
                HashSet<Object> dataSet = new HashSet<Object>(16);
                while (resultSet.next()) {
                    dataSet.add(resultSet.getObject("FID"));
                }
                return dataSet;
            }
        });
        for (Object obj : dataSet) {
            idList.remove(obj);
        }
        return idList;
    }

    private static List<Long> getCustomBizTypeIdList() {
        if (null == customBizTypeIdList) {
            customBizTypeIdList = new LinkedList<Long>();
            DBRoute dbRoute = new DBRoute("qmc");
            if (DB.exitsTable((DBRoute)dbRoute, (String)"t_qcbd_biztype")) {
                SqlBuilder sqlBuilder = new SqlBuilder();
                sqlBuilder.append("select fid from t_qcbd_biztype where fid not in (959929179238017024,960041773667747840,960042738642880512,960042976074041344,1157790804945938432,1157791038325170176,1176040910430171136,1377522299225319424,1408539848628799488,959929527046481920) and fstatus = 'C' and fenable = '1';", new Object[0]);
                DataSet customeBiztypeIdSet = DB.queryDataSet((String)InspectCfgBillUpdateServiceImpl.class.getName(), (DBRoute)dbRoute, (SqlBuilder)sqlBuilder);
                while (customeBiztypeIdSet.hasNext()) {
                    customBizTypeIdList.add(customeBiztypeIdSet.next().getLong("fid"));
                }
            }
        }
        return customBizTypeIdList;
    }
}

